/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo.tags.core.beans;

import java.util.LinkedList;
import shohaku.core.beans.dynamic.ClassDesc;
import shohaku.core.beans.dynamic.FactoryMethodDesc;
import shohaku.core.beans.dynamic.MethodDesc;
import shohaku.core.beans.dynamic.PrototypeBeanFactory;
import shohaku.core.beans.dynamic.SingletonBeanFactory;
import shohaku.core.lang.Eval;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.tags.AbstractValueTag;

public class BeanFactoryTag
extends AbstractValueTag {
    public static final String SINGLETON = "singleton";
    public static final String PROTOTYPE = "prototype";
    private String instance = "singleton";
    private Class clazz = Object.class;
    private ClassDesc classDesc = new ClassDesc();
    private LinkedList initMethods = new LinkedList();

    protected Object generateValue() {
        if (this.clazz == null) {
            throw new GinkgoException("clazz is empty.");
        }
        if (Eval.isBlank((CharSequence)this.instance)) {
            throw new GinkgoException("instance is blank.");
        }
        if (!this.initMethods.isEmpty()) {
            MethodDesc[] es = this.initMethods.toArray(new MethodDesc[this.initMethods.size()]);
            this.classDesc.setInitMethods(es);
        }
        SingletonBeanFactory factory = null;
        if (SINGLETON.equalsIgnoreCase(this.instance)) {
            SingletonBeanFactory f = new SingletonBeanFactory();
            f.setClassDesc(this.classDesc);
            f.setCreateSource(this.clazz);
            factory = f;
        } else if (PROTOTYPE.equalsIgnoreCase(this.instance)) {
            PrototypeBeanFactory f = new PrototypeBeanFactory();
            f.setClassDesc(this.classDesc);
            f.setCreateSource(this.clazz);
            factory = f;
        } else {
            throw new GinkgoException("instance type is illegal. " + this.instance);
        }
        return factory;
    }

    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public String getInstance() {
        return this.instance;
    }

    public void addElementTransferValue(MethodDesc arg) {
        this.initMethods.add(arg);
    }

    public void addElementTransferValue(FactoryMethodDesc arg) {
        if (this.classDesc.getFactory() != null) {
            throw new GinkgoException("FactoryMethodDesc except for one is illegal. " + arg);
        }
        this.classDesc.setFactory(arg);
    }
}

