/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo.rule;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import shohaku.core.lang.Eval;
import shohaku.core.lang.feature.FeatureFactory;
import shohaku.core.resource.IOResource;
import shohaku.core.resource.IOResourceLoader;
import shohaku.ginkgo.Ginkgo;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.NodeCompositeRule;
import shohaku.ginkgo.TagAttributesRule;
import shohaku.ginkgo.TagAttributesRuleSet;
import shohaku.ginkgo.TagNode;
import shohaku.ginkgo.TagRule;
import shohaku.ginkgo.TagRuleSet;
import shohaku.ginkgo.ValueNode;
import shohaku.ginkgo.rule.DefaultNodeCompositeRule;

public class XMLNodeCompositeRuleFactory {
    private static final NodeCompositeRule nodeCompositeRule;
    private IOResourceLoader libraryIOResourceLoader;
    private IOResource ioResource;
    private ClassLoader classLoader;

    private static void addContainTag(List tagRules, String pattern) {
        TagRule tagRule = new TagRule();
        tagRule.setPattern(pattern);
        tagRule.setTagClass("shohaku.ginkgo.tags.PublicContainTag");
        tagRules.add(tagRule);
    }

    private static void addCoreTag(List tagRules, String pattern, String className) {
        TagRule tagRule = new TagRule();
        tagRule.setPattern(pattern);
        tagRule.setTagClass("shohaku.ginkgo.tags.core." + className);
        tagRules.add(tagRule);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public IOResource getIOResource() {
        return this.ioResource;
    }

    public void setIOResource(IOResource ioResource) {
        this.ioResource = ioResource;
    }

    public IOResourceLoader getLibraryIOResourceLoader() {
        return this.libraryIOResourceLoader;
    }

    public void setLibraryIOResourceLoader(IOResourceLoader ioResourceLoader) {
        this.libraryIOResourceLoader = ioResourceLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NodeCompositeRule create() {
        NodeCompositeRule nodeCompositeRule;
        IOResource resource = this.getIOResource();
        ClassLoader loader = this.getClassLoader();
        if (resource == null) {
            throw new GinkgoException("IOResource is null.");
        }
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        InputStream is = null;
        try {
            try {
                is = resource.getInputStream();
                nodeCompositeRule = this.build(is, loader);
                Object var6_6 = null;
            }
            catch (IOException e) {
                throw new GinkgoException("NodeCompositeRule create err.", e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            catch (Exception e2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e2) {
            // empty catch block
            return nodeCompositeRule;
        }
        if (is == null) return nodeCompositeRule;
        is.close();
        return nodeCompositeRule;
    }

    private NodeCompositeRule build(InputStream is, ClassLoader loader) {
        try {
            TagNode rootTag = this.load(is, loader);
            return this.build(rootTag, loader);
        }
        catch (Exception e) {
            throw new GinkgoException("NodeCompositeRule create err.", e);
        }
    }

    private TagNode load(InputStream is, ClassLoader loader) {
        Ginkgo ginkgo = new Ginkgo();
        if (loader != null) {
            ginkgo.setClassLoader(loader);
        }
        ginkgo.setNodeCompositeRule(nodeCompositeRule);
        ginkgo.parse(is);
        return ginkgo.getDocument().getContext().getRoot();
    }

    private NodeCompositeRule build(TagNode rootTag, ClassLoader loader) {
        HashMap tagGroupMapping = new HashMap();
        HashMap uriGroupMapping = new HashMap();
        NodeCompositeRule rule = null;
        Iterator i = rootTag.getTagContext().elementIterator();
        while (i.hasNext()) {
            TagNode tag = (TagNode)i.next();
            String name = tag.getTagContext().getTagName();
            if ("rules".equals(name)) {
                rule = this.buildNodeCompositeRule(tag);
                continue;
            }
            if (!"library".equals(name)) continue;
            this.buildLibrary(tag, tagGroupMapping, uriGroupMapping, loader);
        }
        if (rule == null) {
            rule = new DefaultNodeCompositeRule();
        }
        i = uriGroupMapping.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            rule.addTagRule((String)e.getKey(), new TagRuleSet((List)e.getValue()));
        }
        return rule;
    }

    private void buildLibrary(TagNode libraryTag, Map tagGroupMapping, Map uriGroupMapping, ClassLoader loader) {
        HashMap tagMapping = new HashMap();
        HashMap patternMapping = new HashMap();
        String libraryId = libraryTag.getTagContext().getAttribute("id");
        String nsuri = libraryTag.getTagContext().getAttribute("nsuri", "");
        String classPath = libraryTag.getTagContext().getAttribute("class-path");
        if (!Eval.isBlank((CharSequence)classPath)) {
            this.loadSubLibrary(classPath, tagMapping, patternMapping, loader);
        }
        this.buildLibraryTag(libraryTag, tagMapping, patternMapping);
        this.putTagGroupMapping(libraryId, tagGroupMapping, tagMapping);
        List tagRules = this.buildTagRuleList(tagGroupMapping, tagMapping, patternMapping);
        List l = (List)uriGroupMapping.get(nsuri);
        if (l == null) {
            uriGroupMapping.put(nsuri, tagRules);
        } else {
            l.addAll(tagRules);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadSubLibrary(String path, Map tagMapping, Map patternMapping, ClassLoader loader) {
        IOResourceLoader irl = this.getLibraryIOResourceLoader();
        if (irl == null) {
            irl = FeatureFactory.getLoader().getIOResourceLoader();
        }
        irl.setClassLoader(loader);
        InputStream is = null;
        try {
            try {
                IOResource ir = irl.getIOResource(path);
                is = ir.getInputStream();
                TagNode libraryTag = this.load(is, loader);
                this.buildSubLibraryTag(libraryTag, tagMapping, patternMapping, loader);
            }
            catch (IOException e) {
                throw new GinkgoException("NodeCompositeRule create err.", e);
            }
            catch (URISyntaxException e) {
                throw new GinkgoException("NodeCompositeRule create err.", e);
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            try {
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (is == null) return;
        is.close();
        return;
    }

    private void buildLibraryTag(TagNode libraryTag, Map tagMapping, Map patternMapping) {
        Iterator i = libraryTag.getTagContext().elementIterator();
        while (i.hasNext()) {
            TagNode tag = (TagNode)i.next();
            String name = tag.getTagContext().getTagName();
            if ("tag-mapping".equals(name)) {
                this.buildTagMapping(tag, tagMapping);
                continue;
            }
            if (!"pattern-mapping".equals(name)) continue;
            this.buildPatternMapping(tag, patternMapping);
        }
    }

    private void buildSubLibraryTag(TagNode libraryTag, Map tagMapping, Map patternMapping, ClassLoader loader) {
        Iterator i = libraryTag.getTagContext().elementIterator();
        while (i.hasNext()) {
            TagNode tag = (TagNode)i.next();
            String name = tag.getTagContext().getTagName();
            if ("tag-mapping".equals(name)) {
                this.buildTagMapping(tag, tagMapping);
                continue;
            }
            if ("pattern-mapping".equals(name)) {
                this.buildPatternMapping(tag, patternMapping);
                continue;
            }
            if (!"library".equals(name)) continue;
            String classPath = libraryTag.getTagContext().getAttribute("class-path");
            this.loadSubLibrary(classPath, tagMapping, patternMapping, loader);
        }
    }

    private void putTagGroupMapping(String libraryId, Map tagGroupMapping, Map tagMapping) {
        Iterator i = tagMapping.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            tagGroupMapping.put(libraryId + ":" + e.getKey(), e.getValue());
        }
    }

    private List buildTagRuleList(Map tagGroupMapping, Map tagMapping, Map patternMapping) {
        ArrayList<TagRule> tagRuleSet = new ArrayList<TagRule>(patternMapping.size());
        Iterator i = patternMapping.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            TagRule tagRule = new TagRule();
            String pattern = (String)e.getKey();
            String tagId = (String)e.getValue();
            Map tagDesc = (Map)tagMapping.get(tagId);
            if (tagGroupMapping != null && tagDesc == null) {
                tagDesc = (Map)tagGroupMapping.get(tagId);
            }
            if (tagDesc == null) {
                throw new NullPointerException("tag doesn't exist. tagId=" + tagId);
            }
            String className = (String)tagDesc.get("class");
            TagAttributesRuleSet attributes = (TagAttributesRuleSet)tagDesc.get("attributes");
            tagRule.setPattern(pattern);
            tagRule.setTagClass(className);
            tagRule.setTagAttributesRuleSet(attributes);
            tagRuleSet.add(tagRule);
        }
        return tagRuleSet;
    }

    private NodeCompositeRule buildNodeCompositeRule(TagNode rulesTag) {
        Iterator i = rulesTag.getTagContext().valueIterator("node-composite-rule");
        if (i.hasNext()) {
            ValueNode vnode = (ValueNode)i.next();
            return (NodeCompositeRule)vnode.getNodeValue();
        }
        return new DefaultNodeCompositeRule();
    }

    private void buildTagMapping(TagNode tagMappingTag, Map tagMapping) {
        Iterator i = tagMappingTag.getTagContext().elementIterator("tag");
        while (i.hasNext()) {
            TagNode tag = (TagNode)i.next();
            String tagId = tag.getTagContext().getAttribute("id");
            HashMap<String, Object> tagDesc = new HashMap<String, Object>(2);
            tagDesc.put("class", tag.getTagContext().getAttribute("class"));
            Iterator j = tag.getTagContext().elementIterator();
            while (j.hasNext()) {
                TagNode t = (TagNode)j.next();
                String nm = t.getTagContext().getTagName();
                if (!"attributes".equals(nm)) continue;
                tagDesc.put(nm, this.buildTagAttributesRule(t));
            }
            tagMapping.put(tagId, tagDesc);
        }
    }

    private TagAttributesRuleSet buildTagAttributesRule(TagNode attributesTag) {
        ArrayList<TagAttributesRule> rules = new ArrayList<TagAttributesRule>();
        Iterator i = attributesTag.getTagContext().elementIterator("attribute");
        while (i.hasNext()) {
            TagNode att = (TagNode)i.next();
            String name = att.getTagContext().getAttribute("name");
            String alias = att.getTagContext().getAttribute("alias");
            String defaultValue = att.getTagContext().getAttribute("defaultValue");
            rules.add(new TagAttributesRule(name, alias, defaultValue));
        }
        return new TagAttributesRuleSet(rules);
    }

    private void buildPatternMapping(TagNode patternMappingTag, Map patternMapping) {
        Iterator i = patternMappingTag.getTagContext().elementIterator();
        while (i.hasNext()) {
            TagNode tag = (TagNode)i.next();
            String name = tag.getTagContext().getTagName();
            if ("pattern".equals(name)) {
                patternMapping.put(tag.getTagContext().getAttribute("path"), tag.getTagContext().getAttribute("tag"));
                continue;
            }
            if (!"remove".equals(name)) continue;
            patternMapping.remove(tag.getTagContext().getAttribute("path"));
        }
    }

    static {
        ArrayList tagRules = new ArrayList(50);
        XMLNodeCompositeRuleFactory.addContainTag(tagRules, "/ginkgo-composite-rule");
        XMLNodeCompositeRuleFactory.addContainTag(tagRules, "/ginkgo-tag-library");
        XMLNodeCompositeRuleFactory.addContainTag(tagRules, "/rules");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/rules/node-composite-rule", "beans.ObjectTag");
        XMLNodeCompositeRuleFactory.addContainTag(tagRules, "/library");
        XMLNodeCompositeRuleFactory.addContainTag(tagRules, "/tag-mapping");
        XMLNodeCompositeRuleFactory.addContainTag(tagRules, "/tag-mapping/tag");
        XMLNodeCompositeRuleFactory.addContainTag(tagRules, "/tag-mapping/tag/attributes");
        XMLNodeCompositeRuleFactory.addContainTag(tagRules, "/tag-mapping/tag/attributes/attribute");
        XMLNodeCompositeRuleFactory.addContainTag(tagRules, "/pattern-mapping");
        XMLNodeCompositeRuleFactory.addContainTag(tagRules, "/pattern-mapping/pattern");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/string", "base.StringTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/string/append", "base.ValueTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/char", "base.CharacterTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/byte", "base.ByteTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/short", "base.ShortTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/int", "base.IntgerTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/long", "base.LongTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/double", "base.DoubleTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/float", "base.FloatTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/boolean", "base.BooleanTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/type", "base.ClassTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/ref", "base.ReferenceTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/bigDecimal", "math.BigDecimalTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/bigInteger", "math.BigIntegerTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/date", "util.DateTimeTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/value", "util.ExpressionTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/array", "collections.ArrayTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/list", "collections.ListTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/set", "collections.SetTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/map", "collections.MapTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/map/entry", "collections.SingletonMapTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/object", "beans.ObjectTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/init", "beans.FactoryMethodDescTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/init/arg", "beans.ArgumentDescTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/factory", "beans.FactoryMethodDescTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/factory/arg", "beans.ArgumentDescTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/property", "beans.SetPropertyDescTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/method", "beans.MethodDescTag");
        XMLNodeCompositeRuleFactory.addCoreTag(tagRules, "/method/arg", "beans.ArgumentDescTag");
        DefaultNodeCompositeRule rule = new DefaultNodeCompositeRule();
        rule.addTagRule(null, new TagRuleSet(tagRules));
        nodeCompositeRule = rule;
    }
}

