/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo.rule;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import shohaku.core.collections.IteratorUtils;
import shohaku.core.lang.Eval;
import shohaku.core.lang.Predicate;
import shohaku.ginkgo.Document;
import shohaku.ginkgo.rule.TypeTransformHelper;
import shohaku.ogdl.OgdlContext;
import shohaku.ogdl.OgdlContextMixIn;

class OgdlContextImpl
implements OgdlContext {
    private final OgdlContextMixIn mixIn;
    private final Document document;

    OgdlContextImpl(Document doc) {
        this.document = doc;
        this.mixIn = new OgdlContextMixIn(null, null, new HashMap(0));
    }

    public boolean addImport(Class c) {
        return this.document.getContext().addImport(c);
    }

    public Class forImport(String name) {
        return this.document.getContext().forClass(name);
    }

    public void addFunctionsMap(String prefix, Map functionsMap) {
        this.mixIn.addFunctionsMap(prefix, functionsMap);
    }

    public Collection forFunctions(String name) {
        return this.mixIn.forFunctions(name);
    }

    public Iterator attributeNames() {
        final Map refMap = this.document.getTagValueMapView();
        Map sttMap = this.document.getContext().getAttributeMapView();
        Iterator[] iters = new Iterator[2];
        iters[0] = refMap.keySet().iterator();
        iters[0] = IteratorUtils.predicateIterator(sttMap.keySet().iterator(), (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                return !refMap.containsKey(o);
            }
        });
        return IteratorUtils.compositeIterator((Iterator[])iters);
    }

    public Object getAttribute(String name) {
        if (!Eval.isBlank((CharSequence)name)) {
            if (this.document.containsId(name)) {
                return TypeTransformHelper.getReferenceValue(this.document, name);
            }
            return this.document.getContext().getAttribute(name);
        }
        return null;
    }

    public void setAttribute(String name, Object value) {
        this.document.getContext().setAttribute(name, value);
    }

    public Object removeAttribute(String name) {
        return this.document.getContext().removeAttribute(name);
    }

    public boolean containsAttribute(String name) {
        boolean contains = false;
        if (!Eval.isEmpty((CharSequence)name) && !(contains = this.document.containsId(name))) {
            contains = this.document.getContext().containsName(name);
        }
        return contains;
    }

    public ClassLoader getClassLoader() {
        return this.mixIn.getClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.mixIn.setClassLoader(classLoader);
    }
}

