/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo;

import shohaku.core.lang.ObjectCreationException;
import shohaku.core.lang.feature.FeatureFactory;
import shohaku.ginkgo.Document;
import shohaku.ginkgo.Ginkgo;
import shohaku.ginkgo.NotHierarchyTag;
import shohaku.ginkgo.TagAttributes;
import shohaku.ginkgo.TagContext;
import shohaku.ginkgo.TagNode;
import shohaku.ginkgo.TagRule;
import shohaku.ginkgo.TextNode;

class TagCreateRule {
    private final Ginkgo ginkgo;
    private final Document document;
    private final TagRule tagRule;
    private TagNode tagNode;
    private TagContext tagContext;
    private StringBuffer charBuffer = new StringBuffer();

    TagCreateRule(Document document, TagRule tagRule) {
        this.ginkgo = document.getContext().getGinkgo();
        this.document = document;
        this.tagRule = tagRule;
    }

    void begin(String uri, String namespace, String tagName, String localName, String qName, TagAttributes attributes, TagCreateRule parentRule) throws Exception {
        if (this.ginkgo.getLogger().isDebugEnabled()) {
            this.ginkgo.getLogger().debug((Object)("TagCreateRule#begin():uri:" + uri + ", namespace:" + namespace + ", tagName:" + tagName + ", localName:" + localName + ", qName:" + qName + ", attributes:" + attributes));
        }
        this.tagNode = this.createTagNode();
        boolean isNotHierarchical = this.tagNode instanceof NotHierarchyTag;
        if (!isNotHierarchical && parentRule != null) {
            this.tagContext = new TagContext(this.document, this.tagRule, this.tagNode, parentRule.getTagNode(), uri, namespace, localName, qName, tagName, attributes);
            parentRule.addChild(uri, this.tagNode);
        } else {
            this.tagContext = new TagContext(this.document, this.tagRule, this.tagNode, null, uri, namespace, localName, qName, tagName, attributes);
        }
        this.tagNode.initialize(this.tagContext);
        this.tagNode.begin();
    }

    void addChars(String uri, char[] chars) throws Exception {
        if (this.ginkgo.getLogger().isDebugEnabled()) {
            this.ginkgo.getLogger().debug((Object)("TagCreateRule#chars():uri:" + uri + ":" + "chars:" + String.valueOf(chars)));
        }
        this.charBuffer.append(chars);
    }

    void addChild(String uri, TagNode child) throws Exception {
        if (this.ginkgo.getLogger().isDebugEnabled()) {
            this.ginkgo.getLogger().debug((Object)("TagCreateRule#addChild():uri:" + uri + ", child:" + child));
        }
        this.tagContext.addElement(child);
        this.tagNode.child(child);
    }

    void endBody(TextNode textNode) throws Exception {
        this.tagContext.setTextNode(textNode);
        this.tagNode.text(textNode);
    }

    void end(String uri, String namespace, String tagName, String localName, String qName) throws Exception {
        if (this.ginkgo.getLogger().isDebugEnabled()) {
            this.ginkgo.getLogger().debug((Object)("TagCreateRule#end():uri:" + uri + ", namespace:" + namespace + ", tagName:" + tagName + "localName:" + localName + ", qName:" + qName));
        }
        this.tagNode.end();
    }

    void finish() throws Exception {
        if (this.ginkgo.getLogger().isDebugEnabled()) {
            this.ginkgo.getLogger().debug((Object)("TagCreateRule#finish():" + this.tagNode.getClass()));
        }
        this.tagNode.finish();
        this.tagNode = null;
        this.tagContext = null;
        this.charBuffer = null;
    }

    private TagNode createTagNode() throws ObjectCreationException {
        String className = this.tagRule.getTagClass();
        ClassLoader classLoader = this.ginkgo.getClassLoader();
        TagNode ret = (TagNode)FeatureFactory.getLoader().getInstance(className, classLoader);
        if (ret == null) {
            throw new ObjectCreationException("className:" + this.tagRule.getTagClass());
        }
        return ret;
    }

    StringBuffer getCharBuffer() {
        return this.charBuffer;
    }

    TagNode getTagNode() {
        return this.tagNode;
    }

    TagRule getTagRule() {
        return this.tagRule;
    }
}

