/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import shohaku.core.collections.IteratorUtils;
import shohaku.core.helpers.HSeek;
import shohaku.core.lang.Eval;
import shohaku.core.lang.Predicate;
import shohaku.ginkgo.ContainTag;
import shohaku.ginkgo.Document;
import shohaku.ginkgo.DocumentCompositeRule;
import shohaku.ginkgo.DocumentContext;
import shohaku.ginkgo.Ginkgo;
import shohaku.ginkgo.NodeCompositeRule;
import shohaku.ginkgo.TagAttributes;
import shohaku.ginkgo.TagAttributesRule;
import shohaku.ginkgo.TagAttributesRuleSet;
import shohaku.ginkgo.TagNode;
import shohaku.ginkgo.TagRule;
import shohaku.ginkgo.TextNode;
import shohaku.ginkgo.ValueNode;

public class TagContext {
    private Document document;
    private TagRule tagRule;
    private TagNode target;
    private TagNode parent;
    private String tagURI;
    private String tagNamespaceURI;
    private String tagLocalName;
    private String tagQName;
    private String tagName;
    private TagAttributes tagAttributes;
    private List elements;
    private TextNode textNode;
    private Map attributeMapView = null;

    TagContext(Document document, TagRule tagRule, TagNode target, TagNode parent, String uri, String namespace, String localName, String tagQName, String tagName, TagAttributes attributes) {
        this.document = document;
        this.tagRule = tagRule;
        this.target = target;
        this.parent = parent;
        this.tagURI = uri;
        this.tagNamespaceURI = namespace;
        this.tagLocalName = localName;
        this.tagQName = tagQName;
        this.tagName = tagName;
        this.tagAttributes = attributes;
        this.elements = null;
        this.textNode = null;
    }

    public Document getDocument() {
        return this.document;
    }

    public Ginkgo getGinkgo() {
        return this.getDocumentContext().getGinkgo();
    }

    public NodeCompositeRule getNodeCompositeRule() {
        return this.getDocumentContext().getNodeCompositeRule();
    }

    public DocumentContext getDocumentContext() {
        return this.getDocument().getContext();
    }

    public DocumentCompositeRule getDocumentCompositeRule() {
        return this.getGinkgo().getDocumentCompositeRule();
    }

    public ClassLoader getClassLoader() {
        return this.getGinkgo().getClassLoader();
    }

    public String getTagQName() {
        return this.tagQName;
    }

    public String getTagLocalName() {
        return this.tagLocalName;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getTagNamespaceURI() {
        return this.tagNamespaceURI;
    }

    public String getTagURI() {
        return this.tagURI;
    }

    public int getScope() {
        int scope = 100;
        TagNode tag = this.target;
        while (tag != null) {
            if (tag instanceof ContainTag) {
                int parentScope = ((ContainTag)((Object)tag)).getScope();
                scope = parentScope > scope ? parentScope : scope;
            }
            tag = tag.getTagContext().getParent();
        }
        return scope;
    }

    public TagNode getParent() {
        return this.parent;
    }

    public boolean isChildsEmpty() {
        return this.isElementEmpty() && this.isTextEmpty();
    }

    public boolean isTextEmpty() {
        return this.textNode.getText() == null;
    }

    public TextNode getTextNode() {
        return this.textNode;
    }

    private List getElements() {
        return this.elements != null ? this.elements : (this.elements = new LinkedList());
    }

    public boolean isElementEmpty() {
        return this.elements == null || this.elements.isEmpty();
    }

    public Iterator elementIterator() {
        return this.isElementEmpty() ? IteratorUtils.emptyIterator() : this.getElements().iterator();
    }

    public Iterator elementIterator(String predicateTagName) {
        final String nm = predicateTagName;
        return IteratorUtils.predicateIterator((Iterator)this.elementIterator(), (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                return nm.equals(((TagNode)o).getTagContext().getTagName());
            }
        });
    }

    public Iterator ownerIterator() {
        return IteratorUtils.predicateIterator((Iterator)this.elementIterator(), (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                return 101 >= ((TagNode)o).getTagContext().getScope();
            }
        });
    }

    public Iterator valueIterator() {
        return IteratorUtils.predicateIterator((Iterator)this.elementIterator(), (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                return o instanceof ValueNode;
            }
        });
    }

    public Iterator valueIterator(String predicateTagName) {
        final String nm = predicateTagName;
        return IteratorUtils.predicateIterator((Iterator)this.elementIterator(), (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                return o instanceof ValueNode && nm.equals(((TagNode)o).getTagContext().getTagName());
            }
        });
    }

    private Map getAttributeMap() {
        HashMap<String, String> m = new HashMap<String, String>(4);
        TagAttributes tagAtts = this.getTagAttributes();
        TagAttributesRuleSet ruleSet = this.getTagAttributesRuleSet();
        Iterator i = ruleSet.iterator();
        while (i.hasNext()) {
            TagAttributesRule rule = (TagAttributesRule)i.next();
            m.put(rule.getName(), rule.getDefaultValue());
        }
        for (int i2 = 0; i2 < tagAtts.getLength(); ++i2) {
            String name = HSeek.notEmpty((String)tagAtts.getLocalName(i2), (String)tagAtts.getQName(i2));
            TagAttributesRule rule = ruleSet.find(name);
            String value = null;
            if (rule != null) {
                if (!Eval.isBlank((CharSequence)rule.getAlias())) {
                    name = rule.getAlias();
                }
                if ((value = tagAtts.getValue(name)) == null) {
                    value = rule.getDefaultValue();
                }
            } else {
                value = tagAtts.getValue(name);
            }
            m.put(name, value);
        }
        return Collections.unmodifiableMap(m);
    }

    public Map getAttributeMapView() {
        Map m = this.attributeMapView;
        return m != null ? m : (this.attributeMapView = this.getAttributeMap());
    }

    public String getAttribute(String name) {
        return (String)this.getAttributeMapView().get(name);
    }

    public String getAttribute(String name, String defaultValue) {
        String value = this.getAttribute(name);
        return value != null ? value : defaultValue;
    }

    public TagAttributes getTagAttributes() {
        return this.tagAttributes;
    }

    public String getTagAttribute(String name) {
        return this.getTagAttributes().getValue(name);
    }

    public String getTagAttribute(String name, String defaultValue) {
        String value = this.getTagAttribute(name);
        return value != null ? value : defaultValue;
    }

    public TagAttributesRuleSet getTagAttributesRuleSet() {
        return this.tagRule.getTagAttributesRuleSet();
    }

    public TagAttributesRule getTagAttributesRule(String name) {
        return this.getTagAttributesRuleSet().find(name);
    }

    void addElement(TagNode element) {
        this.getElements().add(element);
    }

    void setTextNode(TextNode textNode) {
        this.textNode = textNode;
    }
}

