/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo;

import java.util.Iterator;
import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import shohaku.ginkgo.CacheBodyTag;
import shohaku.ginkgo.CacheTag;
import shohaku.ginkgo.Document;
import shohaku.ginkgo.EvaluationTag;
import shohaku.ginkgo.Ginkgo;
import shohaku.ginkgo.Node;
import shohaku.ginkgo.TagAttributes;
import shohaku.ginkgo.TagContext;
import shohaku.ginkgo.TagCreateRule;
import shohaku.ginkgo.TagNode;
import shohaku.ginkgo.TagPropertyTransfer;
import shohaku.ginkgo.TagRule;
import shohaku.ginkgo.TextNodeImpl;

class SAXContentHandler
implements ContentHandler {
    private static final int NO_SKIP_BODY = -1;
    private static final int INIT_CACHE_TAG = -1;
    private final Ginkgo ginkgo;
    private final TagPropertyTransfer tagAttsTransfer;
    private final LinkedList stackTagCreateRule;
    private final LinkedList cacheTagCreateRule;
    private String currentUri;
    private int skipBodyCount;
    private int cacheTagCount;

    SAXContentHandler(Ginkgo ginkgo) {
        this.ginkgo = ginkgo;
        this.tagAttsTransfer = ginkgo.getNodeCompositeRule().getTagPropertyTransfer();
        this.stackTagCreateRule = new LinkedList();
        this.cacheTagCreateRule = new LinkedList();
        this.currentUri = "";
        this.skipBodyCount = -1;
        this.cacheTagCount = -1;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.skipBodyCount != -1) {
            ++this.skipBodyCount;
            return;
        }
        try {
            String tagName = SAXContentHandler.getTagName(localName, qName);
            this.startElement(namespaceURI, tagName, localName, qName, new TagAttributes(atts));
        }
        catch (Exception e) {
            this.handleException("Ginkgo.startElement:", e);
        }
    }

    void startElement(String namespaceURI, String tagName, String localName, String qName, TagAttributes atts) throws SAXException {
        try {
            this.downCurrentURI(tagName);
            TagCreateRule targetCreateRule = this.createTagCreateRule(namespaceURI, tagName);
            TagCreateRule parentCreateRule = !this.empty() ? this.peek() : null;
            this.push(targetCreateRule);
            if (!this.isCacheTag()) {
                this.tagAttsTransfer.substitut(this.ginkgo.getDocument(), atts);
            }
            targetCreateRule.begin(this.currentUri, namespaceURI, tagName, localName, qName, atts, parentCreateRule);
            TagNode tag = targetCreateRule.getTagNode();
            if (this.isCurrentRoot()) {
                Document doc = this.ginkgo.getDocument();
                doc.getContext().setRoot(tag);
                String documentId = this.ginkgo.getDocumentCompositeRule().getDocumentId(doc, tag);
                doc.setId(documentId);
            }
            if (!this.isCacheTag()) {
                this.tagAttsTransfer.setAttributes(tag);
            }
            if (tag instanceof CacheBodyTag) {
                ++this.cacheTagCount;
            }
            if (tag instanceof EvaluationTag) {
                this.startEvaluation(tag);
            }
        }
        catch (Exception e) {
            this.handleException("Ginkgo.startElement:", e);
        }
    }

    private boolean isCurrentRoot() {
        return this.size() == 1;
    }

    public void characters(char[] buffer, int start, int length) throws SAXException {
        if (this.skipBodyCount != -1) {
            return;
        }
        try {
            if (!this.empty()) {
                TagCreateRule targetCreateRule = this.peek();
                char[] chars = new char[length];
                System.arraycopy(buffer, start, chars, 0, length);
                targetCreateRule.addChars(this.currentUri, chars);
            }
        }
        catch (Exception e) {
            this.handleException("Ginkgo.characters:", e);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.skipBodyCount != -1) {
            if (this.skipBodyCount == 0) {
                this.skipBodyCount = -1;
            } else {
                --this.skipBodyCount;
                return;
            }
        }
        try {
            TagCreateRule targetCreateRule = this.pop();
            TagCreateRule parentCreateRule = !this.empty() ? this.peek() : null;
            TagNode tag = targetCreateRule.getTagNode();
            if (tag.getTagContext().isElementEmpty()) {
                StringBuffer text = targetCreateRule.getCharBuffer();
                if (!this.isCacheTag()) {
                    this.tagAttsTransfer.substitut(this.ginkgo.getDocument(), text);
                }
                targetCreateRule.endBody(new TextNodeImpl(text.toString()));
            } else {
                targetCreateRule.endBody(new TextNodeImpl(null));
            }
            if (tag instanceof CacheBodyTag) {
                --this.cacheTagCount;
            }
            if (tag instanceof EvaluationTag) {
                this.endEvaluation(tag);
            }
            if (!this.isCacheTag() && !tag.getTagContext().isTextEmpty()) {
                this.tagAttsTransfer.setText(tag);
            }
            String name = SAXContentHandler.getTagName(localName, qName);
            targetCreateRule.end(this.currentUri, namespaceURI, name, localName, qName);
            if (!this.isParentCacheTag() && parentCreateRule != null) {
                TagNode parent = parentCreateRule.getTagNode();
                this.tagAttsTransfer.addElement(parent, tag);
            }
            this.upCurrentURI();
            this.ginkgo.getDocument().endElement(tag);
        }
        catch (Exception e) {
            this.handleException("Ginkgo.endElement:", e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            Iterator i = this.cacheTagCreateRule.iterator();
            while (i.hasNext()) {
                TagCreateRule rule = (TagCreateRule)i.next();
                rule.finish();
            }
        }
        catch (Exception e) {
            this.handleException("Ginkgo.endDocument:", e);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    private boolean isCacheTag() {
        return this.cacheTagCount > -1;
    }

    private boolean isParentCacheTag() {
        return !this.isCurrentRoot() && this.cacheTagCount - 1 > -1;
    }

    private boolean empty() {
        return this.size() == 0;
    }

    private int size() {
        return this.stackTagCreateRule.size();
    }

    private void push(TagCreateRule rule) {
        this.stackTagCreateRule.addLast(rule);
        this.cacheTagCreateRule.add(rule);
    }

    private TagCreateRule pop() {
        return (TagCreateRule)this.stackTagCreateRule.removeLast();
    }

    private TagCreateRule peek() {
        return (TagCreateRule)this.stackTagCreateRule.getLast();
    }

    private void startEvaluation(TagNode tag) {
        int eval = ((EvaluationTag)((Object)tag)).doInitBody();
        if (eval == 1) {
            this.skipBodyCount = 0;
        }
    }

    private void endEvaluation(TagNode tag) throws SAXException {
        EvaluationTag bodyEvalNode = (EvaluationTag)((Object)tag);
        while (2 == bodyEvalNode.doEvalBody()) {
            this.evaluationChilds(tag);
        }
    }

    private void evaluationContent(TagNode tag) throws SAXException {
        TagContext nc = tag.getTagContext();
        String namespaceURI = nc.getTagNamespaceURI();
        String tagName = nc.getTagName();
        String localName = nc.getTagLocalName();
        String qName = nc.getTagQName();
        TagAttributes atts = nc.getTagAttributes();
        this.startElement(namespaceURI, tagName, localName, qName, new TagAttributes(atts));
        this.evaluationChilds(tag);
        this.endElement(namespaceURI, localName, qName);
    }

    private void evaluationChilds(TagNode parent) throws SAXException {
        TagContext context = parent.getTagContext();
        if (!context.isTextEmpty()) {
            String text = context.getTextNode().getText();
            this.characters(text.toCharArray(), 0, text.length());
        }
        if (!context.isElementEmpty()) {
            Iterator i = context.elementIterator();
            while (i.hasNext()) {
                Node child = (Node)i.next();
                this.evaluationContent((TagNode)child);
            }
        }
    }

    private TagCreateRule createTagCreateRule(String namespaceURI, String tagName) throws SAXException {
        if (this.cacheTagCount > -1) {
            TagRule tagRule = this.createCacheTagRule();
            return new TagCreateRule(this.ginkgo.getDocument(), tagRule);
        }
        TagRule tagRule = this.findTagRule(namespaceURI, tagName);
        if (tagRule == null) {
            throw new SAXException("TagRule couldn't be created. uri:" + this.currentUri + ", name:" + tagName);
        }
        return new TagCreateRule(this.ginkgo.getDocument(), tagRule);
    }

    private TagRule createCacheTagRule() {
        TagRule tagRule = new TagRule();
        tagRule.setTagClass(CacheTag.class.getName());
        tagRule.setPattern(this.currentUri);
        return tagRule;
    }

    private void downCurrentURI(String name) {
        StringBuffer sb = new StringBuffer(this.currentUri);
        sb.append('/');
        sb.append(name);
        this.currentUri = sb.toString();
    }

    private void upCurrentURI() {
        String uri = this.currentUri;
        int slash = uri.lastIndexOf(47);
        this.currentUri = slash >= 0 ? uri.substring(0, slash) : "";
    }

    private TagRule findTagRule(String namespaceURI, String tagName) {
        return this.ginkgo.getNodeCompositeRule().findTagRule(namespaceURI, this.currentUri, tagName);
    }

    private void handleException(String msg, Exception e) throws SAXException {
        if (this.ginkgo.isErrThrowable()) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new SAXException(msg, e);
        }
        this.error(msg, e);
    }

    private void error(Object message, Throwable t) {
        this.ginkgo.getLogger().error(message, t);
    }

    private static String getTagName(String localName, String qName) {
        String name = localName;
        if (name == null || name.length() < 1) {
            name = qName;
        }
        return name;
    }
}

