/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import shohaku.core.collections.MapUtils;
import shohaku.core.helpers.HClass;
import shohaku.ginkgo.Ginkgo;
import shohaku.ginkgo.NodeCompositeRule;
import shohaku.ginkgo.TagNode;

public class DocumentContext {
    private final Ginkgo ginkgo;
    private final NodeCompositeRule rule;
    private TagNode root;
    private final HashMap attributes = new HashMap();
    private final HashMap imports = new HashMap();
    private Map importMapView;
    private Map attributeMapView;

    DocumentContext(Ginkgo ginkgo, NodeCompositeRule rule) {
        this.ginkgo = ginkgo;
        this.rule = rule;
    }

    public NodeCompositeRule getNodeCompositeRule() {
        return this.rule;
    }

    public Ginkgo getGinkgo() {
        return this.ginkgo;
    }

    public ClassLoader getClassLoader() {
        return this.getGinkgo().getClassLoader();
    }

    public TagNode getRoot() {
        return this.root;
    }

    void setRoot(TagNode root) {
        this.root = root;
    }

    public Map getImportMapView() {
        Map m = this.importMapView;
        return m != null ? m : (this.importMapView = Collections.unmodifiableMap(this.imports));
    }

    public boolean addImport(Class c) {
        return null != this.imports.put(HClass.getShortClassName((Class)c), c);
    }

    public Class forClass(String name) {
        return (Class)this.imports.get(name);
    }

    public Map getAttributeMapView() {
        Map m = this.attributeMapView;
        return m != null ? m : (this.attributeMapView = Collections.unmodifiableMap(this.attributes));
    }

    public boolean containsName(String name) {
        return this.attributes.containsKey(name);
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.attributes.get(name);
    }

    public Object getAttribute(String name, Object defaultValue) {
        Object value = this.getAttribute(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Map getAttributePrefix(String prefix) {
        return MapUtils.putPrefixKey((Map)this.attributes, (String)prefix, new HashMap());
    }

    public Object setAttribute(String name, Object value) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.attributes.put(name, value);
    }

    public void setAttributeAll(Map map) {
        if (map == null) {
            throw new NullPointerException();
        }
        this.attributes.putAll(map);
    }

    public Object removeAttribute(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.attributes.remove(name);
    }

    public Map removeAttributePrefix(String prefix) {
        return MapUtils.removePrefixKey((Map)this.attributes, (String)prefix, new HashMap());
    }

    public void removeAttributeAll() {
        this.attributes.clear();
    }
}

