/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import shohaku.core.lang.Eval;
import shohaku.ginkgo.DocumentContext;
import shohaku.ginkgo.Ginkgo;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.NodeCompositeRule;
import shohaku.ginkgo.TagNode;
import shohaku.ginkgo.ValueNode;

public class Document {
    private final DocumentContext context;
    private final Document parent;
    private String id;
    private final HashMap nodeValueMap;
    private final boolean isPreserve;
    private Map tagValueMapView;

    Document(Ginkgo ginkgo, NodeCompositeRule rule, Document parent) {
        this.context = new DocumentContext(ginkgo, rule);
        this.parent = parent;
        this.nodeValueMap = new HashMap();
        this.isPreserve = false;
    }

    private Document(Document srcDocument) {
        this.context = null;
        this.parent = srcDocument.parent;
        this.id = srcDocument.id;
        this.nodeValueMap = srcDocument.nodeValueMap;
        this.isPreserve = true;
    }

    public DocumentContext getContext() {
        return this.context;
    }

    public Document getParent() {
        return this.parent;
    }

    public String getId() {
        return this.id;
    }

    void setId(String documentId) {
        this.id = documentId;
    }

    public Map getTagValueMapView() {
        Map m = this.tagValueMapView;
        return m != null ? m : (this.tagValueMapView = Collections.unmodifiableMap(this.nodeValueMap));
    }

    public boolean containsId(String tagId) {
        if (tagId == null) {
            throw new NullPointerException();
        }
        if (Eval.isContains((String)tagId, (char)':')) {
            int off = tagId.indexOf(58);
            String documentId = tagId.substring(0, off);
            String nodeId = tagId.substring(++off);
            return this.containsId(documentId, nodeId);
        }
        return this.nodeValueMap.containsKey(tagId);
    }

    private boolean containsId(String documentId, String nodeId) {
        if (documentId.equals(this.getId())) {
            return this.nodeValueMap.containsKey(nodeId);
        }
        if (null != this.getParent()) {
            return this.getParent().containsId(documentId, nodeId);
        }
        return false;
    }

    public Object getTagValueById(String tagId) {
        if (tagId == null) {
            throw new NullPointerException();
        }
        if (Eval.isContains((String)tagId, (char)':')) {
            int off = tagId.indexOf(58);
            String documentId = tagId.substring(0, off);
            String nodeId = tagId.substring(++off);
            return this.getTagValueById(documentId, nodeId);
        }
        return this.nodeValueMap.get(tagId);
    }

    private Object getTagValueById(String documentId, String nodeId) {
        if (documentId.equals(this.getId())) {
            return this.nodeValueMap.get(nodeId);
        }
        if (null != this.getParent()) {
            return this.getParent().getTagValueById(documentId, nodeId);
        }
        return null;
    }

    void addReferenceNodeValue(TagNode node) {
        String nodeId;
        if (node == null) {
            throw new NullPointerException();
        }
        if (node instanceof ValueNode && !Eval.isBlank((CharSequence)(nodeId = node.getId()))) {
            if (this.nodeValueMap.containsKey(nodeId)) {
                throw new GinkgoException("That ID has already been registered. id:" + nodeId + ".");
            }
            this.nodeValueMap.put(nodeId, ((ValueNode)((Object)node)).getNodeValue());
        }
    }

    public boolean isPreserve() {
        return this.isPreserve;
    }

    public Document getPreserveDocument() {
        return new Document(this);
    }

    void endElement(TagNode node) {
        this.addReferenceNodeValue(node);
    }
}

