/*
SRUniversalAccessPref.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRSoundManager.h"

#import "SRUniversalAccessPref.h"
#import "SRPrefDefaultKeys.H"

@implementation SRUniversalAccessPref

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

- (void)_setUpSoundPopUp:(NSPopUpButton*)popUp forActionName:(NSString*)actionName
{
    NSUserDefaults* defaults;
    defaults = [NSUserDefaults standardUserDefaults];
    
    // Remove all objects
    [popUp removeAllItems];
    
    // Get menu
    NSMenu* menu;
    menu = [popUp menu];
    
    id<NSMenuItem>  menuItem;
    
    // Add 'None'
    menuItem = [menu addItemWithTitle:NSLocalizedString(@"None", nil) action:NULL keyEquivalent:@""]; 
    [menuItem setRepresentedObject:@"None"];
    [menu addItem:[NSMenuItem separatorItem]];
    
    // Add sound file name
    NSArray*        soundPaths;
    NSEnumerator*   soundPathEnumerator;
    NSString*       soundPath;
    soundPaths = HMSoundFilePaths();
    soundPathEnumerator = [soundPaths objectEnumerator];
    while (soundPath = [soundPathEnumerator nextObject]) {
        NSString*   soundName;
        soundName = [soundPath lastPathComponent];
        soundName = [soundName stringByDeletingPathExtension];
        
        menuItem = [menu addItemWithTitle:soundName action:NULL keyEquivalent:@""]; 
        [menuItem setRepresentedObject:soundPath];
    }
    
    // Add Shiira sounds
    NSArray*    shiiraSoundPaths;
    shiiraSoundPaths = [[NSBundle mainBundle] pathsForResourcesOfType:@"aiff" inDirectory:nil];
    if ([shiiraSoundPaths count] > 0) {
        [menu addItem:[NSMenuItem separatorItem]];
        
        soundPathEnumerator = [shiiraSoundPaths objectEnumerator];
        while (soundPath = [soundPathEnumerator nextObject]) {
            NSString*   soundName;
            soundName = [soundPath lastPathComponent];
            soundName = [soundName stringByDeletingPathExtension];
            
            menuItem = [menu addItemWithTitle:soundName action:NULL keyEquivalent:@""]; 
            [menuItem setRepresentedObject:soundPath];
        }
    }
    
    // Set sound
    soundPath = [defaults stringForKey:actionName];
    if (soundPath) {
        int index;
        index = [popUp indexOfItemWithRepresentedObject:soundPath];
        if (index != -1) {
            [popUp selectItemAtIndex:index];
        }
    }
    else {
        [popUp selectItemAtIndex:0];
    }
}

- (void)awakeFromNib
{
    // Set up sound pop up
    [self _setUpSoundPopUp:_pageLoadDonePopUp forActionName:SRUniversalAccessSoundPageLoadDone];
    [self _setUpSoundPopUp:_pageLoadErrorPopUp forActionName:SRUniversalAccessSoundPageLoadError];
    [self _setUpSoundPopUp:_javaScriptDialogPopUp forActionName:SRUniversalAccessSoundJavaScriptDialog];
}

//--------------------------------------------------------------//
#pragma mark -- Actions --
//--------------------------------------------------------------//

- (void)setSoundAction:(id)sender
{
    // Dcide action name
    NSString*   actionName = nil;
    if (sender == _pageLoadDonePopUp) {
        actionName = SRUniversalAccessSoundPageLoadDone;
    }
    if (sender == _pageLoadErrorPopUp) {
        actionName = SRUniversalAccessSoundPageLoadError;
    }
    if (sender == _javaScriptDialogPopUp) {
        actionName = SRUniversalAccessSoundJavaScriptDialog;
    }
    if (!actionName) {
        return;
    }
    
    // Get selected sound file
    NSString*   soundFilePath;
    soundFilePath = [[sender selectedItem] representedObject];
    if (!soundFilePath) {
        return;
    }
    
    // Set sound
    [[NSClassFromString(@"SRSoundManager") sharedInstance] 
            setSound:soundFilePath forAction:actionName];
    
    // Sound test
    [[NSClassFromString(@"SRSoundManager") sharedInstance] playSoundForAction:actionName];
}

@end
