/*
HMMouseOverButtonCell.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "HMMouseOverButtonCell.h"

@implementation HMMouseOverButtonCell

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

- (void)dealloc
{
    [_enabledImage release], _enabledImage = nil;
    [_mouseOverImage release], _mouseOverImage = nil;
    
    [super dealloc];
}

- (void)mouseEntered:(NSEvent*)event
{
    [[self controlView] setNeedsDisplay:YES];
}

- (void)mouseExited:(NSEvent*)event
{
    [[self controlView] setNeedsDisplay:YES];
}

//--------------------------------------------------------------//
#pragma mark -- Image --
//--------------------------------------------------------------//

- (void)setImage:(NSImage*)image
{
    [super setImage:image];
    
    // Keep enabled image
    if (!_enabledImage && image != _mouseOverImage) {
        _enabledImage = [image retain];
    }
}

- (NSImage*)mouseOverImage
{
    return _mouseOverImage;
}

- (void)setMouseOverImage:(NSImage*)image
{
    [_mouseOverImage release], _mouseOverImage = nil;
    _mouseOverImage = [image retain];
}

//--------------------------------------------------------------//
#pragma mark -- Drawing --
//--------------------------------------------------------------//

- (void)drawWithFrame:(NSRect)cellFrame inView:(NSView*)controlView
{
    // Get mouse location
    NSPoint point;
    point = [NSEvent mouseLocation];
    point = [[controlView window] convertScreenToBase:point];
    point = [controlView convertPoint:point fromView:nil];
    
    // Set image
    NSImage*    image;
    image = [self image];
    if (NSPointInRect(point, cellFrame)) {
        if (image != _mouseOverImage) {
            [self setImage:_mouseOverImage];
        }
    }
    else {
        if (image != _enabledImage) {
            [self setImage:_enabledImage];
        }
    }
    
    // Invoke super
    [super drawWithFrame:cellFrame inView:controlView];
}

@end
