/*
SRImageInfoCell.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRImageInfoCell.h"

@implementation SRImageInfoCell

//--------------------------------------------------------------//
#pragma mark -- NSCell methods --
//--------------------------------------------------------------//
#if 0
- (BOOL)isSelectable
{
    return YES;
}
#endif

- (void)drawWithFrame:(NSRect)cellFrame inView:(NSView*)controlView
{
    // Highlight itself
    if ([self state] == NSOnState) {
        // Set highlight color
        [[self highlightColorWithFrame:cellFrame inView:controlView] set];
    }
    else {
        // Set white color
        [[NSColor whiteColor] set];
    }
    NSRectFill(cellFrame);
    
    [super drawWithFrame:cellFrame inView:controlView];
}

- (void)drawInteriorWithFrame:(NSRect)cellFrame inView:(NSView*)controlView
{
    // Draw image
    NSImage*    image;
    image = [self image];
    if (image) {
        // Check flip
        if ([controlView isFlipped] != [image isFlipped]) {
            [image setFlipped:[controlView isFlipped]];
        }
        
        // Get source rect
        NSRect  srcRect;
        srcRect.origin = NSZeroPoint;
        srcRect.size = [image size];
        
        // Decide ratio
        float   ratioW, ratioH, ratio;
        ratioW = cellFrame.size.width / srcRect.size.width;
        ratioH = cellFrame.size.height / srcRect.size.height;
        ratio = ratioW < ratioH ? ratioW : ratioH;
        if (ratio > 1.0f) {
            ratio = 1.0f;
        }
        
        // Set destination rect
        NSRect  destRect;
        destRect.size.width = srcRect.size.width * ratio;
        destRect.size.height = srcRect.size.height * ratio;
        destRect.origin.x = cellFrame.origin.x + (cellFrame.size.width - destRect.size.width) / 2.0f;
        destRect.origin.y = cellFrame.origin.y + (cellFrame.size.height - destRect.size.height) / 2.0f;
        
        // Draw image
        [image drawInRect:destRect fromRect:srcRect operation:NSCompositeSourceOver fraction:1.0f];
    }
}

@end
