/*
SRShelfRepresentation.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRShelfController.h"
#import "SRShelfRepresentation.h"

@implementation SRShelfRepresentation

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

+ (void)load
{
    NSAutoreleasePool*  pool;
    pool = [[NSAutoreleasePool alloc] init];
    
    static isRegistered = NO;
    if (!isRegistered) {
        // Register itself
        [WebView registerViewClass:NSClassFromString(@"SRShelfView") 
                representationClass:NSClassFromString(@"SRShelfRepresentation") 
                forMIMEType:@"shiira/shelf"];
        isRegistered = YES;
    }
    
    [pool release];
}

- (id)init
{
    self = [super init];
    if (!self) {
        return nil;
    }
    
    // Initialize instance variables
    _shelfController = [[SRShelfController alloc] init];
    
    return self;
}

- (void)dealloc
{
    [_shelfController release], _shelfController = nil;
    
    [super dealloc];
}

//--------------------------------------------------------------//
#pragma mark -- Controller --
//--------------------------------------------------------------//

- (SRShelfController*)shelfController
{
    return _shelfController;
}

//--------------------------------------------------------------//
#pragma mark -- WebDocumentRepresentation protocol --
//--------------------------------------------------------------//

- (void)setDataSource:(WebDataSource*)dataSource
{
}

- (void)receivedData:(NSData*)data withDataSource:(WebDataSource*)dataSource
{
}

- (void)receivedError:(NSError*)error withDataSource:(WebDataSource*)dataSource
{
}

- (void)finishedLoadingWithDataSource:(WebDataSource*)dataSource
{
}

- (BOOL)canProvideDocumentSource
{
    return NO;
}

- (NSString*)documentSource
{
    return nil;
}

- (NSString*)title
{
    return @"Shelf";
}

@end
