/*
SRGeneralPref.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRGeneralPref.h"
#import "SRPrefDefaultKeys.h"

#import "SRBrowserMenuProvider.h"

// Utility
NSWindow* SRGetFrontBrowserWindow();

@implementation SRGeneralPref

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

- (void)awakeFromNib
{
    // Update browser pop up menu
    NSMenu*         menu;
    NSArray*        menuItems;
    NSEnumerator*   enumerator;
    NSMenuItem*     menuItem;
    menu = [_browserPopUp menu];
    menuItems = SRBrowserMenuItems(YES);
    
    [_browserPopUp removeAllItems];
    enumerator = [menuItems objectEnumerator];
    while (menuItem = [enumerator nextObject]) {
        [menuItem setTarget:self];
        [menu addItem:menuItem];
    }
    
    // Select current default browser
    NSString*   browserId;
    browserId = (NSString*)LSCopyDefaultHandlerForURLScheme(CFSTR("http"));
    if (browserId) {
        int index;
        index = [_browserPopUp indexOfItemWithRepresentedObject:browserId];
        if (index != NSNotFound) {
            [_browserPopUp selectItemAtIndex:index];
        }
        
        [browserId release];
    }
}

//--------------------------------------------------------------//
#pragma mark -- Action --
//--------------------------------------------------------------//

- (void)setHomePageAsCurrentAction:(id)sender
{
    // Get front window
    NSWindow*   frontWindow;
    frontWindow = SRGetFrontBrowserWindow();
    if (!frontWindow) {
        return;
    }
    
    // Get URL string
    WebView*    webView;
    NSString*   URLString;
    webView = [[[frontWindow windowController] performSelector:@selector(selectedPageController)] webView];
    URLString = [[[[[webView mainFrame] dataSource] request] URL] absoluteString];
    if (!URLString) {
        return;
    }
    
    // Set to current page
    NSUserDefaults* defaults;
    defaults = [NSUserDefaults standardUserDefaults];
    [defaults setObject:URLString forKey:SRGeneralHomePgae];
}

- (void)openURLWithAction:(id)sender
{
    // Get selected browser ID
    NSString*   browserId;
    browserId = [[_browserPopUp selectedItem] representedObject];
    if (!browserId) {
        return;
    }
    
    // Set default browser
    OSStatus    status;
    status = LSSetDefaultHandlerForURLScheme(CFSTR("http"), (CFStringRef)browserId);
}

@end

//--------------------------------------------------------------//
#pragma mark -- Utility --
//--------------------------------------------------------------//

NSWindow* SRGetFrontBrowserWindow()
{
    // Get window number list
    int     count;
    int*    list;
    NSCountWindowsForContext((int)NULL, &count);
    list = malloc(sizeof(int) * count);
    NSWindowListForContext((int)NULL, sizeof(int) * count, list);
    
    // Find browser window
    Class       browserControllerClass;
    NSWindow*   window = nil;
    int         i;
    browserControllerClass = NSClassFromString(@"SRBrowserController");
    for (i = 0; i < count; i++) {
        // Get window
        window = [NSApp windowWithWindowNumber:list[i]];
        if (!window) {
            continue;
        }
        
        // Get window controller
        id  windowController;
        windowController = [window windowController];
        if ([windowController isKindOfClass:browserControllerClass]) {
            break;
        }
    }
    
    free(list);
    
    return window;
}
