/*
SRPlugIn.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRPlugIn.h"
#import "SRPlugInProtocol.h"

#import "SRAppControllerProxy.h"
#import "SRBrowserControllerProxy.h"
#import "SRPageControllerProxy.h"
#import "SRBookmarkProxy.h"

static NSMutableDictionary* _plugInDict = nil;

@implementation SRPlugIn

//--------------------------------------------------------------//
#pragma mark -- Plug-in registration --
//--------------------------------------------------------------//

+ (void)registerPlugIn
{
    // Get info dict
    NSDictionary*   infoDict;
    infoDict = [[NSBundle bundleForClass:self] infoDictionary];
    
    // Get protocol class
    Class   protocolClass;
    protocolClass = NSClassFromString([infoDict objectForKey:@"SRProtocolClass"]);
    if (!protocolClass) {
        // Error
        NSLog(@"protocolClass is nil");
        return;
    }
    
    // Register protocol
    [protocolClass registerClass:protocolClass];
    
    // Get MIME type
    NSString*   MIMEType;
    MIMEType = [protocolClass MIMEType];
    if (!MIMEType) {
        // Error
        NSLog(@"MIMEType is nil");
        return;
    }
    
    // Register representation and view class
    [WebView registerViewClass:NSClassFromString(@"SRPlugInView") 
            representationClass:NSClassFromString(@"SRPlugInRepresentation")  
            forMIMEType:MIMEType];
    
    // Register plug-in
    if (!_plugInDict) {
        _plugInDict = [[NSMutableDictionary dictionary] retain];
    }
    [_plugInDict setObject:self forKey:MIMEType];
}

+ (Class)plugInClassForMIMEType:(NSString*)MIMEType
{
    if (!_plugInDict) {
        return nil;
    }
    return [_plugInDict objectForKey:MIMEType];
}

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

- (void)loadMainNib
{
    // Get bundle
    NSBundle*   bundle;
    bundle = [NSBundle bundleForClass:[self class]];
    
    // Get nib file name
    NSString*   nibFileName;
    nibFileName = [[bundle infoDictionary] objectForKey:@"SRPlugInNibFile"];
    if (!nibFileName) {
        // Error
        NSLog(@"Can't find nib file name");
        return;
    }
    
    // Load nib
    NSDictionary*   context;
    context = [NSDictionary dictionaryWithObject:self forKey:@"NSOwner"];
    if (![bundle loadNibFile:nibFileName externalNameTable:context withZone:nil]) {
        // Error
        NSLog(@"Failed to load nib file %@", nibFileName);
    }
}

- (void)didLoad
{
    // Subclass overrides
}

- (void)dealloc
{
    [super dealloc];
}

//--------------------------------------------------------------//
#pragma mark -- Controller --
//--------------------------------------------------------------//

- (id<SRAppController>)appController
{
    return _appController;
}

- (void)setAppController:(id<SRAppController>)appController
{
    _appController = appController;
}

- (id<SRBrowserController>)browserController
{
    return _browserController;
}

- (void)setBrowserController:(id<SRBrowserController>)browserController
{
    _browserController = browserController;
}

- (id<SRWebHistory>)webHistory
{
    return _webHistory;
}

- (void)setWebHistory:(id<SRWebHistory>)webHistory
{
    _webHistory = webHistory;
}

//--------------------------------------------------------------//
#pragma mark -- Persistent stack --
//--------------------------------------------------------------//

- (NSManagedObjectContext*)managedObjectContext
{
    return [_appController managedObjectContext];
}

//--------------------------------------------------------------//
#pragma mark -- Accessing to view --
//--------------------------------------------------------------//

- (NSView*)mainView
{
    return _mainView;
}

//--------------------------------------------------------------//
#pragma mark -- Accessors --
//--------------------------------------------------------------//

- (NSString*)title
{
    return [[[NSBundle bundleForClass:[self class]] infoDictionary] objectForKey:@"SRPlugInTitle"];
}

@end
