/*
SRPageController.h

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "HMDTFoundation.h"
#import "HMDTAppKit.h"
#import "HMDTWebKit.h"

// Notifications
extern NSString*    SRPageDidStartProvisionalLoad;
extern NSString*    SRPageDidCommitLoad;
extern NSString*    SRPageDidFinishLoad;
extern NSString*    SRPageDidReceiveServerRedirect;
extern NSString*    SRPageTitleReceived;
extern NSString*    SRPageIconReceived;
extern NSString*    SRPageProgressStart;
extern NSString*    SRPageProgressEstimateChanged;
extern NSString*    SRPageProgressFinish;

@class SRBrowserController;

@interface SRPageController : NSObject
{
    SRBrowserController*    _browserController;
    HMTabViewItem*          _tabViewItem;
    
    NSImage*                _documentViewImage;
    NSBitmapImageRep*       _documentViewImageRep;
    BOOL                    _documentViewNeedsUpdate;
    NSImage*                _webViewImage;
    NSBitmapImageRep*       _webViewImageRep;
    BOOL                    _webViewNeedsUpdate;
    
    float                   _loadingTime;
    CFAbsoluteTime          _startTime;
    
    NSString*               _shelfIdWillOpen;
}

// Initialize
- (id)initWithBrowserController:(SRBrowserController*)browserController 
        label:(NSString*)label frameName:(NSString*)frameName groupName:(NSString*)groupName;

// Controller
- (SRBrowserController*)browserController;

// Tab view item
- (HMTabViewItem*)tabViewItem;

// Web view
- (WebView*)webView;

// User agent
- (void)setUserAgent:(int)userAgent;

// Opening page with request
- (WebView*)openRequest:(NSURLRequest*)request;

// Page info
- (float)loadingTime;

// Page image
- (NSImage*)documentViewImage;
- (NSBitmapImageRep*)documentViewImageBitmapRep;
- (NSImage*)webViewImage;
- (NSBitmapImageRep*)webViewImageBitmapRep;
- (void)updateDocumentViewImage;
- (void)updateWebViewImage;
- (void)clearPageImage;

// Shelf
- (void)setSelectedShelfId:(NSString*)shelfId;

@end
