/*
SRAboutController.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRAboutController.h"

@implementation SRAboutController

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

+ (id)sharedInstance
{
    static SRAboutController*   _sharedInstance = nil;
    if (!_sharedInstance) {
        _sharedInstance = [[SRAboutController alloc] init];
    }
    
    return _sharedInstance;
}

- (id)init
{
    self = [super initWithWindowNibName:@"About"];
    if (!self) {
        return nil;
    }
    
    // Initialize instance variables
    
    return self;
}

- (void)awakeFromNib
{
    // Set frame auto save name
    if (![[self window] frameAutosaveName]) {
        [[self window] setFrameAutosaveName:@"SRAboutControllerFrame"];
    }
    
    // Get bundle
    NSBundle*       bundle;
    NSDictionary*   infoDict;
    bundle = [NSBundle mainBundle];
    infoDict = [[NSBundle mainBundle] infoDictionary];
    
    // Set version
    NSString*   shortVersion;
    NSString*   version;
    shortVersion = [infoDict objectForKey:@"CFBundleShortVersionString"];
    version = [infoDict objectForKey:@"CFBundleVersion"];
    
    NSString*   versionString = @"";
    if (shortVersion && version && [version length] > 1) {
        versionString = [NSString stringWithFormat:@"%@ (%@)", shortVersion, version];
    }
    else if (shortVersion) {
        versionString = shortVersion;
    }
    [_versionTextField setStringValue:versionString];
    
    // Set credit
    NSString*   creditPath;
    creditPath = [bundle pathForResource:@"Credits" ofType:@"rtf"];
    if (creditPath) {
        NSAttributedString* credit;
        credit = [[NSAttributedString alloc] initWithPath:creditPath documentAttributes:NULL];
        [credit autorelease];
        if (credit) {
            [[_creditTextView textStorage] setAttributedString:credit];
        }
    }
}

@end
