/*
HMWebKitEx.h

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>

@interface NSPasteboard (WebExtras)
+ (void)initialize;
+ (id)_web_writableTypesForURL;
+ (id)_web_writableTypesForImageIncludingArchive:(BOOL)fp8;
+ (id)_web_dragTypesForURL;
+ (int)_web_setFindPasteboardString:(id)fp8 withOwner:(id)fp12;
- (id)_web_bestURL;
- (void)_web_writeURL:(id)fp8 andTitle:(id)fp12 types:(id)fp16;
- (void)_web_writeFileWrapperAsRTFDAttachment:(id)fp8;
- (void)_web_writeImage:(id)fp8 URL:(id)fp12 title:(id)fp16 archive:(id)fp20 types:(id)fp24;
- (id)_web_declareAndWriteDragImage:(id)fp8 URL:(id)fp12 title:(id)fp16 archive:(id)fp20 source:(id)fp24;
@end

@interface NSURL (WebNSURLExtras)
+ (id)_web_URLWithUserTypedString:(id)fp8;
- (id)_web_userVisibleString;
- (id)_web_hostString;
@end

@protocol WebCoreImageRenderer <NSObject, NSCopying>
- (BOOL)incrementalLoadWithBytes:(const void *)fp8 length:(unsigned int)fp12 complete:(BOOL)fp16 callback:(id)fp20;
- (struct _NSSize)size;
- (void)resize:(struct _NSSize)fp8;
- (void)drawImageInRect:(struct _NSRect)fp8 fromRect:(struct _NSRect)fp24;
- (void)drawImageInRect:(struct _NSRect)fp8 fromRect:(struct _NSRect)fp24 compositeOperator:(int)fp40 context:(struct CGContext *)fp44;
- (void)stopAnimation;
- (void)tileInRect:(struct _NSRect)fp8 fromPoint:(struct _NSPoint)fp24 context:(struct CGContext *)fp32;
- (BOOL)isNull;
- (id)retainOrCopyIfNeeded;
- (void)increaseUseCount;
- (void)decreaseUseCount;
- (void)flushRasterCache;
- (struct CGImage *)imageRef;
- (void)resetAnimation;
@end

@interface WebFrame (Resources)
- (NSArray*)subresources;
@end

@interface WebPreferences (Preferences)
- (BOOL)isPlugInsEnabled;
@end

@protocol WebDocumentDragging <NSObject>
@end
@protocol WebDocumentElement <NSObject>
@end
@protocol WebDocumentSelection <NSObject>
@end

@interface WebHTMLView : NSView <WebDocumentView, WebDocumentSearching, WebDocumentText, WebDocumentDragging, WebDocumentElement, WebDocumentSelection>
{
    id  _private;
}
- (void)_layoutIfNeeded;
- (void)_resetCachedWebPreferences:(NSNotification*)ignored;
- (void)jumpToSelection:(id)sender;
@end

extern NSString*    WebIconDatabaseDidAddIconNotification;

@interface WebIconDatabase : NSObject
{
    id _private;
}
+ (WebIconDatabase*)sharedIconDatabase;
- (NSImage*)iconForURL:(NSString*)URL withSize:(NSSize)size;
- (NSImage*)iconForURL:(NSString*)urlString withSize:(NSSize)size cache:(BOOL)flag;
- (NSString*)iconURLForURL:(NSString*)URL;
- (NSImage*)defaultIconWithSize:(NSSize)size;
- (void)retainIconForURL:(NSString*)URL;
- (void)releaseIconForURL:(NSString*)URL;
- (void)delayDatabaseCleanup;
- (void)allowDatabaseCleanup;
@end

@interface WebIconDatabase (WebPrivate)
- (BOOL)_isEnabled;
- (void)_setIcon:(NSImage*)icon forIconURL:(NSString*)iconURL;
- (void)_setHaveNoIconForIconURL:(NSString*)iconURL;
- (void)_setIconURL:(NSString*)iconURL forURL:(NSString*)URL;
- (BOOL)_hasIconForIconURL:(NSString*)iconURL;
@end

@interface WebURLsWithTitles : NSObject
{
}

+ (id)arrayWithIFURLsWithTitlesPboardType;
+ (void)writeURLs:(id)fp8 andTitles:(id)fp12 toPasteboard:(id)fp16;
+ (id)titlesFromPasteboard:(id)fp8;
+ (id)URLsFromPasteboard:(id)fp8;
@end

@interface WebURLsWithTitles (NSURLExtras)
+ (id)_web_userVisibleURLStringsFromPasteboard:(NSPasteboard*)pboard;
@end

@interface WebView (DocumentText)
- (NSString*)selectedString;
@end

@interface WebView (WebPrivate)
+ (BOOL)_canHandleRequest:(id)request;

- (void)_close;

- (BOOL)canMakeTextStandardSize;
- (IBAction)makeTextStandardSize:(id)sender;
@end

@interface WebView (WebPendingPublic)
- (void)setMainFrameURL:(id)fp8;
- (id)mainFrameURL;
- (BOOL)isLoading;
- (id)mainFrameTitle;
- (id)mainFrameIcon;
- (void)setDrawsBackground:(BOOL)fp8;
- (BOOL)drawsBackground;
- (void)toggleSmartInsertDelete:(id)fp8;
- (void)toggleContinuousSpellChecking:(id)fp8;
- (BOOL)isContinuousGrammarCheckingEnabled;
- (void)setContinuousGrammarCheckingEnabled:(BOOL)fp8;
- (void)toggleContinuousGrammarChecking:(id)fp8;
- (void)setScriptDebugDelegate:(id)fp8;
- (id)scriptDebugDelegate;
- (BOOL)shouldClose;
@end
