/*
HMWebIconDatabase.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "HMWebIconDatabase.h"

static IMP  _defaultIconWithSize_ = NULL;

//--------------------------------------------------------------//
#pragma mark -- Default icon --
//--------------------------------------------------------------//

static id defaultIconWithSize_(
        id self, SEL _cmd, NSSize size)
{
    static NSImage* _defaultIcon = nil;
    
    // Get earth.tiff
    if (!_defaultIcon) {
        NSString*   path;
        path = [[NSBundle bundleForClass:NSClassFromString(@"HMAnchorNodeFilter")] 
                pathForResource:@"earth" ofType:@"tiff"];
        if (path) {
            _defaultIcon = [[NSImage alloc] initByReferencingFile:path];
        }
    }
    
    // Copy and resize icon
    NSImage*    icon;
    icon = [[_defaultIcon copy] autorelease];
    [icon setScalesWhenResized:YES];
    [icon setSize:size];
    
    return icon;
}

//--------------------------------------------------------------//
#pragma mark -- Posing --
//--------------------------------------------------------------//

void HMWebIconDatabaseLoad()
{
    static BOOL _isInitialized = NO;
    if (_isInitialized) {
        return;
    }
    _isInitialized = YES;
    
    // Get WebIconDatabase class
    Class   klass;
    klass = NSClassFromString(@"WebIconDatabase");
    
    // Swap methods
    HMSwapMethod(klass, @selector(defaultIconWithSize:), 
            (IMP)defaultIconWithSize_, 
            &_defaultIconWithSize_);
}
