/*
HMWebBridge.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "HMWebKitDefaultKeys.h"
#import "HMWebBridge.h"

static IMP  _startLoadingResource_withRUL_customHeaders_ = NULL;

//--------------------------------------------------------------//
#pragma mark -- Resource loading --
//--------------------------------------------------------------//

static id startLoadingResource_withRUL_customHeaders_(
        id self, SEL _cmd, id resource, NSURL* url, id headers)
{
    // Check preferences
    if ([[NSUserDefaults standardUserDefaults] boolForKey:HMLoadsSameDomainImagesAutomatically]) {
        // Get domain and extension
        NSString*   host;
        NSString*   extension;
        host = [url host];
        extension = [[url path] pathExtension];
        
        // For image file
        static NSArray* _imgExtensions = nil;
        if (!_imgExtensions) {
            _imgExtensions = [[NSArray arrayWithObjects:@"gif", @"jpg", @"png", nil] retain];
        }
        
        if ([_imgExtensions containsObject:extension]) {
            // Get domain of request
            WebFrame*   frame;
            NSString*   requestHost;
            frame = [self webFrame];
            requestHost = [[[[frame dataSource] request] URL] host];
            
            if (![requestHost isEqualToString:host]) {
                return nil;
            }
        }
    }
    
    // Invoke old method
    return _startLoadingResource_withRUL_customHeaders_(self, _cmd, resource, url, headers);
}

//--------------------------------------------------------------//
#pragma mark -- Posing --
//--------------------------------------------------------------//

void HMWebBridgeLoad()
{
    static BOOL _isInitialized = NO;
    if (_isInitialized) {
        return;
    }
    _isInitialized = YES;
    
    // Get WebImageRenderer class
    Class   klass;
    klass = NSClassFromString(@"WebBridge");
    
    // Swap methods
    HMSwapMethod(klass, @selector(startLoadingResource:withURL:customHeaders:), 
            (IMP)startLoadingResource_withRUL_customHeaders_, 
            &_startLoadingResource_withRUL_customHeaders_);
}
