/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.util;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

public class MacUtil {
    protected static final String osName = System.getProperty("os.name");
    protected static final String fileSeparator = System.getProperty("file.separator");
    protected static final String javaHome = System.getProperty("java.home");
    protected static final String userHome = System.getProperty("user.home");

    public static File getStartupFile() {
        return new File(userHome, "Library/LaunchAgents/xdman.plist");
    }

    public static boolean isInstalled() throws Exception {
        return MacUtil.getStartupFile().exists();
    }

    protected static File getJarFile() throws Exception {
        return new File(MacUtil.class.getProtectionDomain().getCodeSource().getLocation().toURI());
    }

    public static void install() throws Exception {
        File startupFile = MacUtil.getStartupFile();
        PrintWriter out = new PrintWriter(new FileWriter(startupFile));
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<!DOCTYPE plist PUBLIC \"-//Apple Computer//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">");
        out.println("<plist version=\"1.0\">");
        out.println("<dict>");
        out.println("   <key>Label</key>");
        out.println("   <string>xdman</string>");
        out.println("   <key>ProgramArguments</key>");
        out.println("   <array>");
        out.println("      <string>" + javaHome + fileSeparator + "bin" + fileSeparator + "java</string>");
        out.println("      <string>-jar</string>");
        out.println("      <string>" + MacUtil.getJarFile() + "</string>");
        out.println("      <string>-m</string>");
        out.println("   </array>");
        out.println("   <key>RunAtLoad</key>");
        out.println("   <true/>");
        out.println("</dict>");
        out.println("</plist>");
        out.close();
    }

    public static void uninstall() {
        File startupFile = MacUtil.getStartupFile();
        if (startupFile.exists()) {
            startupFile.delete();
        }
    }

    public static void main(String[] args) throws Exception {
        MacUtil.install();
    }
}

