/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.sdg.xdman.gui.MainWindow;
import org.sdg.xdman.gui.MediaInfo;
import org.sdg.xdman.gui.MediaTableModel;
import org.sdg.xdman.util.Java6Util;

public class MediaGrabberWindow
extends JFrame
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 8673545666964719266L;
    JButton download;
    JButton remove;
    JButton copy;
    MediaTableModel model;
    JTable table;
    MainWindow mw;
    JCheckBox top;

    public MediaGrabberWindow(MediaTableModel model, MainWindow mw) {
        this.setIconImage(MainWindow.icon.getImage());
        this.model = model;
        this.mw = mw;
        this.init();
    }

    public void init() {
        this.setSize(500, 300);
        this.setTitle("XDM Media Grabber");
        this.table = new JTable(this.model);
        Java6Util.jtable$setAutoCreateRowSorter(this.table);
        this.add(new JScrollPane(this.table));
        Box box = Box.createHorizontalBox();
        this.top = new JCheckBox("Always on top");
        this.top.addItemListener(this);
        box.add(this.top);
        box.add(Box.createHorizontalGlue());
        this.copy = new JButton("Copy");
        this.copy.addActionListener(this);
        this.download = new JButton("Download");
        this.download.addActionListener(this);
        this.remove = new JButton("Remove");
        this.remove.addActionListener(this);
        box.add(this.copy);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.download);
        box.add(Box.createHorizontalStrut(10));
        box.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        box.add(this.remove);
        this.add((Component)box, "South");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.download) {
            System.out.println("Download video");
            int index = this.table.getSelectedRow();
            if (index < 0) {
                JOptionPane.showMessageDialog(this, "No item selected");
                return;
            }
            index = Java6Util.jtable$convertRowIndexToModel(this.table, index);
            MediaInfo info = this.model.list.get(index);
            if (this.mw != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("referer", info.referer);
                this.mw.addURL(info.url, null, map, null);
            }
        } else if (e.getSource() == this.remove) {
            System.out.println("Remove video");
            int[] index = this.table.getSelectedRows();
            if (index.length < 1) {
                JOptionPane.showMessageDialog(this, "No item selected");
                return;
            }
            MediaInfo[] info = new MediaInfo[index.length];
            int i = 0;
            while (i < index.length) {
                int row = Java6Util.jtable$convertRowIndexToModel(this.table, index[i]);
                info[i] = this.model.list.get(row);
                ++i;
            }
            i = 0;
            while (i < index.length) {
                this.model.list.remove(info[i]);
                ++i;
            }
            this.model.fireTableDataChanged();
        } else if (e.getSource() == this.copy) {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                JOptionPane.showMessageDialog(this, "No item selected");
                return;
            }
            index = Java6Util.jtable$convertRowIndexToModel(this.table, index);
            MediaInfo info = this.model.list.get(index);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(info.url), null);
        }
    }

    public void itemStateChanged(ItemEvent arg0) {
        System.out.println("On top");
        this.setAlwaysOnTop(this.top.isSelected());
    }
}

