/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import org.sdg.xdman.gui.HttpTableModel;
import org.sdg.xdman.gui.MainWindow;
import org.sdg.xdman.proxy.IConnection;
import org.sdg.xdman.util.Java6Util;

public class HttpMonitorDlg
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -1599332187194114536L;
    HttpTableModel model;
    JTable table;
    JButton stop;
    JButton copy;
    JTextArea headers;

    HttpMonitorDlg(HttpTableModel model) {
        this.setTitle("HTTP Monitor");
        try {
            this.setIconImage(MainWindow.icon.getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JSplitPane pane = new JSplitPane(0);
        this.model = model;
        this.table = new JTable(model);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int index = HttpMonitorDlg.this.table.getSelectedRow();
                if (index < 0) {
                    return;
                }
                int idx = Java6Util.jtable$convertRowIndexToModel(HttpMonitorDlg.this.table, index);
                IConnection c = HttpMonitorDlg.this.model.arr.get(idx);
                HttpMonitorDlg.this.headers.setText("----Request Headers----\n" + c.getRequest() + "\n\n----Response Headers----\n" + c.getResponse());
            }
        });
        pane.add(new JScrollPane(this.table));
        JPanel tool = new JPanel();
        this.stop = new JButton("Stop Connection");
        tool.add(this.stop);
        this.stop.addActionListener(this);
        this.copy = new JButton("Copy Address");
        tool.add(this.copy);
        this.copy.addActionListener(this);
        this.add((Component)tool, "North");
        this.headers = new JTextArea();
        this.headers.setEditable(false);
        pane.add(new JScrollPane(this.headers));
        pane.setDividerLocation(200);
        this.add(pane);
        this.add((Component)new JLabel("   HTTP traffic captured by XDM"), "South");
    }

    public void actionPerformed(ActionEvent e) {
        int index = this.table.getSelectedRow();
        if (index == -1) {
            JOptionPane.showMessageDialog(this, "No item selected");
            return;
        }
        IConnection c = this.model.arr.get(Java6Util.jtable$convertRowIndexToModel(this.table, index));
        if (e.getSource() == this.stop) {
            c.stop();
        } else {
            String url = c.getURL();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(url), null);
        }
    }
}

