/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.sdg.xdman.gui.HelpListModel;
import org.sdg.xdman.gui.MainWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpDialog
extends JFrame
implements ListSelectionListener,
ActionListener {
    private static final long serialVersionUID = 2861769092407816472L;
    JButton back;
    JButton next;
    JEditorPane htmlPane;
    HelpListModel model;
    JList helpList;

    public HelpDialog() {
        this.setTitle("Quick Help");
        this.setSize(640, 480);
        this.setLocationRelativeTo(null);
        this.htmlPane = new JEditorPane();
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add(new JScrollPane(this.htmlPane));
        this.add(panel);
        this.model = new HelpListModel();
        this.helpList = new JList(this.model);
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)this.createToolBar(), "North");
        p.add(new JScrollPane(this.helpList));
        panel.add((Component)p, "West");
        try {
            this.setIconImage(MainWindow.icon.getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.helpList.addListSelectionListener(this);
        this.htmlPane.setEditable(false);
    }

    JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        this.next = new JButton(MainWindow.getIcon("next.png"));
        this.next.addActionListener(this);
        this.next.setRolloverIcon(MainWindow.getIcon("next_r.png"));
        this.back = new JButton(MainWindow.getIcon("back.png"));
        this.back.addActionListener(this);
        this.back.setRolloverIcon(MainWindow.getIcon("back_r.png"));
        toolbar.add(this.back);
        toolbar.add(this.next);
        return toolbar;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int index = this.helpList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        String key = "" + this.helpList.getSelectedValue();
        URL url = this.model.map.get(key);
        if (url != null) {
            this.setDocument(url);
        }
    }

    public void setDocument(URL url) {
        try {
            this.setPage(url);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Page could not be displayed");
        }
    }

    void setPage(URL url) throws IOException {
        this.htmlPane.setPage(url);
    }

    public void addPages(HashMap<String, URL> map) {
        this.model.map = map;
        this.helpList.setModel(this.model);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index;
        if (e.getSource() == this.back) {
            index = this.helpList.getSelectedIndex();
            if (index < 0) {
                index = 0;
                this.helpList.setSelectedIndex(index);
                return;
            }
            if (--index < 0) {
                return;
            }
            if (index < this.model.map.size()) {
                this.helpList.setSelectedIndex(index);
            }
        }
        if (e.getSource() == this.next) {
            index = this.helpList.getSelectedIndex();
            if (index < 0) {
                index = 0;
                this.helpList.setSelectedIndex(index);
                return;
            }
            if (++index > this.model.map.size()) {
                return;
            }
            if (index >= 0) {
                this.helpList.setSelectedIndex(index);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, URL> map = new HashMap<String, URL>();
        String dir = "F:\\Users\\subhra\\Desktop\\xdman\\help";
        map.put("Browser Integration", new File(dir, "Browser_Integration.html").toURI().toURL());
        map.put("Capturing Videos", new File(dir, "Video_download.html").toURI().toURL());
        map.put("Refresh Broken Downloads", new File(dir, "Refresh_Link.html").toURI().toURL());
        HelpDialog d = new HelpDialog();
        d.addPages(map);
        d.setVisible(true);
    }
}

