/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.sdg.xdman.core.common.XDMConfig;
import org.sdg.xdman.core.common.http.XDMHttpClient;
import org.sdg.xdman.gui.DownloadList;
import org.sdg.xdman.gui.MainWindow;
import org.sdg.xdman.proxy.RequestHandler;
import org.sdg.xdman.util.Java6Util;
import org.sdg.xdman.util.XDMUtil;

public class DownloadFileInfoDialog
extends JDialog
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 5445253177209103274L;
    JTextField url = new JTextField();
    JTextField file = new JTextField();
    JTextField dir = new JTextField();
    JTextField user = new JTextField();
    JPasswordField pass = new JPasswordField();
    ActionListener dl_action;
    ActionListener dn_action;
    JFileChooser fc;
    XDMHttpClient client;
    HashMap<String, String> extra;
    Object interceptor;
    XDMConfig config;
    boolean cancelled = true;
    DownloadList list;
    JButton dl;
    JButton dn;
    JButton cn;
    JButton br;
    public String cookies;

    public DownloadFileInfoDialog(ActionListener dl, ActionListener dn, XDMConfig config) {
        this.dl_action = dl;
        this.dn_action = dn;
        this.config = config;
        this.init();
    }

    void setURL(String uri) {
        this.url.setText(uri);
    }

    String getURL() {
        return this.url.getText();
    }

    String getFile() {
        return this.file.getText();
    }

    String getDir() {
        return this.dir.getText();
    }

    String getUser() {
        return this.user.getText();
    }

    String getPass() {
        return new String(this.pass.getPassword());
    }

    void setDir(String f) {
        this.dir.setText(f);
    }

    public DownloadFileInfoDialog() {
        this.init();
    }

    void showDlg() {
        if (this.url.getText().length() < 1) {
            try {
                Object obj = Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                String txt = "";
                if (obj != null) {
                    txt = obj.toString();
                }
                if (txt.length() > 0) {
                    int index = txt.indexOf(10);
                    if (index != -1) {
                        txt = txt.substring(0, index);
                    }
                    this.url.setText(new URL(txt).toString());
                }
            }
            catch (Exception obj) {
                // empty catch block
            }
        }
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(d.width / 2 - this.getWidth() / 2, d.height / 2 - this.getHeight() / 2);
        this.setVisible(true);
    }

    void init() {
        this.setTitle("New Download");
        try {
            Java6Util.jdialog$setIconImage(this, MainWindow.icon.getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void windowClosing(WindowEvent e) {
                System.out.println("CALLED");
                DownloadFileInfoDialog downloadFileInfoDialog = DownloadFileInfoDialog.this;
                synchronized (downloadFileInfoDialog) {
                    DownloadFileInfoDialog.this.notifyAll();
                }
                DownloadFileInfoDialog.this.setVisible(false);
            }
        });
        this.url.getDocument().addDocumentListener(this);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.insets = new Insets(5, 5, 5, 5);
        gc.gridx = 0;
        gc.gridy = 0;
        panel.add((Component)new JLabel("Address"), gc);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.gridwidth = 3;
        gc.weightx = 1.0;
        panel.add((Component)this.url, gc);
        gc.weightx = 0.0;
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 1;
        panel.add((Component)new JLabel("Save As"), gc);
        gc.weightx = 1.0;
        gc.gridx = 1;
        gc.gridy = 1;
        gc.gridwidth = 3;
        panel.add((Component)this.file, gc);
        gc.weightx = 0.0;
        gc.gridx = 0;
        gc.gridy = 2;
        gc.gridwidth = 1;
        panel.add((Component)new JLabel("Save In"), gc);
        gc.weightx = 1.0;
        gc.gridx = 1;
        gc.gridy = 2;
        gc.gridwidth = 2;
        panel.add((Component)this.dir, gc);
        this.dir.setEditable(false);
        gc.weightx = 0.0;
        gc.gridx = 3;
        gc.gridy = 2;
        gc.gridwidth = 1;
        this.br = new JButton("Browse...");
        this.br.addActionListener(this);
        panel.add((Component)this.br, gc);
        gc.weightx = 0.0;
        gc.gridx = 0;
        gc.gridy = 3;
        gc.gridwidth = 1;
        panel.add((Component)new JLabel("UserName"), gc);
        gc.weightx = 0.5;
        gc.gridx = 1;
        gc.gridy = 3;
        gc.gridwidth = 1;
        panel.add((Component)this.user, gc);
        gc.weightx = 0.0;
        gc.gridx = 2;
        gc.gridy = 3;
        gc.gridwidth = 1;
        panel.add((Component)new JLabel("Password"), gc);
        gc.weightx = 0.5;
        gc.gridx = 3;
        gc.gridy = 3;
        gc.gridwidth = 1;
        panel.add((Component)this.pass, gc);
        this.dl = new JButton("Download Later");
        this.dl.addActionListener(this);
        this.dn = new JButton("Download Now");
        this.dn.addActionListener(this);
        this.cn = new JButton("Cancel");
        this.cn.addActionListener(this);
        gc.weightx = 0.0;
        gc.gridx = 1;
        gc.gridy = 4;
        gc.gridwidth = 1;
        panel.add((Component)this.dl, gc);
        gc.gridx = 2;
        gc.gridy = 4;
        panel.add((Component)this.dn, gc);
        gc.gridx = 3;
        gc.gridy = 4;
        panel.add((Component)this.cn, gc);
        this.add(panel);
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Cancel")) {
            DownloadFileInfoDialog downloadFileInfoDialog = this;
            synchronized (downloadFileInfoDialog) {
                if (this.interceptor != null) {
                    ((RequestHandler)this.interceptor).intercept = false;
                    this.notifyAll();
                }
            }
            this.setVisible(false);
        } else if (e.getActionCommand().equals("Download Later")) {
            if (this.dl_action != null) {
                if (this.getURL().length() < 1) {
                    JOptionPane.showMessageDialog(this, "URL is Empty");
                    return;
                }
                if (!XDMUtil.validateURL(this.getURL())) {
                    String cu = XDMUtil.createURL(this.getURL());
                    if (cu != null) {
                        this.setURL(cu);
                    } else {
                        JOptionPane.showMessageDialog(this, "Invalid URL");
                    }
                    return;
                }
                this.cancelled = false;
                this.dl_action.actionPerformed(new ActionEvent(this, 0, e.getActionCommand()));
                this.setVisible(false);
            }
        } else if (e.getActionCommand().equals("Download Now")) {
            if (this.dn_action != null) {
                if (!XDMUtil.validateURL(this.getURL())) {
                    if (this.getURL().length() < 1) {
                        JOptionPane.showMessageDialog(this, "URL is Empty");
                        return;
                    }
                    String cu = XDMUtil.createURL(this.getURL());
                    if (cu != null) {
                        this.setURL(cu);
                    } else {
                        JOptionPane.showMessageDialog(this, "Invalid URL");
                    }
                    return;
                }
                this.cancelled = false;
                this.dl_action.actionPerformed(new ActionEvent(this, 0, e.getActionCommand()));
                this.setVisible(false);
            }
        } else if (e.getActionCommand().equals("Browse...")) {
            if (this.fc == null) {
                this.fc = new JFileChooser();
            }
            this.fc.setFileSelectionMode(1);
            if (this.fc.showSaveDialog(this) == 0) {
                this.dir.setText(this.fc.getSelectedFile().getAbsolutePath());
                this.config.destdir = this.dir.getText();
                this.config.save();
            }
        }
    }

    public static void main(String[] args) {
        new DownloadFileInfoDialog().setVisible(true);
    }

    protected void finalize() throws Throwable {
        System.out.println("###########################FINALIZING...");
        super.finalize();
    }

    String getFileName(String url) {
        String file = null;
        try {
            file = XDMUtil.getFileName(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file == null || file.length() < 1) {
            file = "FILE";
        }
        return file;
    }

    void update(DocumentEvent e) {
        try {
            Document doc = e.getDocument();
            int len = doc.getLength();
            String text = doc.getText(0, len);
            this.file.setText(this.getFileName(text));
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public void changedUpdate(DocumentEvent e) {
        this.update(e);
    }

    public void insertUpdate(DocumentEvent e) {
        this.update(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.update(e);
    }
}

