/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.sdg.xdman.gui.BatchDownloadListener;
import org.sdg.xdman.gui.BatchItem;
import org.sdg.xdman.gui.BatchTableModel;
import org.sdg.xdman.gui.MainWindow;
import org.sdg.xdman.util.Java6Util;
import org.sdg.xdman.util.XDMUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchDownloadDlg
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -4717157093775786226L;
    BatchTableModel model;
    JTable table;
    JTextField dir;
    JButton browse;
    JButton ok;
    JButton cancel;
    JButton checkAll;
    JButton uncheckAll;
    JCheckBox startQ;
    JFileChooser fc;
    BatchDownloadListener listener;

    public BatchDownloadDlg() {
        this.setSize(600, 300);
        this.setTitle("Batch download from clipboard");
        this.setIconImage(MainWindow.icon.getImage());
        this.add((Component)new JLabel("Seleceted Items will be added to XDM Download Queue"), "North");
        this.dir = new JTextField();
        this.browse = new JButton("Browse...");
        this.browse.addActionListener(this);
        this.ok = new JButton("OK");
        this.ok.addActionListener(this);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        this.checkAll = new JButton("Check All");
        this.checkAll.addActionListener(this);
        this.uncheckAll = new JButton("Uncheck All");
        this.uncheckAll.addActionListener(this);
        this.startQ = new JCheckBox("Start Queue Processing");
        this.startQ.addActionListener(this);
        this.model = new BatchTableModel();
        this.table = new JTable(this.model);
        JScrollPane jsp = new JScrollPane(this.table);
        if (!Java6Util.jtable$setFillsViewportHeight(this.table, true)) {
            jsp.getViewport().setBackground(this.table.getBackground());
            jsp.getViewport().setOpaque(false);
            jsp.setBackground(this.table.getBackground());
        }
        this.add(jsp);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                int index = BatchDownloadDlg.this.table.getSelectedRow();
                if (index < 0) {
                    return;
                }
                int c = BatchDownloadDlg.this.table.getSelectedColumn();
                if (c != 0) {
                    return;
                }
                BatchItem item = BatchDownloadDlg.this.model.batchList.get(index);
                item.selected = !item.selected;
                BatchDownloadDlg.this.model.fireTableRowsUpdated(index, index);
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(5, 5, 5, 5);
        gc.fill = 2;
        gc.gridwidth = 1;
        gc.gridy = 0;
        panel.add((Component)new JLabel("Save in: "), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        gc.gridwidth = 2;
        panel.add((Component)this.dir, gc);
        gc.gridx = 3;
        gc.weightx = 0.0;
        gc.gridwidth = 2;
        panel.add((Component)this.browse, gc);
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.gridy = 1;
        panel.add((Component)this.checkAll, gc);
        gc.gridx = 1;
        panel.add((Component)this.uncheckAll, gc);
        gc.gridx = 2;
        panel.add((Component)this.startQ, gc);
        gc.gridx = 3;
        panel.add((Component)this.ok, gc);
        gc.gridx = 4;
        panel.add((Component)this.cancel, gc);
        this.add((Component)panel, "South");
    }

    public void showDialog(List<BatchItem> list, String folder, BatchDownloadListener listener) {
        try {
            this.setTitle("Batch download");
            this.listener = listener;
            this.model.batchList.clear();
            this.dir.setText(folder);
            int i = 0;
            while (i < list.size()) {
                this.model.batchList.add(list.get(i));
                ++i;
            }
            this.model.fireTableDataChanged();
            this.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showDialog(String folder, BatchDownloadListener listener) {
        this.setTitle("Batch download from clipboard");
        this.listener = listener;
        this.model.batchList.clear();
        this.dir.setText(folder);
        try {
            Object obj = Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
            String txt = "";
            int count = 0;
            if (obj == null) {
                JOptionPane.showMessageDialog(this, "No web address found in clipboard");
                return;
            }
            txt = obj.toString();
            if (txt.length() > 0) {
                String[] urls = txt.split("\n");
                int i = 0;
                while (i < urls.length) {
                    BatchItem item = new BatchItem();
                    String url = urls[i];
                    if (XDMUtil.validateURL(url)) {
                        ++count;
                        item.url = url;
                        item.dir = this.dir.getText();
                        item.fileName = XDMUtil.getFileName(url);
                        System.out.println(urls[i]);
                        this.model.batchList.add(item);
                    }
                    ++i;
                }
            }
            if (count < 1) {
                JOptionPane.showMessageDialog(this, "No web address found in clipboard");
                return;
            }
            this.model.fireTableDataChanged();
            this.setVisible(true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "No web address found in clipboard");
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i;
        if (e.getSource() == this.browse) {
            if (this.fc == null) {
                this.fc = new JFileChooser();
            }
            this.fc.setFileSelectionMode(1);
            if (this.fc.showSaveDialog(this) == 0) {
                this.dir.setText(this.fc.getSelectedFile().getAbsolutePath());
                i = 0;
                while (i < this.model.batchList.size()) {
                    this.model.batchList.get((int)i).dir = this.dir.getText();
                    ++i;
                }
                this.model.fireTableDataChanged();
            }
        }
        if (e.getSource() == this.checkAll) {
            i = 0;
            while (i < this.model.batchList.size()) {
                this.model.batchList.get((int)i).selected = true;
                ++i;
            }
            this.model.fireTableDataChanged();
        }
        if (e.getSource() == this.uncheckAll) {
            i = 0;
            while (i < this.model.batchList.size()) {
                this.model.batchList.get((int)i).selected = false;
                ++i;
            }
            this.model.fireTableDataChanged();
        }
        if (e.getSource() == this.cancel) {
            this.setVisible(false);
        }
        if (e.getSource() == this.ok) {
            this.listener.download(this.model.batchList, this.startQ.isSelected());
            this.setVisible(false);
        }
    }

    public static void main(String[] args) {
        new BatchDownloadDlg().showDialog(System.getProperty("user.home"), null);
    }
}

