/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.core.common.ftp;

import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPHTTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.sdg.xdman.core.common.Authenticator;
import org.sdg.xdman.core.common.Connection;
import org.sdg.xdman.core.common.ConnectionManager;
import org.sdg.xdman.core.common.Credential;
import org.sdg.xdman.core.common.XDMConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTPConnection
extends Connection {
    XDMConfig config;
    String dir;
    String file;
    int port;
    String host;
    String path;
    FTPClient client;
    int count;
    int errorCode;

    public FTPConnection(String url, String fileName, long startOff, long length, long contentLength, int timeout, ConnectionManager mgr, Object lock, HashMap<String, String> extra, String cookie, Credential c, XDMConfig config) {
        super(url, fileName, startOff, length, contentLength, timeout, mgr, lock, extra, cookie);
        this.credential = c;
        this.config = config;
    }

    public FTPConnection(Connection.State state, int timeout, ConnectionManager mgr, Object lock, String cookie, Credential c, XDMConfig config) {
        super(state, timeout, mgr, lock, cookie);
        this.credential = c;
        this.config = config;
    }

    @Override
    public void close() {
        this.msg(this.stop);
        this.msg(this.stop ? "STOP " : "Releasing all resource...");
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.client.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.msg("Releasing all resource...done");
        this.message = "disconnect";
    }

    @Override
    public boolean connect() {
        try {
            URI ftpuri = new URI(this.url);
            this.host = ftpuri.getHost();
            this.port = ftpuri.getPort();
            this.path = ftpuri.getPath();
            this.msg("Path: " + this.path);
            this.getPath();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.status = 10;
        while (true) {
            block49: {
                this.read = 0L;
                this.clen = 0L;
                if (this.stop) {
                    this.close();
                    break;
                }
                this.chkPause();
                if (this.file == null || this.file.length() < 1) {
                    throw new Error("No file to download");
                }
                this.message = "Connecting...";
                this.mgr.updated();
                this.msg("Connecting...");
                if (this.length <= 0L || this.startOff + this.downloaded - (this.startOff + this.length - 1L) <= 0L) break block49;
                this.mgr.donwloadComplete(this);
                return true;
            }
            try {
                if (this.config.useFtpProxy) {
                    String proxyHost = this.config.ftpProxyHost;
                    int proxyPort = this.config.ftpProxyPort;
                    String proxyUser = this.config.ftpUser;
                    String proxyPass = this.config.ftpPass;
                    boolean proxyAuth = false;
                    if (proxyUser != null && proxyUser.length() >= 1 && proxyPass != null && proxyPass.length() >= 1) {
                        proxyAuth = true;
                    }
                    if (proxyAuth) {
                        this.msg("Authenticating with: " + proxyUser + ":" + proxyPass);
                        this.client = new FTPHTTPClient(proxyHost, proxyPort, proxyUser, proxyPass);
                    } else {
                        this.client = new FTPHTTPClient(proxyHost, proxyPort);
                    }
                } else {
                    this.client = new FTPClient();
                }
                this.msg("Connecting to..." + this.url);
                this.message = "Connecting to ftp server...";
                this.mgr.updated();
                this.client.setConnectTimeout(this.timeout);
                this.client.setDataTimeout(this.timeout);
                if (this.port > 0) {
                    this.client.connect(this.host, this.port);
                } else {
                    this.client.connect(this.host);
                }
                if (this.stop) {
                    this.close();
                    break;
                }
                this.chkPause();
                if (this.credential == null) {
                    this.credential = Authenticator.getInstance().getCredential(this.host);
                }
                this.message = "Logging in...";
                this.mgr.updated();
                if (this.credential != null) {
                    this.msg("Loggin in with specifig user/pass");
                    this.client.login(this.credential.user, this.credential.pass);
                } else {
                    this.msg("Loggin in with anonymous user/pass");
                    this.client.login("anonymous", "anonymous");
                }
                if (this.stop) {
                    this.close();
                    break;
                }
                this.chkPause();
                int reply = this.client.getReplyCode();
                this.msg("Reply: " + this.client.getReplyString());
                if (!FTPReply.isPositiveCompletion(reply)) {
                    this.credential = this.mgr.getCreditential();
                    if (this.credential == null) {
                        throw new Error(this.client.getReplyString());
                    }
                    throw new IllegalArgumentException(this.client.getReplyString());
                }
                this.msg("Switching to binary mode...");
                this.client.setFileType(2);
                reply = this.client.getReplyCode();
                this.msg("Reply: " + this.client.getReplyString());
                if (!FTPReply.isPositiveCompletion(reply)) {
                    throw new Error("Binary transfer not supported by server");
                }
                this.msg("Entering passive mode: " + this.dir);
                this.message = "PASVr...";
                this.mgr.updated();
                this.client.enterLocalPassiveMode();
                if (this.stop) {
                    this.close();
                    break;
                }
                this.msg("Changing working dir to: " + this.dir);
                this.message = "Change dir...";
                this.mgr.updated();
                this.client.changeWorkingDirectory(this.dir);
                if (this.stop) {
                    this.close();
                    break;
                }
                this.chkPause();
                reply = this.client.getReplyCode();
                this.msg("Reply: " + this.client.getReplyString());
                if (!FTPReply.isPositiveCompletion(reply)) {
                    throw new Error("Could not switch to the sprecified directory.");
                }
                if (this.length > 0L) {
                    long restartOff = this.startOff + this.downloaded;
                    this.msg("Sending range");
                    this.message = "Sending REST...";
                    this.mgr.updated();
                    this.client.setRestartOffset(restartOff);
                } else {
                    this.msg("Listing files");
                    FTPFile[] files = this.client.listFiles(this.dir);
                    this.chkPause();
                    reply = this.client.getReplyCode();
                    this.msg("Reply: " + this.client.getReplyString());
                    if (!FTPReply.isPositiveCompletion(reply)) {
                        throw new Error("File information could not be retrived.");
                    }
                    int i = 0;
                    while (i < files.length) {
                        FTPFile f = files[i];
                        this.msg(String.valueOf(f.toString()) + " Name: " + f.getName());
                        if (f.getName().equals(this.file)) {
                            this.length = f.getSize();
                            this.msg("Length found: " + this.length);
                            break;
                        }
                        ++i;
                    }
                    this.msg("Listing files...done");
                }
                if (this.stop) {
                    this.close();
                    break;
                }
                this.chkPause();
                reply = this.client.getReplyCode();
                this.msg("Reply: " + this.client.getReplyString());
                if (!FTPReply.isPositiveCompletion(reply)) {
                    throw new Error("Server does not support resume feature.");
                }
                this.msg("SEND GET...");
                this.message = "Send GET...";
                this.msg("SEND GET...Done");
                if (this.stop) {
                    this.close();
                    break;
                }
                this.chkPause();
                this.message = "Parsing response...";
                this.mgr.updated();
                this.chkPause();
                this.message = "Opening data connection...";
                this.mgr.updated();
                this.msg("Opening Stream for: " + this.file);
                this.in = this.client.retrieveFileStream(this.file);
                this.msg("Data connection mode: " + this.client.getDataConnectionMode());
                if (this.in == null) {
                    throw new Error("Server did not sent any data.");
                }
                if (this.stop) {
                    this.close();
                    break;
                }
                this.chkPause();
                this.status = 20;
                this.message = "Downloading...";
                this.buf = new byte[8192];
                this.mgr.updated();
                this.msg("Notify...");
                this.msg("Going to call connected()...");
                this.mgr.connected(this);
                this.msg("Returned from connected()");
                return true;
            }
            catch (IllegalArgumentException e) {
                this.message = "ReConnecting...";
                this.mgr.updated();
                this.msg(e);
                e.printStackTrace();
                this.close();
                if (this.stop) {
                    this.close();
                    break;
                }
                this.chkPause();
            }
            catch (UnknownHostException e) {
                this.message = "Connecting...";
                this.mgr.updated();
                this.msg(e);
                e.printStackTrace();
                this.close();
                if (this.count > 10) {
                    this.status = 30;
                    this.errorCode = 0;
                    this.lastError = "Host not found";
                    break;
                }
                if (this.stop) {
                    this.close();
                    break;
                }
                this.chkPause();
                this.msg("Sleeping 2 sec");
                this.message = "Disconnect";
                try {
                    Thread.sleep(2000L);
                    this.chkPause();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.message = "Connecting...";
                this.mgr.updated();
                ++this.count;
            }
            catch (Exception e) {
                this.message = "ReConnecting...";
                this.mgr.updated();
                this.msg(e);
                e.printStackTrace();
                this.close();
                if (this.stop) {
                    this.close();
                    break;
                }
                this.chkPause();
                this.msg("Sleeping 2 sec");
                try {
                    Thread.sleep(2000L);
                    this.chkPause();
                }
                catch (Exception exception) {}
            }
            catch (Error e) {
                this.message = "Invalid response.";
                this.errorCode = 5;
                this.lastError = e.getMessage();
                this.mgr.updated();
                this.msg(e);
                e.printStackTrace();
                this.close();
                this.status = 30;
                if (this.lastError != null && this.lastError.length() >= 1) break;
                this.lastError = "Invalid response from server";
                break;
            }
            this.msg("Remaining " + (this.length - this.downloaded));
            if (this.stop) {
                this.close();
                break;
            }
            this.chkPause();
        }
        this.msg("Exiting connect");
        if (!this.stop) {
            this.message = "disconnect.";
            this.mgr.updated();
            this.mgr.failed(this.lastError, this.errorCode);
        }
        return false;
    }

    @Override
    public boolean isEOF() {
        return false;
    }

    void getPath() {
        int pos = this.path.lastIndexOf("/");
        if (pos < 0) {
            return;
        }
        this.dir = this.path.substring(0, pos);
        if (this.dir.length() < 1) {
            this.dir = "/";
        }
        if (pos == this.path.length() - 1) {
            return;
        }
        if (pos < this.path.length() - 1) {
            this.file = this.path.substring(pos + 1);
        }
    }
}

