/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.core.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Observable;

public class XDMConfig
extends Observable
implements Serializable {
    private static final long serialVersionUID = 8597940453061358901L;
    public static boolean hasTray = false;
    File file;
    public String jarPath;
    public boolean useHttpProxy;
    public boolean useFtpProxy;
    public boolean useHttpsProxy;
    public String httpProxyHost;
    public String httpsProxyHost;
    public String ftpProxyHost;
    public int httpProxyPort;
    public int httpsProxyPort;
    public int ftpProxyPort;
    public String httpUser;
    public String httpPass;
    public String httpsUser;
    public String httpsPass;
    public String ftpUser;
    public String ftpPass;
    public boolean showDownloadPrgDlg = true;
    public boolean showDownloadCompleteDlg = true;
    public boolean showDownloadBox = false;
    public final int PROMPT = 2;
    public final int AUTO_RENAME = 0;
    public final int RESUME = 1;
    public int duplicateLinkAction = 2;
    public int maxConn = 8;
    public int timeout = 60;
    public String destdir;
    public String tempdir;
    public boolean executeCmd = false;
    public boolean hungUp = false;
    public boolean halt = false;
    public boolean antivir = false;
    public String cmdTxt;
    public String hungUpTxt;
    public String haltTxt;
    public String antivirTxt;
    public int antidrop = 0;
    public int hungdrop = 0;
    public int haltdrop = 0;
    public String ntDomain = "";
    public final String[] defaultFileTypes = new String[]{"3GP", "7Z", "AAC", "ACE", "AIF", "ARJ", "ASF", "AVI", "BIN", "BZ2", "EXE", "GZ", "GZIP", "IMG", "ISO", "LZH", "M4A", "M4V", "MOV", "MP3", "MP4", "MPA", "MPE", "MPEG", "MPG", "MSI", "MSU", "OGG", "PDF", "PLJ", "PPS", "PPT", "QT", "RA", "RAR", "RM", "SEA", "SIT", "SITX", "TAR", "TIF", "TIFF", "WAV", "WMA", "WMV", "Z", "ZIP", "JAR"};
    public String[] fileTypes = this.defaultFileTypes;
    public boolean schedule;
    public Date startDate;
    public Date endDate;
    public boolean allowbrowser = false;
    public transient int port = 9614;
    public int tcpBuf = 8192;
    public boolean compress = false;
    public boolean attachProxy = false;
    public boolean autostart = false;
    public int version = 0;

    public String getDefaultShutdownCommand() {
        if (File.separatorChar == '\\') {
            return "shutdown -s";
        }
        return "";
    }

    public String getDefaultDisconnectCommand() {
        if (File.separatorChar == '\\') {
            return "rasdial /disconnect";
        }
        return "";
    }

    public XDMConfig(File f) {
        this.file = f;
        this.haltTxt = this.getDefaultShutdownCommand();
        this.hungUpTxt = this.getDefaultDisconnectCommand();
    }

    public void save() {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(this.file));
            out.writeObject(this);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setChanged();
        this.notifyObservers();
    }

    public static XDMConfig load(File file) {
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new FileInputStream(file));
            XDMConfig c = (XDMConfig)in.readObject();
            c.port = 9614;
            c.version = 4;
            return c;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new XDMConfig(file);
        }
    }
}

