/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.core.common;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Set;
import org.sdg.xdman.core.common.Authenticator;
import org.sdg.xdman.core.common.Connection;
import org.sdg.xdman.core.common.Credential;
import org.sdg.xdman.core.common.HelpListener;
import org.sdg.xdman.core.common.XDMConfig;
import org.sdg.xdman.core.common.http.XDMHttpClient;
import org.sdg.xdman.util.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelperConnection
implements Runnable {
    long start;
    long length;
    XDMConfig config;
    String url;
    XDMHttpClient client;
    InputStream in;
    ByteArrayOutputStream out;
    HelpListener listerner;
    Connection c;
    boolean stop = false;
    String fileName;
    Credential credential;
    int timeout;
    HashMap<String, String> extra;
    String cookies;

    public HelperConnection(XDMConfig config, long start, long length, String url, HelpListener l, Connection c, String fileName, int timeout, HashMap<String, String> extra, String cookies, Credential credential) {
        this.config = config;
        this.start = start;
        this.length = length;
        this.url = url;
        this.listerner = l;
        this.c = c;
        this.fileName = fileName;
        this.extra = extra;
        this.credential = credential;
        this.cookies = cookies;
        this.timeout = timeout;
    }

    void start() {
        Thread t = new Thread(this);
        t.start();
    }

    void stop() {
        this.stop = true;
    }

    @Override
    public void run() {
        try {
            int x;
            this.client = new XDMHttpClient(this.config);
            this.client.connect(this.url);
            if (this.stop) {
                this.close();
                return;
            }
            this.client.setTimeOut(this.timeout);
            if (this.extra != null) {
                Set<String> keys = this.extra.keySet();
                for (String key : keys) {
                    String value = this.extra.get(key);
                    if (key.equalsIgnoreCase("cookie") || key.equalsIgnoreCase("range") || key.equalsIgnoreCase("connection") || key.equalsIgnoreCase("host")) continue;
                    this.client.addHeader(key, value);
                }
            }
            this.client.addHeader("range", "bytes=" + this.start + "-");
            if (this.extra == null || this.extra.get("user-agent") == null) {
                this.client.addHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0)");
            }
            if (this.cookies != null) {
                if (this.cookies.length() > 0) {
                    System.out.println("Setting cookies: " + this.cookies);
                    this.client.addCookieString(this.cookies);
                }
            } else {
                System.out.println("COOKIE IS NULL");
            }
            if (this.credential == null) {
                this.credential = Authenticator.getInstance().getCredential(this.client.host);
            }
            if (this.credential != null) {
                System.out.println("Adding auth");
                this.client.addHeader("Authorization", "Basic " + Base64.encode((String.valueOf(this.credential.user) + ":" + this.credential.pass).getBytes()));
            }
            this.client.sendGET();
            if (this.stop) {
                this.close();
                return;
            }
            int rc = this.client.getResponseCode();
            System.out.println("Helper RESPONSE " + rc);
            if (rc != 206) {
                throw new Exception("Invalid RESPONSE CODE");
            }
            this.in = this.client.getInputStream();
            this.out = new ByteArrayOutputStream();
            byte[] buf = new byte[this.config.tcpBuf];
            long dwn = 0L;
            do {
                if (this.stop) {
                    this.close();
                    return;
                }
                int rem = (int)(this.length - dwn);
                x = buf.length > rem ? this.in.read(buf, 0, rem) : this.in.read(buf);
                if (this.stop) {
                    this.close();
                    return;
                }
                if (x == -1) {
                    throw new Exception("UNEXPECTED EOF");
                }
                this.out.write(buf, 0, x);
            } while ((dwn += (long)x) < this.length);
            if (this.listerner != null) {
                if (this.stop) {
                    this.close();
                    return;
                }
                this.listerner.helpComplete(this, this);
            }
            this.close();
        }
        catch (Exception e) {
            System.out.println("Error IN HELPER: " + e);
            e.printStackTrace();
            this.close();
        }
    }

    void close() {
        System.out.println("closing helper conn. " + this.stop);
        try {
            this.client.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

