/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;
import org.sdg.xdman.gui.XDMBlankIcon;

public class XDMMenuItemUI
extends BasicMenuItemUI {
    GradientPaint gradPressed;
    Color lightColor;
    Color darkColor;
    Color lightColor2;
    Icon chkIcon;

    public static ComponentUI createUI(JComponent c) {
        return new XDMMenuItemUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof AbstractButton) {
            AbstractButton btn = (AbstractButton)c;
            btn.setIcon(new XDMBlankIcon(15, 10));
            btn.setBorderPainted(false);
            btn.setMargin(new Insets(10, 0, 0, 0));
        }
        this.lightColor = Color.WHITE;
        this.darkColor = new Color(230, 230, 230);
        this.lightColor2 = new Color(245, 245, 245);
        this.chkIcon = UIManager.getIcon("CheckBoxMenuItem.checkIcon");
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (this.gradPressed == null) {
            this.gradPressed = new GradientPaint(0.0f, 0.0f, new Color(240, 240, 240), 0.0f, b.getHeight(), new Color(220, 220, 220));
        }
        Color c = g.getColor();
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(this.gradPressed);
        int gapx = 0;
        g2.fillRect(gapx + 2, 0, b.getWidth() - (4 + gapx + 2), b.getHeight() - 2);
        g2.setColor(Color.LIGHT_GRAY);
        g2.drawRect(gapx + 2, 0, b.getWidth() - (4 + gapx + 2), b.getHeight() - 2);
        if (this.menuItem.getIcon() != null) {
            int gap = this.menuItem.getIcon().getIconWidth() + 2;
            g.setColor(this.darkColor);
            g.drawLine(gap, 1, gap, this.menuItem.getHeight() - 3);
            g.setColor(this.lightColor2);
            g.drawLine(gap + 1, 1, gap + 1, this.menuItem.getHeight() - 3);
        }
        g.setColor(c);
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        g.setColor(menuItem.getBackground());
        g.fillRect(0, 0, menuWidth, menuHeight);
        if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
            this.paintButtonPressed(g, menuItem);
        } else if (menuItem.getIcon() != null) {
            int gap = menuItem.getIcon().getIconWidth() + 2;
            g.setColor(this.darkColor);
            g.drawLine(gap, 0, gap, menuItem.getHeight());
            g.setColor(this.lightColor);
            g.drawLine(gap + 1, 0, gap + 1, menuItem.getHeight());
        }
        if (menuItem instanceof JCheckBoxMenuItem && ((JCheckBoxMenuItem)menuItem).isSelected()) {
            this.chkIcon.paintIcon(menuItem, g, 5, 5);
        }
        g.setColor(oldColor);
    }
}

