/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import org.sdg.xdman.core.common.ConnectionManager;
import org.sdg.xdman.core.common.DownloadInfo;
import org.sdg.xdman.core.common.DownloadProgressListener;
import org.sdg.xdman.gui.ConnectionTableModel;
import org.sdg.xdman.gui.SegmentPanel;
import org.sdg.xdman.gui.StringResource;
import org.sdg.xdman.gui.XDMIconMap;
import org.sdg.xdman.gui.XDMTableHeaderRenderer;
import org.sdg.xdman.util.XDMUtil;

public class DownloadWindow
extends JFrame
implements DownloadProgressListener,
ActionListener {
    private static final long serialVersionUID = -3466926000657599255L;
    JLabel url;
    JLabel status;
    JLabel filesize;
    JLabel downloaded;
    JLabel rate;
    JLabel time;
    JLabel resume;
    SegmentPanel p;
    JProgressBar prg;
    JButton bg;
    JButton view;
    JButton cancel;
    ConnectionTableModel model;
    JTable table;
    ConnectionManager mgr;
    File file;
    boolean valid = true;

    public DownloadWindow(ConnectionManager mgr) {
        this.init();
        this.mgr = mgr;
    }

    public void showWindow() {
        this.setVisible(true);
    }

    @Override
    public boolean isValidWindow() {
        return this.valid;
    }

    @Override
    public void update(DownloadInfo info) {
        if (info.state == 50 || info.state == 40 || info.state == 30) {
            this.valid = false;
            if (info.state == 30 && this.isVisible()) {
                JOptionPane.showMessageDialog(this, info.msg);
            }
            if (this.mgr != null) {
                this.mgr.setProgressListener(null);
            }
            this.mgr = null;
            this.setVisible(false);
            this.dispose();
            return;
        }
        this.setTitle(String.valueOf(info.prg) + " % " + info.file);
        this.url.setText(info.url);
        this.status.setText(info.status);
        this.filesize.setText(info.length);
        this.downloaded.setText(String.valueOf(info.downloaded) + " (" + info.progress + "%)");
        this.rate.setText(info.speed);
        this.time.setText(info.eta);
        this.resume.setText(info.resume);
        this.p.setValues(info.startoff, info.len, info.dwn, info.rlen);
        this.prg.setValue(info.prg);
        this.model.update(info.dwnld, info.stat);
        this.file = info.path;
    }

    void init() {
        this.setIconImage(XDMIconMap.getIcon("APP_ICON").getImage());
        this.setSize(450, 450);
        Toolkit t = Toolkit.getDefaultToolkit();
        Dimension d = t.getScreenSize();
        this.setLocation(d.width / 2 - this.getWidth() / 2, d.height / 2 - this.getHeight() / 2);
        this.p = new SegmentPanel();
        this.prg = new JProgressBar();
        this.model = new ConnectionTableModel();
        this.table = new JTable(this.model);
        Box vbox = Box.createVerticalBox();
        vbox.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.url = new JLabel("", 2);
        this.status = new JLabel("", 2);
        this.filesize = new JLabel("", 2);
        this.downloaded = new JLabel("", 2);
        this.rate = new JLabel("", 2);
        this.time = new JLabel("", 2);
        this.resume = new JLabel("", 2);
        JPanel infoPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.gridwidth = 2;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.gridheight = 2;
        gc.insets = new Insets(5, 5, 5, 5);
        infoPanel.add((Component)this.url, gc);
        gc.insets = new Insets(1, 5, 1, 5);
        gc.gridheight = 1;
        gc.weightx = 0.0;
        gc.gridwidth = 1;
        gc.gridy = 2;
        infoPanel.add((Component)new JLabel(this.getString("STATUS"), 2), gc);
        gc.gridx = 1;
        gc.gridy = 2;
        infoPanel.add((Component)this.status, gc);
        gc.gridy = 3;
        gc.gridx = 0;
        infoPanel.add((Component)new JLabel(this.getString("FILE_SIZE"), 2), gc);
        gc.gridx = 1;
        gc.gridy = 3;
        infoPanel.add((Component)this.filesize, gc);
        gc.gridy = 4;
        gc.gridx = 0;
        infoPanel.add((Component)new JLabel(this.getString("DOWNLOADED"), 2), gc);
        gc.gridx = 1;
        gc.gridy = 4;
        infoPanel.add((Component)this.downloaded, gc);
        gc.gridx = 0;
        gc.gridy = 5;
        infoPanel.add((Component)new JLabel(this.getString("TRANSFER_RATE"), 2), gc);
        gc.gridx = 1;
        gc.gridy = 5;
        infoPanel.add((Component)this.rate, gc);
        gc.gridx = 0;
        gc.gridy = 6;
        infoPanel.add((Component)new JLabel(this.getString("TIME_LEFT"), 2), gc);
        gc.gridx = 1;
        gc.gridy = 6;
        infoPanel.add((Component)this.time, gc);
        gc.gridx = 0;
        gc.gridy = 7;
        infoPanel.add((Component)new JLabel(this.getString("RESUME_SUPPORT"), 2), gc);
        gc.gridx = 1;
        gc.gridy = 7;
        infoPanel.add((Component)this.resume, gc);
        vbox.add(infoPanel);
        vbox.add(Box.createVerticalStrut(10));
        Box prgBox = Box.createHorizontalBox();
        prgBox.add(Box.createRigidArea(new Dimension(0, 15)));
        prgBox.add(this.prg);
        vbox.add(prgBox);
        vbox.add(Box.createVerticalStrut(10));
        this.bg = new JButton(this.getString("BACKGROUND"));
        System.out.println(this.bg.getPreferredSize());
        this.bg.setName("BACKGROUND");
        this.bg.addActionListener(this);
        this.view = new JButton(this.getString("PREVIEW"));
        this.view.setName("PREVIEW");
        this.view.addActionListener(this);
        this.cancel = new JButton(this.getString("PAUSE"));
        this.cancel.setName("PAUSE");
        this.cancel.addActionListener(this);
        this.view.setPreferredSize(this.bg.getPreferredSize());
        this.cancel.setPreferredSize(this.bg.getPreferredSize());
        Box pp = Box.createHorizontalBox();
        pp.add(this.bg);
        pp.add(Box.createHorizontalGlue());
        pp.add(this.view);
        pp.add(Box.createHorizontalStrut(5));
        pp.add(this.cancel);
        vbox.add(pp);
        vbox.add(Box.createVerticalStrut(10));
        Box hbox9 = Box.createHorizontalBox();
        hbox9.add(Box.createRigidArea(new Dimension(0, 15)));
        hbox9.add(this.p);
        vbox.add(hbox9);
        vbox.add(Box.createVerticalStrut(10));
        Box hbox10 = Box.createHorizontalBox();
        JScrollPane jsp = new JScrollPane(this.table);
        this.table.setCellSelectionEnabled(false);
        if (System.getProperty("xdm.defaulttheme") != null) {
            this.table.getTableHeader().setDefaultRenderer(new XDMTableHeaderRenderer());
        }
        this.table.setFillsViewportHeight(true);
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setFocusable(false);
        this.table.setShowGrid(false);
        hbox10.add(jsp);
        TableColumnModel cm = this.table.getColumnModel();
        cm.getColumn(0).setPreferredWidth(10);
        cm.getColumn(1).setPreferredWidth(50);
        cm.getColumn(2).setPreferredWidth(200);
        vbox.add(hbox10);
        this.add(vbox);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DownloadWindow.this.onClosing(e);
            }
        });
    }

    void onClosing(WindowEvent e) {
        this.valid = false;
        if (this.mgr != null) {
            this.mgr.stop();
        }
        this.mgr = null;
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton b = (JButton)e.getSource();
        if (b.getName().equals("PAUSE")) {
            if (this.mgr != null) {
                this.mgr.stop();
            }
            this.setVisible(false);
            this.dispose();
        } else if (b.getName().equals("PREVIEW") && this.file != null) {
            XDMUtil.open(this.file);
        }
        if (b.getName().equals("BACKGROUND")) {
            this.setVisible(false);
        }
    }

    String getString(String id) {
        return StringResource.getString(id);
    }

    public static void main(String[] args) {
        new DownloadWindow(null).showWindow();
    }
}

