/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.UUID;
import javax.swing.Icon;
import org.sdg.xdman.core.common.ConnectionManager;
import org.sdg.xdman.core.common.DownloadInfo;
import org.sdg.xdman.gui.DownloadWindow;
import org.sdg.xdman.gui.StringResource;
import org.sdg.xdman.gui.TableSortInfo;
import org.sdg.xdman.util.XDMUtil;

public class DownloadListItem
implements Serializable,
Comparable<DownloadListItem> {
    private static final long serialVersionUID = -4925098929484510725L;
    ArrayList<String> cookies;
    String filename;
    boolean q;
    int state;
    UUID id;
    String status;
    String timeleft;
    String transferrate;
    String lasttry;
    String description;
    String dateadded;
    String saveto;
    String type;
    String url;
    String size;
    String tempdir = "";
    String referer;
    String userAgent;
    String user;
    String pass;
    transient Icon icon;
    transient ConnectionManager mgr;
    transient DownloadWindow window;
    long date_created = System.currentTimeMillis();

    void updateData(DownloadInfo info) {
        this.status = info.status;
        this.timeleft = info.eta;
        this.transferrate = info.speed;
        this.url = info.url;
        this.size = info.length;
        this.type = info.category;
        this.state = info.state;
        if (info.state == 50 || info.state == 40 || info.state == 30) {
            this.mgr = null;
            this.window = null;
            if (info.state == 50) {
                this.q = false;
                this.status = StringResource.getString("DOWNLOAD_COMPLETE");
            } else {
                this.status = StringResource.getString("STOPPED");
            }
        }
    }

    @Override
    public int compareTo(DownloadListItem item) {
        int c = TableSortInfo.getSortingField();
        switch (c) {
            case 1: {
                return XDMUtil.nvl(this.filename).compareToIgnoreCase(XDMUtil.nvl(item.filename));
            }
            case 2: {
                return XDMUtil.nvl(String.valueOf(this.q)).compareToIgnoreCase(XDMUtil.nvl(String.valueOf(item.q)));
            }
            case 3: {
                return XDMUtil.nvl(this.size).compareToIgnoreCase(XDMUtil.nvl(item.size));
            }
            case 4: {
                return XDMUtil.nvl(this.status).compareToIgnoreCase(XDMUtil.nvl(item.status));
            }
            case 5: {
                return XDMUtil.nvl(this.timeleft).compareToIgnoreCase(XDMUtil.nvl(item.timeleft));
            }
            case 6: {
                return XDMUtil.nvl(this.transferrate).compareToIgnoreCase(XDMUtil.nvl(item.transferrate));
            }
            case 7: {
                return XDMUtil.nvl(this.lasttry).compareToIgnoreCase(XDMUtil.nvl(item.lasttry));
            }
            case 8: {
                return XDMUtil.nvl(this.description).compareToIgnoreCase(XDMUtil.nvl(item.description));
            }
            case 9: {
                long diff = this.date_created - item.date_created;
                return (int)diff;
            }
            case 10: {
                return XDMUtil.nvl(this.saveto).compareToIgnoreCase(XDMUtil.nvl(item.saveto));
            }
            case 11: {
                return XDMUtil.nvl(this.url).compareToIgnoreCase(XDMUtil.nvl(item.url));
            }
            case 12: {
                return XDMUtil.nvl(this.referer).compareToIgnoreCase(XDMUtil.nvl(item.referer));
            }
        }
        return 0;
    }
}

