<?php
	/*
	MGB 0.6.x - OpenSource PHP and MySql Guestbook
	Copyright (C) 2004 - 2013 Juergen Grueneisl - http://www.m-gb.org/

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
	*/

	// ================================
	// lang_admin.php - German (formal)
	// ================================

	// general values
	$lang['no'] = "Nein";
	$lang['yes'] = "Ja";
	$lang['asc'] = "Aufsteigend";
	$lang['desc'] = "Absteigend";
	$lang['save'] = "Speichern";
	$lang['administrator'] = "Administrator";
	$lang['moderator'] = "Moderator";
	$lang['gravatar_type_0'] = "Standard";
	$lang['gravatar_type_1'] = "Mistery-Man";
	$lang['gravatar_type_2'] = "Identicon";
	$lang['gravatar_type_3'] = "Monsterid";
	$lang['gravatar_type_4'] = "Wavatar";
	$lang['gravatar_type_5'] = "Retro";
	$lang['gravatar_position_left'] = "Links vom Eintrag";
	$lang['gravatar_position_right'] = "Rechts vom Eintrag";
	$lang['timestamp'] = "Zeitstempel";
	$lang['quote'] = "Zitat von";

	// login.inc.php
	$lang['title'] = "MGB {MGB_VERSION} - Administration";
	$lang['login_username'] = "Benutzername:";
	$lang['login_password'] = "Passwort:";
	$lang['login_lostpassword'] = "Ich habe mein Passwort vergessen";
	$lang['login'] = "Anmelden";
	$lang['logout'] = "Abmelden";
	$lang['login_ok'] = "Herzlich Willkommen <b>{SESSION_USERNAME}</b>.";
	$lang['logged_in'] = "Sie sind angemeldet als <b>{SESSION_USERNAME}</b>";
	$lang['logged_out'] = "Geben Sie bitte Ihren Benutzernamen und Ihr Passwort ein um sich anzumelden.";
	$lang['please_wait'] = "Sie wurden erfolgreich angemeldet.<br>Bitte warten Sie einen kurzen Moment...";

	// errormessages
	$lang['errormessage1'] = "Bitte f&uuml;llen Sie alle Felder aus!";
	$lang['errormessage2'] = "Diese Benutzername/Passwort Kombination existiert nicht.";
	$lang['errormessage3'] = "Ihr Benutzerkonto wurde von einem Administrator deaktiviert.";
	$lang['errormessage4'] = "Sie haben keinen Zugriff auf diese Seite.";
	$lang['errormessage5'] = "Das angegebene Passwort ist falsch.";
	$lang['errormessage6'] = "Die neuen Passw&ouml;rter sind nicht identisch.";
	$lang['errormessage7'] = "Die angegebene eMail Adresse ist nicht g&uuml;ltig, oder es wurde keine angegeben.";
	$lang['errormessage8'] = "Sie k&ouml;nnen sich nicht selbst ihren Administratorstatus nehmen, Ihr eigenes Benutzerkonto deaktivieren, oder es l&ouml;schen.";
	$lang['errormessage9'] = "Sie waren zu lange inaktiv, und wurden deshalb automatisch abgemeldet.";
	$lang['errormessage10'] = "Beim letzten Besuch haben Sie sich nicht richtig ausgeloggt. Sie wurden deshalb automatisch abgemeldet.<br><br>Bitte benutzen Sie zu Ihrer eigenen Sicherheit immer den Knopf ''Abmelden'' um sich auszuloggen. Danke.";
	$lang['errormessage11'] = "Dieser Benutzername oder diese eMail Adresse wird bereits verwendet.";
	$lang['errormessage12'] = "Dieser Schl&uuml;ssel ist ung&uuml;ltig oder bereits abgelaufen.";
	$lang['errormessage13'] = "Es wurde bereits ein neues Passwort f&uuml;r dieses Benutzerkonto beantragt.<br>Es ist nicht m&ouml;glich ein weiteres Passwort zu beantragen, bis das Neue aktiviert, oder abgelaufen ist.";
	$lang['errormessage14'] = "Die eMail konnte nicht verschickt werden. M&ouml;glicherweise gibt es ein Problem mit dem Mailserver.";
	$lang['errormessage15'] = "Die Version konnte nicht ermittelt werden, da <a href=\"http://php.net/manual/de/function.fopen.php\">fopen()</a> auf Ihrem Server deaktiviert ist.<br>Setzen Sie sich gegebenenfalls mit Ihrem Hoster in Verbindung.<br><br>In der Zwischenzeit k&ouml;nnen Sie sich auf http://www.m-gb.org/ &uuml;ber die aktuellste Version informieren.";
	$lang['errormessage16'] = "Das neue Passwort ist zu kurz. Es muss mindestens ".$settings['password_min_length']." Zeichen haben.";

	// general strings
	$lang['back_to_mainpage'] = "Zur&uuml;ck zur Hauptseite";
	$lang['back'] = "Zur&uuml;ck";
	$lang['go'] = "Los!";
	$lang['entry'] = "Eintrag";
	$lang['entries'] = "Eintr&auml;ge";
	$lang['no_entries'] = "Keine Eintr&auml;ge vorhanden.";
	$lang['no_deactivated_entries'] = "Keine deaktivierten Eintr&auml;ge vorhanden.";
	$lang['no_activated_entries'] = "Keine aktiven Eintr&auml;ge vorhanden.";
	$lang['no_spam_entries'] = "Keine Spam-Eintr&auml;ge vorhanden.";
	$lang['entries_on_pages'] = "Eintr&auml;ge auf {PAGES} Seiten";
	$lang['page_first'] = "Zur ersten Seite";
	$lang['page_first_symbol'] = "&laquo;";
	$lang['page_forwards'] = "Eine Seite vorw&auml;rts bl&auml;ttern";
	$lang['page_forwards_symbol'] = "&rsaquo;";
	$lang['page_last'] = "Zur letzten Seite";
	$lang['page_last_symbol'] = "&raquo;";
	$lang['page_backwards'] = "Eine Seite zur&uuml;ck bl&auml;ttern";
	$lang['page_backwards_symbol'] = "&lsaquo;";
	$lang['captcha_method_code'] = "Sicherheitscode";
	$lang['captcha_method_math'] = "Mathematisch";
	$lang['activate_entry'] = "Diesen Eintrag aktivieren";
	$lang['deactivate_entry'] = "Diesen Eintrag deaktivieren";
	$lang['delete_entry'] = "Diesen Eintrag l&ouml;schen";
	$lang['mark_as_spam'] = "Als Spam markieren";
	$lang['nospam_entry'] = "Als 'kein Spam' markieren und freischalten";
	$lang['nospam_deactivate_entry'] = "Als 'kein Spam' markieren aber deaktiviert lassen";
	$lang['active'] = "Dieser Eintrag ist im G&auml;stebuch freigeschaltet";
	$lang['inactive'] = "Dieser Eintrag ist im G&auml;stebuch nicht freigeschaltet";
	$lang['edit_entry'] = "Diesen Eintrag editieren";
	$lang['do_nothing'] = "Keine Aktion gew&auml;hlt...";
	$lang['delete_whole_spam'] = "L&ouml;sche alle Spam-Eintr&auml;ge";
	$lang['mark_all_no_spam_deactivate'] = "Alle Eintr&auml;ge als 'kein Spam' markieren aber deaktiviert lassen";
	$lang['mark_all_no_spam_activate'] = "Alle Eintr&auml;ge als 'kein Spam' markieren und freischalten";
	$lang['mark_all_as_spam'] = "Alle Eintr&auml;ge als Spam markieren";
	$lang['activate_all_entries'] = "Alle Eintr&auml;ge aktivieren";
	$lang['deactivate_all_entries'] = "Alle Eintr&auml;ge deaktivieren";
	$lang['delete_all_entries'] = "Alle Eintr&auml;ge l&ouml;schen";

	$lang['sendmail_user_notification_title'] = "Ihr Eintrag auf {DOMAIN} wurde freigeschaltet";
	$lang['sendmail_user_comment_title'] = "Zu Ihrem Eintrag auf {DOMAIN} wurde ein Kommentar verfasst";
	$lang['sendmail_adduser_title'] = "Ihre Benutzerdaten bei {DOMAIN}";
	$lang['sendmail_adduser_text'] = "Sie wurden erfolgreich bei {DOMAIN} von einem Administrator angemeldet. Hier Ihre Benutzerdaten:<br /><br />Benutzername: {ADDUSER_NAME}<br />Passwort: {ADDUSER_PASSWORD}<br /><br />Sie k&ouml;nnen sich hier anmelden: {ADDUSER_URL}";
	$lang['sendmail_admin_text'] = "{NAME} hat einen neuen Eintrag im G&auml;stebuch hinterlassen.<br /><br />Datum: {DATE}<br />Zeit: {TIME}<br /><br />---<br />{MESSAGE}<br />---<br /><br />{URL_TO_GB}";
	$lang['sendmail_user_text'] = "Hallo {NAME},<br /><br />vielen Dank f&uuml;r Ihren Eintrag in meinem G&auml;stebuch. Der Eintrag ist sofort verf&uuml;gbar.<br /><br />{URL_TO_GB}";
	$lang['sendmail_user_text_moderated'] = "Hallo {NAME},<br /><br />vielen Dank f&uuml;r Ihren Eintrag in meinem G&auml;stebuch. Nach einer Pr&uuml;fung werde ich ihn so bald wie m&ouml;glich freischalten.<br /><br />{URL_TO_GB}";
	$lang['sendmail_user_notification_text'] = "Hallo {NAME},<br /><br />Ihr Eintrag auf {DOMAIN} wurde soeben freigeschaltet. Sie k&ouml;nnen ihn sich hier ansehen: {URL_TO_GB}";
	$lang['sendmail_comment_text'] = "Hallo {NAME},<br /><br />zu Ihrem Eintrag<br /><br />---<br />{MESSAGE}<br />---<br /><br />wurde soeben ein Kommentar verfasst. Sie k&ouml;nnen ihn sich hier ansehen: {URL_TO_GB}";
	$lang['sendmail_contactmail_text'] = "Sie haben eine eMail von {NAME} &uuml;ber das G&auml;stebuch von {DOMAIN} erhalten. Hier die Nachricht:<br /><br />---<br />{MESSAGE}<br />---<br /><br />Datum: {DATE}<br />Zeit: {TIME}";
	$lang['sendmail_contactmail_text_copy'] = "Sie haben eine Nachricht an {NAME} &uuml;ber das G&auml;stebuch von {DOMAIN} verschickt. Hier eine Kopie davon:<br /><br />---<br />{MESSAGE}<br />---<br /><br />Datum: {DATE}<br />Zeit: {TIME}<br /><br />Beinhaltet diese eMail Spam? Oder sind Sie gar nicht der Absender dieser eMail? Sie k&ouml;nnen hier den Webmaster kontaktieren: {URL_TO_GB}";
	$lang['sendmail_new_password_title'] = "Neues Passwort: Best&auml;tigung";
	$lang['sendmail_new_password_text'] = "Hallo {NAME},<br /><br />F&uuml;r Ihren Account wurde ein neues Passwort generiert. Um dieses zu best&auml;tigen, klicken Sie bitte innerhalb der n&auml;chsten 24 Stunden auf den untenstehenden Link. Bis das neue Passwort aktiviert wurde, bleibt das alte Passwort aktiv.<br /><br />Wird innerhalb der n&auml;chsten 24 Stunden nicht auf den Link geklickt, verf&auml;llt das neue Passwort.<br /><br />{NEW_PASSWORD_LINK}";
	$lang['sendmail_new_password_created_title'] = "Das neue Passwort wurde aktiviert";
	$lang['sendmail_new_password_created_text'] = "Hallo {NAME},<br /><br />Sie haben ihr neues Passwort erfolgreich best&auml;tigt. Anbei erhalten Sie die neuen Zugangsdaten.<br /><br />Benutzername: {NAME}<br />Passwort: {NEW_PASSWORD}";

	// navigation
	$lang['settings'] = "Konfiguration";
	$lang['activate'] = "Eintrag freischalten";
	$lang['deactivate'] = "Eintrag deaktivieren";
	$lang['delete'] = "Eintrag l&ouml;schen";
	$lang['edit'] = "Eintrag editieren";
	$lang['spam'] = "Spam-Eintr&auml;ge";
	$lang['edit_smilies'] = "Smilies bearbeiten";
	$lang['users'] = "Benutzerverwaltung";
	$lang['stats'] = "Statistik";
	$lang['license'] = "Lizenz";
	$lang['forum'] = "Forum";
	$lang['bugreport'] = "Fehler melden";
	$lang['version'] = "Version";
	$lang['manual'] = "Dokumentation";
	$lang['to_guestbook'] = "Zum G&auml;stebuch";
	$lang['paypal'] = "Wenn Sie das MGB n&uuml;tzlich finden, d&uuml;rfen Sie gerne etwas spenden um die weitere Entwicklung zu unterst&uuml;tzen.";

	// settings.inc.php
	$lang['edit_caption_general'] = "Allgemeine Einstellungen";
	$lang['edit_caption_look'] = "Aussehen";
	$lang['edit_caption_bbcodes'] = "BBCodes";
	$lang['edit_caption_smilies'] = "Emoticons";
	$lang['edit_caption_gravatars'] = "Gravatar-Unterst&uuml;tzung";
	$lang['edit_caption_security'] = "Sicherheit";
	$lang['edit_caption_email'] = "eMail";
	$lang['edit_save_message'] = "Einstellungen erfolgreich gespeichert.";
	$lang['edit_title'] = "Titel:";
	$lang['edit_h_author'] = "Autor:";
	$lang['edit_h_domain'] = "Domain:";
	$lang['edit_gb_path'] = "Pfad zum G&auml;stebuch:";
	$lang['edit_h_keywords'] = "Schl&uuml;sselw&ouml;rter:";
	$lang['edit_h_description'] = "Beschreibung:";
	$lang['edit_timezone'] = "Zeitzone:";
	$lang['edit_admin_name'] = "Admin Name:";
	$lang['edit_admin_email'] = "Admin eMail:";
	$lang['edit_admin_gbemail'] = "G&auml;stebuchemail:";
	$lang['edit_sendmail_admin'] = "eMail Benachrichtigung:";
	$lang['edit_sendmail_admin_text'] = "Text f&uuml;r eMail Benachrichtigung:";
	$lang['edit_sendmail_user'] = "Dankesmail an Benutzer:";
	$lang['edit_sendmail_user_text'] = "Text f&uuml;r Dankesmail (unmoderiert):";
	$lang['edit_sendmail_user_text_moderated'] = "Text f&uuml;r Dankesmail (moderiert):";
	$lang['edit_sendmail_user_notification_text'] = "Text f&uuml;r Freischaltungsmail:";
	$lang['edit_sendmail_comment_text'] = "Text bei Kommentarbenachrichtigung:";
	$lang['edit_sendmail_contactmail_text'] = "Text bei eMail &uuml;ber G&auml;stebuch:";
	$lang['edit_sendmail_contactmail_text_copy'] = "Text f&uuml;r die eigene Kopie bei eMail &uuml;ber G&auml;stebuch:";
	$lang['edit_template_path'] = "Template:";
	$lang['edit_template_style_path'] = "Template-Stil:";
	$lang['edit_iconset_path'] = "Grafikset:";
	$lang['edit_language_path'] = "Sprachdatei:";
	$lang['edit_badwords'] = "Wortzensur:";
	$lang['edit_bbcode'] = "BBcodes:";
	$lang['edit_allow_img_tag'] = "IMG-Tag:";
	$lang['edit_max_img_width'] = "Maximale Bildbreite:";
	$lang['edit_max_img_height'] = "Maximale Bildh&ouml;he:";
	$lang['edit_center_img'] = "Zentrierte Bilddarstellung:";
	$lang['edit_allow_flash_tag'] = "FLASH-Tag:";
	$lang['edit_max_flash_width'] = "Maximale Flashbreite:";
	$lang['edit_max_flash_height'] = "Maximale Flashh&ouml;he:";
	$lang['edit_center_flash'] = "Zentrierte Flashdarstellung:";
	$lang['edit_smileys'] = "Smilies:";
	$lang['edit_smileys_break'] = "Smilies in einer Reihe:";
	$lang['edit_smileys_order'] = "Smileysortierung:";
	$lang['edit_captcha'] = "Sicherheitsabfrage (''Captcha''):";
	$lang['edit_captcha_method'] = "Art des Captchas:";
	$lang['edit_captcha_coords'] = "Captcha-Koordinaten:";
	$lang['edit_captcha_color'] = "Captcha-Textfarbe:";
	$lang['edit_captcha_angle'] = "Captcha-Winkel:";
	$lang['edit_akismet_plugin'] = "Akismet-Plugin:";
	$lang['edit_akismet_api'] = "Akismet API Key (erforderlich):";
	$lang['edit_akismet_mark_as_spam'] = "Spam-Markierung:";
	$lang['edit_time_lock'] = "Absendesperre:";
	$lang['edit_time_lock_value'] = "Minimale Zeit f&uuml;r Absendesperre:";
	$lang['edit_time_lock_maxtime'] = "Maximale Zeit f&uuml;r Absendesperre:";
	$lang['edit_user_notification'] = "Benutzerbenachrichtigung:";
	$lang['edit_user_show_email'] = "Benutzeremail im G&auml;stebuch:";
	$lang['edit_session_timeout'] = "Ablaufzeit der Session:";
	$lang['edit_password_min_length'] = "Mindestl&auml;nge f&uuml;r Passw&ouml;rter:";
	$lang['edit_moderated'] = "Moderiertes G&auml;stebuch:";
	$lang['edit_require_email'] = "eMail bei Eintrag erforderlich:";
	$lang['edit_entries_per_page'] = "Eintr&auml;ge pro Seite:";
	$lang['edit_entries_order'] = "Sortierung der Eintr&auml;ge:";
	$lang['edit_entries_order_asc_desc'] = "Reihenfolge der Sortierung:";
	$lang['edit_entries_numbering'] = "Reihenfolge der Nummerierung:";
	$lang['edit_spam_protection'] = "eMail Spamschutz:";
	$lang['edit_ipblocker'] = "IP-Sperre:";
	$lang['edit_wordwrap'] = "Zeilenumbruch:";
	$lang['edit_dateform'] = "Datumsformat:";
	$lang['edit_gravatar_show'] = "Zeige Gravatare:";
	$lang['edit_gravatar_rating'] = "Gravatar Einstufung:";
	$lang['edit_gravatar_type'] = "Unregistrierte Gravatare:";
	$lang['edit_gravatar_size'] = "Gravatar Gr&ouml;sse:";
	$lang['edit_gravatar_position'] = "Position:";

	$lang['edit_expl_title'] = "Der Titel &uuml;ber dem G&auml;stebuch.";
	$lang['edit_expl_h_author'] = "Der Name des Autors der Internetseite.";
	$lang['edit_expl_h_domain'] = "Domain auf der sich das G&auml;stebuch befindet <b>ohne http://</b> am Anfang, und <b>/</b> am Ende. (www.beispiel.de)";
	$lang['edit_expl_gb_path'] = "Der Pfad relativ zur Domain in dem sich das G&auml;stebuch befindet.";
	$lang['edit_expl_h_keywords'] = "Schl&uuml;sselw&ouml;rter durch Kommata getrennt.";
	$lang['edit_expl_h_description'] = "Eine kurze Beschreibung der Seite.";
	$lang['edit_expl_timezone'] = "Seit PHP5 wird die Angabe einer expliziten Zeitzone vorausgesetzt. Geben Sie hier Ihre Zeitzone ein. Siehe: <a href='http://www.php.net/manual/de/timezones.php' target='_blank'>Liste aller verf&uuml;gbaren Zeitzonen</a>";
	$lang['edit_expl_admin_name'] = "Der Name des Admins oder einfach nur ''Admin''.";
	$lang['edit_expl_admin_email'] = "An diese Adresse werden Benachrichtigungen &uuml;ber neue Eintr&auml;ge geschickt.";
	$lang['edit_expl_admin_gbemail'] = "Wird als Absenderadresse f&uuml;r eMails benutzt.";
	$lang['edit_expl_sendmail_admin'] = "Wenn diese Option aktiviert ist, dann wird dem Administrator bei einem neuen Eintrag eine eMail geschickt.";
	$lang['edit_expl_sendmail_admin_text'] = "Dieser Text wird dem Administrator bei aktivierter eMail Benachrichtigung geschickt.<br><br>Verf&uuml;gbare Platzhalter: {NAME}, {DATE}, {TIME}, {MESSAGE}, {DOMAIN}, {URL_TO_GB}";
	$lang['edit_expl_sendmail_user'] = "Wenn diese Option aktiviert ist, dann wird dem Benutzer nach einem Eintrag eine Dankesmail geschickt.";
	$lang['edit_expl_sendmail_user_text'] = "Dieser Text wird dem Benutzer bei einem <b>unmoderierten G&auml;stebuch</b> und <b>aktivierter Dankesmail</b> geschickt.<br><br>Verf&uuml;gbare Platzhalter: {NAME}, {DATE}, {TIME}, {MESSAGE}, {DOMAIN}, {URL_TO_GB}";
	$lang['edit_expl_sendmail_user_text_moderated'] = "Dieser Text wird dem Benutzer bei einem <b>moderierten G&auml;stebuch</b> und <b>aktivierter Dankesmail</b> geschickt.<br><br>Verf&uuml;gbare Platzhalter: {NAME}, {DATE}, {TIME}, {MESSAGE}, {DOMAIN}, {URL_TO_GB}";
	$lang['edit_expl_sendmail_user_notification_text'] = "Dieser Text wird dem Benutzer geschickt, sobald sein Beitrag freigeschaltet wurde. Voraussetzung hierf&uuml;r ist, dass der Benutzer dem bei der Eintragung auch zugestimmt hat.<br><br>Verf&uuml;gbare Platzhalter: {NAME}, {DATE}, {TIME}, {MESSAGE}, {DOMAIN}, {URL_TO_GB}";
	$lang['edit_expl_sendmail_comment_text'] = "Dieser Text wird dem Benutzer geschickt, wenn von einem Administrator oder Moderator ein Kommentar zu seinem Beitrag verfasst wurde. Voraussetzung hierf&uuml;r ist, dass der Benutzer dem bei der Eintragung auch zugestimmt hat.<br><br>Verf&uuml;gbare Platzhalter: {NAME}, {DATE}, {TIME}, {MESSAGE}, {DOMAIN}, {URL_TO_GB}";
	$lang['edit_expl_sendmail_contactmail_text'] = "Dieser Text wird Benutzern geschickt, die bei aktiviertem eMail Spamschutz eine email &uuml;ber das G&auml;stebuch erhalten.<br><br>Verf&uuml;gbare Platzhalter: {NAME}, {DATE}, {TIME}, {MESSAGE}, {DOMAIN}, {URL_TO_GB}";
	$lang['edit_expl_sendmail_contactmail_text_copy'] = "Dieser Text wird dem Absender einer bei aktiviertem eMail Spamschutz &uuml;ber das Kontaktformular gesendeten Nachricht geschickt.<br><br>Verf&uuml;gbare Platzhalter: {NAME}, {DATE}, {TIME}, {MESSAGE}, {DOMAIN}, {URL_TO_GB}";
	$lang['edit_expl_template_path'] = "Das Template das benutzt werden soll.";
	$lang['edit_expl_template_style_path'] = "Der gew&uuml;nschte Stil des Templates. Kann erst ausgew&auml;hlt werden, nachdem das entsprechende Template geladen wurde.";
	$lang['edit_expl_iconset_path'] = "Das gew&uuml;nschte Grafikset das Icons unabh&auml;ngig vom gew&auml;hlten Template bereitstellt.";
	$lang['edit_expl_language_path'] = "Die Sprache die benutzt werden soll.<br><br><b>ACHTUNG:</b> Seit Version <b>0.6.5</b> werden Sprachen die den Zeichencode latin9 (iso-8859-15) besitzen, <b>NICHT</b> mehr Unterst&uuml;tzt. Bei fehlenden Variablen, leeren Textfeldern etc. im G&auml;stebuch bitte auf eine utf-8-basierte Sprache (z.B. ''German / Deutsch (Du)'') umstellen, und jegliche latin9-Sprachen aus dem Ordner ''language'' entfernen.<br><br>Anschlie&szlig;end k&ouml;nnen Probleme mit Sonderzeichen, Umlauten etc. auftreten. Dann bitte die Datei ''convert_ansi.php'' im Ordner ''install'' ausf&uuml;hren.";
	$lang['edit_expl_language_charset'] = "Zeichensatz:";
	$lang['edit_expl_badwords'] = "Geben Sie hier unerw&uuml;nschte W&ouml;rter durch Kommata getrennt ein, die im G&auml;stebuch durch Sternchen ersetzt werden sollen. Leer lassen zur Deaktivierung.";
	$lang['edit_expl_bbcode'] = "L&auml;sst Textformatierungen durch den Benutzer zu.";
	$lang['edit_expl_allow_img_tag'] = "Das Einbinden von Bildern und Grafiken in einen G&auml;stebucheintrag birgt ein Sicherheitsrisiko. Bilder k&ouml;nnten Schadsoftware enthalten, und ebenso k&ouml;nnten durch Benutzer eventuell unerw&uuml;nschte oder juristisch fragliche Bilder eingebunden werden. Sehr viele, gro&szlig;e Bilder k&ouml;nnen lange Ladezeiten des G&auml;stebuches hervorrufen.<br><br><b>Der BBCode f&uuml;r Bilder sollte nur bei einem moderierten G&auml;stebuch eingeschaltet werden.</b>";
	$lang['edit_expl_max_img_width'] = "Bestimmt die maximale Breite eines durch einen [img]-Tag eingef&uuml;gten Bildes.<br><br><b>ACHTUNG: Greift nur bei funktionierendem <a href='http://de2.php.net/manual/de/function.getimagesize.php' target='_blank' title='php.net'>getimagesize();</a> oder bei einem [img]-Tag mit Angabe der Abmessungen ([img=Breite,H&ouml;he]Bildadresse[/img]).</b>";
	$lang['edit_expl_max_img_height'] = "Bestimmt die maximale H&ouml;he eines durch einen [img]-Tag eingef&uuml;gten Bildes.<br><br><b>ACHTUNG: Greift nur bei funktionierendem <a href='http://de2.php.net/manual/de/function.getimagesize.php' target='_blank' title='php.net'>getimagesize();</a> oder bei einem [img]-Tag mit Angabe der Abmessungen ([img=Breite,H&ouml;he]Bildadresse[/img]).</b>";
	$lang['edit_expl_center_img'] = "Legt fest ob durch einen [img]-Tag eingef&uuml;gte Bilder zentriert dargestellt werden.";
	$lang['edit_expl_allow_flash_tag'] = "Erlaubt es dem Benutzer Flashvideos, wie sie etwa von YouTube bereitgestellt werden, in einen Eintrag einzubinden.<br><br><b>Der BBCode f&uuml;r Flash-Dateien sollte nur bei einem moderierten G&auml;stebuch eingeschaltet werden, da die Gefahr besteht, dass jemand anst&ouml;&szlig;ige Videos verbreitet.</b>";
	$lang['edit_expl_max_flash_width'] = "Bestimmt die maximale Breite eines durch einen [flash]-Tag eingef&uuml;gten Videos.";
	$lang['edit_expl_max_flash_height'] = "Bestimmt die maximale H&ouml;he eines durch einen [flash]-Tag eingef&uuml;gten Videos.";
	$lang['edit_expl_center_flash'] = "Legt fest ob ein durch einen [flash]-Tag eingef&uuml;gtes Video zentriert dargestellt wird.";
	$lang['edit_expl_smileys'] = "Erm&ouml;glicht es dem Benutzer Smilies einzuf&uuml;gen.";
	$lang['edit_expl_smileys_break'] = "Gibt an, nach wie vielen Smilies in der ''newentry.php'' eine neue Zeile angefangen wird. Hilfreich bei sehr vielen Smilies.";
	$lang['edit_expl_smileys_order'] = "Definiert ob Smilies aufsteigend oder absteigend sortiert geladen werden.";
	$lang['edit_expl_captcha'] = "Bei Aktivierung muss ein Sicherheitscode eingegeben oder eine mathematische Formel gel&ouml;st werden, um einen neuen Eintrag und eine eMail an einen Benutzer zu schreiben.";
	$lang['edit_expl_captcha_method'] = "Sie k&ouml;nnen zwischen einem Sicherheitscode und einem mathematischen Captcha, bei dem der Benutzer eine Rechenaufgabe l&ouml;sen muss, w&auml;hlen.";
	$lang['edit_expl_captcha_coords'] = "Definiert die Koordinaten, an denen der Text im Bild startet. Anfangspunkt ist dabei die <b>linke, untere Ecke des ersten Buchstabens</b>.";
	$lang['edit_expl_captcha_color'] = "Bestimmt die Textfarbe des Captchas. Der Wert muss im HTML-Format und ohne '#' vorliegen.<br><br><b>Richtig: <span class='newer_version'>505050</span><br>Falsch: <span class='old_version'>#505050</span></b>";
	$lang['edit_expl_captcha_angle'] = "Diese beiden Werte geben den Bereich an, in dem der Winkel den der Text einnimmt, zuf&auml;llig ausgew&auml;hlt wird.";
	$lang['edit_expl_akismet_plugin'] = "Akismet ist ein externer Service, der neue Eintr&auml;ge auf Spam pr&uuml;ft, und bei einem positiven Ergebnis den Eintrag blockt. Das Akismet-Plugin kann auf <a href='http://www.m-gb.org/index.php?id=download_gb' title='Download Akismet Plugin'>http://www.m-gb.org/</a> herunter geladen werden.<br><br><b>ACHTUNG: Mit der Nutzung von 'Akismet' erkl&auml;ren Sie sich einverstanden, dass Daten auf einen Server in die USA &uuml;bermittelt werden. Sind Sie damit nicht einverstanden, d&uml;rfen Sie das Plugin nicht benutzen! Ebenso m&uuml;ssen Benutzer, die Eintr&auml;ge verfassen, der &Uuml;bermittlung der Daten in die USA zustimmen.</b>";
	$lang['edit_expl_akismet_api'] = "Um Akismet nutzen zu k&ouml;nnen, ist das Akismet-Plugin sowie ein <a href='http://akismet.com/signup/#free' title='Akismet API Key'>API Key</a> erforderlich. Gib ihn nach der Registrierung hier ein.";
	$lang['edit_expl_akismet_check_ok'] = "<span class='same_version' style='font-size: 14px;'>Akismet ist installiert!</span>";
	$lang['edit_expl_akismet_check_fail'] = "<span class='old_version' style='font-size: 14px;'>Akismet ist NICHT installiert!</span>";
	$lang['edit_expl_akismet_mark_as_spam'] = "Ist diese Option aktiv, werden neue, von Akismet als Spam identifizierte Eintr&auml;ge, als solcher markiert, und erscheinen in der Administration in der Kategorie Spam.";
	$lang['edit_expl_time_lock'] = "Wenn diese Option aktiviert wird, l&auml;uft bei einem neuen G&auml;stebucheintrag im Hintergrund ein Z&auml;hler mit. Sendet der Benutzer das Formular vor Ablauf dieses Z&auml;hlers ab, wird er darauf hingewiesen dass er zu schnell war, und wie viele Sekunden er noch warten muss, um das Formular abzusenden.";
	$lang['edit_expl_time_lock_value'] = "Die minimale Zeit in Sekunden die der Benutzer warten muss, bis er das Formular absenden kann.";
	$lang['edit_expl_time_lock_maxtime'] = "Die maximale Zeit in Sekunden in der ein Benutzer Gelegenheit hat, einen G&auml;stebucheintrag zu hinterlassen. L&auml;uft die Zeit w&auml;hrend des G&auml;stebucheintrags ab, beginnt die Absendesperre von vorne.";
	$lang['edit_expl_user_notification'] = "Erm&ouml;glicht es dem Benutzer zu entscheiden, ob er sich per eMail benachrichtigen lassen will wenn sein Eintrag freigeschaltet wurde.";
	$lang['edit_expl_user_show_email'] = "Erm&ouml;glicht es dem Benutzer zu entscheiden, ob seine eMail im G&auml;stebuch angezeigt wird, oder nicht. Deaktiviert er das K&auml;stchen kann ihm niemand au&szlig;er der Administrator eine eMail schreiben.";
	$lang['edit_expl_session_timeout'] = "Ein Administrator / Moderator wird bei Inaktivit&auml;t nach Ablauf dieser Zeit automatisch abgemeldet. Angabe in <b>Sekunden</b>. Wert muss >= <b>60</b> sein.";
	$lang['edit_expl_password_min_length'] = "Legt die Mindestl&auml;nge f&uuml;r Passw&ouml;rter fest. Wert darf nicht kleiner als <b>3</b> sein.<br><br><b>ACHTUNG:</b> Sichere Passw&ouml;rter sollten mindestens acht oder mehr Zeichen lang sein, und Sonderzeichen enthalten!";
	$lang['edit_expl_moderated'] = "Bei Aktivierung m&uuml;ssen Eintr&auml;ge erst freigeschaltet werden, bevor sie im G&auml;stebuch erscheinen.";
	$lang['edit_expl_require_email'] = "Legt fest, ob bei einem neuen Eintrag eine eMail Adresse zwingend angegeben werden muss.<br><br><b>ACHTUNG: Wirkung wird mit der Nutzung von Akismet au&szlig;er Kraft gesetzt.</b>";
	$lang['edit_expl_entries_per_page'] = "Gibt an, wieviele Eintr&auml;ge auf einer Seite angezeigt werden. Der Wert darf <b>nicht 0</b> sein.";
	$lang['edit_expl_entries_order'] = "Bestimmt das MySQL-Feld nach dem die Eintr&auml;ge sortiert werden sollen.";
	$lang['edit_expl_entries_order_asc_desc'] = "Bestimmt die Reihenfolge nach der die Eintr&auml;ge sortiert werden sollen.";
	$lang['edit_expl_entries_numbering'] = "Bestimmt die Reihenfolge nach der die Eintr&auml;ge nummeriert werden.<br><br><b>Achtung:</b> Dies hat nichts mit der Sortierung zu tun. Lediglich die einem &ouml;ffentlichen Benutzer gezeigte Nummer eines Eintrags &auml;ndert sich hier.";
	$lang['edit_expl_spam_protection'] = "Bei Aktivierung wird bei Klick auf das eMail Symbol im Beitrag, ein Kontaktformular ge&ouml;ffnet, durch das ein anderer Benutzer dann eine eMail versenden kann. eMail Adressen werden somit <b>nicht</b> direkt angezeigt.";
	$lang['edit_expl_ipblocker'] = "Verhindert mehrere Eintr&auml;ge hintereinander.<br><br><b>NICHT VOLL FUNKTIONSF&Auml;HIG!</b>";
	$lang['edit_expl_wordwrap'] = "Gibt die Anzahl der Zeichen an, nachdem ein sehr langes Wort umgebrochen wird. <b>0</b> f&uuml;r Deaktivierung.";
	$lang['edit_expl_dateform'] = "Die Form in der das Datum dargestellt wird. Formatierungen sind anhand der php Funktion <a class='admin' href='http://www.php.net/manual/en/function.date.php' title='date()' target='_blank'>date()</a> m&ouml;glich.";
	$lang['edit_expl_gravatar_show'] = "Gravatare (Global Recognized Avatars) sind kleine Bildchen, die neben dem Eintrag des Benutzers angezeigt werden. Sie sind abh&auml;ngig davon, ob der Benutzer mit seiner eMail Adresse bei dem Service <a class=\"admin\" href=\"http://site.gravatar.com/\" target=\"_blank\" title=\"Gravatar Service\">registriert</a> ist.";
	$lang['edit_expl_gravatar_rating'] = "Legt fest bis zu welcher Einstufung Gravatare angezeigt werden.<br><br><b>G</b> = F&uuml;r jedes Alter<br><b>PG</b> = leichte Gewaltdarstellungen, provokant gekleidete Menschen und Gesten<br><b>R</b> = Intensive Gewaltdarstellungen, Obsz&ouml;nit&auml;ten<br><b>X</b> = sexuell anst&ouml;&szlig;ige Bilder";
	$lang['edit_expl_gravatar_type'] = "Hier k&ouml;nnen Sie festlegen, wie Gravatare dargestellt werden, sollte der Benutzer nicht bei dem Dienst mit seiner eMail-Adresse registriert sein.";
	$lang['edit_expl_gravatar_size'] = "Legt die Abmessungen des Gravatars in <b>Pixeln</b> fest.";
	$lang['edit_expl_gravatar_position'] = "Legt fest, ob der Gravatar links oder rechts vom Eintrag erscheint.";

	// edit.php
	$lang['ID'] = "ID:";
	$lang['ip'] = "IP:";
	$lang['date'] = "Datum:";
	$lang['time'] = "Zeit:";
	$lang['name'] = "Name:";
	$lang['city'] = "Wohnort:";
	$lang['email'] = "eMail:";
	$lang['icq'] = "ICQ:";
	$lang['aim'] = "AIM:";
	$lang['msn'] = "MSN:";
	$lang['hp'] = "Homepage:";
	$lang['message'] = "Eintrag:";
	$lang['user_notification'] = "Benachrichtigung bei Freischaltung oder Kommentar:";
	$lang['user_show_email'] = "Zeige email im G&auml;stebuch an:";
	$lang['comment'] = "Kommentar:";

	// smilies.inc.php
	$lang['add_smilies_descr'] = "Hier k&ouml;nnen Sie bestehende Smilies &auml;ndern, oder neue hinzuf&uuml;gen.<br><br>Alle Smilies die hinzugef&uuml;gt werden sollen, m&uuml;ssen sich im Ordner <b>'images/smilies/'</b> im Hauptverzeichnis des G&auml;stebuches befinden. Sie m&uuml;ssen also nur den Dateinamen angeben. Benutzen Sie dazu bitte das <b>leere Feld</b> und dr&uuml;cken dann <b>Speichern</b>.<br><br>Sie k&ouml;nnen auch mehrere Platzhalter angeben. Trennen Sie sie durch ein <b>Komma und ein Leerzeichen</b>. Um Smilies in der ''newentry.php'' einzuf&uuml;gen, wird der <b>erste</b> angegebene Platzhalter verwendet.<br><br><span class='same_version'>Richtig:</span> :smile:, :), :-)<br><span class='old_version'>Falsch:</span> :smile:,:),:-)<br><br><b>Bitte beachten Sie, dass wenn Sie bestehende Platzhalter oder Smilies &auml;ndern bzw. l&ouml;schen, die in Eintr&auml;gen bereits verwendet wurden, diese nicht mehr korrekt angezeigt werden k&ouml;nnen! Sie m&uuml;ssen diese Eintr&auml;ge dann per Hand editieren.</b>";
	$lang['smiley_path'] = "Dateiname";
	$lang['smiley_replacement'] = "Platzhalter";
	$lang['add_new_smiley'] = "Smiley hinzuf&uuml;gen";
	$lang['checked_smilies'] = "Markierte Smilies ...";
	$lang['delete_checked_smilies'] = "... aus Liste entfernen, unmarkierte behalten";
	$lang['keep_checked_smilies'] = "... in Liste behalten, unmarkierte entfernen";
	$lang['smiley_width'] = "Breite";
	$lang['smiley_height'] = "H&ouml;he";
	$lang['smilies'] = "Smilies";

	// edit_user.inc.php
	$lang['user_is_active'] = "Benutzer ist aktiv:";
	$lang['r_user_type'] = "Benutzer ist:";
	$lang['r_settings'] = "Konfiguration &auml;ndern:";
	$lang['r_activate'] = "Eintr&auml;ge freischalten:";
	$lang['r_deactivate'] = "Eintr&auml;ge deaktivieren:";
	$lang['r_delete'] = "Eintr&auml;ge l&ouml;schen:";
	$lang['r_edit'] = "Eintr&auml;ge editieren:";
	$lang['r_spam'] = "Spam verwalten:";
	$lang['r_edit_smilies'] = "Smilies bearbeiten";
	$lang['old_password'] = "Ihr aktuelles Passwort:";
	$lang['new_password_1'] = "Passwort:";
	$lang['new_password_2'] = "Passwort best&auml;tigen:";
	$lang['delete_user'] = "Best&auml;tigen:";
	$lang['edit_user_caption_rights'] = "Rechte (nur f&uuml;r Moderatoren)";
	$lang['edit_user_caption_password'] = "Passwort dieses Benutzers:";
	$lang['edit_user_caption_delete_user'] = "Diesen Benutzer l&ouml;schen";
	$lang['edit_user_caption_old_password'] = " Ihr aktuelles Passwort:";
	$lang['user_add'] = "Benutzer hinzuf&uuml;gen";
	$lang['user_edit'] = "Benutzer editieren";
	$lang['edit_user_caption_send_account_data'] = "Daten zusenden";
	$lang['send_account_data'] = "per eMail zusenden?";

	// version.inc.php
	$lang['current_version'] = "Installierte Version:";
	$lang['stable_version'] = "Neueste stabile Version:";
	$lang['unstable_version'] = "Neueste instabile Version:";
	$lang['old_version'] = "Ihre Version ist veraltet.<br>Eine Aktualisierung wird empfohlen.<br><br><a href='http://www.m-gb.org/index.php?id=download_gb' class='admin' target='_blank' title='Jetzt aktualisieren'>Zur neuesten Version</a>";
	$lang['same_version'] = "Sie besitzen die neueste Version.<br>Eine Aktualisierung ist nicht erforderlich.";
	$lang['newer_version'] = "Ihre Version ist neuer als die verf&uuml;gbare stabile Version.<br>Eine Aktualisierung ist nicht erforderlich.";
	$lang['new_version_available'] = "Eine neuere Version ist verf&uuml;gbar: <a href='http://www.m-gb.org/files/latest/mgb-latest.zip' class='admin' target='_blank' title='Jetzt aktualisieren'>{LATEST_VERSION}</a>";

	// lostpassword.php
	$lang['lostpassword_mail'] = "Ihre eMail Adresse:";
	$lang['get_new_pw'] = "Neues Passwort anfordern";
	$lang['lostpassword_success'] = "Ihre Anfrage wurde bearbeitet. Sie werden in K&uuml;rze eine eMail mit einem<br>Best&auml;tigungslink erhalten. Klicken Sie darauf, um ihr neues Passwort zu aktivieren.";
	$lang['lostpassword_no_success'] = "Ihre Anfrage konnte nicht bearbeitet werden, da ein Problem mit dem Mailserver aufgetreten ist.";
	$lang['lostpassword_success_created'] = "Ihre neuen Zugangsdaten wurden<br>Ihnen per eMail zugeschickt.";
	$lang['lostpassword_no_success_created'] = "Ein Fehler ist beim Mailversand aufgetreten.<br>Die Zugangsdaten konnten nicht verschickt werden.";
?>
