<?php
	/*
	MGB 0.6.x - OpenSource PHP and MySql Guestbook
	Copyright (C) 2004 - 2013 Juergen Grueneisl - http://www.m-gb.org/

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
	*/

	// ======= //
	// 067.php //
	// ======= //
	//
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //

$sql = array();

// 0.6.7

$sql[1] = "CREATE TABLE ".$db['prefix']."smilies (
	  `ID` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
	  `path` VARCHAR( 255 ) NOT NULL ,
	  `replacement` VARCHAR( 255 ) NOT NULL ,
	  `height` TINYINT( 4 ) NOT NULL ,
	  `width` TINYINT( 4 ) NOT NULL
	  );";
$sqldescription[1] = "- Creating table for smilies...";

$sql[2] = "INSERT INTO ".$db['prefix']."smilies (
	  `ID` ,
	  `path` ,
	  `replacement` ,
	  `height` ,
	  `width`
	  ) VALUES 	( NULL , 'smiley_smile.gif', ':smile:, :), :-)', '15', '15' ),
				( NULL , 'smiley_wink.gif', ':wink:, ;), ;-)', '15', '15' ),
				( NULL , 'smiley_lol.gif', ':lol:', '15', '15' ),
				( NULL , 'smiley_biggrin.gif', ':biggrin:, :D, :-D', '15', '15' ),
				( NULL , 'smiley_cool.gif', ':cool:, B), B-)', '15', '15' ),
				( NULL , 'smiley_fun.gif', ':fun:, ^^', '15', '15' ),
				( NULL , 'smiley_surprised.gif', ':surprised:, :O, :-O', '15', '15' ),
				( NULL , 'smiley_tongue.gif', ':tongue:, :P, :-P', '15', '15' ),
				( NULL , 'smiley_confused.gif', ':confused:, :-/', '15', '15' ),
				( NULL , 'smiley_eek.gif', ':eek:, 8O, 8-O', '15', '15' ),
				( NULL , 'smiley_doubt.gif', ':doubt:', '15', '15' ),
				( NULL , 'smiley_neutral.gif', ':neutral:, :|, :-|', '15', '15' ),
				( NULL , 'smiley_redface.gif', ':redface:', '15', '15' ),
				( NULL , 'smiley_rolleyes.gif', ':rolleyes:', '15', '15' ),
				( NULL , 'smiley_silenced.gif', ':silenced:', '15', '15' ),
				( NULL , 'smiley_sad.gif', ':sad:, :(, :-(', '15', '15' ),
				( NULL , 'smiley_cry.gif', ':cry:, :\'(, :\'-(', '15', '15' ),
				( NULL , 'smiley_doh.gif', ':doh:', '15', '15' ),
				( NULL , 'smiley_angry.gif', ':angry:', '15', '15' ),
				( NULL , 'icon_arrow.gif', ':arrow:', '15', '15' ),
				( NULL , 'icon_exclaim.gif', ':exclaim:', '15', '15' ),
				( NULL , 'icon_question.gif', ':question:', '15', '15' );";
$sqldescription[2] = "- Adding smilies...";
$sqlisinsert[2] = 1;

$sql[3] = "ALTER TABLE `".$db['prefix']."user`
		ADD `r_edit_smilies` TINYINT( 1 ) NOT NULL AFTER `r_spam`";
$sqldescription[3] = "- Adding 'r_edit_smilies' in user table...";

// 0.6.8

$sql[4] = "ALTER TABLE `".$db['prefix']."settings`
		ADD `gravatar_type` TINYINT( 1 ) NOT NULL DEFAULT '1' AFTER `gravatar_rating`";
$sqldescription[4] = "- Adding 'gravatar_type' in settings table...";

$sql[5] = "ALTER TABLE `".$db['prefix']."settings`
		ADD `gravatar_size` INT( 3 ) NOT NULL DEFAULT '50' AFTER `gravatar_type`";
$sqldescription[5] = "- Adding 'gravatar_size' in settings table...";

$sql[6] = "ALTER TABLE `".$db['prefix']."settings`
		ADD `gravatar_position` TINYINT( 1 ) NOT NULL DEFAULT '1' AFTER `gravatar_size` ";
$sqldescription[6] = "- Adding 'gravatar_position' in settings table...";

$sql[7] = "ALTER TABLE `".$db['prefix']."settings`
		ADD `entries_order_asc_desc` VARCHAR( 4 ) NOT NULL DEFAULT 'DESC' AFTER `entries_order`";
$sqldescription[7] = "- Adding 'entries_order_asc_desc' in settings table...";

$sql[8] = "ALTER TABLE `".$db['prefix']."settings`
		ADD `entries_numbering` TINYINT( 1 ) NOT NULL DEFAULT '1' AFTER `entries_order_asc_desc`";
$sqldescription[8] = "- Adding 'entries_numbering' in settings table...";

$sql[9] = "ALTER TABLE `".$db['prefix']."settings`
		CHANGE `entries_order` `entries_order` VARCHAR( 11 ) NOT NULL DEFAULT 'ID'";
$sqldescription[9] = "- Changing 'entries_order' in settings table...";

$sql[10] = "UPDATE `".$db['prefix']."settings` SET `entries_order` = 'ID'";
$sqldescription[10] = "- Changing value of 'entries_order' in settings table...";
$sqlisinsert[10] = 1;

$sql[11] = "ALTER TABLE `".$db['prefix']."settings`
		ADD `smileys_break` INT( 2 ) NOT NULL DEFAULT '11' AFTER `smileys`";
$sqldescription[11] = "- Adding 'smileys_break' in settings table...";

$sql[12] = "ALTER TABLE `".$db['prefix']."settings`
		ADD `smileys_order` VARCHAR( 4 ) NOT NULL DEFAULT 'ASC' AFTER `smileys_break`";
$sqldescription[12] = "- Adding 'smileys_order' in settings table...";

$sql[13] = "ALTER TABLE `".$db['prefix']."settings`
		ADD `password_min_length` TINYINT( 2 ) NOT NULL DEFAULT '8' AFTER `session_timeout`";
$sqldescription[13] = "- Adding 'password_min_length' in settings table...";

// 0.6.9

$sql[14] = "ALTER TABLE `".$db['prefix']."settings`
		ADD `allow_img_tag` TINYINT( 1 ) NOT NULL DEFAULT '0' AFTER `bbcode`";
$sqldescription[14] = "- Adding 'allow_img_tag' in settings table...";

$sql[15] = "ALTER TABLE `".$db['prefix']."settings`
		ADD `max_img_width` INT( 4 ) NOT NULL DEFAULT '400' AFTER `allow_img_tag`";
$sqldescription[15] = "- Adding 'max_img_width' in settings table...";

$sql[16] = "ALTER TABLE `".$db['prefix']."settings`
		ADD `max_img_height` INT( 4 ) NOT NULL DEFAULT '400' AFTER `max_img_width`";
$sqldescription[16] = "- Adding 'max_img_height' in settings table...";

$sql[17] = "ALTER TABLE `".$db['prefix']."settings` 
		ADD `center_img` TINYINT( 1 ) NOT NULL DEFAULT '1' AFTER `max_img_height`";
$sqldescription[17] = "- Adding 'center_img' in settings table...";

$sql[18] = "ALTER TABLE `".$db['prefix']."settings`
		ADD `allow_flash_tag` TINYINT( 1 ) NOT NULL DEFAULT '0' AFTER `center_img`";
$sqldescription[18] = "- Adding 'allow_flash_tag' in settings table...";

$sql[19] = "ALTER TABLE `".$db['prefix']."settings`
		ADD `max_flash_width` INT( 4 ) NOT NULL DEFAULT '400' AFTER `allow_flash_tag`";
$sqldescription[19] = "- Adding 'max_flash_width' in settings table...";

$sql[20] = "ALTER TABLE `".$db['prefix']."settings`
		ADD `max_flash_height` INT( 4 ) NOT NULL DEFAULT '400' AFTER `max_flash_width`";
$sqldescription[20] = "- Adding 'max_flash_height' in settings table...";

$sql[21] = "ALTER TABLE `".$db['prefix']."settings`
		ADD `center_flash` TINYINT( 1 ) NOT NULL DEFAULT '1' AFTER `max_flash_height`";
$sqldescription[21] = "- Adding 'center_flash' in settings table...";

$sql[22] = "ALTER TABLE `".$db['prefix']."settings`
		ADD `captcha_coords_x` INT( 3 ) NOT NULL DEFAULT '20' AFTER `captcha_method`";
$sqldescription[22] = "- Adding 'captcha_coords_x' in settings table...";
		
$sql[23] = "ALTER TABLE `".$db['prefix']."settings`
		ADD `captcha_coords_y` INT( 3 ) NOT NULL DEFAULT '25' AFTER `captcha_coords_x`";
$sqldescription[23] = "- Adding 'captcha_coords_y' in settings table...";

$sql[24] = "ALTER TABLE `".$db['prefix']."settings`
		ADD `captcha_color` VARCHAR( 6 ) NOT NULL DEFAULT '505050' AFTER `captcha_coords_y`";
$sqldescription[24] = "- Adding 'captcha_color' in settings table...";

$sql[25] = "ALTER TABLE `".$db['prefix']."settings`
		ADD `captcha_angle_1` INT( 4 ) NOT NULL DEFAULT '-10' AFTER `captcha_color`";
$sqldescription[25] = "- Adding 'captcha_angle_1' in settings table...";

$sql[26] = "ALTER TABLE `".$db['prefix']."settings`
		ADD `captcha_angle_2` INT( 4 ) NOT NULL DEFAULT '5' AFTER `captcha_angle_1` ";
$sqldescription[26] = "- Adding 'captcha_angle_2' in settings table...";

// 0.6.9.1 - 0.6.9.3

$sql[27] = "ALTER TABLE `".$db['prefix']."settings`
		ADD `timezone` VARCHAR( 255 ) NOT NULL DEFAULT 'Europe/Berlin' AFTER `h_description`";
$sqldescription[27] = "- Adding 'timezone' in settings table...";

// 0.6.9.4

$sql[28] = "ALTER TABLE `".$db['prefix']."settings`
		ADD `require_email` TINYINT ( 1 ) NOT NULL DEFAULT '1' AFTER `moderated`";
$sqldescription[28] = "- Adding 'require_email' in settings table...";

$sql[29] = "ALTER TABLE `".$db['prefix']."settings`
		ADD `sendmail_user_text_moderated` MEDIUMTEXT NOT NULL AFTER `sendmail_user_text`";
$sqldescription[29] = "- Adding 'sendmail_user_text_moderated' in settings table...";

$sql[30] = "ALTER TABLE `".$db['prefix']."settings`
		ADD `sendmail_contactmail_text_copy` MEDIUMTEXT NOT NULL AFTER `sendmail_contactmail_text`";
$sqldescription[30] = "- Adding 'sendmail_contactmail_text_copy' in settings table...";

include("../language/".$settings['language_path']."/lang_admin.php");

$sql[31] = "UPDATE `".$db['prefix']."settings` SET
		`sendmail_user_text` = '".$lang['sendmail_user_text']."',
		`sendmail_user_text_moderated` = '".$lang['sendmail_user_text_moderated']."',
		`sendmail_contactmail_text_copy` = '".$lang['sendmail_contactmail_text_copy']."';";
$sqldescription[31] = "- Inserting values in new fields ...";
$sqlisinsert[31] = 1;

$sql[32] = "ALTER TABLE `".$db['prefix']."user` ADD
		`user_ip` VARCHAR( 15 ) NOT NULL AFTER `user_key`";
$sqldescription[32] = "- Adding 'user_ip' in user table...";

if(isset($_POST['update_version']) AND $_POST['update_version'] == 1)
	{
	$sql[33] = "UPDATE `".$db['prefix']."settings` SET `version` = '".MGB_VERSION."'";
	$sqldescription[33] = "- Updating version number...";
	}
?>

