<?php
	/*
	MGB 0.6.x - OpenSource PHP and MySql Guestbook
	Copyright (C) 2004 - 2011 Juergen Grueneisl - http://www.m-gb.org/
	
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
	*/

	// ======================== //
	// lang_admin.php - English //
	// ======================== //
	//
	// This languagefile was translated by Christian Rech alias HeyJ (mail@heyj.de) 
	// and edited by Jürgen Schäfer ==> juergen.schaefer(at)minetoshsoft.com
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //

	// general values
	$lang['no'] = "No";
	$lang['yes'] = "Yes";
	$lang['save'] = "Save";
	$lang['asc'] = "Ascending";
	$lang['desc'] = "Descending";
	$lang['administrator'] = "Administrator";
	$lang['moderator'] = "Moderator";
	$lang['gravatar_type_0'] = "Standard";
	$lang['gravatar_type_1'] = "Mistery-Man";
	$lang['gravatar_type_2'] = "Identicon";
	$lang['gravatar_type_3'] = "Monsterid";
	$lang['gravatar_type_4'] = "Wavatar";
	$lang['gravatar_type_5'] = "Retro";
	$lang['gravatar_position_left'] = "Left side of entry";
	$lang['gravatar_position_right'] = "Right side of entry";
	$lang['timestamp'] = "Timestamp";
	$lang['quote'] = "Quote of";

	// login.inc.php
	$lang['title'] = "MGB {MGB_VERSION} - Administration";
	$lang['login_username'] = "Username:";
	$lang['login_password'] = "Password:";
	$lang['login_lostpassword'] = "I forgot my password";
	$lang['login'] = "Login";
	$lang['logout'] = "Logout";
	$lang['login_ok'] = "Welcome <b>{SESSION_USERNAME}</b>.";
	$lang['logged_in'] = "You are logged in as <b>{SESSION_USERNAME}</b>";
	$lang['logged_out'] = "Please provide your username and your password to login.";
	$lang['please_wait'] = "You are successfully logged in.<br>Please wait a moment...";

	// errormessages
	$lang['errormessage1'] = "Please fill in all fields!";
	$lang['errormessage2'] = "This username/password combination does not exist.";
	$lang['errormessage3'] = "Your user account was deactivated by the administrator.";
	$lang['errormessage4'] = "You do not have access to this site.";
	$lang['errormessage5'] = "The provided password is wrong.";
	$lang['errormessage6'] = "The new passwords are not identical.";
	$lang['errormessage7'] = "The provided eMail address is not valid or the field was empty.";
	$lang['errormessage8'] = "You cannot remove your own administrator rights, or disable or delete your account.";
	$lang['errormessage9'] = "You have been inactive for too long and thus were deactivated automatically.";
	$lang['errormessage10'] = "On your last visit you did not logout correctly. The system did it for you.<br><br>Please, your for your own security, always use the ''Logout'' button to log out of the system. Thank you.";
	$lang['errormessage11'] = "This username or this eMail address is already in use.";
	$lang['errormessage12'] = "This key is invalid or already expired.";
	$lang['errormessage13'] = "There was already a new password requested for this user account.<br>It is not possible to request another password until the new password is activated or expired.";
	$lang['errormessage14'] = "The email could not be sent. Maybe there's a problem with the mail server.";
	$lang['errormessage15'] = "The version number could not be retrieved because <a href=\"http://php.net/manual/en/function.fopen.php\">fopen()</a> is deactivated on your server.<br>Please contact your host to solve the problem.<br><br>In the meantime you can check the latest version on http://www.m-gb.org/.";
	$lang['errormessage16'] = "Your new password is too short. Secure passwords should have at least ".$settings['password_min_length']." characters.";

	// general strings
	$lang['back_to_mainpage'] = "Back to the main page";
	$lang['back'] = "Backwards";
	$lang['go'] = "Go!";
	$lang['entry'] = "Entry";
	$lang['entries'] = "Entries";
	$lang['no_entries'] = "No entries available.";
	$lang['no_deactivated_entries'] = "No deactivated entries available.";
	$lang['no_activated_entries'] = "No activated entries available.";
	$lang['no_spam_entries'] = "No spam entries available.";
	$lang['entries_on_pages'] = "Entries on {PAGES} pages";
	$lang['page_first'] = "First page";
	$lang['page_first_symbol'] = "&laquo;";
	$lang['page_forwards'] = "One page forward";
	$lang['page_forwards_symbol'] = "&rsaquo;";
	$lang['page_last'] = "Last page";
	$lang['page_last_symbol'] = "&raquo;";
	$lang['page_backwards'] = "One page backward";
	$lang['page_backwards_symbol'] = "&lsaquo;";
	$lang['captcha_method_code'] = "Securitycode";
	$lang['captcha_method_math'] = "Mathematic";
	$lang['activate_entry'] = "Activate this entry";
	$lang['deactivate_entry'] = "Deactivate this entry";
	$lang['delete_entry'] = "Delete this entry";
	$lang['mark_as_spam'] = "Mark as spam";
	$lang['nospam_entry'] = "Mark entry as 'no spam' and activate it";
	$lang['nospam_deactivate_entry'] = "Mark entry as 'no spam' but let it deactivated";
	$lang['active'] = "This entry is activated in the guestbook";
	$lang['inactive'] = "This entry is not activated in the guestbook";
	$lang['edit_entry'] = "Edit this entry";
	$lang['do_nothing'] = "Do nothing ...";
	$lang['delete_whole_spam'] = "Delete all spam entries";
	$lang['mark_all_no_spam_deactivate'] = "Mark all entries as 'no spam' and activate them";
	$lang['mark_all_no_spam_activate'] = "Mark all entries as 'no spam' but let them deactivated";
	$lang['mark_all_as_spam'] = "Mark all entries as spam";
	$lang['activate_all_entries'] = "Activate all entries";
	$lang['deactivate_all_entries'] = "Deactivate all entries";
	$lang['delete_all_entries'] = "Delete all entries";

	$lang['sendmail_user_notification_title'] = "Your entry at {DOMAIN} has been activated.";
	$lang['sendmail_user_comment_title'] = "Concerning your entry at {DOMAIN} a comment was posted.";
	$lang['sendmail_adduser_title'] = "Your user data at {DOMAIN}";
	$lang['sendmail_adduser_text'] = "You were registered successfully at {DOMAIN} by an administrator. Your user data:<br /><br />Username: {ADDUSER_NAME}<br />Password: {ADDUSER_PASSWORD}<br /><br />You can login here: {ADDUSER_URL}";
	$lang['sendmail_admin_text'] = "{NAME} has posted a new entry in the guestbook.<br /><br />Date: {DATE}<br />Time: {TIME}<br /><br />---<br />{MESSAGE}<br />---<br /><br />{URL_TO_GB}";
	$lang['sendmail_user_text'] = "Hello {NAME},<br /><br />thank you for your entry in my guestbook. After reviewing it, I will activate it as soon as possible.";
	$lang['sendmail_user_notification_text'] = "Hello {NAME},<br /><br />Your entry at {DOMAIN} has just been activated. You can look at it here: {URL_TO_GB}";
	$lang['sendmail_comment_text'] = "Hello {NAME},<br /><br />concerning your entry<br /><br />---<br />{MESSAGE}<br />---<br /><br />a comment has just been posted. You can look at it here: {URL_TO_GB}";
	$lang['sendmail_contactmail_text'] = "You received an email from {NAME} through the guestbook of {DOMAIN}. The message:<br /><br />---<br />{MESSAGE}<br />---<br /><br />Date: {DATE}<br />Time: {TIME}";
	$lang['sendmail_new_password_title'] = "New password: Authentication";
	$lang['sendmail_new_password_text'] = "Hello {NAME},<br /><br /> a new password has been generated for your account. To validate it, please click on the link below within the next 24 hours. Until the activation of the new password, the old one will stay active.<br /><br />If the link is not clicked within the next 24 hours, the new password will expire.<br /><br />{NEW_PASSWORD_LINK}";
	$lang['sendmail_new_password_created_title'] = "The new password is activated";
	$lang['sendmail_new_password_created_text'] = "Hello {NAME},<br /><br />You have validated your new password. Enclosed you will find your new user details.<br /><br />Username: {NAME}<br />Password: {NEW_PASSWORD}";	

	// navigation
	$lang['settings'] = "Settings";
	$lang['activate'] = "Activate entry";
	$lang['deactivate'] = "Deactivate entry";
	$lang['delete'] = "Delete entry";
	$lang['edit'] = "Edit entry";
	$lang['spam'] = "Spam entries";
	$lang['edit_smilies'] = "Edit smilies";
	$lang['users'] = "User administration";
	$lang['stats'] = "Statistics";
	$lang['license'] = "License";
	$lang['forum'] = "Forum";
	$lang['bugreport'] = "Report bug";
	$lang['version'] = "Version";
	$lang['manual'] = "Documentation";
	$lang['to_guestbook'] = "To the guestbook";
	$lang['paypal'] = "If you like MGB and think it is useful, you may donate to the project to support its future development.";

	// settings.inc.php
	$lang['edit_caption_general'] = "General settings";
	$lang['edit_caption_look'] = "Look &amp; feel";
	$lang['edit_caption_bbcodes'] = "BBCodes";
	$lang['edit_caption_smilies'] = "Emoticons";
	$lang['edit_caption_gravatars'] = "Gravatar-support";
	$lang['edit_caption_security'] = "Security";
	$lang['edit_caption_email'] = "Email";
	$lang['edit_save_message'] = "Saved settings successfully.";
	$lang['edit_title'] = "Title:";
	$lang['edit_h_author'] = "Author:";
	$lang['edit_h_domain'] = "Domain:";
	$lang['edit_gb_path'] = "Path to the guestbook:";
	$lang['edit_h_keywords'] = "Keywords:";
	$lang['edit_h_description'] = "Description:";
	$lang['edit_admin_name'] = "Admin Name:";
	$lang['edit_admin_email'] = "Admin email:";
	$lang['edit_admin_gbemail'] = "Guestbook email:";
	$lang['edit_sendmail_admin'] = "Notification email:";
	$lang['edit_sendmail_admin_text'] = "Text for notification email:";
	$lang['edit_sendmail_user'] = "Thank-You mail to the user:";
	$lang['edit_sendmail_user_text'] = "Text for Thank-You mail:";
	$lang['edit_sendmail_user_notification_text'] = "Text for activation-mail:";
	$lang['edit_sendmail_comment_text'] = "Text for comment-notification:";
	$lang['edit_sendmail_contactmail_text'] = "Text for eMail through the guestbook:";
	$lang['edit_template_path'] = "Template:";
	$lang['edit_template_style_path'] = "Template-Style:";
	$lang['edit_iconset_path'] = "Icon set:";
	$lang['edit_language_path'] = "Language file:";
	$lang['edit_badwords'] = "Bad words:";
	$lang['edit_bbcode'] = "BBcodes:";
	$lang['edit_allow_img_tag'] = "IMG-Tag:";
	$lang['edit_max_img_width'] = "Maximum width of image:";
	$lang['edit_max_img_height'] = "Maximum height of image:";
	$lang['edit_center_img'] = "Display images centered:";
	$lang['edit_allow_flash_tag'] = "FLASH-Tag:";
	$lang['edit_max_flash_width'] = "Maximum width of flash:";
	$lang['edit_max_flash_height'] = "Maximum height of flash:";
	$lang['edit_center_flash'] = "Display flash centered:";
	$lang['edit_smileys'] = "Smileys:";
	$lang['edit_smileys_break'] = "Smiley line break:";
	$lang['edit_smileys_order'] = "Sorting of smilies:";
	$lang['edit_captcha'] = "Captcha:";
	$lang['edit_captcha_method'] = "Sort of captcha:";
	$lang['edit_captcha_coords'] = "Captcha coordinates:";
	$lang['edit_captcha_color'] = "Captcha text color:";
	$lang['edit_captcha_angle'] = "Captcha angle:"; 
	$lang['edit_akismet_plugin'] = "Akismet-Plugin:";
	$lang['edit_akismet_api'] = "Akismet API Key:";
	$lang['edit_akismet_mark_as_spam'] = "Spam marking:";
	$lang['edit_time_lock'] = "Sign lock:";
	$lang['edit_time_lock_value'] = "Minimum time for sign lock:";
	$lang['edit_time_lock_maxtime'] = "Maximum time for sign lock:";
	$lang['edit_user_notification'] = "User notification:";
	$lang['edit_user_show_email'] = "User mail in the guestbook:";
	$lang['edit_session_timeout'] = "Session timeout:";
	$lang['edit_password_min_length'] = "Minimum length of passwords:";
	$lang['edit_moderated'] = "Moderated guestbook:";
	$lang['edit_entries_per_page'] = "Entries per page:";
	$lang['edit_entries_order'] = "Sorting of entries:";
	$lang['edit_entries_order_asc_desc'] = "Sequence of sorting:";
	$lang['edit_entries_numbering'] = "Sequence of numbering:";
	$lang['edit_spam_protection'] = "Email spam protection:";
	$lang['edit_ipblocker'] = "IP-Blocker:";
	$lang['edit_wordwrap'] = "Word wrap:";
	$lang['edit_dateform'] = "Date format:";
	$lang['edit_gravatar_show'] = "Show gravatars:";
	$lang['edit_gravatar_rating'] = "Gravatar rating:";
	$lang['edit_gravatar_type'] = "Unregistered gravatars:";
	$lang['edit_gravatar_size'] = "Gravatar size:";
	$lang['edit_gravatar_position'] = "Position:";

	$lang['edit_expl_title'] = "The title of the guestbook.";
	$lang['edit_expl_h_author'] = "The authors name of the internet page.";
	$lang['edit_expl_h_domain'] = "Top Level Domain (TLD) where the guestbook is located <b>without http://</b> on the beginning and <b>/</b> at the end. (www.example.net)";
	$lang['edit_expl_gb_path'] = "The path relative to the TLD where the guestbook is located.";
	$lang['edit_expl_h_keywords'] = "Keywords separated by commas.";
	$lang['edit_expl_h_description'] = "A short description of the page.";
	$lang['edit_expl_admin_name'] = "The administrators name or simply ''admin''.";
	$lang['edit_expl_admin_email'] = "Email address to which notifications about new entries will be sent.";
	$lang['edit_expl_admin_gbemail'] = "Will be used as email sender address.";
	$lang['edit_expl_sendmail_admin'] = "If this option is active, the administrator receives an eMail when new entries are posted.";
	$lang['edit_expl_sendmail_admin_text'] = "This text will be send to the administrator if notification by email is active.<br><br>Available placeholders: {NAME}, {DATE}, {TIME}, {MESSAGE}, {DOMAIN}, {URL_TO_GB}";
	$lang['edit_expl_sendmail_user'] = "If this option is active, the user will receive a Thank-You mail.";
	$lang['edit_expl_sendmail_user_text'] = "This text will be send to the user, if the Thank-You mail option is activated.<br><br>Available placeholders: {NAME}, {DATE}, {TIME}, {MESSAGE}, {DOMAIN}, {URL_TO_GB}";
	$lang['edit_expl_sendmail_user_notification_text'] = "This text will be send to the user as soon as his contribution becomes activated. This requires that the user agreed to this at his entry.<br><br>Available placeholders: {NAME}, {DATE}, {TIME}, {MESSAGE}, {DOMAIN}, {URL_TO_GB}";
	$lang['edit_expl_sendmail_comment_text'] = "This text will be send to the user, if an administrator or moderator posted a comment to his entry. This requires that the user agreed to this at his entry.<br><br>Available placeholders: {NAME}, {DATE}, {TIME}, {MESSAGE}, {DOMAIN}, {URL_TO_GB}";
	$lang['edit_expl_sendmail_contactmail_text'] = "This text will be send to users, when they receive an email through the guestbook while spam-protection is activated.<br><br>Available placeholders: {NAME}, {DATE}, {TIME}, {MESSAGE}, {DOMAIN}, {URL_TO_GB}";
	$lang['edit_expl_template_path'] = "The template to be used.";
	$lang['edit_expl_template_style_path'] = "The style of the template. You cannot select it until the desired template was loaded.";
	$lang['edit_expl_iconset_path'] = "The desired graphic-set which provides icons, smileys and captcha-backgrounds independent from the template.";
	$lang['edit_expl_language_path'] = "The language which shall be used.<br><br><b>ATTENTION:</b> Since version <b>0.6.5</b> languages that use the character-set latin9 (iso-8859-15) are <b>NO LONGER</b> supported. If you discover problems with missing variables, empty text fields and so on, try to switch to an utf-8-based language and delete all 'latin9'-languages in the folder 'language'.<br><br>If you then discover problems with umlauts or special chars, please execute 'convert_ansi.php' in the folder 'install'.";
	$lang['edit_expl_language_charset'] = "Charset:";
	$lang['edit_expl_badwords'] = "Enter unwanted bad words, separated by comma, which will be replaced with asterisks (*) in the guest book. Leave empty to deactivate.";
	$lang['edit_expl_bbcode'] = "Let's the user format the text.";
	$lang['edit_expl_allow_img_tag'] = "The implementation of images in a guest-book entry contains some security risks. Images could include malware, or a user could provide an image that is juristic ominous. Many and large pictures also reduce the loading speed of the guest-book.<br><br><b>The IMG-Tag should only be activated if the guest-book is moderated.</b>";
	$lang['edit_expl_max_img_width'] = "Defines the maximum width of an image.<br><br><b>ATTENTION: This only works if <a href='http://de2.php.net/manual/en/function.getimagesize.php' target='_blank' title='php.net'>getimagesize();</a> is working, or if width and height are provided with the [img]-Tag like here -> [img=width,height]address of image[/img]).</b>";
	$lang['edit_expl_max_img_height'] = "Defines the maximum height of an image.<br><br><b>ATTENTION: This only works if <a href='http://de2.php.net/manual/en/function.getimagesize.php' target='_blank' title='php.net'>getimagesize();</a> is working, or if width and height are provided with the [img]-Tag like here -> [img=width,height]address of image[/img]).</b>";
	$lang['edit_expl_center_img'] = "Defines if [img]-Tag images are displayed centered.";
	$lang['edit_expl_allow_flash_tag'] = "Allows the user to insert flash videos, like they come from youtube.<br><br><b>For security reasons the BBCode for flash videos should only be activated if the guestbook is moderated.</b>";
	$lang['edit_expl_max_flash_width'] = "Defines the maximum widht of a flashvideo.";
	$lang['edit_expl_max_flash_height'] = "Defines the maximum height of a flashvideo.";
	$lang['edit_expl_center_flash'] = "Defines if [flash]-Tag videos are displayed centered.";
	$lang['edit_expl_smileys'] = "Enables the user to add smileys.";
	$lang['edit_expl_smileys_break'] = "Defines the number of smilies before a line break will be inserted into the list of smilies in ''newentry.php''. Can be very helpful if many smilies are used.";
	$lang['edit_expl_smileys_order'] = "Indicates how smilies are sorted. Ascending or descending.";
	$lang['edit_expl_captcha'] = "If activated, a security code has to be entered to post a new entry or to send an e-mail.";
	$lang['edit_expl_captcha_method'] = "You can choose between a securitycode, or a mathematic formula the user has to solve.";
	$lang['edit_expl_captcha_coords'] = "Sets the coordinates where the text starts to be drawn into the background picture. Origin is the <b>lower left edge of the first character</b>.";
	$lang['edit_expl_captcha_color'] = "Sets the text color of the captcha. The value has to be in the HTML-Format and without the number sign '#'.<br><br><b>Right: <span class='newer_version'>505050</span><br>Wrong: <span class='old_version'>#505050</span></b>";
	$lang['edit_expl_captcha_angle'] = "These values both define the array of degrees, the captcha text is randomly designed with. The left value has to be <b>lower</b> than the right value."; 
	$lang['edit_expl_akismet_plugin'] = "Akismet is an external anti-spam-service, that checks new entries on spam. The akismet-plugin can be downloaded at <a href='http://www.m-gb.org/index.php?id=download_gb' title='Download Akismet Plugin'>http://www.m-gb.org/</a>.<br><br><b>ATTENTION: When using the 'akismet' plugin, you accept the transmission of data to a server in the United States of America. If you don't comply with that precondition you MUST NOT USE 'Akismet'. Your users also need to agree to that condition if you activate the 'akismet' plugin.</b>";
	$lang['edit_expl_akismet_api'] = "In order to use Akismet you need an <a href='http://akismet.com/signup/#free' title='Akismet API Key'>API Key</a>. Sign in for free and enter it here after registration.";
	$lang['edit_expl_akismet_check_ok'] = "<span class='same_version' style='font-size: 14px;'>Akismet is installed!</span>";
	$lang['edit_expl_akismet_check_fail'] = "<span class='old_version' style='font-size: 14px;'>Akismet is NOT installed!</span>";
	$lang['edit_expl_akismet_mark_as_spam'] = "If this option is enabled, positive Akismet entries are marked as spam and appear in the administration panel so you can check them for yourself and decide what to do with.";
	$lang['edit_expl_time_lock'] = "If this option is enabled, a counter will run in the background during the editing of a new entry, preventing that the entry form will be sent too soon. If the user is editing his entry too quickly, a message will appear telling him how many seconds he'll have to wait until he can sign the guest book.";
	$lang['edit_expl_time_lock_value'] = "Minimum time a user has to wait to send the entry form.";
	$lang['edit_expl_time_lock_maxtime'] = "Maximum value for time period, within which the user can sign the guest book. If the user takes too long editing his entry, the counter restarts.";
	$lang['edit_expl_user_notification'] = "Enables the user to decide whether he wants to be notified by e-mail or not, when his contribution becomes activated.";
	$lang['edit_expl_user_show_email'] = "Enables the user to decide whether his e-mail address will be shown in the guestbook or not. If he disables the checkbox, only the administrator will be able to send him e-mails.";
	$lang['edit_expl_session_timeout'] = "Indicates the time after which an inactive user will be logged out automatically. Expressed in <b>seconds</b>. Value must be >= <b>60</b>.";
	$lang['edit_expl_password_min_length'] = "Defines the minimum length of passwords for Administrators / Moderators.";
	$lang['edit_expl_moderated'] = "If this option is enabled, contributions need to be activated before they show up in the guestbook.";
	$lang['edit_expl_entries_per_page'] = "Indicates the number of entries per page. The value <b>must not be 0</b>.";
	$lang['edit_expl_entries_order'] = "Defines the order in which entries are numbered";
	$lang['edit_expl_entries_order_asc_desc'] = "Defines the sequence in which entries are sorted.";
	$lang['edit_expl_entries_numbering'] = "Defines the sequence in which entries are numbered.<br><br><b>Attention:</b> This has nothing to do with the sorting of entries. It applies solely to the way entries are numbered.";
	$lang['edit_expl_spam_protection'] = "If this option is active, one may open a contact form window by clicking on the e-mail icon beneath a guest book entry. This contact form allows sending email to the corresponding guest book user. The user's email address will <b>not</b> be revealed.";
	$lang['edit_expl_ipblocker'] = "Avoids serial entries by a single user.";
	$lang['edit_expl_wordwrap'] = "Indicates the number of characters after which a very long word will be automatically moved to the beginning of the next line. <b>0</b> to deactivate.";
	$lang['edit_expl_dateform'] = "The format the date will be displayed in. To set up the date format you may use the php function <a class='admin' href='http://www.php.net/manual/en/function.date.php' title='date()' target='_blank'>date()</a>.";
	$lang['edit_expl_gravatar_show'] = "Gravatars (Global Recognized Avatars) are small icons showing up adjacent to a user's guest book entry. To activate them, the user has to <a class=\"admin\" href=\"http://site.gravatar.com/\" target=\"_blank\" title=\"Gravatar Service\">register</a> himself with his email address at the gravatar service.";
	$lang['edit_expl_gravatar_rating'] = "Defines up to which rating gavatars will be shown.<br><br><b>G</b> = for all ages<br><b>PG</b> = illustration of soft violence, persons dressed in stimulating manners and provoking gestures<br><b>R</b> = illustration of severe violence, obscenities<br><b>X</b> = explicit sexual pictures";
	$lang['edit_expl_gravatar_type'] = "Here you can set how gravatars will be displayed if the user's email address is not registered at the service.";
	$lang['edit_expl_gravatar_size'] = "Sets the size of the gravatar in <b>pixels</b>.";
	$lang['edit_expl_gravatar_position'] = "Displays the gravatar on the left or right side of the message.";

	// edit.inc.php
	$lang['ID'] = "ID:";
	$lang['ip'] = "IP:";
	$lang['date'] = "Date:";
	$lang['time'] = "Time:";
	$lang['name'] = "Name:";
	$lang['city'] = "City:";
	$lang['email'] = "eMail:";
	$lang['icq'] = "ICQ:";
	$lang['aim'] = "AIM:";
	$lang['msn'] = "MSN:";
	$lang['hp'] = "Homepage:";
	$lang['message'] = "Message:";
	$lang['user_notification'] = "Notification of activation or comment:";
	$lang['user_show_email'] = "Show email address in the guestbook:";
	$lang['comment'] = "Comment:";

	// smilies.inc.php
	$lang['add_smilies_descr'] = "Here you can edit, add or remove smilies.<br><br>All smilies need to be in the folder <b>'images/smilies/'</b> in the root directory of the guest book. You only need to put the filename into the <b>empty text-field</b> and then press <b>Save</b>.<br><br>You may also add several placeholders. Separate each of them with <b>a comma and a space</b>. To add smileys in ''newentry.php'', the first of the given placeholders will be used.<br><br><span class='same_version'>Right:</span> :smile:, :), :-)<br><span class='old_version'>Wrong:</span> :smile:,:),:-)<br><br><b>Please note: If you change or delete existing smilies or placeholders already used in entries, they won't be displayed correctly anymore! You will have to edit these entries by hand.</b>";
	$lang['smiley_path'] = "Filename";
	$lang['smiley_replacement'] = "Placeholder";
	$lang['add_new_smiley'] = "Add smiley";
	$lang['checked_smilies'] = "Checked smilies ...";
	$lang['delete_checked_smilies'] = "... remove from list, keep unchecked";
	$lang['keep_checked_smilies'] = "... keep, remove unchecked";
	$lang['smiley_width'] = "Width";
	$lang['smiley_height'] = "Height";
	$lang['smilies'] = "Smilies";

	// edit_user.inc.php
	$lang['user_is_active'] = "User is active:";
	$lang['r_user_type'] = "User is:";
	$lang['r_settings'] = "Change settings:";
	$lang['r_activate'] = "Activate post:";
	$lang['r_deactivate'] = "Deactivate post:";
	$lang['r_delete'] = "Delete post:";
	$lang['r_edit'] = "Edit post:";
	$lang['r_spam'] = "Manage spam:";
	$lang['r_edit_smilies'] = "Edit smilies";
	$lang['old_password'] = "Your current password:";
	$lang['new_password_1'] = "New password:";
	$lang['new_password_2'] = "Retype new password:";
	$lang['delete_user'] = "Confirm:";
	$lang['edit_user_caption_rights'] = "Permissions (moderators only)";
	$lang['edit_user_caption_password'] = "Password of this user:";
	$lang['edit_user_caption_delete_user'] = "Delete this user:";
	$lang['edit_user_caption_old_password'] = "Your current password:";
	$lang['user_add'] = "Add user";
	$lang['user_edit'] = "Edit user";
	$lang['edit_user_caption_send_account_data'] = "Send account data";
	$lang['send_account_data'] = "Send per email?";

	// version.inc.php
	$lang['current_version'] = "Installed version:";
	$lang['stable_version'] = "Newest stable version:";
	$lang['unstable_version'] = "Newest instable version:";
	$lang['old_version'] = "Your version is outdated.<br>An update is recommended.<br><br><a href='http://www.m-gb.org/index.php?id=download_gb' class='admin' target='_blank' title='Update now'>Show the latest version</a>";
	$lang['same_version'] = "You are using the latest version.<br>An update is not necessary.";
	$lang['newer_version'] = "Your version is newer than the latest stable version.<br>An update is not necessary.";
	$lang['new_version_available'] = "A new version is available: <a href='http://www.m-gb.org/files/latest/mgb-latest.zip' class='admin' target='_blank' title='Upgrade now!'>{LATEST_VERSION}</a>";

	// lostpassword.php
	$lang['lostpassword_mail'] = "Your eMail address:";
	$lang['get_new_pw'] = "Request a new password";
	$lang['lostpassword_success'] = "Your demand was treated successfully. You will soon receive an email<br>with a confirmation-link. Click this link to activate your new password.";
	$lang['lostpassword_no_success'] = "Your demand couldn't be treated successfully. There was an error with the mailserver.";
	$lang['lostpassword_success_created'] = "Your new login data were<br>sent to you by email.";
	$lang['lostpassword_no_success_created'] = "Your demand couldn't be treated successfully. There was an error with the mailserver.";
?>
