<?php
	/*
	MGB 0.6.x - OpenSource PHP and MySql Guestbook
	Copyright (C) 2004 - 2011 Juergen Grueneisl - http://www.m-gb.org/

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
	*/

	// ======= //
	// 064.php //
	// ======= //
	//
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //

$sql = array();

$sql[1] = "CREATE TABLE ".$db['prefix']."captcha_math (
	`math` VARCHAR( 20 ) NOT NULL ,
	  `sum` INT NOT NULL ,
	  PRIMARY KEY ( `math` )
	  );";
$sqldescription[1] = "- Creating table for new captcha...";

$sql[2] = "INSERT INTO ".$db['prefix']."captcha_math (
		`math` ,
		`sum`
	) VALUES (
		'1+2+3' ,
		'6'
		);";
$sqldescription[2] = "- Inserting default values...";

$sql[3] = "ALTER TABLE `".$db['prefix']."settings` ADD `captcha_method` TINYINT( 1 ) DEFAULT '0' NOT NULL AFTER `captcha` ;";
$sqldescription[3] = "- Inserting field for new captcha method...";

$sql[4] = "ALTER TABLE `".$db['prefix']."settings` ADD `akismet_plugin` TINYINT( 1 ) DEFAULT '0' NOT NULL AFTER `captcha_method` ;";
$sqldescription[4] = "- Inserting field for akismet support...";

$sql[5] = "ALTER TABLE `".$db['prefix']."settings` ADD `akismet_api` VARCHAR( 50 ) NOT NULL AFTER `akismet_plugin` ;";
$sqldescription[5] = "- Inserting field for akismet support (API)...";

$sql[6] = "ALTER TABLE `".$db['prefix']."settings` ADD `akismet_mark_as_spam` TINYINT( 1 ) DEFAULT '1' NOT NULL AFTER `akismet_api` ;";
$sqldescription[6] = "- Inserting field for akismet spam-marking (settings)...";

$sql[7] = "ALTER TABLE `".$db['prefix']."entries` ADD `isspam` TINYINT( 1 ) NOT NULL AFTER `checked` ;";
$sqldescription[7] = "- Inserting field for akismet spam-marking (entries)...";

$sql[8] = "ALTER TABLE `".$db['prefix']."user` ADD `r_spam` TINYINT( 1 ) NOT NULL AFTER `r_edit` ;";
$sqldescription[8] = "- Inserting field for new user right 'manage spam'...";

$sql[9] = "ALTER TABLE `".$db['prefix']."settings` ADD `time_lock` INT( 1 ) NOT NULL AFTER `akismet_mark_as_spam` , ADD `time_lock_value` INT( 3 ) DEFAULT '30' NOT NULL AFTER `time_lock` , ADD `time_lock_maxtime` INT DEFAULT '300' NOT NULL AFTER `time_lock_value` ";
$sqldescription[9] = "- Inserting fields for time lock (settings)...";

$sql[10] = "CREATE TABLE ".$db['prefix']."smilies (
	  `ID` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
	  `path` VARCHAR( 255 ) NOT NULL ,
	  `replacement` VARCHAR( 255 ) NOT NULL ,
	  `height` TINYINT( 4 ) NOT NULL ,
	  `width` TINYINT( 4 ) NOT NULL
	  );";
$sqldescription[10] = "- Adding table for smilies...";

$sql[11] = "INSERT INTO ".$db['prefix']."smilies ( 
	  `ID` ,
	  `path` ,
	  `replacement` ,
	  `height` ,
	  `width`
	  ) VALUES 	( NULL , 'smiley_smile.gif', ':smile:, :), :-)', '15', '15' ),
				( NULL , 'smiley_wink.gif', ':wink:, ;), ;-)', '15', '15' ),
				( NULL , 'smiley_lol.gif', ':lol:', '15', '15' ),
				( NULL , 'smiley_biggrin.gif', ':biggrin:, :D, :-D', '15', '15' ),
				( NULL , 'smiley_cool.gif', ':cool:, B), B-)', '15', '15' ),
				( NULL , 'smiley_fun.gif', ':fun:, ^^', '15', '15' ),
				( NULL , 'smiley_surprised.gif', ':surprised:, :O, :-O', '15', '15' ),
				( NULL , 'smiley_tongue.gif', ':tongue:, :P, :-P', '15', '15' ),
				( NULL , 'smiley_confused.gif', ':confused:, :-/', '15', '15' ),
				( NULL , 'smiley_eek.gif', ':eek:, 8O, 8-O', '15', '15' ),
				( NULL , 'smiley_doubt.gif', ':doubt:', '15', '15' ),
				( NULL , 'smiley_neutral.gif', ':neutral:, :|, :-|', '15', '15' ),
				( NULL , 'smiley_redface.gif', ':redface:', '15', '15' ),
				( NULL , 'smiley_rolleyes.gif', ':rolleyes:', '15', '15' ),
				( NULL , 'smiley_silenced.gif', ':silenced:', '15', '15' ),
				( NULL , 'smiley_sad.gif', ':sad:, :(, :-(', '15', '15' ),
				( NULL , 'smiley_cry.gif', ':cry:, :\'(, :\'-(', '15', '15' ),
				( NULL , 'smiley_doh.gif', ':doh:', '15', '15' ),
				( NULL , 'smiley_angry.gif', ':angry:', '15', '15' ),
				( NULL , 'icon_arrow.gif', ':arrow:, ->', '15', '15' ),
				( NULL , 'icon_exclaim.gif', ':exclaim:', '15', '15' ),
				( NULL , 'icon_question.gif', ':question:', '15', '15' );";
$sqldescription[11] = "- Adding smilies...";

$sql[12] = "ALTER TABLE `".$db['prefix']."user` ADD `r_edit_smilies` TINYINT( 1 ) NOT NULL AFTER `r_spam`";
$sqldescription[12] = "- Updating table for users...";

$sql[13] = "ALTER TABLE `".$db['prefix']."settings` ADD `gravatar_type` TINYINT( 1 ) NOT NULL DEFAULT '1' AFTER `gravatar_rating` ,
          ADD `gravatar_size` INT( 3 ) NOT NULL DEFAULT '50' AFTER `gravatar_type` ,
          ADD `gravatar_position` TINYINT( 1 ) NOT NULL DEFAULT '1' AFTER `gravatar_size` ";
$sqldescription[13] = "- Adding improved gravatar support...";

$sql[14] = "ALTER TABLE `".$db['prefix']."settings` ADD `entries_order_asc_desc` VARCHAR( 4 ) NOT NULL DEFAULT 'DESC' AFTER `entries_order` ,
		   ADD `entries_numbering` TINYINT( 1 ) NOT NULL DEFAULT '1' AFTER `entries_order_asc_desc` ,
		   CHANGE `entries_order` `entries_order` VARCHAR( 11 ) NOT NULL DEFAULT 'ID' ";
$sqldescription[14] = "- Adding fields for improved entries ordering...";

$sql[15] = "UPDATE `".$db['prefix']."settings` SET `entries_order` = 'ID'";
$sqldescription[15] = "- Changing value of field 'entries_order'...";

$sql[16] = "ALTER TABLE `".$db['prefix']."settings` ADD `smileys_break` INT( 2 ) NOT NULL DEFAULT '11' AFTER `smileys` ,
		   ADD `smileys_order` VARCHAR( 4 ) NOT NULL DEFAULT 'ASC' AFTER `smileys_break` ";
$sqldescription[16] = "- Adding fields for improved smiley editing...";

$sql[17] = "ALTER TABLE `".$db['prefix']."settings` ADD `password_min_length` TINYINT( 2 ) NOT NULL DEFAULT '8' AFTER `session_timeout` ";
$sqldescription[17] = "- Adding field for minimum password length...";

$sql[18] = "ALTER TABLE `".$db['prefix']."settings` ADD `allow_img_tag` TINYINT( 1 ) NOT NULL DEFAULT '0' AFTER `bbcode`,
		   ADD `max_img_width` INT( 4 ) NOT NULL DEFAULT '400' AFTER `allow_img_tag` ,
		   ADD `max_img_height` INT( 4 ) NOT NULL DEFAULT '400' AFTER `max_img_width`,
		   ADD `center_img` TINYINT( 1 ) NOT NULL DEFAULT '1' AFTER `max_img_height` ,
		   ADD `allow_flash_tag` TINYINT( 1 ) NOT NULL DEFAULT '0' AFTER `center_img`,
		   ADD `max_flash_width` INT( 4 ) NOT NULL DEFAULT '400' AFTER `allow_flash_tag` ,
		   ADD `max_flash_height` INT( 4 ) NOT NULL DEFAULT '400' AFTER `max_flash_width`,
		   ADD `center_flash` TINYINT( 1 ) NOT NULL DEFAULT '1' AFTER `max_flash_height`,
		   ADD `captcha_coords_x` INT( 3 ) NOT NULL DEFAULT '20' AFTER `captcha_method` ,
		   ADD `captcha_coords_y` INT( 3 ) NOT NULL DEFAULT '25' AFTER `captcha_coords_x` ,
		   ADD `captcha_color` VARCHAR( 6 ) NOT NULL DEFAULT '505050' AFTER `captcha_coords_y` ,
		   ADD `captcha_angle_1` INT( 4 ) NOT NULL DEFAULT '-10' AFTER `captcha_color` ,
		   ADD `captcha_angle_2` INT( 4 ) NOT NULL DEFAULT '5' AFTER `captcha_angle_1` ";
$sqldescription[18] = "- Adding fields necessary for [img] and [flash]-Tag and for improved captcha options...";

// update version number every time
if (isset($_POST['update_version']) AND $_POST['update_version'] == 1)
	{
	if($settings['version'] == "0.6.4")
		{
		$sql[19] = "UPDATE `".$db['prefix']."settings` SET `version` = '0.6.9.1'";
		$sqldescription[19] = "- Updating version number...";
		$to = 19;
		}
	else
		{
		$sql[19] = "UPDATE `".$db['prefix']."settings` SET `version` = '".MGB_VERSION."'";
		$sqldescription[19] = "- Updating version number...";
		$to = 19;
		}
	}
else
	{
	$to = 18;
	}

$config_file = "<?"."php\n\n";
$config_file .= "\t"."// THIS FILE WAS AUTOMATICALLY GENERATED BY MGB\n";
$config_file .= "\t"."// DO NOT MODIFY IT!\n\n";
$config_file .= "\t"."// Database settings\n";
$config_file .= "\t"."\$db = array();\n\n";
$config_file .= "\t"."\$db['hostname'] = '".$db['hostname']."';\n";
$config_file .= "\t"."\$db['dbname'] = '".$db['dbname']."';\n";
$config_file .= "\t"."\$db['username'] = '".$db['username']."';\n";
$config_file .= "\t"."\$db['password'] = '".$db['password']."';\n";
$config_file .= "\t"."\$db['prefix'] = '".$db['prefix']."';\n\n";
$config_file .= "\t"."\$mgb_installation_complete = TRUE;\n";
$config_file .= "?>";

if(write_config("../includes/config.inc.php", $config_file) === TRUE)
	{
	echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- rewriting config.inc.php...</span>\n
	\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: green;\">&nbsp;OK!<br /></span>\n";
	$success++;
	$count++;
	}
else
	{
	echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- rewriting config.inc.php...</span>\n
	\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: red;\">ERROR!<br /></span>\n";
	$count++;
	}
?>
