<?php
	/*
	MGB 0.6.x - OpenSource PHP and MySql Guestbook
	Copyright (C) 2004 - 2011 Juergen Grueneisl - http://www.m-gb.org/

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
	*/

	// ================ //
	// import.php - 0.6 //
	// ================ //
	//
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //

	// Show all errors but no warnings
	error_reporting(E_ALL & ~E_NOTICE);

	// check if MGB has been already installed
	if (file_exists("../includes/config.inc.php"))
		{
		require ("../includes/config.inc.php");
		if(!isset($mgb_installation_complete))
			{
			echo "It seems as if you haven't installed the MGB yet. You can do that <a href=\"install.php\">here</a>.";
			die();
			}
		}
	else
		{
		echo "The config file could not be found. If you haven't installed the MGB yet, you can do that <a href=\"install.php\">here</a>.";
		die();
		}

	// start session
	session_name("sid");
	ini_set('url_rewriter.tags', '');
	session_start();

	if(SID != NULL) { $sid = "?".SID; } else { $sid = NULL; }

	// load includes
	require ("includes/config.inc.php");
	require ("includes/load_templates.inc.php");
	require ("includes/functions.inc.php");
	require ("../includes/load_settings.inc.php");
	require ("../language/".$settings['language_path']."/lang_import.php");
	require ("../language/".$settings['language_path']."/settings.php");	

	// load main template
	$page_body = $content_import_body;
	$page_header = $content_install_header;

	if(isset($_POST['sent']) AND ($_POST['sent'] == 1))
		{
		$_POST['db_hostname'] = cleanstr($_POST['db_hostname']);
		$_POST['db_dbname'] = cleanstr($_POST['db_dbname']);
		$_POST['db_username'] = cleanstr($_POST['db_username']);
		$_POST['db_password'] = cleanstr($_POST['db_password']);
		$_POST['oldgb_path'] = cleanstr($_POST['oldgb_path']);
		$_POST['import_settings'] = cleanstr($_POST['import_settings']);

		$page_body = template("TEMPLATE_STEPS", $content_import_step1, $page_body);
		$page_body = template("POST_DB_HOSTNAME", $_POST['db_hostname'], $page_body);
		$page_body = template("POST_DB_DBNAME", $_POST['db_dbname'], $page_body);
		$page_body = template("POST_DB_USERNAME", $_POST['db_username'], $page_body);
		$page_body = template("POST_DB_PASSWORD", $_POST['db_password'], $page_body);
		$page_body = template("POST_OLDGB_PATH", $_POST['oldgb_path'], $page_body);

		if(!empty($_POST['db_hostname']) AND !empty($_POST['db_dbname']) AND !empty($_POST['db_username']) AND !empty($_POST['db_password']) AND !empty($_POST['oldgb_path']))
			{
			// check connection to database
			$link = mysql_connect($_POST['db_hostname'], $_POST['db_username'], $_POST['db_password']);
			$link = mysql_select_db($_POST['db_dbname'], $link);

			if(isset($link) AND ($link == TRUE))
				{
				include ($_SERVER['DOCUMENT_ROOT'].$_POST['oldgb_path']."config.php");
				if(file_exists($_SERVER['DOCUMENT_ROOT'].$_POST['oldgb_path']."config.php") == TRUE)
					{
					include ($_SERVER['DOCUMENT_ROOT'].$_POST['oldgb_path']."config.php");
					$sql = "SELECT * FROM ".$db[settings];
					$link = @mysql_connect($_POST['db_hostname'], $_POST['db_username'], $_POST['db_password']) or die ("(import.php) Error: ".mysql_error());
					@mysql_select_db($_POST['db_dbname'], $link) or die ("(import.php) Error: ".mysql_error());
					if(@mysql_query($sql, $link) == TRUE)
						{
						$page_body = template("TEMPLATE_WARNINGS", $content_install_warnings, $page_body);
						$page_body = template("ERROR", "", $page_body);
						$page_body = template("NO_ERROR", "<span class=\"install_no_error\">-&nbsp;".$lang['no_error']."</span><br>", $page_body);
						$page_body = template("VALUE_SENT", 2, $page_body);

						$_SESSION['db_hostname'] = $_POST['db_hostname'];
						$_SESSION['db_dbname'] = $_POST['db_dbname'];
						$_SESSION['db_username'] = $_POST['db_username'];
						$_SESSION['db_password'] = $_POST['db_password'];
						$_SESSION['oldgb_path'] = $_POST['oldgb_path'];
						$_SESSION['import_settings'] = $_POST['import_settings'];
						}
					else
						{
						$page_body = template("TEMPLATE_WARNINGS", $content_install_warnings, $page_body);
						$page_body = template("ERROR", "<span class=\"install_error_critical\">-&nbsp;".$lang['error_4_step1']."</span><br>", $page_body);
						$page_body = template("NO_ERROR", "", $page_body);
						$page_body = template("VALUE_SENT", 1, $page_body);
						}
					}
				else
					{
					$page_body = template("TEMPLATE_WARNINGS", $content_install_warnings, $page_body);
					$page_body = template("ERROR", "<span class=\"install_error_critical\">-&nbsp;".$lang['error_3_step1']."</span><br>", $page_body);
					$page_body = template("NO_ERROR", "", $page_body);
					$page_body = template("VALUE_SENT", 1, $page_body);
					}
				}
			else
				{
				$page_body = template("TEMPLATE_WARNINGS", $content_install_warnings, $page_body);
				$page_body = template("ERROR", "<span class=\"install_error_critical\">-&nbsp;".$lang['error_2_step1']."</span><br>", $page_body);
				$page_body = template("NO_ERROR", "", $page_body);
				$page_body = template("VALUE_SENT", 1, $page_body);
				}
			}
		else
			{
			$page_body = template("TEMPLATE_WARNINGS", $content_install_warnings, $page_body);
			$page_body = template("ERROR", "<span class=\"install_error_critical\">-&nbsp;".$lang['error_1_step1']."</span><br>", $page_body);
			$page_body = template("NO_ERROR", "", $page_body);
			$page_body = template("VALUE_SENT", 1, $page_body);
			}
			
		$page_body = template("ERROR_1", "", $page_body);
		$page_body = template("ERROR_2", "", $page_body);
		$page_body = template("ERROR_3", "", $page_body);
		$page_body = template("ERROR_4", "", $page_body);
		$page_body = template("ERROR_5", "", $page_body);

		$page_body = template("LANG_EXPL_IMPORT", $lang['expl_import'], $page_body);
		$page_body = template("LANG_DB_TITLE", $lang['db_title'], $page_body);
		$page_body = template("LANG_DB_HOSTNAME", $lang['db_hostname'], $page_body);
		$page_body = template("LANG_DB_DBNAME", $lang['db_dbname'], $page_body);
		$page_body = template("LANG_DB_USERNAME", $lang['db_username'], $page_body);
		$page_body = template("LANG_DB_PASSWORD", $lang['db_password'], $page_body);
		$page_body = template("LANG_DB_PREFIX", $lang['db_prefix'], $page_body);
		$page_body = template("LANG_OLDGB_PATH", $lang['oldgb_path'], $page_body);
		$page_body = template("LANG_IMPORT_SETTINGS", $lang['import_settings'], $page_body);
		
		$page_body = template("POST_DB_HOSTNAME", "", $page_body);
		$page_body = template("POST_DB_DBNAME", "", $page_body);
		$page_body = template("POST_DB_USERNAME", "", $page_body);
		$page_body = template("POST_DB_PASSWORD", "", $page_body);
		$page_body = template("POST_DB_PREFIX", "mgb_", $page_body);
		$page_body = template("POST_OLDGB_PATH", "", $page_body);
		
		if ($_POST['import_settings'] == 0) { $import_settings_checked = ""; } else { $import_settings_checked = " checked='checked'"; }
		$page_body = template("IMPORT_SETTINGS_CHECKED", $import_settings_checked, $page_body);

		$page_body = template("TEMPLATE_WARNINGS", "", $page_body);
		$page_body = template("VALUE_SENT", 1, $page_body);
		}
	elseif(isset($_POST['sent']) AND ($_POST['sent'] == 2))
		{
		include ($_SERVER['DOCUMENT_ROOT'].$_SESSION['oldgb_path']."config.php");

		$page_body = template("TEMPLATE_STEPS", $content_import_step2, $page_body);

		// connect to old database
		$link = @mysql_connect($_SESSION['db_hostname'], $_SESSION['db_username'], $_SESSION['db_password']) or die ("(import.php) Error: ".mysql_error());
		@mysql_select_db($_SESSION['db_dbname'], $link) or die ("(import.php) Error: ".mysql_error());

		if($_SESSION['import_settings'] == 1)
			{
			// transfer old settings
			$sql = "SELECT * FROM ".$db[settings];
			$result = @mysql_query($sql, $link) or die ("(import.php) Error: ".mysql_error());

			$old_value = @mysql_fetch_array($result);

			if($charset == "utf-8")
				{
				$title = utf8_encode(delete_quake($old_value['ueberschrift']));
				$h_author = utf8_encode(delete_quake($old_value['autor']));
				$keywords = utf8_encode(delete_quake($old_value['keywords']));
				$h_description = utf8_encode(delete_quake($old_value['description']));
				$badwords = utf8_encode(delete_quake($old_value['zensur']));
				}
			else
				{
				$title = delete_quake($old_value['ueberschrift']);
				$h_author = delete_quake($old_value['autor']);
				$keywords = delete_quake($old_value['keywords']);
				$h_description = delete_quake($old_value['description']);
				$badwords = delete_quake($old_value['zensur']);
				}

			$moderated = $old_value['moderated'];
			$spam_protection = $old_value['spam'];
			$smileys = $old_value['smilies'];
			$bbcode = $old_value['bbcodes'];
			$sendmail_user = $old_value['sendemailuser'];
			$user_notification = $old_value['sendemailuserfrei'];
			$sendmail_admin = $old_value['sendemail'];
			$captcha = $old_value['captcha'];
			$ipblocker = $old_value['ipsperre'];

			// save data to database
			$sql = "UPDATE `".$db['prefix']."settings` SET
							`title` = '".$title."',
							`h_author` = '".$h_author."',
							`h_keywords` = '".$keywords."',
							`h_description` = '".$h_description."',
							`sendmail_admin` = '".$sendmail_admin."',
							`sendmail_user` = '".$sendmail_user."',
							`badwords` = '".$badwords."',
							`bbcode` = '".$bbcode."',
							`smileys` = '".$smileys."',
							`captcha` = '".$captcha."',
							`user_notification` = '".$user_notification."',
							`moderated` = '".$moderated."',
							`spam_protection` = '".$spam_protection."',
							`ipblocker` = '".$ipblocker."'";
					
			$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(import.php) Error: ".mysql_error());
			@mysql_select_db($db['dbname'], $link) or die ("(import.php) Error: ".mysql_error());
			@mysql_query($sql, $link) or die ("(import.php) Error: ".mysql_error());

			$page_body = template("LANG_TRANSFER_SETTINGS", "<span class='install_general'>".$lang['transfer_settings']."</span><span class=\"install_no_error\">&nbsp;".$lang['ok']."</span><br>", $page_body);
			}
		else
			{
			$page_body = template("LANG_TRANSFER_SETTINGS", "", $page_body);
			}

		// connect to old database
		$link = @mysql_connect($_SESSION['db_hostname'], $_SESSION['db_username'], $_SESSION['db_password']) or die ("(import.php) Error: ".mysql_error());
		@mysql_select_db($_SESSION['db_dbname'], $link) or die ("(install.php) Error: ".mysql_error());

		// transfer old entries
		$sql = "SELECT * FROM ".$db[entrys]." ORDER BY ID ASC";
		$result = @mysql_query($sql, $link) or die ("(import.php) Error: ".mysql_error());

		for($i = 0; $i < @mysql_num_rows($result); $i++)
			{
			$import[$i] = @mysql_fetch_array($result);
			}

		for($i = 0; $i < count($import); $i++)
			{
			if($charset == "utf-8")
				{
				$name = utf8_encode(delete_quake($import[$i]['name']));
				$email = utf8_encode($import[$i]['email']);
				$message = utf8_encode(delete_quake($import[$i]['message']));
				$comment = utf8_encode(delete_quake($import[$i]['kommentar']));
				$hp = utf8_encode($import[$i]['hp']);
				$city = utf8_encode(delete_quake($import[$i]['place']));
				$aim = utf8_encode($import[$i]['aim']);
				$msn = utf8_encode($import[$i]['msn']);
				}
			else
				{
				$name = delete_quake($import[$i]['name']);
				$email = $import[$i]['email'];
				$message = delete_quake($import[$i]['message']);
				$comment = delete_quake($import[$i]['kommentar']);
				$hp = $import[$i]['hp'];
				$city = delete_quake($import[$i]['place']);
				$aim = $import[$i]['aim'];
				$msn = $import[$i]['msn'];
				}

			$name = str_replace("'", "&#039;", $name);
			$message = str_replace("'", "&#039;", $message);
			$comment = str_replace("'", "&#039;", $comment);
			$date = $import[$i]['date'];
			$time = $import[$i]['time'];
			$ip = $import[$i]['ip'];
			$icq = $import[$i]['icq'];
			$user_notification = $import[$i]['notify'];
			$checked = $import[$i]['checked'];
			if($checked == -1) { $checked = 0; }

			// set timestamp to NOW(); format
			$delimiter = "/";

			$date = explode($delimiter, $date);
			
			$month = $date[1];
			$day = $date[0];
			$year = $date[2];

			$hours = substr($time, 0,2);
			$minutes = substr($time, 3,2);

			$timestamp = mktime($hours, $minutes, 0, $month, $day, $year);

			// Write data into database
			$sql = "INSERT INTO ".$db['prefix']."entries (
								name,
								city,
								email,
								icq,
								aim,
								msn,
								hp,
								message,
								comment,
								ip,
								timestamp,
								user_notification,
								user_show_email,
								checked
							   ) values (
								'".$name."',
								'".$city."',
								'".$email."',
								'".$icq."',
								'".$aim."',
								'".$msn."',
								'".$hp."',
								'".$message."',
								'".$comment."',
								'".$ip."',
								'".$timestamp."',
								'".$user_notification."',
								'1',
								'".$checked."'
							   )";

			$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(import.php) Error: ".mysql_error());
			@mysql_select_db($db['dbname'], $link) or die ("(import.php) Error: ".mysql_error());
			@mysql_query($sql, $link) or die ("(import.php) Error: ".mysql_error());

			$page_body = template("LANG_TRANSFER_ENTRIES", "<span class='install_general'>".$lang['transfer_entries']."</span><span class=\"install_no_error\">&nbsp;".$lang['ok']."</span><br>", $page_body);
			$page_body = template("VALUE_SENT", 3, $page_body);
			}
		}
	elseif(isset($_POST['sent']) AND ($_POST['sent'] == 3))
		{
		$page_body = template("TEMPLATE_STEPS", $content_import_finish, $page_body);
		$page_body = template("LANG_IMPORT_FINISH", $lang['import_finish'], $page_body);

		session_unset();
		session_destroy();
		$_SESSION = array();
		}
	else
		{
		$page_body = template("TEMPLATE_STEPS", $content_import_step1, $page_body);

		$page_body = template("LANG_EXPL_IMPORT", $lang['expl_import'], $page_body);
		$page_body = template("LANG_DB_TITLE", $lang['db_title'], $page_body);
		$page_body = template("LANG_DB_HOSTNAME", $lang['db_hostname'], $page_body);
		$page_body = template("LANG_DB_DBNAME", $lang['db_dbname'], $page_body);
		$page_body = template("LANG_DB_USERNAME", $lang['db_username'], $page_body);
		$page_body = template("LANG_DB_PASSWORD", $lang['db_password'], $page_body);
		$page_body = template("LANG_DB_PREFIX", $lang['db_prefix'], $page_body);
		$page_body = template("LANG_OLDGB_PATH", $lang['oldgb_path'], $page_body);
		$page_body = template("LANG_IMPORT_SETTINGS", $lang['import_settings'], $page_body);

		$page_body = template("POST_DB_HOSTNAME", "localhost", $page_body);
		$page_body = template("POST_DB_DBNAME", "", $page_body);
		$page_body = template("POST_DB_USERNAME", "", $page_body);
		$page_body = template("POST_DB_PASSWORD", "", $page_body);
		$page_body = template("POST_DB_PREFIX", "mgb_", $page_body);
		$page_body = template("POST_OLDGB_PATH", "", $page_body);

		$page_body = template("TEMPLATE_WARNINGS", "", $page_body);
		$page_body = template("VALUE_SENT", 1, $page_body);
		}

	$page_header = template("H_LANGUAGE_SHORT", $language_short, $page_header);
	$page_header = template("H_INSTALL_TITLE", $lang['h_title'], $page_header);
	$page_header = template("H_CHARSET", $charset, $page_header);

	$page_body = template("TEMPLATE_HEADER", $page_header, $page_body);	
	$page_body = template("TITLE", $lang['title'], $page_body);
	$page_body = template("IMPORT_FORM_ACTION", "import.php".$sid, $page_body);
	$page_body = template("LANG_NEXT_STEP", $lang['next_step'], $page_body);
	$page_body = template("TEMPLATE_COPYRIGHT", $content_install_copyright, $page_body);
	$page_body = template("TEMPLATE_FOOTER", $content_install_footer, $page_body);	
	$page_body = template("COPYRIGHT_DATE", date("Y"), $page_body);
	$page_body = template("MGB_VERSION", MGB_VERSION, $page_body);

	if ($_POST['import_settings'] == 0) { $import_settings_checked = ""; } else { $import_settings_checked = " checked='checked'"; }
	$page_body = template("IMPORT_SETTINGS_CHECKED", $import_settings_checked, $page_body);

	echo $page_body;
?>
