<?php
	/*
	MGB 0.6.x - OpenSource PHP and MySql Guestbook
	Copyright (C) 2004 - 2011 Juergen Grueneisl - http://www.m-gb.org/

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
	*/

	// ========= //
	// admin.php //
	// ========= //
	//
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //

	// Show all errors but no warnings
	error_reporting(E_ALL & ~E_NOTICE);

	header("Cache-Control: no-cache, must-revalidate"); // HTTP/1.1
	header("Expires: Sat, 26 Jul 1997 05:00:00 GMT"); // Datum in der Vergangenheit

	define('ADMINISTRATION', TRUE);

	// check if MGB has been already installed or updated
	if (file_exists("../includes/config.inc.php"))
		{
		require ("../includes/config.inc.php");
		if(!isset($mgb_installation_complete))
			{
			echo "<span style='font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; color: darkblue;'>It seems as if you haven't installed the MGB yet. You can do it
					<a href=\"../install/install.php\">here</a>.<br><br> If MGB is already installed, try to copy your 'config.inc.php' from root directory into 'includes/config.inc.php'.</span>";
			die();
			}
		elseif (isset($mgb_installation_complete) AND $mgb_installation_complete == TRUE AND file_exists('../install'))
			{
			echo "<center><span style='font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; color: darkblue;'>If you upgraded to a newer version shortly, please run
			<a href='../install/upgrade.php'>upgrade.php</a> in install directory <b>now!</b> Otherwise you might discover problems when using this software.<br>If you did a fresh install, you can ignore this message. To remove it, delete install directory. Thank you!<br></span></center>";}
		}
	else
		{
		echo "<span style='font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; color: darkblue;'>The config file could not be found. If you haven't installed MGB yet,
				you can do it <a href=\"../install/install.php\">here</a>.<br><br>Maybe you've forgotten to run <a href=\"../install/upgrade.php\">upgrade.php</a>?<br><br>
				If MGB is already installed and you ran upgrade.php try to copy your 'config.inc.php' from root directory into 'includes/config.inc.php' manually.</span>";
		die();
		}

	// start session
	session_name("sid");
	ini_set('url_rewriter.tags', '');
	session_start();
	session_regenerate_id();

	if(SID != NULL) { $sid = "&amp;".SID; } else {$sid = NULL; }

	require ("../includes/functions.inc.php");
	require ("../includes/config.inc.php");
	require ("../includes/load_settings.inc.php");
	if(isset($_POST['language_path']) AND $_POST['language_path'] != "")
		{
		require ("../language/".cleanstr($_POST['language_path'])."/lang_admin.php");
		require ("../language/".cleanstr($_POST['language_path'])."/settings.php");
		}
	else
		{
		require ("../language/".$settings['language_path']."/lang_admin.php");
		require ("../language/".$settings['language_path']."/settings.php");
		}
	require ("load_template_admin.inc.php");

	if(isset($_SESSION['key']))
		{
		if(!check_session($_SESSION['ID'], $_SESSION['key'], $settings['session_timeout']))
			{
			session_unset();
			session_destroy();
			$_SESSION = array();
			$errorcode = 9;
			}
		}
	else
		{
		$include = "login.inc.php";
		$new_version_available = "&nbsp;";
		}

	// login status
	if(!isset($_SESSION['ID']) OR isset($_GET['action']) AND $_GET['action'] == "logout")
		{
		$include = "login.inc.php";
		$new_version_available = "&nbsp;";
		}
	else
		{
		// get info about new version
		$latest_version = get_mgb_version_info("http://www.m-gb.org/latest.txt");

		switch(version_compare($settings['version'], $latest_version)) {
		case -1: $new_version_available = $lang['new_version_available'];
			break;
		case 0: $new_version_available = "&nbsp;";
			break;
		case 1: $new_version_available = "&nbsp;";
			break;
		}

		// connect to database
		$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(admin.php) Error, line 118: ".mysql_error());
		@mysql_select_db($db['dbname'], $link) or die ("(admin.php) Error, line 119: ".mysql_error());

		// get total number of spam entries
		$sql_count_spam = "SELECT COUNT(ID) FROM ".$db['prefix']."entries WHERE isspam=1";
		$sql_count_deactivated = "SELECT COUNT(ID) FROM ".$db['prefix']."entries WHERE checked=0 and isspam=0";
		$results_spam = @mysql_query($sql_count_spam) or die ("(admin.php) Error, line 124: ".mysql_error()."<br><br>Did you upgrade to a newer version shortly? Try to run <a href='install/upgrade.php'>upgrade.php</a> in install directory if this problem exists permanently.");
		$results_deactivated = @mysql_query($sql_count_deactivated) or die ("(admin.php) Error, line 125: ".mysql_error()."<br><br>Did you upgrade to a newer version shortly? Try to run <a href='install/upgrade.php'>upgrade.php</a> in install directory if this problem exists permanently.");
		$total_spam = @mysql_result($results_spam, 0);
		$total_deactivated = @mysql_result($results_deactivated, 0);
		@mysql_close($link);

		// if there are spam entries, show it in navigation
		if ($total_spam >= 1)
			{
			$lang['spam'] = $lang['spam']."&nbsp;(".$total_spam.")";
			}
		// if there are deactivated entries, show it in navigation
		if ($total_deactivated >= 1)
			{
			$lang['activate'] = $lang['activate']."&nbsp;(".$total_deactivated.")";
			}

		$login_status_text = $lang['logged_in']."&nbsp;|&nbsp;<a class='admin' href='admin.php?action=logout' title='{LANG_LOGOUT}'>{LANG_LOGOUT}</a>&nbsp;";
		$login_status_img = "<img src='templates/default/images/logout.png' height='16' width='16' title='{LANG_LOGOUT}' alt='{LANG_LOGOUT}'>";

		$page_navigation = $content_navigation;

		$page_navigation = template("LINK_SETTINGS", "admin.php?action=settings".$sid, $page_navigation);
		$page_navigation = template("LINK_ACTIVATE", "admin.php?action=activate".$sid, $page_navigation);
		$page_navigation = template("LINK_DEACTIVATE", "admin.php?action=deactivate".$sid, $page_navigation);
		$page_navigation = template("LINK_DELETE", "admin.php?action=delete".$sid, $page_navigation);
		$page_navigation = template("LINK_EDIT", "admin.php?action=edit".$sid, $page_navigation);
		$page_navigation = template("LINK_SPAM", "admin.php?action=spam".$sid, $page_navigation);
		$page_navigation = template("LINK_EDIT_SMILIES", "admin.php?action=smilies".$sid, $page_navigation);
		$page_navigation = template("LINK_EDIT_USERS", "admin.php?action=editusers".$sid, $page_navigation);
		$page_navigation = template("LINK_LICENSE", "admin.php?action=license".$sid, $page_navigation);
		$page_navigation = template("LINK_FORUM", "http://forum.m-gb.org/", $page_navigation);
		$page_navigation = template("LINK_BUGREPORT", "http://bugreport.m-gb.org/", $page_navigation);
		$page_navigation = template("LINK_VERSION", "admin.php?action=version".$sid, $page_navigation);
		$page_navigation = template("LINK_MANUAL", "http://www.m-gb.org/wiki/", $page_navigation);
		$page_navigation = template("LINK_TO_GUESTBOOK", "../index.php", $page_navigation);

		$page_navigation = template("LANG_SETTINGS", $lang['settings'], $page_navigation);
		$page_navigation = template("LANG_ACTIVATE", $lang['activate'], $page_navigation);
		$page_navigation = template("LANG_DEACTIVATE", $lang['deactivate'], $page_navigation);
		$page_navigation = template("LANG_DELETE", $lang['delete'], $page_navigation);
		$page_navigation = template("LANG_EDIT", $lang['edit'], $page_navigation);
		$page_navigation = template("LANG_SPAM", $lang['spam'], $page_navigation);
		$page_navigation = template("LANG_EDIT_SMILIES", $lang['edit_smilies'], $page_navigation);
		$page_navigation = template("LANG_EDIT_USERS", $lang['users'], $page_navigation);
		$page_navigation = template("LANG_LICENSE", $lang['license'], $page_navigation);
		$page_navigation = template("LANG_FORUM", $lang['forum'], $page_navigation);
		$page_navigation = template("LANG_BUGREPORT", $lang['bugreport'], $page_navigation);
		$page_navigation = template("LANG_VERSION", $lang['version'], $page_navigation);
		$page_navigation = template("LANG_MANUAL", $lang['manual'], $page_navigation);
		$page_navigation = template("LANG_TO_GUESTBOOK", $lang['to_guestbook'], $page_navigation);
		//$page_navigation = template("LANG_PAYPAL", $lang['paypal'], $page_navigation);

		$page_navigation = template("TEMPLATE_PATH", "../templates/".$settings['template_path'], $page_navigation);

		if(isset($_GET['action']) AND ($_GET['action'] == "activate"))
			{
			$include = "activate.inc.php";
			}
		elseif(isset($_GET['action']) AND ($_GET['action'] == "deactivate"))
			{
			$include = "deactivate.inc.php";
			}
		elseif(isset($_GET['action']) AND ($_GET['action'] == "delete"))
			{
			$include = "delete.inc.php";
			}
		elseif(isset($_GET['action']) AND ($_GET['action'] == "edit"))
			{
			$include = "edit.inc.php";
			}
		elseif(isset($_GET['action']) AND ($_GET['action'] == "spam"))
			{
			$include = "spam.inc.php";
			}
		elseif(isset($_GET['action']) AND ($_GET['action'] == "smilies"))
			{
			$include = "smilies.inc.php";
			}
		elseif(isset($_GET['action']) AND ($_GET['action'] == "editusers"))
			{
			$include = "edit_user.inc.php";
			}
		elseif(isset($_GET['action']) AND ($_GET['action'] == "license"))
			{
			$page_include = file_get_contents("license.html");
			}
		elseif(isset($_GET['action']) AND ($_GET['action'] == "version"))
			{
			$include = "version.inc.php";
			}
		else
			{
			$include = "settings.inc.php";
			}
		}

	if (!isset($_GET['action']) OR $_GET['action'] != "license")
		{
		require $include;
		}
	elseif($_GET['action'] == "license")
		{
		$login_status_text = $lang['logged_in']."&nbsp;|&nbsp;<a class='admin' href='admin.php?action=logout' title='{LANG_LOGOUT}'>{LANG_LOGOUT}</a>&nbsp;";
		$login_status_img = "<img src='templates/default/images/logout.png' height='16' width='16' title='{LANG_LOGOUT}' alt='{LANG_LOGOUT}'>";

		// get info about new version
		$latest_version = get_mgb_version_info("http://www.m-gb.org/latest.txt");

		switch(version_compare($settings['version'], $latest_version)) {
		case -1: $new_version_available = $lang['new_version_available'];
			break;
		case 0: $new_version_available = "&nbsp;";
			break;
		case 1: $new_version_available = "&nbsp;";
			break;
		}

		if(isset($include) AND ($include == "login.inc.php"))
			{
			require $include;
			}
		else
			{
			$page_include = file_get_contents("license.html");
			$content_scrolling_function = "<br>";
			}
		}
	else
		{
		$content_scrolling_function = "<br>";
		}

	// fill header template with content
	$page_header = $content_header;
	$page_header = template("H_LANGUAGE_SHORT", $language_short, $page_header);
	$page_header = template("H_DOMAIN", $settings['h_domain'], $page_header);
	$page_header = template("H_AUTHOR", $settings['h_author'], $page_header);
	$page_header = template("H_KEYWORDS", $settings['h_keywords'], $page_header);
	$page_header = template("H_DESCRIPTION", $settings['h_description'], $page_header);
	$page_header = template("H_CHARSET", $charset, $page_header);
	if(!isset($refresh)) { $refresh = NULL; }
	$page_header = template("REFRESH", $refresh, $page_header);

	// fill admin_body template with content
	$page_admin = $content_admin;
	$page_admin = template("TEMPLATE_HEADER", $page_header, $page_admin);
	$page_admin = template("TITLE", $lang['title'], $page_admin);
	$page_admin = template("LOGIN_STATUS_TEXT", $login_status_text, $page_admin);
	$page_admin = template("LOGIN_STATUS_IMG", $login_status_img, $page_admin);

	if(!isset($_SESSION['username'])) { $_SESSION['username'] = NULL; }

	$page_admin = template("SESSION_USERNAME", $_SESSION['username'], $page_admin);
	$page_admin = template("LANG_LOGOUT", $lang['logout'], $page_admin);

	if(!isset($page_navigation)) { $page_navigation = NULL; }

	$page_admin = template("TEMPLATE_NAVIGATION", $page_navigation, $page_admin);

	if(!isset($how_many_entries)) { $how_many_entries = NULL; }

	$page_admin = template("LANG_HOW_MANY_ENTRIES", $how_many_entries, $page_admin);

	if(!isset($p)) { $p = NULL; }

	$page_admin = template("PAGES", $p, $page_admin);
	$page_admin = template("TEMPLATE_SCROLLING_FUNCTION", $content_scrolling_function, $page_admin);

	if(!isset($page_include)) { $page_include = NULL; }
	
	if ($saved_settings_successfull == 1)
		{
		if (($_GET['action'] == "settings") OR ($_GET['action'] == "editusers") OR ($_GET['action'] == "edit"))
			{
			$page_admin = template("TEMPLATE_MESSAGE", "<span class='newer_version'>".$lang['edit_save_message']."</span><br><br>", $page_admin);
			}
		}

	if ($sendemail_successfull == 1)
		{
		$page_admin = template("TEMPLATE_MESSAGE", "", $page_admin);
		}
	else
		{
		if (isset($_GET['action']) AND ($_GET['action'] == "activate") AND (isset($_GET['id']) AND !isset($_GET['isspam'])))
			{
			$page_admin = template("TEMPLATE_MESSAGE", "<span class='old_version'>".$lang['errormessage14']."</span><br><br>", $page_admin);
			}
		elseif (isset($_GET['action']) AND ($_GET['action'] == "edit") AND (isset($_GET['id']) AND (isset($_POST['sent_edit']) AND ($_POST['sent_edit'] == 1)) AND !isset($_GET['isspam'])))
			{
			$page_admin = template("TEMPLATE_MESSAGE", "<span class='old_version'>".$lang['errormessage14']."</span><br><br>", $page_admin);
			}
		elseif (isset($_GET['action']) AND ($_GET['action'] == "editusers" AND (isset($_POST['sent_edit']) AND ($_POST['sent_edit'] == 1)) AND !isset($_GET['isspam'])))
			{
			$page_admin = template("TEMPLATE_MESSAGE", "<span class='old_version'>".$lang['errormessage14']."</span><br><br>", $page_admin);
			}
		else
			{
			$page_admin = template("TEMPLATE_MESSAGE", "", $page_admin);
			}
		}

	if($_GET['action'] == 'spam')
		{
		$page_admin = template("TEMPLATE_DROPBOX_NORMAL", '', $page_admin);
		if($total >= 2)
			{
			$page_admin = template("TEMPLATE_DROPBOX_SPAM", $content_dropbox_spam, $page_admin);
			}
		else
			{
			$page_admin = template("TEMPLATE_DROPBOX_SPAM", '', $page_admin);
			}
		}
	else
		{
		if($total >= 1)
			{
			if($_GET['action'] == 'activate')
				{
				$page_admin = template("TEMPLATE_DROPBOX_NORMAL", $content_dropbox_normal, $page_admin);
				$page_admin = template("OPTION_ACTIVATE_ALL_ENTRIES", "<option value='1'>{LANG_ACTIVATE_ALL_ENTRIES}</option>", $page_admin);
				$page_admin = template("OPTION_MARK_ALL_AS_SPAM", "<option value='2'>{LANG_MARK_ALL_AS_SPAM}</option>", $page_admin);
				$page_admin = template("OPTION_DEACTIVATE_ALL_ENTRIES", '', $page_admin);
				$page_admin = template("OPTION_DELETE_ALL_ENTRIES", '', $page_admin);
				$page_admin = template("LANG_ACTIVATE_ALL_ENTRIES", $lang['activate_all_entries'], $page_admin);
				$page_admin = template("LANG_MARK_ALL_AS_SPAM", $lang['mark_all_as_spam'], $page_admin);
				}
			elseif($_GET['action'] == 'deactivate')
				{
				$page_admin = template("TEMPLATE_DROPBOX_NORMAL", $content_dropbox_normal, $page_admin);
				$page_admin = template("OPTION_ACTIVATE_ALL_ENTRIES", '', $page_admin);
				$page_admin = template("OPTION_MARK_ALL_AS_SPAM", '', $page_admin);
				$page_admin = template("OPTION_DEACTIVATE_ALL_ENTRIES", "<option value='1'>{LANG_DEACTIVATE_ALL_ENTRIES}</option>", $page_admin);
				$page_admin = template("OPTION_DELETE_ALL_ENTRIES", '', $page_admin);
				$page_admin = template("LANG_DEACTIVATE_ALL_ENTRIES", $lang['deactivate_all_entries'], $page_admin);
				}
			elseif($_GET['action'] == 'delete')
				{
				$page_admin = template("TEMPLATE_DROPBOX_NORMAL", $content_dropbox_normal, $page_admin);
				$page_admin = template("OPTION_ACTIVATE_ALL_ENTRIES", '', $page_admin);
				$page_admin = template("OPTION_MARK_ALL_AS_SPAM", '', $page_admin);
				$page_admin = template("OPTION_DEACTIVATE_ALL_ENTRIES", '', $page_admin);
				$page_admin = template("OPTION_DELETE_ALL_ENTRIES", "<option value='1'>{LANG_DELETE_ALL_ENTRIES}</option>", $page_admin);
				$page_admin = template("LANG_DELETE_ALL_ENTRIES", $lang['delete_all_entries'], $page_admin);
				}
			elseif($_GET['action'] == 'edit')
				{
				$page_admin = template("TEMPLATE_DROPBOX_NORMAL", '', $page_admin);
				}
			}
		else
			{
			$page_admin = template("TEMPLATE_DROPBOX_NORMAL", '', $page_admin);
			}
		$page_admin = template("TEMPLATE_DROPBOX_SPAM", '', $page_admin);
		}

	$page_admin = template("LANG_DO_NOTHING", $lang['do_nothing'], $page_admin);
	$page_admin = template("LANG_DELETE_WHOLE_SPAM", $lang['delete_whole_spam'], $page_admin);
	$page_admin = template("LANG_MARK_ALL_NO_SPAM_DEACTIVATE", $lang['mark_all_no_spam_deactivate'], $page_admin);
	$page_admin = template("LANG_MARK_ALL_NO_SPAM_ACTIVATE", $lang['mark_all_no_spam_activate'], $page_admin);
	$page_admin = template("LANG_GO", $lang['go'], $page_admin);
	$page_admin = template("LANG_QUOTE", $lang['quote'], $page_admin);
	$page_admin = template("LANG_PAYPAL", $lang['paypal'], $page_admin);
	$page_admin = template("ACTION", $_GET['action'], $page_admin);
	$page_admin = template("PAGE_NR", $add_page_nr, $page_admin);
	$page_admin = template("SID", $sid, $page_admin);
	$page_admin = template("INCLUDE", $page_include, $page_admin);
	$page_admin = template("LANG_NEW_VERSION_AVAILABLE", $new_version_available, $page_admin);
	$page_admin = template("LATEST_VERSION", $latest_version, $page_admin);
	$page_admin = template("LANG_LOGIN", $lang['login'], $page_admin);
	$page_admin = template("TEMPLATE_COPYRIGHT", $content_copyright, $page_admin);
	$page_admin = template("TEMPLATE_FOOTER", $content_footer, $page_admin);
	$page_admin = template("COPYRIGHT_DATE", date("Y"), $page_admin);
	$page_admin = template("MGB_VERSION", $settings['version'], $page_admin);
	$page_admin = template("TEMPLATE_SCROLLING_FUNCTION", $content_scrolling_function, $page_admin);
	$page_admin = template("SF_FIRST", $sf_first, $page_admin);
	$page_admin = template("SF_BACKWARDS", $sf_backwards, $page_admin);
	$page_admin = template("SF_PAGENUMBER", $sf_pagenumber, $page_admin);
	$page_admin = template("SF_FORWARDS", $sf_forwards, $page_admin);
	$page_admin = template("SF_LAST", $sf_last, $page_admin);

	echo $page_admin;
?>
