<?php
	/*
	MGB 0.6.x - OpenSource PHP and MySql Guestbook
	Copyright (C) 2004 - 2011 Juergen Grueneisl - http://www.m-gb.org/

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
	*/

	// ============ //
	// 061.php - 1.0 //
	// ============ //
	//
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //

if (file_exists("../functions.inc.php"))
	{
	if (unlink("../functions.inc.php"))
		{
		echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- deleting old ''functions.inc.php'' from root directory...</span>\n
			\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: green;\">&nbsp;OK!<br /></span>\n";
		$success++;
		$count++;
		}
	else
		{
		echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- deleting old ''functions.inc.php'' from root directory...</span>\n
			\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: red;\">ERROR!<br /></span>\n";
		$count++;
		}
	}
if (file_exists("../load_templates.inc.php"))
	{
	if (unlink("../load_templates.inc.php"))
		{
		echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- deleting old ''load_templates.inc.php'' from root directory...</span>\n
			\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: green;\">&nbsp;OK!<br /></span>\n";
		$success++;
		$count++;
		}
	else
		{
		echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- deleting old ''load_templates.inc.php'' from root directory...</span>\n
			\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: red;\">ERROR!<br /></span>\n";
		$count++;
		}
	}
if (file_exists("../load_settings.inc.php"))
	{
	if (unlink("../load_settings.inc.php"))
		{
		echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- deleting old ''load_settings.inc.php'' from root directory...</span>\n
			\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: green;\">&nbsp;OK!<br /></span>\n";
		$success++;
		$count++;
		}
	else
		{
		echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- deleting old ''load_settings.inc.php'' from root directory...</span>\n
			\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: red;\">ERROR!<br /></span>\n";
		$count++;
		}
	}
if (file_exists("../captcha.php"))
	{
	if (unlink("../captcha.php"))
		{
		echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- deleting old ''captcha.php'' from root directory...</span>\n
			\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: green;\">&nbsp;OK!<br /></span>\n";
		$success++;
		$count++;
		}
	else
		{
		echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- deleting old ''captcha.php'' from root directory...</span>\n
			\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: red;\">ERROR!<br /></span>\n";
		$count++;
		}
	}
if (file_exists("../akoom.ttf"))
	{
	if (unlink("../akoom.ttf"))
		{
		echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- deleting old ''akoom.ttf'' from root directory...</span>\n
			\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: green;\">&nbsp;OK!<br /></span>\n";
		$success++;
		$count++;
		}
	else
		{
		echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- deleting old ''akoom.ttf'' from root directory...</span>\n
			\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: red;\">ERROR!<br /></span>\n";
		$count++;
		}
	}
if (file_exists("../config.inc.php"))
	{
	if (rename("../config.inc.php", "../config.inc.bak"))
		{
		echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- renaming old ''config.inc.php'' to ''config.inc.bak''...</span>\n
			\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: green;\">&nbsp;OK!<br /></span>\n";
		$success++;
		$count++;
		}
	else
		{
		echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- renaming old ''config.inc.php'' to ''config.inc.bak''...</span>\n
			\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: red;\">ERROR!<br /></span>\n";
		$count++;
		}
	}

$sql = array();

$sql[1] = "CREATE TABLE ".$db['prefix']."captcha_math (
	`math` VARCHAR( 20 ) NOT NULL ,
	  `sum` INT NOT NULL ,
	  PRIMARY KEY ( `math` )
	  ) TYPE = MYISAM;";
$sqldescription[1] = "- Creating table for new captcha...";

$sql[2] = "INSERT INTO ".$db['prefix']."captcha_math (
		`math` ,
		`sum`
	) VALUES (
		'1+2+3' ,
		'6'
		);";
$sqldescription[2] = "- Inserting default values...";

$sql[3] = "ALTER TABLE `".$db['prefix']."settings` ADD `captcha_method` TINYINT( 1 ) DEFAULT '0' NOT NULL AFTER `captcha` ;";
$sqldescription[3] = "- Inserting field for new captcha method...";

// SQL field for entry ordering -> came with 0.6.2
$sql[4] = "ALTER TABLE `".$db['prefix']."settings` ADD `entries_order` TINYINT( 1 ) NOT NULL DEFAULT '0' AFTER `entries_per_page`";
$sqldescription[4] = "- Adding field for entry ordering...";

$sql[5] = "ALTER TABLE `".$db['prefix']."settings` ADD `akismet_plugin` TINYINT( 1 ) DEFAULT '0' NOT NULL AFTER `captcha_method` ;";
$sqldescription[5] = "- Inserting field for akismet support...";

$sql[6] = "ALTER TABLE `".$db['prefix']."settings` ADD `akismet_api` VARCHAR( 50 ) NOT NULL AFTER `akismet_plugin` ;";
$sqldescription[6] = "- Inserting field for akismet support (API)...";

$sql[7] = "ALTER TABLE `".$db['prefix']."entries` ADD `isspam` TINYINT( 1 ) NOT NULL AFTER `checked` ;";
$sqldescription[7] = "- Inserting field for akismet spam-marking (entries)...";

$sql[8] = "ALTER TABLE `".$db['prefix']."settings` ADD `akismet_mark_as_spam` TINYINT( 1 ) DEFAULT '1' NOT NULL AFTER `akismet_api` ;";
$sqldescription[8] = "- Inserting field for akismet spam-marking (settings)...";

$sql[9] = "ALTER TABLE `".$db['prefix']."user` ADD `r_spam` TINYINT( 1 ) NOT NULL AFTER `r_edit` ;";
$sqldescription[9] = "- Inserting field for new user right 'manage spam'...";

$sql[10] = "ALTER TABLE `".$db['prefix']."settings` ADD `time_lock` INT( 1 ) NOT NULL AFTER `akismet_mark_as_spam` , ADD `time_lock_value` INT( 3 ) DEFAULT '30' NOT NULL AFTER `time_lock` , ADD `time_lock_maxtime` INT DEFAULT '300' NOT NULL AFTER `time_lock_value` ";
$sqldescription[10] = "- Inserting fields for time lock (settings)...";

$sql[11] = "CREATE TABLE ".$db['prefix']."smilies (
	  `ID` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
	  `path` VARCHAR( 255 ) NOT NULL ,
	  `replacement` VARCHAR( 255 ) NOT NULL ,
	  `height` TINYINT( 4 ) NOT NULL ,
	  `width` TINYINT( 4 ) NOT NULL
	  ) TYPE = MYISAM;";
$sqldescription[11] = "- Adding table for smilies...";

$sql[12] = "INSERT INTO ".$db['prefix']."smilies ( 
	  `ID` ,
	  `path` ,
	  `replacement` ,
	  `height` ,
	  `width`
	  ) VALUES 	( NULL , 'smiley_angry.gif', ':angry:', '15', '15' ),
				( NULL , 'smiley_biggrin.gif', ':biggrin:', '15', '15' ),
				( NULL , 'smiley_confused.gif', ':confused:', '15', '15' ),
				( NULL , 'smiley_cool.gif', ':cool:', '15', '15' ),
				( NULL , 'smiley_eek.gif', ':eek:', '15', '15' ),
				( NULL , 'smiley_lol.gif', ':lol:', '15', '15' ),
				( NULL , 'smiley_sad.gif', ':sad:', '15', '15' ),
				( NULL , 'smiley_smile.gif', ':smile:', '15', '15' ),
				( NULL , 'smiley_surprised.gif', ':surprised:', '15', '15' ),
				( NULL , 'smiley_tongue.gif', ':tongue:', '15', '15' ),
				( NULL , 'smiley_wink.gif', ':wink:', '15', '15' );";
$sqldescription[12] = "- Adding smilies...";

$sql[13] = "ALTER TABLE `".$db['prefix']."user` ADD `r_edit_smilies` TINYINT( 1 ) NOT NULL AFTER `r_spam`";
$sqldescription[13] = "- Updating table for users...";

// update version number every time
$sql[14] = "UPDATE `".$db['prefix']."settings` SET `version` = '".MGB_VERSION."'";
$sqldescription[14] = "- Updating version number...";

$to = 14;

if($settings['language_path'] == "lang_german_ansi")
	{
	$sql[25] = "UPDATE `".$db['prefix']."settings` SET `language_path` = 'lang_german_utf8'";
	$sqldescription[25] = "- Updating language path (delete \"language/lang_german_ansi/\" after this upgrade and VERY IMPORTANT: start <a href='convert_ansi.php'>convert_ansi.php</a>)!";
	$to = 25;
	}
?>
