<?php
	/*
	MGB 0.6.x - OpenSource PHP and MySql Guestbook
	Copyright (C) 2004 - 2011 Juergen Grueneisl - http://www.m-gb.org/

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
	*/

	// ================== //
	// newentry.php - 1.4 //
	// ================== //
	//
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //

	// show all errors
	error_reporting(E_ALL & ~E_NOTICE);

	header("Cache-Control: no-cache, must-revalidate"); // HTTP/1.1
	header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); // Datum in der Vergangenheit

	// check if MGB has been already installed
	if (file_exists("includes/config.inc.php"))
		{
		require ("includes/config.inc.php");
		if(!isset($mgb_installation_complete))
			{
			echo "It seems as if you haven't installed the MGB yet. You can do it <a href=\"install/install.php\">here</a>.<br><br>If MGB is already installed, try copy your 'config.inc.php' from root directory into 'includes/config.inc.php'.";
			die();
			}
		}
	else
		{
		echo "The config file could not be found. If you haven't installed the MGB yet, you can do it <a href=\"install/install.php\">here</a>.<br><br>If MGB is already installed, try copy your 'config.inc.php' from root directory into 'includes/config.inc.php'.";
		die();
		}

	$site_name = "newentry.php";

	// load config, settings, language files and necessary templates
	require ("includes/config.inc.php");
	require ("includes/functions.inc.php");
	require ("includes/load_settings.inc.php");
	require ("language/".$settings['language_path']."/lang_main.php");
	require ("language/".$settings['language_path']."/settings.php");
	require ("includes/load_templates.inc.php");

	if (isset($settings['time_lock']) AND $settings['time_lock'] == 1)
		{
		// start session for anti-spam-time-lock
		session_name("time_lock");
		ini_set('url_rewriter.tags', '');
		session_start();
		session_regenerate_id();

		// set start time
		if (isset($_SESSION['start_time']))
			{
			if (time() > ($_SESSION['start_time'] + $settings['time_lock_maxtime']))
				{
				$_SESSION['start_time'] = time();
				}
			}
		else
			{
			$_SESSION['start_time'] = time();
			}
		}

	if (isset($_POST['send']) AND $_POST['send'] == $lang['send'])
		{
		if (isset($settings['time_lock']) AND $settings['time_lock'] == 1)
			{
			// time check for formular load
			$actual_time = time();
			$difference = $actual_time - $_SESSION['start_time'];

			if ($difference < $settings['time_lock_value'])
				{
				$errorcode = 10;
				$rest = $settings['time_lock_value'] - $difference;
				}
			}

		// delete html, php code and white spaces
		
		if(!isset($_POST['user_notification'])) { $_POST['user_notification'] = 0; }
		if(!isset($_POST['user_show_email'])) { $_POST['user_show_email'] = 0; }

		$_POST['name'] = cleanstr($_POST['name']);
		$_POST['city'] = cleanstr($_POST['city']);
		$_POST['message'] = cleanstr($_POST['message']);
		$_POST['email'] = cleanstr($_POST['email']);
		$_POST['icq'] = cleanstr($_POST['icq']);
		$_POST['aim'] = cleanstr($_POST['aim']);
		$_POST['msn'] = cleanstr($_POST['msn']);
		$_POST['hp'] = cleanstr($_POST['hp']);
		$_POST['user_notification'] = cleanstr($_POST['user_notification']);
		$_POST['user_show_email'] = cleanstr($_POST['user_show_email']);
		$_POST['user_accept_akismet_service'] = cleanstr($_POST['user_accept_akismet_service']);

		// include akismet if it exists
		if (file_exists("plugins/akismet/akismet.class.php") AND (isset($settings['akismet_api'])) AND ($settings['akismet_api'] != "") AND (isset($_POST['user_accept_akismet_service']) AND $_POST['user_accept_akismet_service'] == 1) AND ($_POST['name'] != "") AND ($_POST['email'] != "") AND ($_POST['message'] != ""))
			{
			include ("plugins/akismet/akismet.class.php");

			$akismet_author = bbcode_delete($_POST['name']);
			$akismet_email = bbcode_delete($_POST['email']);
			$akismet_website = bbcode_delete($_POST['hp']);
			$akismet_body = bbcode_delete($_POST['message']);

			// check for spam
			// Load array with comment data.
			$comment = array(
				'author' => $akismet_author,
				'email' => $akismet_email,
				'website' => $akismet_website,
				'body' => $akismet_body,
				'permalink' => 'http://'.$settings['h_domain'].$settings['gb_path'],
				'user_ip' => $_SERVER['REMOTE_ADDR'], // Optional, if not in array defaults to $_SERVER['REMOTE_ADDR'].
				'user_agent' => $_SERVER['HTTP_USER_AGENT'], // Optional, if not in array defaults to $_SERVER['HTTP_USER_AGENT'].
				);

			// Instantiate an instance of the class.
			$akismet = new Akismet('http://'.$settings['h_domain'].$settings['gb_path'], $settings['akismet_api'], $comment);

			// Test for errors.
			if($akismet->errorsExist())
				{ // Returns true if any errors exist.
				if($akismet->isError('AKISMET_INVALID_KEY'))
					{
					echo "AKISMET API KEY INVALID";
					}
				elseif($akismet->isError('AKISMET_RESPONSE_FAILED'))
					{
					echo "AKISMET RESPONSE FAILED";
					}
				elseif($akismet->isError('AKISMET_SERVER_NOT_FOUND'))
					{
					echo "AKISMET_SERVER_NOT_FOUND";
					}
				}
			else
				{
				// No errors, check for spam.
				if ($akismet->isSpam())
					{
					// if is set in the admin panel, mark the entry as spam
					if (isset($settings['akismet_mark_as_spam']) AND ($settings['akismet_mark_as_spam'] == 1))
						{
						$mark_as_spam = 1;
						$noemail = 1;
						}
					else
						{
						$mark_as_spam = 0;
						$noemail = 0;
						}
					}
				}
			}

		// THE CAKE IS A LIE!

		// search for content to identify spam
		$string = bbcode_delete($_POST['message']);
		$searchstring = "Hi there, very nice homepage :-)";
		$pos = strpos($string, $searchstring);

		if ($pos !== false)
			{
			// if is set in the admin panel, mark the entry as spam
			if (isset($settings['akismet_mark_as_spam']) AND ($settings['akismet_mark_as_spam'] == 1))
				{
				$mark_as_spam = 1;
				$noemail = 1;
				}
			else
				{
				$mark_as_spam = 0;
				$noemail = 0;
				}
			}
	
		// following IP adresses will be blocked. Add desired IPs to the array.
		// NOTE: the last entry has to be without a comma at the end like here:
		//
		// $string = array(
		// 'xxx.xxx.xxx.xxx',
		// 'xxx.xxx.xxx.xxx',
		// 'xxx.xxx.xxx.xxx'	 <-- see? no comma :)
		// );

	  // Array for blocked IPs
	  $blocked_ips = array(
			'xxx.xxx.xxx.xxx',
			'xxx.xxx.xxx.xxx',
			'xxx.xxx.xxx.xxx'
			);

		 foreach ($blocked_ips as $ip)
			{
			if ($_SERVER["REMOTE_ADDR"] == $ip)
				{
				// if is set in the admin panel, mark the entry as spam
				if (isset($settings['akismet_mark_as_spam']) AND ($settings['akismet_mark_as_spam'] == 1))
					{
					$mark_as_spam = 1;
					$noemail = 1;
					}
				else
					{
					$mark_as_spam = 0;
					$noemail = 0;
					}
				}
			}

		// form was sent and is ok!
		// check if captcha is correct
		if ($settings['captcha'] == 1)
			{
			if ($settings['captcha_method'] == 0)
				{
				$sql = "SELECT `code` FROM ".$db['prefix']."captcha LIMIT 1";
				$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(newentry.php) Error, line 237: ".mysql_error());
				mysql_select_db($db['dbname'], $link) or die ("(newentry.php) Error, line 238: ".mysql_error());
				$result = mysql_query($sql, $link) or die ("(newentry.php) Error, line 239: ".mysql_error());

				$saved_code = @mysql_fetch_array($result);
				$captcha_code = $saved_code['code'];

				if ($captcha_code != $_POST['captcha']) { $errorcode = 7; }
				}
			elseif ($settings['captcha_method'] == 1)
				{
				$sql = "SELECT `sum` FROM ".$db['prefix']."captcha_math LIMIT 1";
				$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(newentry.php) Error, line 249: ".mysql_error());
				mysql_select_db($db['dbname'], $link) or die ("(newentry.php) Error, line 250: ".mysql_error());
				$result = mysql_query($sql, $link) or die ("(newentry.php) Error, line 251: ".mysql_error());

				$saved_code = @mysql_fetch_array($result);
				$captcha_code = $saved_code['sum'];

				if ($captcha_code != $_POST['captcha']) { $errorcode = 7; }
				}
			}

		// if you want the email field to be not necessary, just outcomment next line with "//"
		if (!check_mail($_POST['email'])) { $errorcode = 4; }

		if ($_POST['icq'])
			{
			if (!check_number($_POST['icq'])) { $errorcode = 5; }
			}

		if (!preg_match("/http:\/\//i", $_POST['hp']))
			{
			$_POST['hp'] = "http://".$_POST['hp'];
			}

		// check necessary fields
		if (!$_POST['message']) { $errorcode = 1; }
		// if you want the email field to be not necessary, just outcomment next line with "//"
		if (!$_POST['email']) { $errorcode = 2; }
		if (!$_POST['name']) { $errorcode = 3; }
		if ((isset($settings['akismet_plugin'])) AND ($settings['akismet_plugin'] == 1) AND $_POST['user_accept_akismet_service'] != 1) { $errorcode = 11; }
		
		// uncomment this to block ip-adresses
		//if ($_SERVER["REMOTE_ADDR"] == "XXx.xxx.xxx.xxx") { die(); }
		
		if (!isset($errorcode))
			{
			// delete bbcode except from message
			$_POST['name'] = bbcode_delete($_POST['name']);
			$_POST['city'] = bbcode_delete($_POST['city']);
			$_POST['aim'] = bbcode_delete($_POST['aim']);
			$_POST['msn'] = bbcode_delete($_POST['msn']);
			$_POST['hp'] = bbcode_delete($_POST['hp']);

			$_POST['message'] = nl2br($_POST['message']);
			$t1 = chr(10);
			$t2 = chr(13);
			$_POST['message'] = str_replace($t1,'', $_POST['message']);
			$_POST['message'] = str_replace($t2,'', $_POST['message']);
			if ($_POST['hp'] == "http://"){ $_POST['hp'] = ""; }

			// check if "moderated gb" and "user email notification" is on
			if (($settings['moderated'] == 1) OR ($mark_as_spam == 1)) { $checked = 0; } else { $checked = 1; }
			if ($settings['user_notification'] == 0 OR empty($_POST['email'])) { $_POST['user_notification'] = 0; }
			if ($settings['user_show_email'] == 0 OR empty($_POST['email'])) { $_POST['user_show_email'] = 0; }

			// get IP of user
			$ip = $_SERVER["REMOTE_ADDR"];

			// timestamp
			$time = time();

			// Write data into database
			$sql = "INSERT INTO ".$db['prefix']."entries (
								name,
								city,
								email,
								icq,
								aim,
								msn,
								hp,
								message,
								ip,
								timestamp,
								user_notification,
								user_show_email,
								checked,
								isspam
							   ) values (
								'".$_POST['name']."',
								'".$_POST['city']."',
								'".$_POST['email']."',
								'".$_POST['icq']."',
								'".$_POST['aim']."',
								'".$_POST['msn']."',
								'".$_POST['hp']."',
								'".$_POST['message']."',
								'".$ip."',
								'".$time."',
								'".$_POST['user_notification']."',
								'".$_POST['user_show_email']."',
								'".$checked."',
								'".$mark_as_spam."'
							   )";
			
			$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(newentry.php) Error, line 343: ".mysql_error());
			@mysql_select_db($db['dbname'], $link) or die ("(newentry.php) Error, line 344: ".mysql_error());
			@mysql_query($sql, $link) or die ("(newentry.php) Error, line 345: ".mysql_error());

			// save IP of user for ipblocker
			$sql = "UPDATE ".$db['prefix']."lastip SET lastIP = '".$ip."'";
			$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(newentry.php) Error, line 349: ".mysql_error());
			@mysql_select_db($db['dbname'], $link) or die ("(newentry.php) Error, line 350: ".mysql_error());
			@mysql_query($sql, $link) or die ("(newentry.php) Error, line 351: ".mysql_error());
			
			// turn xhtml breaks into new lines
			$_POST['message'] = xhtmlbr2nl($_POST['message']);
			
			// send an email to admin
			if(($settings['sendmail_admin'] == 1) AND ($noemail == 0))
				{
				$date = date("d"."/"."m"."/"."Y");
				$time = date("H".":"."i");
				
				$url_to_gb = "http://".$settings['h_domain'].$settings['gb_path']."index.php";
				
				$lang['sendmail_admin_title'] = format_mail(repl_uml($lang['sendmail_admin_title'], $charset), $_POST['name'], $date, $time, xhtmlbr2nl($_POST['message']), $settings['h_domain'], $url_to_gb, "", "", "", "", "", "");
				$settings['sendmail_admin_text'] = format_mail(repl_uml($settings['sendmail_admin_text'], $charset), $_POST['name'], $date, $time, xhtmlbr2nl($_POST['message']), $settings['h_domain'], $url_to_gb, "", "", "", "", "", "");
				
				$mail_header = "content-type: text/plain; charset=".$charset."\n";
				$mail_header .= "from: ".$settings['admin_gbemail']; 
				
				if ( mail($settings['admin_email'], $lang['sendmail_admin_title'], $settings['sendmail_admin_text'], $mail_header) )
					{
					$sendemail_successfull = 1;
					}
				else
					{
					$sendemail_successfull = 0;
					}
				}
			
			// send an email to user
			if($settings['sendmail_user'] == 1 AND isset($_POST['email']) AND ($noemail == 0))
				{
				$date = date("d"."/"."m"."/"."Y");
				$time = date("H".":"."i");
				
				$url_to_gb = "http://".$settings['h_domain'].$settings['gb_path']."index.php";
				
				$lang['sendmail_user_title'] = format_mail(repl_uml($lang['sendmail_user_title'], $charset), $_POST['name'], $date, $time, xhtmlbr2nl($_POST['message']), $settings['h_domain'], $url_to_gb, "", "", "", "", "", "");
				$settings['sendmail_user_text'] = format_mail(repl_uml($settings['sendmail_user_text'], $charset), $_POST['name'], $date, $time, xhtmlbr2nl($_POST['message']), $settings['h_domain'], $url_to_gb, "", "", "", "", "", "");
				
				$mail_header = "content-type: text/plain; charset=".$charset."\n";
				$mail_header .= "from: ".$settings['admin_gbemail']; 
				
				if (mail($_POST['email'], $lang['sendmail_user_title'], $settings['sendmail_user_text'], $mail_header) )
					{
					$sendemail_successfull = 1;
					}
				else
					{
					$sendemail_successfull = 0;
					}
				}

			$entry_successfull = 1;

			if (isset($settings['time_lock']) AND $settings['time_lock'] == 1)
				{
				session_destroy();
				}

			// refresh site
			$refresh = "<meta http-equiv=\"refresh\" content=\"5; URL=index.php\">";
			}
		else
			{
			if ($errorcode == 1) { $errormessage = $lang['errormessage1']; }
			if ($errorcode == 2) { $errormessage = $lang['errormessage2']; }
			if ($errorcode == 3) { $errormessage = $lang['errormessage3']; }
			if ($errorcode == 4) { $errormessage = $_POST['email']."&nbsp;".$lang['errormessage4']; }
			if ($errorcode == 5) { $errormessage = $_POST['icq']."&nbsp;".$lang['errormessage5']; }
			if ($errorcode == 7) { $errormessage = $lang['errormessage7']; }
			if ($errorcode == 10) { $errormessage = $lang['errormessage10']; }
			if ($errorcode == 11) { $errormessage = $lang['errormessage11']; }

			// do not refresh site
			$refresh = "";

			// generate captchacode if activated
			if(($settings['captcha'] == 1) AND ($captcha_generated != 1))
				{
				generate_captcha($settings['captcha_method']);
				$captcha_img = "<img src=\"includes/captcha.inc.php\" class=\"captcha\" title=\"".$lang['security_code']."\" alt=\"".$lang['security_code']."\">";
				$captcha_img = preg_replace("/\{CAPTCHA_IMG\}/", $captcha, $content_captcha);
				$captcha_generated = 1;
				}
			elseif ($settings['captcha'] == 0)
				{
				$captcha_img = "";
				}
			}
		// don't show preview here
		$content_newentry_preview = "";
		}
	else
		{
		// maybe preview button has been pushed instead?

		if (isset($_POST['preview']) AND $_POST['preview'] == $lang['preview'] AND $_POST['message'] != "")
			{
			$_POST['message'] = cleanstr($_POST['message']);
			$preview_message = nl2br($_POST['message']);
			$t1 = chr(10);
			$t2 = chr(13);
			$preview_message = str_replace($t1,'', $preview_message);
			$preview_message = str_replace($t2,'', $preview_message);

			if (!$settings['wordwrap'] == 0)
				{
				$preview_message = textWrap($preview_message, $settings['wordwrap']);
				}

			// set smilies
			if ($settings['smileys'] == 1)
				{
				$preview_message = set_smilies($preview_message);
				}
			else
				{
				$preview_message = delete_smilies($preview_message);
				}

			// set bbcode
			if($settings['bbcode'] == 1)
				{
				$preview_message = bbcode_format($preview_message);
				}
			else
				{
				$preview_message = bbcode_delete($preview_message);
				}

			$content_newentry_preview = preg_replace("/\{TEMPLATE_ENTRY_MESSAGE\}/", $preview_message, $content_newentry_preview);
			}
		else
			{
			$content_newentry_preview = "";
			}

		// do not refresh site
		$refresh = "";

		// check for ip
		if ($settings['ipblocker'] == 1)
			{
			$sql = "SELECT lastIP FROM ".$db['prefix']."lastip LIMIT 1";
			$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(newentry.php) Error, line 496: ".mysql_error());
			@mysql_select_db($db['dbname'], $link) or die ("(newentry.php) Error, line 497: ".mysql_error());
			$result = @mysql_query($sql, $link) or die ("(newentry.php) Error, line 498: ".mysql_error());

			$lastIP = @mysql_fetch_array($result);
			}

		if(!isset($lastIP)) { $lastIP = NULL; }

		if ($lastIP == $_SERVER["REMOTE_ADDR"]) { $errorcode = 6;  $errormessage = $lang['errormessage6']; }

		// generate captchacode if activated
		if(($settings['captcha'] == 1) AND ($captcha_generated != 1))
			{
			generate_captcha($settings['captcha_method']);
			$captcha_img = "<img src=\"includes/captcha.inc.php\" class=\"captcha\" title=\"".$lang['security_code']."\" alt=\"".$lang['security_code']."\">";
			$captcha_img = preg_replace("/\{CAPTCHA_IMG\}/", $captcha, $content_captcha);
			$captcha_generated = 1;
			}
		elseif ($settings['captcha'] == 0)
			{
			$captcha_img = "";
			}
		}

	// Generate Page

	// fill header template with content
	$page_header = $content_header;

	// check if "install" directory has been deleted
	if (file_exists("install"))
		{
		$page_header = preg_replace("/\{INSTALL_DIRECTORY_EXISTS\}/", "<div style=\"background-color: white; padding: 3px; border: 2px solid black; width: 500px;\"><span style=\"color: red; font-size: 12px; font-weight: bold;\">".$lang['install_directory_exists']."</span></div>", $page_header);
		}
	else
		{
		$page_header = preg_replace("/\{INSTALL_DIRECTORY_EXISTS\}/", "", $page_header);
		}

	$page_header = preg_replace("/\{H_LANGUAGE_SHORT\}/", $language_short, $page_header);
	$page_header = preg_replace("/\{H_DOMAIN\}/", $settings['h_domain'], $page_header);
	$page_header = preg_replace("/\{H_AUTHOR\}/", $settings['h_author'], $page_header);
	$page_header = preg_replace("/\{H_KEYWORDS\}/", $settings['h_keywords'], $page_header);
	$page_header = preg_replace("/\{H_DESCRIPTION\}/", $settings['h_description'], $page_header);
	$page_header = preg_replace("/\{H_CHARSET\}/", $charset, $page_header);
	$page_header = preg_replace("/\{REFRESH\}/", $refresh, $page_header);

	if (!isset($errorcode))
		{
		$content_errormessage = NULL;
		}

	// Add smilies if activated
	if ($settings['smileys'] == 1)
		{
		$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(newentry.php) Error, line 552: ".mysql_error());
		@mysql_select_db($db['dbname'], $link) or die ("(newentry.php) Error, line 553: ".mysql_error());
		$sql="SELECT * FROM ".$db['prefix']."smilies ORDER BY ID DESC";
		$result = @mysql_query($sql, $link) or die ("(newentry.php) Error, line 555: ".mysql_error());

		for($i = 0; $i < mysql_num_rows($result); $i++)
			{
			$smilies[$i] = mysql_fetch_array($result);
			}

		if(!isset($smilies)) { $smilies = NULL; }

		for($i = 0; $i < count($smilies); $i++)
			{
			$smilies_loop = "<a href=\"javascript&#058;AddSmiley('".$smilies[$i]['replacement']."')\"><img src='images/smilies/".$smilies[$i]['path']."' width='".$smilies[$i]['width']."' height='".$smilies[$i]['height']."' alt='".$smilies[$i]['replacement']."' title='".$smilies[$i]['replacement']."'></a>&nbsp;";
			$smilies_replace .= $smilies_loop;
			}

		$content_newentry_smileys = preg_replace("/\{SMILIES}/", $smilies_replace, $content_newentry_smileys);
		}
	else
		{
		$content_newentry_smileys = NULL;
		}

	if ($settings['bbcode'] == 1)
		{
		$content_newentry_bbcodes = preg_replace("/\{LANG_BBCODES\}/", $lang['bbcodes'], $content_newentry_bbcodes);
		$content_newentry_bbcodes = preg_replace("/\{LANG_BBCODE_HELP_BOLD\}/", $lang['bbcode_help_bold'], $content_newentry_bbcodes);
		$content_newentry_bbcodes = preg_replace("/\{LANG_BBCODE_HELP_ITALIC\}/", $lang['bbcode_help_italic'], $content_newentry_bbcodes);
		$content_newentry_bbcodes = preg_replace("/\{LANG_BBCODE_HELP_URL\}/", $lang['bbcode_help_url'], $content_newentry_bbcodes);
		$content_newentry_bbcodes = preg_replace("/\{LANG_BBCODE_TEXTSIZE\}/", $lang['bbcode_textsize'], $content_newentry_bbcodes);
		$content_newentry_bbcodes = preg_replace("/\{LANG_BBCODE_EXTRASMALL\}/", $lang['bbcode_extrasmall'], $content_newentry_bbcodes);
		$content_newentry_bbcodes = preg_replace("/\{LANG_BBCODE_SMALL\}/", $lang['bbcode_small'], $content_newentry_bbcodes);
		$content_newentry_bbcodes = preg_replace("/\{LANG_BBCODE_DEFAULT\}/", $lang['bbcode_default'], $content_newentry_bbcodes);
		$content_newentry_bbcodes = preg_replace("/\{LANG_BBCODE_BIG\}/", $lang['bbcode_big'], $content_newentry_bbcodes);
		$content_newentry_bbcodes = preg_replace("/\{LANG_BBCODE_EXTRABIG\}/", $lang['bbcode_extrabig'], $content_newentry_bbcodes);		
		$content_newentry_bbcodes = preg_replace("/\{LANG_BBCODE_TEXTCOLOR\}/", $lang['bbcode_textcolor'], $content_newentry_bbcodes);
		$bbcodes = $content_newentry_bbcodes;
		}
	else
		{
		$bbcodes = NULL;
		}

	// insert template if user_notification == 1
	if ($settings['user_notification'] == 1)
		{
		$content_newentry_user_notification = preg_replace("/\{LANG_USER_NOTIFICATION\}/", $lang['user_notification'], $content_newentry_user_notification);
		$user_notification = $content_newentry_user_notification;
		}
	else
		{
		$user_notification = NULL;
		}

	// insert template if user_show_email == 1
	if ($settings['user_show_email'] == 1)
		{
		$content_newentry_user_show_email = preg_replace("/\{LANG_USER_SHOW_EMAIL\}/", $lang['user_show_email'], $content_newentry_user_show_email);
		$user_show_email = $content_newentry_user_show_email;
		}
	else
		{
		$user_show_email = NULL;
		}

	// insert template if akismet is acitvated
	if (file_exists("plugins/akismet/akismet.class.php") AND (isset($settings['akismet_plugin'])) AND ($settings['akismet_plugin'] == 1))
		{
		$content_newentry_user_accept_akismet_service = preg_replace("/\{LANG_USER_ACCEPT_AKISMET_SERVICE\}/", $lang['user_accept_akismet_service'], $content_newentry_user_accept_akismet_service);
		$user_accept_akismet_service = $content_newentry_user_accept_akismet_service;
		}
	else
		{
		$user_accept_akismet_service = NULL;
		}

	// fill template with captcha
	if(($settings['captcha'] == 1) AND ($captcha_generated != 1))
		{
		generate_captcha($settings['captcha_method']);
		$captcha_img = "<img src=\"includes/captcha.inc.php\" class=\"captcha\" title=\"".$lang['security_code']."\" alt=\"".$lang['security_code']."\">";
		$captcha_img = preg_replace("/\{CAPTCHA_IMG\}/", $captcha, $content_captcha);
		$captcha_generated = 1;
		}
	elseif ($settings['captcha'] == 0)
		{
		$captcha_img = "";
		}

	// footer
	$page_footer = $content_footer;

	 // entry was not successfull or it is the first time the site was loaded
	if (!isset($entry_successfull))
		{
		// get data from template
		$page_newentry_body = $content_newentry_body;

		// fill template with other templates if set
		$page_newentry_body = preg_replace("/\{HEADER\}/", $page_header, $page_newentry_body);
		$page_newentry_body = preg_replace("/\{TEMPLATE_ERRORMESSAGE\}/", $content_errormessage, $page_newentry_body);
		$page_newentry_body = preg_replace("/\{TEMPLATE_PREVIEW\}/", $content_newentry_preview, $page_newentry_body);
		$page_newentry_body = preg_replace("/\{TEMPLATE_SMILEYS\}/", $content_newentry_smileys, $page_newentry_body);
		$page_newentry_body = preg_replace("/\{TEMPLATE_BBCODES\}/", $bbcodes, $page_newentry_body);
		$page_newentry_body = preg_replace("/\{TEMPLATE_USER_NOTIFICATION\}/", $user_notification, $page_newentry_body);
		$page_newentry_body = preg_replace("/\{TEMPLATE_USER_SHOW_EMAIL\}/", $user_show_email, $page_newentry_body);
		$page_newentry_body = preg_replace("/\{TEMPLATE_USER_ACCEPT_AKISMET_SERVICE\}/", $user_accept_akismet_service, $page_newentry_body);
		$page_newentry_body = preg_replace("/\{TEMPLATE_CAPTCHA\}/", $captcha_img, $page_newentry_body);
		$page_newentry_body = preg_replace("/\{TEMPLATE_COPYRIGHT\}/", $content_copyright, $page_newentry_body);
		$page_newentry_body = preg_replace("/\{TEMPLATE_FOOTER\}/", $page_footer, $page_newentry_body);
		$page_newentry_body = preg_replace("/\{MGB_VERSION\}/", $settings['version'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{COPYRIGHT_DATE\}/", date("Y"), $page_newentry_body);
		$page_newentry_body = preg_replace("/\{ICONSET_PATH\}/", $settings['iconset_path'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{TEMPLATE_PATH\}/", "templates/".$settings['template_path'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{TEMPLATE_STYLE_PATH\}/", $settings['template_style_path'], $page_newentry_body);

		// fill template with language strings
		if(!isset($errormessage)) { $errormessage = NULL; }
		$page_newentry_body = preg_replace("/\{ERRORMESSAGE\}/", $errormessage, $page_newentry_body);
		$page_newentry_body = preg_replace("/\{TIME_LOCK_REST\}/", $rest, $page_newentry_body);
		$page_newentry_body = preg_replace("/\{TITLE\}/", $settings['title'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{LANG_NEW_ENTRY_NAME\}/", $lang['name'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{LANG_NEW_ENTRY_CITY\}/", $lang['city'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{LANG_NEW_ENTRY_EMAIL\}/", $lang['email'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{LANG_NEW_ENTRY_ICQ\}/", $lang['icq'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{LANG_NEW_ENTRY_AIM\}/", $lang['aim'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{LANG_NEW_ENTRY_MSN\}/", $lang['msn'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{LANG_NEW_ENTRY_HP\}/", $lang['homepage'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{LANG_NEW_ENTRY_MESSAGE\}/", $lang['message'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{LANG_NECESSARY_FIELDS\}/", $lang['necessary_fields'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{LANG_SMILEYS\}/", $lang['smileys'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{LANG_CAPTCHA_WHAT_IS_THAT\}/", $lang['captcha_what_is_that'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{LANG_CAPTCHA_WIKIPEDIA\}/", $lang['captcha_wikipedia'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{LANG_CAPTCHA_TOOLTIP\}/", $lang['captcha_tooltip'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{LANG_SECURITY_CODE\}/", $lang['security_code'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{LANG_PREVIEW\}/", $lang['preview'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{LANG_SEND\}/", $lang['send'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{LANG_BACK\}/", $lang['back'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{LANG_BACK_TO_MAINPAGE\}/", $lang['back_to_mainpage'], $page_newentry_body);

		// fill template with sent strings
		if(!isset($_POST['sent']))
			{
			$_POST['name'] = "";
			$_POST['city'] = "";
			$_POST['email'] = "";
			$_POST['icq'] = "";
			$_POST['aim'] = "";
			$_POST['msn'] = "";
			$_POST['hp'] = "http://";
			$_POST['message'] = "";
			}

		$page_newentry_body = preg_replace("/\{POST_NAME\}/", $_POST['name'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{POST_CITY\}/", $_POST['city'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{POST_EMAIL\}/", $_POST['email'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{POST_ICQ\}/", $_POST['icq'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{POST_AIM\}/", $_POST['aim'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{POST_MSN\}/", $_POST['msn'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{POST_HP\}/", $_POST['hp'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{POST_MESSAGE\}/", $_POST['message'], $page_newentry_body);

		// fill template with general data
		$page_newentry_body = preg_replace("/\{FORM_ACTION\}/", "newentry.php", $page_newentry_body);
		}
	else
		{
		// entry was successfull, load success template
		$page_newentry_body = $content_newentry_body_entry_success;

		// fill template with other templates
		$page_newentry_body = preg_replace("/\{HEADER\}/", $page_header, $page_newentry_body);
		$page_newentry_body = preg_replace("/\{TITLE\}/", $settings['title'], $page_newentry_body);
		if ($settings['moderated'] == 1) { $page_newentry_body = preg_replace("/\{LANG_ENTRY_SUCCESS\}/", $lang['entry_success_mod'], $page_newentry_body); } else { $page_newentry_body = preg_replace("/\{LANG_ENTRY_SUCCESS\}/", $lang['entry_success'], $page_newentry_body); }
		$page_newentry_body = preg_replace("/\{LANG_FORWARDING\}/", $lang['forwarding'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{LANG_BACK\}/", $lang['back'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{LANG_BACK_TO_MAINPAGE\}/", $lang['back_to_mainpage'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{TEMPLATE_COPYRIGHT\}/", $content_copyright, $page_newentry_body);
		$page_newentry_body = preg_replace("/\{TEMPLATE_FOOTER\}/", $page_footer, $page_newentry_body);
		$page_newentry_body = preg_replace("/\{MGB_VERSION\}/", $settings['version'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{COPYRIGHT_DATE\}/", date("Y"), $page_newentry_body);
		$page_newentry_body = preg_replace("/\{ICONSET_PATH\}/", $settings['iconset_path'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{TEMPLATE_PATH\}/", "templates/".$settings['template_path'], $page_newentry_body);
		$page_newentry_body = preg_replace("/\{TEMPLATE_STYLE_PATH\}/", $settings['template_style_path'], $page_newentry_body);
		}

	echo $page_newentry_body;
?>
