<?php
	
	/*
	MGB 0.6.x - OpenSource PHP and MySql Guestbook
	Copyright (C) 2004 - 2007 Juergen Grueneisl - http://www.m-gb.org/

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
	*/

        // ======================== //
	// functions.inc.php - 1.0  //
	// ======================== //
        //
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //

	// badwords
	if (!function_exists("badwords"))
		{
		function badwords($text)
			{
			global $badwords;			
			foreach($badwords as $b)
				{
				if($b != "")
					{
					$r = $b[0].str_repeat("*", strlen($b)-2).$b[strlen($b)-1];
					if(function_exists("str_ireplace"))
						{
						$text = str_ireplace($b, $r, $text);
						}
					else
						{
						$text = str_replace($b, $r, $text);
						}
					}
				}
                         	return $text;
                		}
         	}


	// checks if email is valid
	if (!function_exists("check_mail"))
		{		
		function check_mail($email)
   			{
			if (eregi("^[a-z0-9]+([-_\.]?[a-z0-9])+@[a-z0-9]+([-_\.]?[a-z0-9])+\.[a-z]{2,4}", $email))
				{
				return TRUE;
				}
			else
				{
				return FALSE;
				}
                		}
        		}


        // checks if icq number is valid
	if (!function_exists("check_number"))
		{         	
         	function check_number($number)
                 	{
                 	if (preg_match("=^[0-9]+$=i", $number))
                         	{
                        	return TRUE;
                         	}
                	else
                         	{
                         	return FALSE;
                         	}
                 	}
         	}
         	
         
        // sets smilies
	if (!function_exists("set_smilies"))
		{
		function set_smilies($text, $iconset_path)
			{
			$smilie_search = array(
						'/\:smile:/is',
						'/\:-\)/is',
                                         	'/\:\)/is',
						'/\:biggrin:/is',
						'/\^^/is',
						'/\:D/is',
						'/\:-D/is',
                                         	'/\:lol:/is',
						'/\:wink:/is',
						'/\;-\)/is',
						'/\;\)/is',
						'/\:surprised:/is',
						'/\:tongue:/is',
						'/\:p/is',
						'/\:-p/is',
						'/\:P/is',
						'/\:-P/is',
						'/\:cool:/is',
						'/\:eek:/is',
						'/\:confused:/is',
						'/\:sad:/is',
						'/\:\(/is',
						'/\:-\(/is',
						'/\:angry:/is'
						);
			$smilie_replace = array(
						'<img src="images/'.$iconset_path.'/smileys/smiley_smile.gif" alt="smiley" title="smiley" class="smiley">',
						'<img src="images/'.$iconset_path.'/smileys/smiley_smile.gif" alt="smiley" title="smiley" class="smiley">',
						'<img src="images/'.$iconset_path.'/smileys/smiley_smile.gif" alt="smiley" title="smiley" class="smiley">',
                                         	'<img src="images/'.$iconset_path.'/smileys/smiley_biggrin.gif" alt="smiley" title="smiley" class="smiley">',
						'<img src="images/'.$iconset_path.'/smileys/smiley_biggrin.gif" alt="smiley" title="smiley" class="smiley">',
						'<img src="images/'.$iconset_path.'/smileys/smiley_biggrin.gif" alt="smiley" title="smiley" class="smiley">',
						'<img src="images/'.$iconset_path.'/smileys/smiley_biggrin.gif" alt="smiley" title="smiley" class="smiley">',
						'<img src="images/'.$iconset_path.'/smileys/smiley_lol.gif" alt="smiley" title="smiley" class="smiley">',
						'<img src="images/'.$iconset_path.'/smileys/smiley_wink.gif" alt="smiley" title="smiley" class="smiley">',
						'<img src="images/'.$iconset_path.'/smileys/smiley_wink.gif" alt="smiley" title="smiley" class="smiley">',
						'<img src="images/'.$iconset_path.'/smileys/smiley_wink.gif" alt="smiley" title="smiley" class="smiley">',
						'<img src="images/'.$iconset_path.'/smileys/smiley_surprised.gif" alt="smiley" title="smiley" class="smiley">',
						'<img src="images/'.$iconset_path.'/smileys/smiley_tongue.gif" alt="smiley" title="smiley" class="smiley">',
						'<img src="images/'.$iconset_path.'/smileys/smiley_tongue.gif" alt="smiley" title="smiley" class="smiley">',
						'<img src="images/'.$iconset_path.'/smileys/smiley_tongue.gif" alt="smiley" title="smiley" class="smiley">',
						'<img src="images/'.$iconset_path.'/smileys/smiley_tongue.gif" alt="smiley" title="smiley" class="smiley">',
						'<img src="images/'.$iconset_path.'/smileys/smiley_tongue.gif" alt="smiley" title="smiley" class="smiley">',
						'<img src="images/'.$iconset_path.'/smileys/smiley_cool.gif" alt="smiley" title="smiley" class="smiley">',
						'<img src="images/'.$iconset_path.'/smileys/smiley_eek.gif" alt="smiley" title="smiley" class="smiley">',
						'<img src="images/'.$iconset_path.'/smileys/smiley_confused.gif" alt="smiley" title="smiley" class="smiley">',
						'<img src="images/'.$iconset_path.'/smileys/smiley_sad.gif" alt="smiley" title="smiley" class="smiley">',
						'<img src="images/'.$iconset_path.'/smileys/smiley_sad.gif" alt="smiley" title="smiley" class="smiley">',
						'<img src="images/'.$iconset_path.'/smileys/smiley_sad.gif" alt="smiley" title="smiley" class="smiley">',
						'<img src="images/'.$iconset_path.'/smileys/smiley_angry.gif" alt="smiley" title="smiley" class="smiley">'
						);
			$text = preg_replace($smilie_search, $smilie_replace, $text);

			return $text;
			}
		}


	// delete smileys and replace them with text smileys
	if (!function_exists("delete_smilies"))
		{
		function delete_smilies($text)
			{
			$smilie_search = array(
						'/\:smile:/is',
						'/\:biggrin:/is',
                                         	'/\:lol:/is',
						'/\:wink:/is',
						'/\:surprised:/is',
						'/\:tongue:/is',
						'/\:cool:/is',
						'/\:eek:/is',
						'/\:confused:/is',
						'/\:sad:/is',
						'/\:angry:/is'
						);
			$smilie_replace = array(
						':)',
						':D',
						'lol',
						';)',
						':O',
						':P',
						'B)',
						':&amp;',
						'o_O',
						':(',
						'-.-'
						);
			$text = preg_replace($smilie_search, $smilie_replace, $text);

			return $text;
			}
		}
		
	// this function adds "http://" to a bbcode url
	// if it isn't there
	if (!function_exists("http_1"))
		{
		function http_1($treffer)
			{
			$url = $treffer[1];			
			
			if (!preg_match("/http:\/\//i", $url))
				{
				$url = "http://".$url;
				}
				
			$link = "[url]".$url."[/url]";
			
			return $link;
			}
		}
		
	// this function adds "http://" to a bbcode url
	// if it isn't there
	if (!function_exists("http_2"))
		{
		function http_2($treffer)
			{
			$url = $treffer[1];
			$text = $treffer[2];
			
			if (!preg_match("/http:\/\//i", $url))
				{
				$url = "http://".$url;
				}
				
			$link = "[url=".$url."]".$text."[/url]";
			
			return $link;
			}
		}


	// bbcode formatting
	if (!function_exists("bbcode_format"))
		{
		function bbcode_format($bbcode)
			{
			//$bbcode = htmlentities($bbcode);									
			$bbcode = preg_replace_callback('/\[url\](.*?)\[\/url\]/is', 'http_1', $bbcode);
			$bbcode = preg_replace_callback('/\[url\=(.*?)\](.*?)\[\/url\]/is', 'http_2', $bbcode);
			
			$bbcode_search = array(
                 				'/\[b\](.*?)\[\/b\]/is',
                                		'/\[i\](.*?)\[\/i\]/is',
                                         	'/\[url\](.*?)\[\/url\]/is',
                                         	'/\[url\=(.*?)\](.*?)\[\/url\]/is',
                                         	'/\[size\=(.*?)\]\[color\=(.*?)\](.*?)\[\/color\]\[\/size\]/is',
                                         	'/\[color\=(.*?)\]\[size\=(.*?)\](.*?)\[\/size\]\[\/color\]/is',
                                         	'/\[size\=(.*?)\](.*?)\[\/size\]/is',
                                         	'/\[color\=(.*?)\](.*?)\[\/color\]/is'
                                	 	);

        		$bbcode_replace = array(
                               			'<b>$1</b>',
                               			'<i>$1</i>',
						'<a href="$1" target="_blank" title="$1">$1</a>',
                                       		'<a href="$1" target="_blank" title="$2">$2</a>',
						'<span style="font-size: $1px; color: $2;">$3</span>',
						'<span style="color: $1; font-size: $2px;">$3</span>',
						'<span style="font-size: $1px;">$2</span>',
						'<span style="color: $1;">$2</span>'
                               			);

        		$bbcode = preg_replace ($bbcode_search, $bbcode_replace, $bbcode);

        		return $bbcode;
			}
         	}

	// deletes bbcode
	if (!function_exists("bbcode_delete"))
		{
		function bbcode_delete($bbcode)
			{
			//$bbcode = htmlentities($bbcode);
                 	$bbcode_search = array(
                 				'/\[b\](.*?)\[\/b\]/is',
                                		'/\[i\](.*?)\[\/i\]/is',
                                         	'/\[url\](.*?)\[\/url\]/is',
                                         	'/\[url\=(.*?)\](.*?)\[\/url\]/is',
                                         	'/\[size\=(.*?)\](.*?)\[\/size\]/is',
                                         	'/\[color\=(.*?)\](.*?)\[\/color\]/is'
                                	 	);

        		$bbcode_replace = array(
						'$1',
                               			'$1',
						'$1',
						'$1',
						'$2',
						'$2'
                               			);

        		$bbcode = preg_replace ($bbcode_search, $bbcode_replace, $bbcode);

        		return $bbcode;
			}
         	}
         	
	// checks if login is ok
	if (!function_exists("login_ok"))
		{		
		function login_ok($name, $ID, $password)
			{
			require "../config.inc.php";
								
			$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(functions.inc.php, login_ok) Error: ".mysql_error());
			@mysql_select_db($db['dbname'], $link) or die ("(functions.inc.php, login_ok) Error: ".mysql_error());
			
			if($ID != "")
				{
				$sql = "SELECT user_password FROM ".$db['prefix']."user WHERE ID=".$ID;
				}
			else
				{
				$sql = "SELECT user_password FROM ".$db['prefix']."user WHERE user_name=".$name;
				}
			$result = @mysql_query($sql, $link) or die ("(functions.inc.php,  login_ok) Error: ".mysql_error());

			$user = @mysql_fetch_array($result);
			$pass = md5($password);
			
			if ($user['user_password'] == $pass)
				{
				return TRUE;
				unset($ID);
				unset($user['user_password']);
				unset($pass);
				}
			else
				{
				return FALSE;
				unset($ID);
				unset($user['user_password']);
				unset($pass);
				}
			}
		}
		
	// checks if username exists when adding new user
	if (!function_exists("check_if_user_exists"))
		{		
		function check_if_user_exists($name, $email)
			{
			require "../config.inc.php";
			
			$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(functions.inc.php) Error: ".mysql_error());
			@mysql_select_db($db['dbname'], $link) or die ("(functions.inc.php) Error: ".mysql_error());
			
			$sql = "SELECT user_name FROM ".$db['prefix']."user WHERE user_name=".$name;		
			$result = @mysql_query($sql, $link) or die ("(functions.inc.php) Error: ".mysql_error());

			$user = @mysql_fetch_array($result);		
			
			if(secure_value(strtolower($user['user_name'])) == strtolower($name))
				{
				return FALSE;				
				}
			else
				{
				$ok = 1;
				}
			
			$sql = "SELECT user_email FROM ".$db['prefix']."user WHERE user_email=".$email;		
			$result = @mysql_query($sql, $link) or die ("(functions.inc.php) Error: ".mysql_error());
			
			$user = @mysql_fetch_array($result);
			
			if(secure_value(strtolower($user['user_email'])) == strtolower($email))
				{				
				return FALSE;
				}
			else
				{
				$ok = 1;
				}
			
			if($ok == 1) { return TRUE; }
			}
		}
	
	// wordwrap: if message contains words longer than $settings['wordwrap'] they will
	// be broken into two or more strings. If $settings['wordwrap'] == 0, function is off.
	// This method taken from http://de.php.net/manual/en/function.wordwrap.php#64517
	// by ab_at_notenet(dot)dk (thanks for that!!) will luckily not affect html tags
	if (!function_exists("textWrap"))
		{	
		function textWrap($text, $size)
			{
			$new_text = '';
			$text_1 = explode('>',$text);
			$sizeof = sizeof($text_1);
			for ($i=0; $i<$sizeof; ++$i)
				{
				$text_2 = explode('<',$text_1[$i]);
				if (!empty($text_2[0]))
					{
					$new_text .= preg_replace('#([^\n\r .]{'. $size .'})#i', '\\1  ', $text_2[0]);
					}
				if (!empty($text_2[1]))
					{
					$new_text .= '<' . $text_2[1] . '>'; 
					}
				}
			return $new_text;
			}
		}
		
	// secure values to prevent remote sql exploits
	if (!function_exists("secure_value"))
		{
		function secure_value($value)
			{			
			if (get_magic_quotes_gpc()) {
				$value = stripslashes($value);
				}			
			if (!is_numeric($value)) {
				$value = "'" . mysql_real_escape_string($value) . "'";
				}
			return $value;
			}
		}
	
	// turn xhtml breaks to new lines
	if (!function_exists("xhtmlbr2nl"))
		{
		function xhtmlbr2nl($value)
			{			
			$value = preg_replace("/\<br \/>/", "\n", $value);
			return $value;
			}
		}
		
	// replace placeholders in email
	if (!function_exists("format_mail"))
		{
		function format_mail($value, $name, $date, $time, $message, $domain, $url_to_gb, $adduser_name, $adduser_password, $adduser_url, $new_password_key, $user_id, $new_password)
			{
						
			$value = preg_replace("/\{NAME\}/", $name, $value);
			$value = preg_replace("/\{DATE\}/", $date, $value);
			$value = preg_replace("/\{TIME\}/", $time, $value);			
			$value = preg_replace("/\{DOMAIN\}/", $domain, $value);
			$value = preg_replace("/\{URL_TO_GB\}/", $url_to_gb, $value);
			$value = preg_replace("/\{MESSAGE\}/", $message, $value);
			$value = preg_replace("/\{ADDUSER_NAME\}/", $adduser_name, $value);
			$value = preg_replace("/\{ADDUSER_PASSWORD\}/", $adduser_password, $value);
			$value = preg_replace("/\{ADDUSER_URL\}/", $adduser_url, $value);
			$value = preg_replace("/\{NEW_PASSWORD_KEY\}/", $new_password_key, $value);
			$value = preg_replace("/\{NEW_PASSWORD_LINK\}/", $url_to_gb."?id=".$user_id."&key=".$new_password_key, $value);
			$value = preg_replace("/\{NEW_PASSWORD\}/", $new_password, $value);
			
			return $value;
			}
		}
		
	// replace umlauts in email
	if (!function_exists("repl_uml"))
		{
		function repl_uml($text, $charset)
			{						
			if($charset == "utf-8")
				{
				$text = preg_replace("/\&uuml;/", utf8_encode(""), $text);
				$text = preg_replace("/\&auml;/", utf8_encode(""), $text);
				$text = preg_replace("/\&ouml;/", utf8_encode(""), $text);
				$text = preg_replace("/\&szlig;/", utf8_encode(""), $text);				
				}
			else
				{
				$text = preg_replace("/\&uuml;/", "", $text);
				$text = preg_replace("/\&auml;/", "", $text);
				$text = preg_replace("/\&ouml;/", "", $text);
				$text = preg_replace("/\&szlig;/", "", $text);				
				}				
			
			return $text;
			}
		}
		
	// generate captcha
	if (!function_exists("generate_captcha"))
		{
		function generate_captcha()
			{
			require "config.inc.php";
			
			$captcha_letters = array("A", "B", "C", "D", "E", "F", "G", "H", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z");
			$captcha_numbers = array("2", "3", "4", "5", "6", "8", "9");
			$captcha_special = array("!", "?");

			for ($i = 0, $code = NULL; strlen($code) < 6; $i++)
				{
				// if you like to use special characters in your captcha
				// set the "2" in the following line to "3"
				$captcha_random = rand(1, 2);
				if ($captcha_random == 1)
					{
					$code .= $captcha_letters[rand(0, (count($captcha_letters))-1)];
					}
				elseif ($captcha_random == 2)
					{
					$code .= $captcha_numbers[rand(0, (count($captcha_numbers))-1)];
					}
				else
					{
					$code .= $captcha_special[rand(0, (count($captcha_special))-1)];
					}
				}
                        
                        // save captcha to database
	        	$sql = "UPDATE `".$db['prefix']."captcha` SET `code` = '$code' LIMIT 1";
         		$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(functions.inc.php) Error: ".mysql_error());
        		@mysql_select_db($db['dbname'], $link) or die ("(functions.inc.php) Error: ".mysql_error());
        		@mysql_query($sql, $link) or die ("(functions.inc.php) Error: ".mysql_error());
        		}
        	}
        	
	// generate user_key
        if (!function_exists("generate_key_and_pw"))
		{
		function generate_key_and_pw($name, $length)
			{
			require "config.inc.php";
			
			$key_pw_letters = array("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z");
			$key_pw_letters_small = array("a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z");
			$key_pw_numbers = array("1", "2", "3", "4", "5", "6", "7", "8", "9");
			$key_pw_special = array("!", "", "$", "%", "&", "=", "?");

			for ($i = 0, $key_pw = NULL; strlen($key_pw) < $length; $i++)
				{
				// if you like to use special characters in your user_key
				// set the "3" in the following line to "4"
				$key_pw_random = rand(1, 3);
				if ($key_pw_random == 1)
					{
					$key_pw .= $key_pw_letters[rand(0, (count($key_pw_letters))-1)];
					}
				elseif ($key_pw_random == 2)
					{
					$key_pw .= $key_pw_letters_small[rand(0, (count($key_pw_letters_small))-1)];
					}
				elseif ($key_pw_random == 3)
					{
					$key_pw .= $key_pw_numbers[rand(0, (count($key_pw_numbers))-1)];
					}
				else
					{
					$key_pw .= $key_pw_special[rand(0, (count($key_pw_special))-1)];
					}
				}
                        if($name != "")
				{
				// save user_key for user in database
				$sql = "UPDATE `".$db['prefix']."user` SET `user_key` = '".$key_pw."' WHERE `user_name` = ".$name." LIMIT 1";	        	
				$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(functions.inc.php) Error: ".mysql_error());
				@mysql_select_db($db['dbname'], $link) or die ("(functions.inc.php) Error: ".mysql_error());
				@mysql_query($sql, $link) or die ("(functions.inc.php) Error: ".mysql_error());
				}
			else
				{
				return $key_pw;
				}
        		}
        	}
        	
        // check $_SESSION['key']        
	if (!function_exists("check_session"))
		{		
		function check_session($sessid, $sessionkey, $timeout)
			{
			require "../config.inc.php";			
			
			$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(functions.inc.php, check_session) Error: ".mysql_error());
			@mysql_select_db($db['dbname'], $link) or die ("(functions.inc.php, check_session) Error: ".mysql_error());
			
			$sql = "SELECT user_key, logged_in FROM ".$db['prefix']."user WHERE ID=".$sessid." LIMIT 1";
			$result = @mysql_query($sql, $link) or die ("(functions.inc.php, check_session) Error: ".mysql_error());

			$user = @mysql_fetch_array($result);			
			
			if($user['user_key'] == $sessionkey)
				{
				$ok = 1;
				}			
			
			if(time() > ($user['logged_in'] + $timeout))
				{
				$ok = 0;
				}
			else
				{
				$sql = "UPDATE ".$db['prefix']."user SET `logged_in` = '".time()."' WHERE ID=".$sessid." LIMIT 1";						
				@mysql_query($sql, $link) or die ("(functions.inc.php, check_session) Error: ".mysql_error());
				$ok = 1;
				}
			
			if($ok == 1) { return TRUE; } else { return FALSE; }			
			}
		}	
		
	// check rights for access of several adminsites        
	if (!function_exists("check_rights"))
		{		
		function check_rights($site, $sessid)
			{
			require "../config.inc.php";
			
			$sql = "SELECT user_level, r_settings, r_activate, r_deactivate, r_delete, r_edit FROM ".$db['prefix']."user WHERE ID=".$sessid;
			$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(functions.inc.php, check_rights) Error: ".mysql_error());
			@mysql_select_db($db['dbname'], $link) or die ("(functions.inc.php, check_rights) Error: ".mysql_error());
			$result = @mysql_query($sql, $link) or die ("(functions.inc.php, check_rights) Error: ".mysql_error());

			$user = @mysql_fetch_array($result);			
			
			switch ($user['user_level'])
				{
				case 0:
					return TRUE;
					break;
				case 1:
					if($site == "settings" AND $user['r_settings'] == 1)
						{
						return TRUE;
						}
					elseif($site == "activate" AND $user['r_activate'] == 1)
						{
						return TRUE;
						}
					elseif($site == "deactivate" AND $user['r_deactivate'] == 1)
						{
						return TRUE;
						}
					elseif($site == "delete" AND $user['r_delete'] == 1)
						{
						return TRUE;
						}
					elseif($site == "edit" AND $user['r_edit'] == 1)
						{
						return TRUE;
						}
					elseif($site == "version")
						{
						return TRUE;
						}
					elseif($site == "editusers")
						{
						return FALSE;
						}					
					else
						{
						return FALSE;
						}
					break;
				}		
			}
		}
		
	
	// clean string
	if (!function_exists("cleanstr"))
		{		
		function cleanstr($string)
   			{
			$string = htmlspecialchars(stripslashes(strip_tags(trim($string))), ENT_QUOTES);
			return $string;
			}	
		}
?>
