﻿/*************************
  Coppermine Photo Gallery
  ************************
  Copyright (c) 2003-2012 Coppermine Dev Team
  v1.0 originally written by Gregory Demar

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 3
  as published by the Free Software Foundation.
  
  ********************************************
  Coppermine version: 1.5.18
  $HeadURL: https://coppermine.svn.sourceforge.net/svnroot/coppermine/trunk/cpg1.5.x/docs/de/script.js $
  $Revision: 8304 $
**********************************************/

var linebreak = '\n';

$(function() {
    $("#toc_overall").treeview({
        collapsed: true,
        animated: "medium",
        control:"#sidetreecontrol"
    });
    $(".cpg_zebra tr:even").addClass("tableb");
    $(".cpg_zebra tr:odd").addClass("tableb_alternate");
});

function cpgDocToc() {
  if (getUrlParameters('hide_nav') == 1) {
    $('#toc').replaceWith('');
    return;
  }
var doc_toc = '';
doc_toc += '<div id="toc_collapsed" class="en">\n';
doc_toc += '<h6><a href="toc.htm" class="en">Inhaltsverzeichnis</a></h6>\n';
doc_toc += 'Bewege Deine Maus über dieses Feld\n';
doc_toc += '<div align="center" class="en"><img src="../../images/icons/downdown.png" border="0" width="10" height="10" alt="" /></div>\n';
doc_toc += '</div>\n';
doc_toc += '<div id="toc_expanded" style="display:none;" class="en">\n';
doc_toc += '<h6>Inhaltsverzeichnis (<a href="../index.htm" class="en">Sprachauswahl</a>)</h6>\n';
doc_toc += '<ul id="tree" class="en">\n';
doc_toc += '  <li><a href="index.htm" class="de">Coppermine Dokumentation</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="index.htm#about" class="de">Über Coppermine</a></li>\n';
doc_toc += '      <li><a href="index.htm#about_documentation" class="en">Über die Dokumentation</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="index.htm#about_documentation_conventions" class="en">Konventionen</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="index.htm?expand_all=1#features" class="en">Features</a></li>\n';
doc_toc += '      <li><a href="quickstart.htm#about" class="en">Schnellstart-Assistent</a></li>\n';
doc_toc += '      <li><a href="toc.htm" class="en">Inhaltsverzeichnis</a></li>\n';
doc_toc += '      <li><a href="requirements.htm" class="us_de">Mindestvoraussetzung</a>\n';
doc_toc += '        <ul class="en">\n';
doc_toc += '          <li><a href="requirements.htm#what_minimum" class="de">Server-seitige Mindestvoraussetzungen</a>\n';
doc_toc += '            <ul class="en">\n';
doc_toc += '              <li><a href="requirements.htm#what_minimum_webserver" class="de">Ein Webserver</a></li>\n';
doc_toc += '              <li><a href="requirements.htm#what_minimum_php" class="de">Ein Webserver mit PHP-Unterstützung</a></li>\n';
doc_toc += '              <li><a href="requirements.htm#what_minimum_mysql" class="de">Eine MySQL-Datenbank</a></li>\n';
doc_toc += '              <li><a href="requirements.htm#what_minimum_image_library" class="de">Eine Grafik-Bibliothek:</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="requirements.htm#what_minimum_self-hosting" class="de">Selbst-Hosting und Webserver-Setup</a></li>\n';
doc_toc += '          <li><a href="requirements.htm#personal" class="de">Persönliche Voraussetzungen</a></li>\n';
doc_toc += '          <li><a href="requirements.htm#requirements_faq" class="en">Requirements FAQ</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="testing.htm" class="en">Test / Fehler bei den Entwicklern melden</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="testing.htm#testing_support" class="en">No support for alpha and beta versions</a></li>\n';
doc_toc += '          <li><a href="testing.htm#testing_areas" class="en">Areas to be particularly mindful of</a></li>\n';
doc_toc += '          <li><a href="testing.htm#testing_feature_list" class="en">Feature list</a></li>\n';
doc_toc += '          <li><a href="testing.htm#testing_report" class="en">The report format</a></li>\n';
doc_toc += '          <li><a href="testing.htm#testing_availability" class="en">Availability</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="languages.htm" class="us_de">Sprachen</a>\n';
doc_toc += '        <ul class="en">\n';
doc_toc += '          <li><a href="languages.htm#how" class="de">Wie Coppermine mit Sprachen arbeitet</a></li>\n';
doc_toc += '          <li><a href="translation.htm" class="en">Übersetzungs-Assistent</a>\n';
doc_toc += '            <ul class="en">\n';
doc_toc += '              <li><a href="translation.htm#translation_translators_wanted" class="en">Translators wanted!</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_why_translate" class="en">Why translate?</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_which_languages" class="en">Translations for which languages are needed?</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_who" class="en">Who can translate?</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_char_encoding" class="en">Character encoding</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_editors" class="en">Editors &amp; Tools</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_full_translation" class="en">Full translations only</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_step_by_step" class="en">Step by step</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_special_issues" class="en">Special issues</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_versions" class="en">Language versions</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_work_in_progress" class="en">Work in progress</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_initial_translation" class="en">Initial translation for release</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_older_language_files" class="en">Using older language files</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_documentation" class="en">Translating the documentation</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="translation.htm#translation_documentation_steps" class="en">Steps for translating the docs into your language</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_not_exist" class="en">Make sure that the translation doesn\'t already exist</a></li>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_structure" class="en">Create the structure</a></li>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_copy_core" class="en">Copy the core language files</a></li>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_start_translating" class="en">Start translating</a></li>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_attention" class="en">Areas to pay attention to</a></li>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_toc" class="en">Take care of the table of contents</a></li>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_zip" class="en">Zip your translation</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="translation.htm#translation_links" class="en">Further reading</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="credits.htm" class="de">Danksagungen</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="credits.htm#developers" class="de">Coppermine Entwickler Team</a></li>\n';
doc_toc += '          <li><a href="credits.htm#contributors" class="de">Unterstützer</a></li>\n';
doc_toc += '          <li><a href="credits.htm#translators" class="de">Übersetzer</a>\n';
doc_toc += '            <ul class="de">\n';
doc_toc += '              <li><a href="credits.htm#translators_language_file" class="de">Sprachdateien</a></li>\n';
doc_toc += '              <li><a href="credits.htm#translators_documentation" class="de">Dokumentation</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="credits.htm#codebase" class="de">Verwendeter Open Source Code</a></li>\n';
doc_toc += '          <li><a href="credits.htm#acknowledgements" class="en">Danksagungen</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="credits.htm#acknowledgements_thanks" class="en">Many Thanks</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="copyrights.htm" class="us_de">Lizenz und Copyright</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="copyrights.htm#copyright_copyright" class="de">Copyrights</a></li>\n';
doc_toc += '          <li><a href="copyrights.htm#copyright_license" class="de">Lizenz</a></li>\n';
doc_toc += '          <li><a href="copyrights.htm#copyrights_previous_versions" class="de">Vorhergehende Versionen</a></li>\n';
doc_toc += '          <li><a href="copyrights.htm#copyright_additional" class="de">Zusätzliche Bedingungen</a>\n';
doc_toc += '            <ul class="en">\n';
doc_toc += '              <li><a href="copyrights.htm#copyright_additional_preservation" class="de">Erhaltung der Autorenschaftshinweise</a></li>\n';
doc_toc += '              <li><a href="copyrights.htm#copyright_additional_marking" class="de">Kennzeichnung von modifizierte Versionen des Materials</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="copyrights.htm#copyright_freedom" class="en">Freiheit</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="known_issues.htm" class="en">Bekannte Probleme</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="install.htm" class="us_de">Installation und Einstellungen</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="install.htm#how" class="en">Wie man das Skript installiert</a></li>\n';
doc_toc += '      <li><a href="install.htm#what" class="en">Was passiert während der Installation</a></li>\n';
doc_toc += '      <li><a href="install_permissions.htm" class="en">Berechtigungs-Einstellungen</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '              <li><a href="install_permissions.htm#chmod" class="en">Apache auf Unix/Linux (CHMOD)</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_basics" class="en">Basics</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_groups" class="en">Groups in Lunix</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_daemon" class="en">Webserver daemon</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_binary_arithmetics" class="en">Binary arithmetics</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_benefit" class="en">What good is all of this?</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_ftp" class="en">FTP application</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_website_control_panel" class="en">Website control panel</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_shell_access" class="en">Shell access</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_chown" class="en">Ownership (CHOWN)</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '          <li><a href="install_permissions.htm#apache_windows" class="en">Apache auf Windows</a></li>\n';
doc_toc += '          <li><a href="install_permissions.htm#iis" class="en">IIS on Windows</a></li>\n';
doc_toc += '          <li><a href="install_permissions.htm#support" class="en">Unterstützung/Support in Berechtigungsfragen</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="install_screen.htm" class="en">Der Installations-Assistent</a></li>\n';
doc_toc += '      <li><a href="auto-installers.htm" class="en">Automatische Installation</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="auto-installers.htm#definition" class="en">What are auto-installers?</a></li>\n';
doc_toc += '          <li><a href="auto-installers.htm#sad_story" class="en">The sad story</a></li>\n';
doc_toc += '          <li><a href="auto-installers.htm#" class="en">Why not use auto-installers</a></li>\n';
doc_toc += '          <li><a href="auto-installers.htm#no_support" class="en">No support</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="install_faq.htm" class="en">Installations FAQ</a></li>\n';
doc_toc += '      <li><a href="uninstall.htm" class="de">De-Installation</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="upgrading.htm" class="en">Aktualisierung</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="upgrading.htm#upgrade_why" class="en">Warum aktualisieren?</a>\n';
doc_toc += '          <ul>\n';
doc_toc += '              <li><a href="upgrading.htm#upgrade_why_reasons" class="en">Gründe für die Veröffentlichungen</a></li>\n';
doc_toc += '              <li><a href="upgrading.htm#upgrade_why_changelog" class="en">Changelog</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upgrading.htm#upgrade_any" class="en">Aktualisierungs-Schritte (alle Versionen)</a></li>\n';
doc_toc += '      <li><a href="upgrading.htm#upgrade_particular" class="en">Zusätzliche Schritte für bestimmte Versionen</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="upgrading.htm#upgrade_10" class="en">Aktualisierung von cpg1.0,1.1,1.2.x oder 1.3.x</a></li>\n';
doc_toc += '          <li><a href="upgrading.htm#upgrade_14" class="en">Aktualisierung von cpg1.4.x auf Version cpg1.5.x</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upgrading.htm#updater" class="en">Das Aktualisierungs-Skript</a>\n';
doc_toc += '          <ul class="en">\n';
doc_toc += '              <li><a href="upgrading.htm#updater_what_it_does" class="en">Was das Skript macht</a></li>\n';
doc_toc += '              <li><a href="upgrading.htm#updater_purpose" class="en">Zweck</a></li>\n';
doc_toc += '              <li><a href="upgrading.htm#updater_authorization" class="en">Überprüfung der Berechtigung</a></li>\n';
doc_toc += '              <li><a href="upgrading.htm#updater_when" class="en">Wann muss das Aktualiserungs-Skript laufen?</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upgrading.htm#versioncheck" class="en">Die Versions-Prüfung</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="upgrading.htm#versioncheck_description_start" class="en">Was das Skript tut</a></li>\n';
doc_toc += '          <li><a href="upgrading.htm#versioncheck_options_start" class="en">Optionen</a></li>\n';
doc_toc += '          <li><a href="upgrading.htm#versioncheck_comparison_start class="en"" class="en">Versionsvergleich</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upgrading.htm#upgrade_faq" class="en">Aktualisierungs-FAQ</a></li>\n';
doc_toc += '      <li><a href="upgrading.htm#downgrading" class="en">Von cpg1.5.x auf eine ältere Version downgraden</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="start.htm" class="en">Am Anfang</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="start.htm#getting_concepts" class="en">Grundlegende Konzepte</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_initial_configuration" class="en">Erstmalige Einrichtung</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_structure" class="en">Kategorie/Alben/Datei-Struktur</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_resizing" class="en">Größenänderung von Bildern</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="start.htm#getting_resizing_thumbnails" class="en">Thumbnails</a></li>\n';
doc_toc += '          <li><a href="start.htm#getting_resizing_intermediate" class="en">Intermediates</a></li>\n';
doc_toc += '          <li><a href="start.htm#getting_resizing_original" class="en">Originals</a></li>\n';
doc_toc += '          <li><a href="start.htm#getting_resizing_recommended" class="en">Recommended resizing setups</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="start.htm#getting_resizing_recommended_nofullsize" class="en">No full-size pop-ups</a></li>\n';
doc_toc += '              <li><a href="start.htm#getting_resizing_recommended_nointermediate" class="en">Allow full-size pop-ups with maximum space saving</a></li>\n';
doc_toc += '              <li><a href="start.htm#getting_resizing_recommended_regular" class="en">&quot;Regular&quot; setup with moderate file space consumption</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="start.htm#getting_admin_account" class="en">Dein Admin-Konto</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_check_uploads" class="en">ochladen</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_consider_bridging" class="en">Bridging in Betracht ziehen</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_interaction" class="en">Was dürfen die Besucher der Seite tun?</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_design" class="en">Das Aussehen Deiner Galerie anpassen</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_typical" class="en">Gebräuchliche Einstellungen</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="start.htm#getting_typical_monolithic" class="en">Single uploader without user interaction (Monolithic gallery)</a></li>\n';
doc_toc += '          <li><a href="start.htm#getting_typical_single_uploader_community" class="en">Single uploader with user interaction</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="faq.htm" class="en">Häufig gestellte Fragen (FAQ)</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="faq.htm#faq_setup" class="en">Setup / Configuration</a></li>\n';
doc_toc += '      <li><a href="faq.htm#hacks" class="en">Add-ons / Modifications / Hacks</a></li>\n';
doc_toc += '      <li><a href="faq.htm#support_board" class="en">Coppermine Support board</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="theme.htm" class="en">Designs (Themes)</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="theme.htm#theme_builtin" class="en">Mitgelieferte Designs</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme.htm#theme_builtin_curve">Curve</a></li>\n';
doc_toc += '          <li><a href="theme.htm#theme_builtin_eyeball">Eyeball</a></li>\n';
doc_toc += '          <li><a href="theme.htm#theme_builtin_hardwired">Hardwired</a></li>\n';
doc_toc += '          <li><a href="theme.htm#theme_builtin_rainy_day">Rainy Day</a></li>\n';
doc_toc += '          <li><a href="theme.htm#theme_builtin_sample">Sample</a></li>\n';
doc_toc += '          <li><a href="theme.htm#theme_builtin_waterdrop">Waterdrop</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme.htm#theme_upgrading" class="en">Aktualisierung Deines selbstgemachten Designs</a>\n';
doc_toc += '      <ul>\n';
doc_toc += '        <li><a href="theme_upgrade_14x-15x.htm" class="en">Konvertierung von cpg1.4.x-Themes auf cpg1.5.x</a>\n';
doc_toc += '          <ul>\n';
doc_toc += '            <li><a href="theme_upgrade_14x-15x.htm#theme_convert_style" class="en">Bearbeite style.css</a></li>\n';
doc_toc += '            <li><a href="theme_upgrade_14x-15x.htm#theme_convert_template" class="en">Bearbeite template.html</a></li>\n';
doc_toc += '            <li><a href="theme_upgrade_14x-15x.htm#theme_convert_theme" class="en">Bearbeite theme.php</a></li>\n';
doc_toc += '            <li><a href="theme_upgrade_14x-15x.htm#theme_convert_validation" class="en">Validierung</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '        </li>\n';
doc_toc += '      </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme.htm#theme_files" class="en">Inhalt eines Themes</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_template.htm#theme_template_html" class="en">Editing template.html</a>\n';
doc_toc += '              <ul class="en">\n';
doc_toc += '                  <li><a href="theme_template.htm#theme_template_token" class="en">Template tokens</a></li>\n';
doc_toc += '                  <li><a href="theme_template.htm#theme_template_important" class="en">Important</a></li>\n';
doc_toc += '                  <li><a href="theme_template.htm#theme_template_token_list" class="en">List of tokens in template.html</a></li>\n';
doc_toc += '              </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="theme_style_css.htm#theme_style_css" class="en">Editing style.css</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_tools" class="en">Tools</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="theme_style_css.htm#theme_style_css_tools_webdev" class="en">Web Developer Toolbar usage</a></li>\n';
doc_toc += '                  <li><a href="theme_style_css.htm#theme_style_css_tools_editor" class="en">Editor</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_list" class="en">List of classes in style.css</a>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_overall" class="en">Additional stylesheet</a>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="theme_theme_php.htm#theme_create_theme_php" class="en">Editing theme.php</a>\n';
doc_toc += '              <ul class="en">\n';
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_php_types" class="en">Item types</a></li>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm" class="en">The sample theme - a template to copy from</a></li>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_php_method" class="en">Method</a></li>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_php_scope" class="en">Scope</a></li>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_php_list" class="en">List of items in theme.php</a></li>\n';
doc_toc += '                  <li><a href="theme_examples.htm#theme_examples" class="en">Theme Examples</a></li>\n';
doc_toc += '              </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme.htm#theme_engine" class="en">Wie ein Theme funktioniert</a></li>\n';
doc_toc += '      <li><a href="theme_user-contributions.htm#theme_user-contributions" class="en">Zusätzliche Themes</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_preview" class="en">Preview user-contributed themes</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_download" class="en">Download user-contributed themes</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_install" class="en">Installing user-contributed themes</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_copyrights" class="en">Copyrights of user-contributed themes</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_support" class="en">Asking for support on user-contributed themes</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_contributing" class="en">Contributing your own theme</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme_create.htm#theme_create" class="en">Erstellung eines eigenen Themes</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_create.htm#theme_create_rename" class="en">Benennen Dein Theme zuerst um</a></li>\n';
doc_toc += '          <li><a href="theme_create.htm#theme_create_tipps" class="en">Tips &amp; Tricks</a></li>\n';
doc_toc += '          <li><a href="theme_create.htm#theme_create_wysiwyg" class="en">Verwendung von grafischen Editoren</a></li>\n';
doc_toc += '          <li><a href="theme_create.htm#theme_create_colors" class="en">Farben bearbeiten</a></li>\n';
doc_toc += '          <li><a href="theme_create_matching_page_tutorial.htm#theme_matching" class="en">Erstellen eines Themes für Coppermine im Stil der restlichen Seite</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_intro" class="en">Introduction</a></li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_pre-requisites" class="en">Pre-requisites</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_pre-requisites_tools" class="en">Tools</a></li>\n';
doc_toc += '                  <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_pre-requisites_skills" class="en">Skills</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_examples" class="en">Example</a></li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_pick_similar" class="en">Pick a similar theme first</a></li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_start" class="en">Start editing your theme</a></li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_placeholder_replace" class="en">Replace the content from the sample with placeholder tokens</a></li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_style" class="en">Adapting the style</a></li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_test1" class="en">Initial test</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="theme_template.htm#theme_template_html" class="en">Bearbeitung von template.html</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_template.htm#theme_template_token" class="en">Template-Platzhalter</a></li>\n';
doc_toc += '              <li><a href="theme_template.htm#theme_template_important" class="en">Wichtig</a></li>\n';
doc_toc += '              <li><a href="theme_template.htm#theme_template_token_list" class="en">Übersicht der Platzhalter in template.html</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="theme_theme_php.htm#theme_php" class="en">Editing theme.php</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_theme_php.htm#theme_php_types" class="en">Item types</a></li>\n';
doc_toc += '              <li><a href="theme_theme_php.htm#theme_sample" class="en">The sample theme - a template to copy from</a></li>\n';
doc_toc += '              <li><a href="theme_theme_php.htm#theme_php_method" class="en">Method</a></li>\n';
doc_toc += '              <li><a href="theme_theme_php.htm#theme_php_scope" class="en">Scope</a></li>\n';
doc_toc += '              <li><a href="theme_theme_php.htm#theme_php_list" class="en">List of items in theme.php</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="theme_style_css.htm#theme_style_css" class="en">Bearbeitung von style.css</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_tools" class="en">Tools</a></li>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_list" class="en">List of classes in style.css</a></li>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_overall" class="en">Additional stylesheet</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme_examples.htm#theme_examples" class="en">Theme examples</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_examples.htm#theme_examples_summary" class="en">Summary</a></li>\n';
doc_toc += '          <li><a href="theme_examples.htm#theme_examples_content" class="en">Additional content</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_examples.htm#theme_examples_content_thumbnail" class="en">Additional content on the thumbnail page</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="theme_examples.htm#theme_examples_content_thumbnail_extra_row" class="en">Extra row between thumbnail rows</a></li>\n';
doc_toc += '                  <li><a href="theme_examples.htm#theme_examples_content_thumbnail_cell" class="en">Extra table cell on each thumbnail page</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="theme_examples.htm#theme_examples_content_displayimage" class="en">Additional content on the intermediate-image pages (displayimage.php)</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="theme_examples.htm#theme_examples_content_displayimage_image" class="en">Directly next to the intermediate image</a></li>\n';
doc_toc += '                  <li><a href="theme_examples.htm#theme_examples_content_displayimage_filmstrip" class="en">Directly next to the film strip</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="theme_examples.htm#theme_examples_content_fullsize" class="en">Additional content on the full-size pop-up</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme_copyright.htm" class="en">Copyright-Disclaimer in der Fußzeile</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_copyright.htm#theme_copyright_fair_use" class="en">Fair use</a>\n';
doc_toc += '          <li><a href="theme_copyright.htm#theme_copyright_unfair_use" class="en">Unfair use</a>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="php-content.htm" class="en">Dynamischer (PHP-basierter) Inhalt</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="php-content.htm#php-content_anycontent" class="en">Verwendung von anycontent.php</a></li>\n';
doc_toc += '          <li><a href="php-content.htm#php-content_header_footer" class="en">Benutzerdefinierte Kopf- und Fußzeile</a></li>\n';
doc_toc += '          <li><a href="php-content.htm#php-content_theme" class="en">Theme-basierter dynamischer Inhalt (theme.php)</a></li>\n';
doc_toc += '          <li><a href="php-content.htm#php-content_core" class="en">Veränderung von Grund-Dateien</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme_graphics.htm" class="en">Grafische Resourcen in Designs</a>\n';
doc_toc += '          <ul class="en">\n';
doc_toc += '              <li><a href="theme_graphics.htm#theme_graphics_menu_icons" class="en">Menü-Icons</a></li>\n';
doc_toc += '              <li><a href="theme_graphics.htm#theme_graphics_nav_bar" class="en">Bildnavigation</a></li>\n';
doc_toc += '              <li><a href="theme_graphics.htm#theme_graphics_rating" class="en">Bewertungs-Icons</a></li>\n';
doc_toc += '              <li><a href="theme_graphics.htm#theme_graphics_film_strip" class="en">Film Strip graphics</a></li>\n';
doc_toc += '              <li><a href="theme_graphics.htm#theme_graphics_progress" class="en">Progress image (loader)</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="administration.htm" class="us_de">Administration</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="admin_menu.htm" class="en">Admin-Menü-Einträge</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="admin_menu.htm#admin_user_mode" class="en">Enable / disable admin controls</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#upload_approval" class="en">Upload approval</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#config" class="en">Config</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#categories" class="en">Categories</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#albums" class="en">Albums</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#sort_my_pictures" class="en">Sort my pictures</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#groups" class="en">Groups</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#users" class="en">Users</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#ban" class="en">Ban Users</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#my_profile" class="en">My profile</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#review_comments" class="en">Review Comments</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#ecard_log" class="en">Display Ecards</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#batch_add" class="en">Batch add files</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#admin_tools" class="en">Admin Tools (Resize Pictures)</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#keyword_manager" class="en">Keyword manager</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#plugin_manager" class="en">Plugin Manager</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#bridge_manager" class="en">Bridge Manager</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#view_log" class="en">View log files</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#stats" class="en">Overall stats</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#versioncheck" class="en">Check versions</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#update_database" class="en">Update database</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#export" class="en">Export</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#phpinfo" class="en">phpinfo</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#show_news" class="en">Show news</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#documentation" class="en">Documentation</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#admin_mode_regular_users" class="en">Admin mode for regular users</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#user_menu_items" class="en">Admin menu items for regular users</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="banning.htm#banning" class="en">Verbannen</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '      <li><a href="banning.htm#banning_whats_new" class="en">What\'s new?</a></li>\n';
doc_toc += '      <li><a href="banning.htm#banning_scope" class="en">Scope</a></li>\n';
doc_toc += '      <li><a href="banning.htm#bannig_how_it_works" class="en">How banning works</a></li>\n';
doc_toc += '      <li><a href="banning.htm#banning_by_ip_address_no_good" class="en">Why banning by IP address is not recommended</a></li>\n';
doc_toc += '      <li><a href="banning.htm#banning_page" class="en">Page controls</a></li>\n';
doc_toc += '      <li><a href="banning.htm#banning_bridged" class="en">No banning when bridged</a></li>\n';
doc_toc += '      <li><a href="banning.htm#banning_todo" class="en">To do</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="configuration.htm" class="us_de">Einstellungen</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="configuration.htm#admin_general" class="de">Allgemeine Einstellungen</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_language" class="us_de">Sprach- und Zeichensatz-Einstellungen</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_theme" class="us_de">Themen-Einstellungen</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_album_list" class="de">Ansicht Albenliste</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_thumbnail_view" class="de">Ansicht Thumbnail</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_image_comment" class="us_de">Ansicht Bild</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_comment_start" class="en">Einstellungen Kommentare</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_contact_start" class="en">Kontakformular-Einstellungen</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_thumb_start" class="en">Thumbnail Einstellungen</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_picture_thumbnail" class="en">Bild/Datei-Einstellungen</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_watermarking" class="en">Wasserzeichen auf Bildern</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_registration" class="en">Registrierung</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_user" class="en">Benutzer-Einstellungen</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_custom" class="en">Benutzerdefinierte Felder für Benutzerprofile</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_custom_image" class="en">Benutzerdefinierte Felder für zusätzliche Dateiinformationen</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_cookie" class="en">Cookie-Einstellungen</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_email" class="en">Email-Einstellungen</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_logging" class="en">Logging und Statistiken</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_misc" class="en">Wartungs-Einstellungen</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_reset_entire_config" class="en">Werkseinstellungen zurücksetzen</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="groups.htm" class="en">Gruppen</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="groups.htm#group_cp" class="en">Gruppen-Einstellungen</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_names" class="en">Gruppen-Namen</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_types" class="en">Gruppen-Arten</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_quota" class="en">Speicherlimits</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_permissions" class="en">Gruppenberechtigungen (Bewertung/Ecards/Kommentare)</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_public" class="en">Uploads in öffentliche Alben</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_personal" class="en">Persönliche Galerien</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_upload_method" class="en">Upload-Methoden</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_assigned" class="en">Zugewiesene Alben</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_create" class="en">Benutzerdefinierte Gruppen erstellen</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_delete" class="en">Benutzerdefinierte Gruppen löschen</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_sync" class="en">Synchronisierung auslösen (nur bei Bridging)</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_more_than_one_group" class="en">Mitgliedschaft in mehr als einer Gruppe</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="users.htm" class="en">Benutzer</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="users.htm#user_cp" class="en">Benutzer-Manager</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="users.htm#user_cp_page" class="en">Bedien-Elemente</a></li>\n';
doc_toc += '              <li><a href="users.htm#user_cp_search" class="en">Benutzer suchen</a></li>\n';
doc_toc += '              <li><a href="users.htm#user_cp_new" class="en">Benutzer erstellen</a></li>\n';
doc_toc += '              <li><a href="users.htm#user_cp_edit" class="en">Benutzer bearbeiten</a></li>\n';
doc_toc += '              <li><a href="users.htm#user_cp_group" class="en">Gruppen-Mitgliedschaft</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="users.htm#lost_password" class="en">Vergessene Passwörter</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="users.htm#lost_password_cpg_user_account" class="en">Passwort für ein Coppermine Benutzerkonto</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="users.htm#lost_password_cpg_user_account_standalone" class="en">Coppermine im Standalone-Modus</a></li>\n';
doc_toc += '                  <li><a href="users.htm#lost_password_cpg_user_account_bridged" class="en">Coppermine gebridged</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="users.htm#lost_password_cpg_user_account" class="en">Passwort für das mySQL-Konto</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      <li><a href="categories.htm" class="en">Kategorien</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="categories.htm#cat_cp" class="en">The categories control panel</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="categories.htm#cat_cp_page_controls" class="en">Page controls</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="categories.htm#cat_cp_page_controls_sort" class="en">Top box &quot;Sort categories alphabetically&quot;</a></li>\n';
doc_toc += '                  <li><a href="categories.htm#cat_cp_page_controls_categories" class="en">Middle box &quot;Manage Categories&quot;</a></li>\n';
doc_toc += '                  <li><a href="categories.htm#cat_cp_page_controls_create" class="en">Bottom box &quot;Update/Create category&quot;</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="categories.htm#cat_user_galleries" class="en">Special category &quot;User galleries&quot;</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="albums.htm" class="en">Alben</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="albums.htm#albmgr" class="en">Der Alben-Manager</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="albums.htm#albmgr_create" class="en">Alben erzeugen</a></li>\n';
doc_toc += '              <li><a href="albums.htm#albmgr_rename" class="en">Alben umbenennen</a></li>\n';
doc_toc += '              <li><a href="albums.htm#albmgr_order" class="en">Alben-Reihenfolge ändern</a></li>\n';
doc_toc += '              <li><a href="albums.htm#albmgr_delete" class="en">Alben löschen</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="albums.htm#modif_alb_pics" class="en">Alben/Dateien bearbeiten</a></li>\n';
doc_toc += '          <li><a href="albums.htm#album_prop" class="en">Alben-Eigenschaften</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="albums.htm#album_prop_reset_start" class="en">Alben-Eigenschaften zurücksetzen</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="albums.htm#album_admin_user" class="en">Gegenüberstellung Admin/Benutzer</a></li>\n';
doc_toc += '          <li><a href="albums.htm#album_faq" class="en">Alben-FAQ</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="files.htm" class="en">Dateien</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="files.htm#edit_pics" class="en">Dateien bearbeiten</a></li>\n';
doc_toc += '          <li><a href="files.htm#edit_vids" class="en">Videos bearbeiten</a></li>\n';
doc_toc += '          <li><a href="files.htm#cust_thmb" class="en">Benutzerdefinierte Thumbnails</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_order" class="en">Order of thumbnails</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_types" class="en">Types of thumbnails</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_upload" class="en">Uploading custom thumbs</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_how" class="en">How it works</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_how_naming" class="en">Naming scheme</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_why" class="en">Why can\'t coppermine create thumbnails for my videos?</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_step" class="en">Step-by-step instructions</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_faq" class="en">Custom thumbnails FAQ</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="keywords.htm" class="en">Schlüsselwörter</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="keywords.htm#keywords_assign" class="en">Schlüsselwörter zuweisen</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="keywords.htm#keywords_assign_separator" class="en">Keyword separator or keyword delimiter</a></li>\n';
doc_toc += '              <li><a href="keywords.htm#keywords_assign_edit" class="en">Schlüsselwörter bearbeiten/ändern</a></li>\n';
doc_toc += '              <li><a href="keywords.htm#keywords_manager" class="en">Schlüsselwort-Manager</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="keywords.htm#keywords_album" class="en">Alben-Schlüsselwörter</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="bbcode.htm" class="en">bbCode</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="bbcode.htm#bbcode_purpose" class="en">Purpose</a></li>\n';
doc_toc += '          <li><a href="bbcode.htm#bbcode_available" class="en">Available bbcode tags</a></li>\n';
doc_toc += '          <li><a href="bbcode.htm#bbcode_dangers" class="en">Dangers</a></li>\n';
doc_toc += '          <li><a href="bbcode.htm#bbcode_control" class="en">More control</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="exif.htm" class="en">Exif-Daten</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="exif.htm#exif_what" class="en">What is EXIF</a></li>\n';
doc_toc += '          <li><a href="exif.htm#exif_makers" class="en">Different flavors</a></li>\n';
doc_toc += '          <li><a href="exif.htm#exif_how_it_works" class="en">How it works</a></li>\n';
doc_toc += '          <li><a href="exif.htm#exif_image_libraries" class="en">No exif support on the server</a></li>\n';
doc_toc += '          <li><a href="exif.htm#exif_limitations" class="en">Limitations</a></li>\n';
doc_toc += '          <li><a href="exif.htm#exif_manager" class="en">EXIF manager</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="plugins.htm" class="en">Zusatzmodule (Plugins)</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_definition" class="en">Was ist ein Plugin?</a></li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_api" class="en">Die Plugin-API</a></li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_obtain" class="en">Wo erhalte ich Plugins?</a></li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_bundled" class="en">Im Paket enthaltene Plugins</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_link_target" class="en">Link Target (link_target)</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_onlinestats" class="en">Who is online? (onlinestats)</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_opensearch" class="en">OpenSearch (opensearch)</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_sample" class="en">Sample Plugin (sample)</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_usergal_alphatabs" class="en">User Gallery Alphabetic Tabbing (usergal_alphatabs)</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_visiblehookpoints" class="en">Visible HookPoints (visiblehookpoints)</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_sef_url" class="en">SEF_URLS plugin</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_manager" class="en">Der Plugin-Manager</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_manager_upload" class="en">Plugins hochladen</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_manager_install" class="en">Plugins installieren</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_manager_configuration" class="en">Plugins konfigurieren</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_manager_uninstall" class="en">Plugins deinstallieren</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_writing" class="en">Plugins erstellen</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="performance.htm#perf_tips" class="en">Leistung</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="performance.htm#perf_config" class="en">Configuration settings</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="performance.htm#perf_config_general" class="en">General</a></li>\n';
doc_toc += '              <li><a href="performance.htm#perf_config_spikes" class="en">Spiking</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="performance.htm#perf_server class="en"" class="en">Server settings</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="performance.htm#perf_config_spikes" class="en">PHP settings</a></li>\n';
doc_toc += '              <li><a href="performance.htm#perf_server_mysql" class="en">MySQL settings</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="performance.htm#perf_tools" class="en">Third party tools</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="performance.htm#perf_yslow" class="en">YSlow</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="admin-tools.htm#admin_tools" class="en">Admin-Werkzeuge</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="admin-tools.htm#admin_tools_options" class="en">Available Tools</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_rebuild" class="en">Update thumbs and/or resized photos</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_filename_filetitle" class="en">Filename &rarr; File title</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_delete_titles" class="en">Delete file titles</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_delete_original" class="en">Delete original size photos</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_intermediate" class="en">Delete intermediate pictures</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_delete_older_files" class="en">Delete files that are older than a set number of days</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_delete_comments" class="en">Delete comments on missing files</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_delete_original_backup" class="en">Delete original image backup (watermark mod)</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_reload_dimensions" class="en">Reload file dimensions and size information</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_reset_views" class="en">Reset view counters</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_keyword_convert" class="en">Convert keyword separator</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="admin-tools.htm#admin_tools_usage" class="en">Usage</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="errors.htm#errors" class="en">Fehlermeldungen</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="errors.htm#errors_types" class="en">Error types</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="errors.htm#errors_soft" class="en">Soft Errors</a></li>\n';
doc_toc += '              <li><a href="errors.htm#errors_hard" class="en">Hard Errors</a></li>\n';
doc_toc += '              <li><a href="errors.htm#errors_unhandled" class="en">Unhandled Errors</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="errors.htm#errors_fatal" class="en">Fatal error</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="errors.htm#errors_debug_mode_config" class="en">Enabling debug_mode in Config</a></li>\n';
doc_toc += '              <li><a href="errors.htm#errors_debug_mode_manual" class="en">Manually enabling debug_mode</a></li>\n';
doc_toc += '              <li><a href="errors.htm#errors_debug_mode_off" class="en">Turning debug_mode off</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="errors.htm#errors_messages" class="en">Common error messages</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="errors.htm#errors_messages_database" class="en">Database-related error messages</a></li>\n';
doc_toc += '              <li><a href="errors.htm#commonPHPerrors" class="en">Common PHP errors</a></li>\n';
doc_toc += '              <li><a href="errors.htm#errors_messages_upload" class="en">Upload-related error messages</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="export.htm#backup_move" class="en">Backup &amp; Moving</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="export.htm#backup" class="en">Backing up your gallery</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="export.htm#backup_file" class="en">File Backup</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="export.htm#backup_file_complete" class="en">Complete File Backup</a></li>\n';
doc_toc += '                  <li><a href="export.htm#backup_file_partial" class="en">Partial File Backup</a></li>\n';
doc_toc += '                  <li><a href="export.htm#backup_file_incremental" class="en">Incremental File Backup</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="export.htm#backup_database" class="en">Database Backup</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="export.htm#backup_database_what" class="en">What needs to be backed up?</a></li>\n';
doc_toc += '                  <li><a href="export.htm#backup_database_tools" class="en">Database Backup Tools</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="export.htm#backup_database_tools_phpmyadmin" class="en">phpMyAdmin</a></li>\n';
doc_toc += '                      <li><a href="export.htm#backup_database_tools_mysqldumper" class="en">mySqlDumper</a></li>\n';
doc_toc += '                      <li><a href="export.htm#backup_database_tools_shell_mysqldump" class="en">mysqldump</a></li>\n';
doc_toc += '                      <li><a href="export.htm#backup_database_tools_shell_mysqlhotcopy" class="en">mysqlhotcopy</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="export.htm#backup_database_after" class="en">After the database backup</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="export.htm#moving" class="en">Moving your gallery</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="export.htm#moving_folder" class="en">Moving on your webserver</a></li>\n';
doc_toc += '              <li><a href="export.htm#moving_server" class="en">Moving from one webserver to the other</a></li>\n';
doc_toc += '              <li><a href="export.htm#moving_disadvantages" class="en">Disadvantages of renaming</a></li>\n';
doc_toc += '              <li><a href="export.htm#moving_config_url" class="en">Changing Coppermine\'s URL in config</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="watermarking.htm#watermark" class="en">Wasserzeichen</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="watermarking.htm#watermark_alternatives" class="en">Alternatives</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="watermarking.htm#watermark_alternatives_no_right_click" class="en">Turning the context menu off</a></li>\n';
doc_toc += '              <li><a href="watermarking.htm#watermark_alternatives_registered_only" class="en">Only display your precious content to legitimate viewers</a></li>\n';
doc_toc += '              <li><a href="watermarking.htm#watermark_alternatives_overlay" class="en">Display on overlay</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="watermarking.htm#watermark_client_sided" class="en">Client-sided watermarking</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="uploading.htm" class="en">Hochladen (Upload)</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="uploading_batch-add.htm#batch_add_pics" class="en">Hochladen per FTP/Stapel-Hinzufügen</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="uploading_batch-add.htm#batch_add_pics_what" class="en">What batch-add does</a></li>\n';
doc_toc += '          <li><a href="uploading_batch-add.htm#batch_add_pics_how" class="en">How batch-add works</a></li>\n';
doc_toc += '          <li><a href="uploading_batch-add.htm#batch_add_common_mistakes" class="en">Common mistakes</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_common_mistakes_doesnt_work" class="en">Batch-add does not work as expected</a></li>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_common_mistakes_broken_files" class="en">Files appear to be broken</a></li>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_common_mistakes_rename" class="en">Do not rename</a></li>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_common_mistakes_delete" class="en">Do not delete</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="uploading_batch-add.htm#batch_add_sort" class="en">Sorting</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_sort_capitalization" class="en">Capitalization matters</a></li>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_sort_numbers" class="en">Computers see numbers differently</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="uploading_http.htm#upload_http" class="en">Hochladen per http</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="uploading_http.htm#upload_http_interface" class="en">Upload interfaces</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="uploading_http.htm#upload_http_interface_flash" class="en">Flash-driven multiple-files upload interface</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="uploading_http.htm#upload_http_interface_flash_usage" class="en">Usage</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="uploading_http.htm#upload_http_interface_html" class="en">HTML-driven single-file upload interface</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="uploading_http.htm#upload_http_interface_html_usage" class="en">Usage</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="uploading_xp-publisher.htm#xp" class="en">Windows XP Web Publishing-Assistent</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_requirements" class="en">Requirements</a></li>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_setup" class="en">Setup</a></li>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_upload" class="en">Uploading pictures</a></li>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_upload" class="en">File structure</a></li>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_remove" class="en">Removal/Uninstall</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upload_troubleshooting.htm#upload_trouble" class="en">Fehlerbehandlung beim Hochladen</a>\n';
doc_toc += '         <ul>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_trouble_permission" class="en">Berechtigungen</a></li>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_trouble_enable_settings" class="en">Einstellungen für die Fehlersuche</a></li>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_support" class="en">Upload-Support</a>\n';
doc_toc += '             <ul>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_support_step-by-step" class="en">Step-by-step guide when asking for support</a>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_support_example" class="en">Example support request</a>\n';
doc_toc += '             </ul>\n';
doc_toc += '           </li>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_error_messages" class="en">Fehlermeldungen beim Hochladen</a>\n';
doc_toc += '             <ul>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#ErrorCantMovePic" class="en"></a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#ErrorImpossibleToMove" class="en">Impossible to move x to y</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#ErrorFailedToOpenDir" class="en">failed to open dir: No such file or directory</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#httpPostVars" class="en">Undefined variable: HTTP_POST_VARS</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#ErrorNoAlbumExisting" class="en">Sorry there is no album where you are allowed to upload files</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#ErrorAllowedMemorySize" class="en">Allowed memory size of X bytes exhausted</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#ErrorExecDisabled" class="en">Exec() has been disabled</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#ErrorNotAGdExtension" class="en">Not a GD extension</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#imagemagick127" class="en">Error executing ImageMagick - Return value 127</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#no_gd_support" class="en">PHP running on your server does not support the GD image library</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#no_file_uploaded" class="en">No file was uploaded ! If you have really selected a file to upload, check that the server allows file uploads</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#destination_not_writable" class="en">Destination directory x is not writable by the script</a></li>\n';
doc_toc += '             </ul>\n';
doc_toc += '           </li>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_trouble_server-sided_restrictions" class="en">Server-seitige Einschränkungen</a>\n';
doc_toc += '             <ul>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_trouble_server-sided_restrictions_php_ini" class="en">The PHP configuration file php.ini</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_trouble_server-sided_restrictions_check" class="en">Things to check</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_trouble_methods" class="en">Upload mechanisms/methods</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_trouble_memory_usage" class="en">Memory usage during resizing</a></li>\n';
doc_toc += '             </ul>\n';
doc_toc += '           </li>\n';
doc_toc += '         </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="comments.htm" class="en">Kommentare</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="comments.htm#comments_allow" class="en">Kommentare zulassen</a></li>\n';
doc_toc += '      <li><a href="comments.htm#comments_options" class="en">Kommentar-Optionen</a></li>\n';
doc_toc += '      <li><a href="comments.htm#comments_options_spam" class="en">Spam-Probleme</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="comments.htm#comments_options_spam_captcha" class="en">Captcha</a></li>\n';
doc_toc += '          <li><a href="comments.htm#comments_options_spam_approval" class="en">Approval</a></li>\n';
doc_toc += '          <li><a href="comments.htm#comments_options_spam_akismet" class="en">Akismet</a></li>\n';
doc_toc += '          <li><a href="comments.htm#comments_options_spam_resume" class="en">Summary</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="comments.htm#comments_review" class="en">Kommentare begutachten</a></li>\n';
doc_toc += '      <li><a href="comments.htm#comments_individual" class="en">Einzelne Kommentare</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="bridging.htm" class="en">Integration mit anderen Applikationen (Bridging)</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_bridge_purpose" class="en">Was bedeutet Bridging</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_bridge_start" class="en">Verfügbare Bridging-Dateien</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_prerequisites_start" class="en">Vorbedingungen</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_cookie_start" class="en">Authentifizierung durch Cookies</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_standalone_start" class="en">Zuerst die unabhängige Version</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_users_start" class="en">Coppermine-Benutzer, -Gruppen und duch die Benutzer hochgeladene Bilder gehen verloren bei der Integration</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_backup_start" class="en">Backup</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_steps_start" class="en">Integrations-Schritte</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_start" class="en">Verwendung des Bridge-Managers</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_app_start" class="en">Wähle Applikation, mit der gebridged werden soll</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_path_start" class="en">Von der Bridge-Applikation verwendete Pfade</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="bridging.htm#bridge_manager_path_full_forum_url" class="en">Bridge app URL</a></li>\n';
doc_toc += '              <li><a href="bridging.htm#bridge_manager_path_relative_path_of_forum_from_webroot" class="en">Absolute bridge app path</a></li>\n';
doc_toc += '              <li><a href="bridging.htm#bridge_manager_path_relative_path_to_config_file" class="en">Relative path to your bridge app\'s config file</a></li>\n';
doc_toc += '              <li><a href="bridging.htm#bridge_manager_path_cookie_prefix" class="en">Cookie prefix</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_specific_start" class="en">Bridge-Applikations-spezifische Einstellungen</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="bridging.htm#bridge_manager_specific_groups" class="en">Use bridge app custom groups?</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_enable_start" class="en">Bridging ein-/ausschalten</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="bridging.htm#bridge_manager_recover_start" class="en">Rettung nach fehlgeschlagenem Bridging-Versuch</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_steps_sync_start" class="en">Gruppen-Synchronisierung zwischen der Bridge-Applikation und Coppermine</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_support_start" class="en">Bridging-Support</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_config_options_start" class="en">Einige Einstellungen werden deaktiviert</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_files_start" class="en">Bridge-Dateien</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_bridge_file_creating_start" class="en">Eigene Bridge erstellen</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_philosophy_start" class="en">Bridging-Philosophie</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_individual_bridge_issues_start" class="en">Bridge-spezifische Probleme</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_individual_bridge_issues_phpbb3" class="en">phpBB3</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_individual_bridge_issues_punbb115" class="en">PunBB1.1.5</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_individual_bridge_issues_punbb12" class="en">PunBB1.2</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_individual_bridge_issues_xmb" class="en">XMB</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_subdomain" class="en">Subdomains</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_subdomain_file_system" class="en">File system</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_subdomain_cookie" class="en">Cookies</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_subdomain_www" class="en">www-subdomain</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="dev.htm" class="en">Entwickler-Doku</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="dev_files.htm" class="en">Adding/renaming/removing files</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_files.htm#dev_files_target_audience" class="en">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_files.htm#dev_files_scope" class="en">Scope</a></li>\n';
doc_toc += '          <li><a href="dev_files.htm#dev_files_naming" class="en">Naming conventions</a></li>\n';
doc_toc += '          <li><a href="dev_files.htm#dev_files_adding" class="en">Adding files</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_files.htm#dev_files_adding_language" class="en">Language files</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_files.htm#dev_files_renaming" class="en">Renaming files</a></li>\n';
doc_toc += '          <li><a href="dev_files.htm#dev_files_deleting" class="en">Deleting files</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_coding.htm" class="en">Coding guidelines</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_target_audience" class="en">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_scope" class="en">Scope</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_indentation" class="en">Indentation</a></li>\n';
doc_toc += '          <li><a href="dev_coding_encoding" class="en">Encoding</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_general" class="en">General guidelines</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_php" class="en">PHP code</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_formatting" class="en">Formatting</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_control_structures" class="en">Control Structures</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_function_calls" class="en">Function Calls</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_function_definitions" class="en">Function Definitions</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_php_tags" class="en">PHP Code Tags</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_html_nesting" class="en">Nesting of HTML in PHP</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_linebreaks" class="en">Line breaks</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_naming_conventions" class="en">Naming Conventions</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_database" class="en">Database queries</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_documentation" class="en">Documentation</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_html_output" class="en">HTML output</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_html_output_images" class="en">Image-tags in HTML output</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_html_output_dev_coding_html_output_links" class="en">Links in HTML output</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_html_output_form" class="en">Form elements in HTML output</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_html_output_deprecated" class="en">Deprecated tags</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_html_prefered_tags" class="en">Prefered tags</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_credits" class="en">Credits for coding guidelines</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_usability" class="en">Usability</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_usability_forms" class="en">Forms</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_config.htm" class="en">Config options</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_config.htm#dev_config_add_target_audience" class="en">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_config.htm#dev_config_history" class="en">History</a></li>\n';
doc_toc += '          <li><a href="dev_config.htm#dev_config_new_features" class="en">New features</a></li>\n';
doc_toc += '          <li><a href="dev_config.htm#dev_config_step_by_step" class="en">Step by Step</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_config.htm#dev_config_step_basiq_sql" class="en">Basic.sql</a></li>\n';
doc_toc += '              <li><a href="dev_config.htm#dev_config_step_update_sql" class="en">Update.sql</a></li>\n';
doc_toc += '              <li><a href="dev_config.htm#dev_config_step_array" class="en">Admin.inc.php</a></li>\n';
doc_toc += '              <li><a href="dev_config.htm#dev_config_step_language_file" class="en">Language file</a></li>\n';
doc_toc += '              <li><a href="dev_config.htm#dev_config_step_documentation" class="en">Documentation</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_config.htm#dev_config_todo" class="en">To Do</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_database.htm" class="en">Database schema</a>\n';
doc_toc += '          <ul>\n';
doc_toc += '              <li><a href="dev_database.htm#db_config_file" class="en">Configuration file</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_reference within_code" class="en">Database reference within coppermine code</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_albums" class="en">cpg15x_albums</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_banned" class="en">cpg15x_banned</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_bridge" class="en">cpg15x_bridge</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_categories" class="en">cpg15x_categories</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_categorymap" class="en">cpg15x_categorymap</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_comments" class="en">cpg15x_comments</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_config" class="en">cpg15x_config</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_dict" class="en">cpg15x_dict</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_ecards" class="en">cpg15x_ecards</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_exif" class="en">cpg15x_exif</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_favpics" class="en">cpg15x_favpics</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_filetypes" class="en">cpg15x_filetypes</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_hit_stats" class="en">cpg15x_hit_stats</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_languages" class="en">cpg15x_languages</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_pictures" class="en">cpg15x_pictures</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_plugins" class="en">cpg15x_plugins</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_sessions" class="en">cpg15x_sessions</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_temp_messages" class="en">cpg15x_temp_messages</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_usergroups" class="en">cpg15x_usergroups</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_users" class="en">cpg15x_users</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_votes" class="en">cpg15x_votes</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_vote_stats" class="en">cpg15x_vote_stats</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_documentation.htm" class="en">Editing the documentation</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_target_audience" class="en">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_edit_existing" class="en">Edit existing documents</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_add" class="en">Add new documents</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_move" class="en">Moving content from one document to the other</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_hidden_feature" class="en">Hidden features</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_database_structure" class="en">Database structure</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_header_block" class="en">Header &amp; footer blocks</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_i18n" class="en">Documentation internationalization</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_detail" class="en">Expandable/collapsible "detail"-blocks</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_help" class="en">Help</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_help_start_end" class="en">Start and end anchors needed</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_heading_anchors" class="en">Adding anchors to headings</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_code" class="en">Code</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_css_code" class="en">CSS class &quot;code&quot;</a></li>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_html_pre" class="en">HTML-tag &quot;pre&quot;</a></li>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_css_cpg_code" class="en">CSS class &quot;cpg_code&quot;</a></li>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_css_smallcode" class="en">CSS class &quot;smallcode&quot;</a></li>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_html_textarea" class="en">HTML-tag &quot;textarea&quot;</a></li>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_combining" class="en">Combining HTML tags and CSS classes</a></li>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_syntaxhighlighting" class="en">No syntax highlighting</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_javascript.htm" class="en">Javascript in Coppermine</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_javascript.htm#dev_javascript_target_audience" class="en">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_javascript.htm#dev_javascript_files_location" class="en">Javascript files location and organization</a></li>\n';
doc_toc += '          <li><a href="dev_javascript.htm#dev_javascript_files_location_todo" class="en">TODO</a></li>\n';
doc_toc += '          <li><a href="dev_javascript.htm#dev_javascript_include_files" class="en">How to include javascript files</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_javascript.htm#dev_javascript_include_files_plugin" class="en">How to include JavaScript files in plugins</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_javascript.htm#dev_javascript_php_vars" class="en">How to pass PHP variables to included javascript</a></li>\n';
doc_toc += '          <li><a href="dev_javascript.htm#dev_javascript_autostart" class="en">Autostart JavaScript</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_package.htm#packaging" class="en">Packaging a new release</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_package.htm#packaging_target_audience" class="en">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_package.htm#packaging_subversion" class="en">Subversion repository</a></li>\n';
doc_toc += '          <li><a href="dev_package.htm#packaging_steps" class="en">Steps</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_checkout" class="en">Check out</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_loop_through_files" class="en"></a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#" class="en">Replace version number in all files</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_loop_through_files_linux" class="en">Linux</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_loop_through_files_windows" class="en">Windows</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_bom" class="en">Remove Byte Order Marks</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#" class="en">Prepare an announcement thread</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_write_announcement_thread" class="en"></a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_docs_upgrade" class="en">Edit the upgrade section of the docs</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_changelog" class="en">Edit the changelog</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_version_number" class="en">Edit the version number</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_svn_commit" class="en">Commit your changes</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_versioncheck" class="en">Update the versioncheck data</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_versioncheck_complete" class="en">Completeness</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_versioncheck_update" class="en">Update revision numbers and hashes</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_xml_webspace" class="en">Update cpg15x.files.xml on the Coppermine home page</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_svn_export" class="en">Export from subversion</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_rapidsvn" class="en">RapidSVN</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_tortoisesvn" class="en">Tortoise SVN</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_create_zip" class="en">Create the archive</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_upload_zip" class="en">Upload the archive</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_move_announcement" class="en">Publish announcement thread</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_news" class="en">Create news items</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_news_sf" class="en">News item on sf.net</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_news_forum" class="en">News item on forum</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_news_homepage" class="en">News item on home page</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_news_embedded" class="en">News embedded into existing galleries</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_package.htm#packaging_steps_demo" class="en">Update the demo</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_plugins.htm" class="en">Plugin Writing for Coppermine</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing" class="en">Quick Start Guide</a></li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_target_audience" class="en">Intended Audience</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_target_audience_yes" class="en">People who should read this documentation</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_target_audience_no" class="en">People who do not need to read this documentation</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_why_write" class="en">Why write plugins?</a></li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_preparation" class="en">Preparations</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_preparation_name" class="en">Choose a name</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_preparation_translation" class="en">Consider translations</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_preparation_config" class="en">Consider a config screen</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_preparation_db" class="en">Database changes</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_preparation_support" class="en">Support issues</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_preparation_versions" class="en">Plugin versions</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_core_files" class="en">Core files</a></li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_naming_conventions" class="en">Naming conventions</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_naming_conventions_folders" class="en">Folders</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_naming_conventions_files" class="en">Files</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_naming_conventions_archives" class="en">Archives</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_naming_conventions_coding" class="en">Coding</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_globals" class="en">Use of Superglobals</a></li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_database" class="en">Database access</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_database_direct_queries" class="en">Direct queries</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_database_tables_access" class="en">Accessing database tables</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_database_tables_create" class="en">Creating database tables</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_database_tables_delete" class="en">Deleting database tables</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_database_config" class="en">Storing your plugin\'s config values</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_types" class="en">Plugin Types</a></li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_includes" class="en">Using includes</a></li>\n';
doc_toc += '          <li><a href="dev_plugin_api.htm" class="en">Plugin Writing: Tutorial, API</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_overview_who" class="en">Intended Audience</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_overview_skills" class="en">Required Skills &amp; Knowledge</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_overview_tools" class="en">Recommended Software &amp; Support Forums</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_tutorial" class="en">"Hello, world" Plugin Tutorial</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_first" class="en">My First Plugin</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_installconfig" class="en">Installation, Configuration, and Clean-Up</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_installsimple" class="en">Installation with Simple Configuration</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_install" class="en">Installation with Configuration Parameters</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_config" class="en">Adding a config section to your plugin</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_cleanup" class="en">Uninstallation &amp; Clean-Up</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>  \n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_linking" class="en">Linking to Custom Plugin Scripts</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_button" class="en">Adding a Button to Coppermine</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_button_admin_menu" class="en">Adding a Button to the admin menu</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_button_overall_menu" class="en">Adding a Button to the overall menu</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_js" class="en">Adding JavaScript to plugins</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_lang" class="en">Multi-language Support</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_distrib" class="en">Distributing Your Plugin</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_hooks" class="en">Plugin Hooks</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_plugin_class" class="en">Plugin Class Properties &amp; Methods</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_globals" class="en">Global Variables &amp; Constants</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugin_steps.htm" class="en">Creating plugins: step by step</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugin_steps.htm#steps_template_plugin" class="en">Getting started with the plugin template</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_extract_template" class="en">1. Extract the plugin template</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_pick_name" class="en">2. Choose a name</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_rename_folder" class="en">3. Rename the folder</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_rename_file_content" class="en">4. Rename the placeholders inside the files</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_copy_to_target" class="en">5. Copy the new plugin folder to the target</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_plugin_steps.htm#steps_config" class="en">Creating a config record for your plugin</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_option_type" class="en">1. Decide for an option type</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_name" class="en">2. Choose a record name</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_install" class="en">3. Create the record during plugin install</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_uninstall" class="en">4. Create the uninstall query</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_defaults" class="en">5. Specify the scope of your config record</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_form_options" class="en">6. Populate form options</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_rows" class="en">7. Output the form elements (rows)</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_steps.htm#steps_config_rows_checkbox" class="en">a. Checkbox</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_steps.htm#steps_config_rows_radio" class="en">b. Radio button</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_steps.htm#steps_config_rows_dropdown" class="en">c. Dropdown (select/option list)</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_steps.htm#steps_config_rows_textinput" class="en">d. Text input field (one line), both for numerical input (integers) as well as any other textual input</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_steps.htm#steps_config_rows_textarea" class="en">e. Text input field (multiple lines, aka textarea)</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_language" class="en">8. Create the needed translation strings</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugin_hooks.htm" class="en">Reference list of plugin hooks </a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_target_audience" class="en">Target audience</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_choosing" class="en">Choosing Plugin Hooks</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_finding" class="en">Finding Plugin Hooks</a></li>\n';
//doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_using" class="en">Using Plugin Hooks</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_filename" class="en">Plugin Hooks by File Name</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_ind_php" class="en">Script: index.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_ind_anyc" class="en">Filter: \'anycontent\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_ind_ucp" class="en">Filter: \'user_caption_params\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_ind_pb" class="en">Filter: \'plugin_block\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_di_php" class="en">Script: displayimage.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_di_fi" class="en">Filter: \'file_info\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_di_pbc" class="en">Filter: \'post_breadcrumb\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_thumb_php" class="en">Script: thumbnails.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_thumb_pbc" class="en">Filter: \'post_breadcrumb\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_php" class="en">Script: functions.inc.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_ghgf" class="en">Filters: \'gallery_header\' and \'gallery_footer\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_td" class="en">Filter: \'thumb_data\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_th" class="en">Filter: \'template_html\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_pm" class="en">Filter: \'page_meta\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_tc" class="en">Filters: \'thumb_caption\' and all derivatives</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_th_php" class="en">Script: themes.inc.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_th_fd" class="en">Filter: \'file_data\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_um_php" class="en">Script: usermgr.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_um_umh" class="en">Filter: \'usermgr_header\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_um_umf" class="en">Filter: \'usermgr_footer\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_pm_php" class="en">Script: pluginmgr.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_pm_pcon" class="en">Filter: \'plugin_configure\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_pm_pcl" class="en">Filter: \'plugin_cleanup\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_php" class="en">Script: plugin_api.inc.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_ph" class="en">Filter: \'page_html\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_pe" class="en">Filter: \'page_end\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_pi" class="en">Filter: \'plugin_install\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_pu" class="en">Filter: \'plugin_uninstall\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_pw" class="en">Filter: \'plugin_wakeup\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_ps" class="en">Filter: \'plugin_sleep\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_init_php" class="en">Script: init.inc.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_init_ps" class="en">Filter: \'page_start\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_picm_php" class="en">Script: picmgmt.inc.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_picm_afd" class="en">Filter: \'add_file_data\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_alphabetically" class="en">Plugin Hooks Alphabetically</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_hooktype" class="en">Plugin Hooks by Hook Type</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hook_examples" class="en">Plugin Hook Examples</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                    <li><a href="dev_plugin_hooks.htm#plugin_hook_example_upload_method" class="en">Adding an upload method</a></li>\n';
doc_toc += '                    <li><a href="dev_plugin_hooks.htm#plugin_hook_example_theme_display_thumbnails" class="en">Add tags for thumbnails display</a></li>\n';
doc_toc += '                </ul></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_superglobals.htm" class="en">Sanitization of Superglobals using Inspekt</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_superglobals.htm#superglobals_sanitization_target_audience" class="en">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_superglobals.htm#superglobals_sanitization_whats_new" class="en">What\'s new?</a></li>\n';
doc_toc += '          <li><a href="dev_superglobals.htm#superglobals_sanitization_reason" class="en">Reason</a></li>\n';
doc_toc += '          <li><a href="dev_superglobals.htm#superglobals_sanitization_about_inspekt" class="en">What Inspekt does</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_superglobals.htm#superglobals_sanitization_inspekt_accessor_methods" class="en">Inspekt accessor methods</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_superglobals.htm#superglobals_sanitization_howto" class="en">How to use Inspekt with Coppermine Photo Gallery</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_superglobals.htm#superglobals_sanitization_howto_using" class="en">Using Inspekt</a></li>\n';
doc_toc += '              <li><a href="dev_superglobals.htm#superglobals_sanitization_howto_inspekt_in_coppermine" class="en">Inspekt in Coppermine</a></li>\n';
doc_toc += '              <li><a href="dev_superglobals.htm#superglobals_sanitization_howto_consider_methods" class="en">Consider the methods to use</a></li>\n';
doc_toc += '              <li><a href="dev_superglobals.htm#superglobals_sanitization_howto_examples" class="en">Examples</a></li>\n';
doc_toc += '              <li><a href="dev_superglobals.htm#superglobals_sanitization_howto_regex" class="en">Regular Expressions</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_superglobals.htm#superglobals_sanitization_links" class="en">Links</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_subversion.htm" class="en">Subversion</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_target_audience" class="en">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_caveat" class="en">Caveats</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_definition" class="en">What is subversion?</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_hosting" class="en">Where is the subversion repository hosted?</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_software" class="en">Recommended software</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_websvn" class="en">Alternative access using Web SVN</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_repository_structure" class="en">Repository structure</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_repository_structure_trunk" class="en">Coppermine core files</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_repository_structure_plugins" class="en">Plugins</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_checking_out" class="en">Checking out</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_checking_out_entire" class="en">Checking out the entire repository</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_checking_out_particular_package" class="en">Checking out a particular Package</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_checking_out_particular_file" class="en">Checking out a particular file</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_checking_out_refering" class="en">Refering to files downloaded from the subversion repository</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_download" class="en">Is there no single package that I could download instead?</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_download_tarball" class="en">Download Tarball archives</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_dev-only" class="en">Developers-only</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_checkout_checkin" class="en">Check out before checking in</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_commit" class="en">Committing your code</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_changelog" class="en">Changelog</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_write_access" class="en">Obtaining write access</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_step-by-step" class="en">Step by step</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_client-download" class="en">Download the client application</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_initial_checkout" class="en">Initial checkout</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_revision" class="en">Revisions</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_fileheaders" class="en">Subversion file headers</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_tools.htm" class="en">Tools recommended by the devs</a>\n';
doc_toc += '          <ul>\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_database" class="en">Database manipulation</a></li>\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_ftp_client" class="en">FTP clients</a></li>\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_web_development" class="en">Web development</a></li>\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_editor" class="en">Text editors</a></li>\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_picture_editors" class="en">Picture Editors</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_update.htm" class="en">Updating</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_update.htm#dev_update_target_audience" class="en">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_update.htm#dev_update_hidden_feature" class="en">Hidden feature</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_vars.htm#vars_constants" class="en">Variables &amp; Constants</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_vars.htm#vars_constants_system" class="en">System Global Variables</a></li>\n';
doc_toc += '          <li><a href="dev_vars.htm#vars_constants_constants" class="en">Coppermine Constants</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_versioncheck.htm" class="en">Versioncheck</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_versioncheck.htm#dev_versioncheck_hidden_features" class="en">Hidden features</a></li>\n';
doc_toc += '          <li><a href="dev_versioncheck.htm#dev_versioncheck_xml" class="en">XML structure</a></li>\n';
doc_toc += '          <li><a href="dev_versioncheck.htm#dev_versioncheck_todo" class="en">To do list</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '</ul>\n';
doc_toc += '</div>\n';
$('#toc').replaceWith('<div id="toc" class="en">' + doc_toc + '</div>');
}



function cpgDocHeader() {
    // Only display the header if the docs are not included
    if (getUrlParameters('hide_nav') == 1) {
        return;
    }
    $('#docheader').text('Coppermine Photo Gallery v1.5.18: Dokumentation und Handbuch');
    $('#docheader').after('<br clear="all" />\n<a name="top" class="en"></a>');
    $('#docheader').before('<img src="../images/coppermine-logo.png" alt="Coppermine Photo Gallery - Deine Fotogalerie im Web" align="left" />\n');
}

function cpgDocSearch() {
    // Only display the header if the docs are not included
    if (getUrlParameters('hide_nav') == 1) {
        return;
    }
    var doc_search = '';
    doc_search += '  <div id="doc_search" style="display:none;" class="en">\n';
    doc_search += '    <form action="http://www.google.com/cse" id="cse-search-box" class="en">\n';
    doc_search += '      <input type="hidden" name="cx" value="009353514429642786404:pguj0cqk2xc" />\n';
    doc_search += '      <input type="text" name="q" size="25" />\n';
    doc_search += '      <input type="submit" name="sa" value="suche in Doku" style="font-size:9px;" />\n';
    doc_search += '    </form>\n';
    doc_search += '    <script type="text/javascript" src="http://www.google.com/coop/cse/brand?form=cse-search-box&lang=de" class="en"></script>\n';
    doc_search += '  </div>\n';
    $('#toc').append(doc_search);
}

function cpgDocFooter() {
  var overall_doc_footer = '';
  overall_doc_footer += '</div>';
  overall_doc_footer += '<div class="backtotop" class="en">';
  overall_doc_footer += '<a href="#top" class="en">Seitenanfang</a>';
  overall_doc_footer += '</div>';
  $('#doc_footer').append(overall_doc_footer);
}



function dateRevision() {
  // strip the unneeded data from last_changed and revision fields
  var lastChangeDate = $('#doc_last_changed').text();
  var lastChangeDate = lastChangeDate.replace('$', '');
  var lastChangeDate = lastChangeDate.replace('$', '');
  var lastChangeDate = lastChangeDate.replace('LastChangedDate: ', '');
  var lastChangeDate = lastChangeDate.replace(/Date: /g, '');
  $('#doc_last_changed').text('Über dieses Dokument: ' + 'zuletzt geändert am ' + lastChangeDate);

  var revisionNumber = $('#doc_revision').text();
  var revisionNumber = revisionNumber.replace('$', '');
  var revisionNumber = revisionNumber.replace('$', '');
  var revisionNumber = revisionNumber.replace(/Revision: /g, '');
  $('#doc_revision').text(', SVN Revision ' + revisionNumber);
}

function getUrlParameters(name)
{
  // Taken from http://www.netlobo.com/url_query_string_javascript.html
  name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  var regexS = "[\\?&]"+name+"=([^&#]*)";
  var regex = new RegExp(regexS);
  var results = regex.exec(window.location.href);
  if(results == null) {
    return '';
  } else {
    return results[1];
  }
}

function cpgDocTranslationWarning() {
  if (getUrlParameters('hide_nav') == 1) {
    return;
  }
  $('#doc_en_only').replaceWith('<div class="cpg_message_validation" class="en"><h1>Noch nicht übersetzt</h1><p>Diese Seite wurde noch nicht übersetzt und erscheint daher nur auf Englisch.</p><p>Übersetzer gesucht: schau Dir die Seite in Ruhe an - so kompliziert ist sie doch nicht, oder? Wenn Du Dir zutraust, diese Seite auf Deutsch zu übersetzen, dann schau doch mal auf der offiziellen Coppermine-Seite vorbei. Wir freuen uns auf Deinen Beitrag.</div>');
  $('#doc_en_partial').replaceWith('<div class="cpg_message_warning" class="en"><h1>Teilweise Übersetzung</h1><p>Diese Seite wurde noch nicht vollständig übersetzt und erscheint daher nur zum Teil auf Deutsch. Teile der Seite erscheinen auf Englisch.</p><p>Übersetzer gesucht: schau Dir die Seite in Ruhe an - so kompliziert ist sie doch nicht, oder? Wenn Du Dir zutraust, diese Seite vollständig auf Deutsch zu übersetzen, dann schau doch mal auf der offiziellen Coppermine-Seite vorbei. Wir freuen uns auf Deinen Beitrag.</div>');
}

$(document).ready(function()
{
    var $_GET = {};
    document.location.search.replace(/\??(?:([^=]+)=([^&]*)&?)/g, function () {
        function decode(s) {
            return decodeURIComponent(s).replace(/\+/g, " ");
        }
        $_GET[decode(arguments[1])] = decode(arguments[2]);
    });
    //hide all elements with class detail_body
    $(".detail_body").hide();
    if ($_GET["expand_all"] == 1) { // Show all details and get rid of the details toggle if the GET parameter expand_all is set
        $('.detail_body').show();
        //$('.detail_head_collapsed').replaceWith('');
    }
    //toggle the component with class detail_body
    $(".detail_head_collapsed").click(function()
    {
        $(this).toggleClass("detail_head_expanded").next(".detail_body").slideToggle(600);
    });
    $(".detail_expand_all").click(function()
    {
        $(".detail_body").slideDown(1200);
        $(".detail_head_collapsed").toggleClass("detail_head_expanded");
        $(".detail_expand_all").hide();
        $(".detail_collapse_all").show();

    });
    $(".detail_collapse_all").click(function()
    {
        $(".detail_body").slideUp(1200);
        $(".detail_head_collapsed").toggleClass("detail_head_expanded");
        $(".detail_expand_all").show();
        $(".detail_collapse_all").hide();

    });
    $(".detail_toggle_all").click(function()
    {
        $(".detail_body").slideToggle(600);
        $(".detail_head_collapsed").toggleClass("detail_head_expanded");
    });
    cpgDocHeader();
    cpgDocTranslationWarning();
    cpgDocToc();
    $("#tree").treeview({
        collapsed: true,
        unique: true,
        animated: "slow",
        persist: "location"
    });
    cpgDocSearch();
    cpgDocFooter();
    dateRevision();
    $("a.nolink").click(function(){
      return false;
    });
    // Fade the toc in if it is needed
    $("#toc").bind("mouseenter",function(){
        $("#toc_collapsed").hide();
        $("#toc_expanded").fadeIn('slow');
        $("#doc_search").show();
    });
    // Fade the toc out if it isn't used
    $("#toc").bind("mouseleave",function(){
        $("#toc_expanded").fadeOut('slow');
        $("#toc_collapsed").show();
        $("#doc_search").hide();
    });
    
});