/*
 * Decompiled with CFR 0.152.
 */
package slothLib.linearAlgebra.vector;

import slothLib.linearAlgebra.vector.AbstractVector;
import slothLib.linearAlgebra.vector.IVector;

public final class BasicVector
extends AbstractVector {
    private double[] vector;

    public BasicVector(int dimension) {
        this.vector = new double[dimension];
    }

    public BasicVector(double[] doubleArray) {
        this(doubleArray.length);
        System.arraycopy(doubleArray, 0, this.vector, 0, doubleArray.length);
    }

    public BasicVector(IVector vector) {
        this(vector.dimension());
        int i = 0;
        while (i < vector.dimension()) {
            this.vector[i] = vector.get(i);
            ++i;
        }
    }

    @Override
    public double get(int dimension) {
        return this.vector[dimension];
    }

    @Override
    public void set(int dimension, double value) {
        this.vector[dimension] = value;
    }

    @Override
    public int dimension() {
        return this.vector.length;
    }

    @Override
    public double[] getPlainVector() {
        return (double[])this.vector.clone();
    }

    @Override
    public Object clone() {
        return new BasicVector(this.getPlainVector());
    }
}

