/*
 * Decompiled with CFR 0.152.
 */
package slothLib.linearAlgebra.featureVector;

import java.util.Iterator;
import slothLib.linearAlgebra.featureVector.Cluster;
import slothLib.linearAlgebra.featureVector.IVector;

public class ClusteringResult<T>
implements Iterable<Cluster<T>> {
    private Cluster<T>[] _clusters;

    public ClusteringResult(Cluster<T>[] clusters) {
        this._clusters = clusters;
    }

    public int clusterCount() {
        return this._clusters.length;
    }

    public Cluster<T>[] clusters() {
        return this._clusters;
    }

    public Cluster<T> getClusterByVector(IVector<T> vector) {
        Cluster<T>[] clusterArray = this._clusters;
        int n = this._clusters.length;
        int n2 = 0;
        while (n2 < n) {
            Cluster<T> c = clusterArray[n2];
            if (c.contains(vector)) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    public Cluster<T> getClusterByIndex(int index) {
        Cluster<T>[] clusterArray = this._clusters;
        int n = this._clusters.length;
        int n2 = 0;
        while (n2 < n) {
            Cluster<T> c = clusterArray[n2];
            if (c.contains(index)) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Iterator<Cluster<T>> iterator() {
        return new ClusterIterator();
    }

    class ClusterIterator<T>
    implements Iterator<Cluster<T>> {
        int index = 0;

        ClusterIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < ClusteringResult.this._clusters.length;
        }

        @Override
        public Cluster<T> next() {
            return ClusteringResult.this._clusters[this.index++];
        }

        @Override
        public void remove() {
        }
    }
}

