/*
 * Decompiled with CFR 0.152.
 */
package slothLib.NLP;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.regex.Pattern;
import slothLib.NLP.ChaSenResult;
import slothLib.NLP.HankakuZenkaku;
import slothLib.NLP.IMorphologicalAnalyzer;
import slothLib.SlothLib;
import slothLib.SlothLibException;
import slothLib.portUtil.PortUtil;

public class ChaSen
implements IMorphologicalAnalyzer {
    private static final String chasenPathPropKey = "slothLib.NLP.ChaSen.chaSenPath";
    private static final String chasenRcPathPropKey = "slothLib.NLP.ChaSen.chaSenRcPath";
    private static final String chasenEncodingPropKey = "slothLib.NLP.ChaSen.chaSenEncoding";
    private static final String CHASEN_PATH_DEFAULT = "/usr/local/bin/chasen";
    private static final String CHASEN_RCPATH_DEFAULT = "/usr/local/etc/chasenrc";
    private static final String CHASEN_ENCODING_DEFAULT = "EUC_JP";
    private String chaSenPath;
    private String chaSenRcPath;
    private String option = "";
    private static Pattern regexHalfKana;

    static {
        SlothLib.init();
        regexHalfKana = Pattern.compile("^([^\uff61-\uff9f]*)([\uff61-\uff9f]*)(.*)$");
    }

    public ChaSen() throws SlothLibException {
        this(false);
    }

    public ChaSen(boolean useOption_j) throws SlothLibException {
        this.setChaSenPath(ChaSen._getChaSenPath());
        this.setChaSenRcPath(ChaSen._getChaSenRcPath());
        if (useOption_j) {
            this.option = "-j ";
        }
    }

    public ChaSen(String chaSenPath, String chaSenRcPath) throws SlothLibException {
        this(chaSenPath, chaSenRcPath, false);
    }

    public ChaSen(String chaSenPath, String chaSenRcPath, boolean useOption_j) throws SlothLibException {
        this.setChaSenPath(chaSenPath);
        this.setChaSenRcPath(chaSenRcPath);
        if (useOption_j) {
            this.option = "-j ";
        }
    }

    public String getChaSenPath() {
        return this.chaSenPath;
    }

    public String getChaSenRcPath() {
        return this.chaSenRcPath;
    }

    private void setChaSenPath(String path) throws SlothLibException {
        if (!PortUtil.fileExists(path)) {
            throw new SlothLibException("chasen.exe\u3092\u898b\u3064\u3051\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + path);
        }
        this.chaSenPath = path;
    }

    private void setChaSenRcPath(String path) throws SlothLibException {
        if (!PortUtil.fileExists(path)) {
            throw new SlothLibException("chasenrc\u3092\u898b\u3064\u3051\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + path);
        }
        this.chaSenRcPath = path;
    }

    @Override
    public ChaSenResult doAnalyze(String text) throws SlothLibException {
        try {
            if (text == null) {
                throw new IllegalArgumentException("text\u5f15\u6570\u304cnull\u3067\u3059\u3002");
            }
            String tempFilePath = File.createTempFile("SlothLib.NLP.ChaSen.doAnalyze.", ".tmp").getPath();
            String[] splitText = text.split("\\n");
            PrintWriter sw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFilePath), ChaSen.getChaSenEncoding()));
            String[] stringArray = splitText;
            int n = splitText.length;
            int n2 = 0;
            while (n2 < n) {
                String input = stringArray[n2];
                String inputTrim = input.trim();
                if (!PortUtil.isNullOrEmpty(inputTrim)) {
                    sw.println(HankakuZenkaku.hankanaToZen(inputTrim));
                    System.err.println(HankakuZenkaku.hankanaToZen(inputTrim));
                }
                ++n2;
            }
            sw.flush();
            sw.close();
            String parsedText = this.parseFile(tempFilePath);
            PortUtil.fileDelete(tempFilePath);
            return new ChaSenResult(parsedText);
        }
        catch (IOException e) {
            throw new SlothLibException(e);
        }
    }

    private String parseFile(String tempFilePath) throws SlothLibException {
        try {
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add(this.getChaSenPath());
            if (!PortUtil.isNullOrEmpty(this.option)) {
                cmds.add(this.option);
            }
            cmds.add(tempFilePath);
            ProcessBuilder pb = new ProcessBuilder(cmds);
            Process p = pb.start();
            String output = PortUtil.readFully(p.getInputStream(), ChaSen.getChaSenEncoding());
            while (true) {
                try {
                    p.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            int ec = p.exitValue();
            if (ec != 0) {
                throw new SlothLibException("chasen.exe\u306e\u5b9f\u884c\u6642\u306b\u30a8\u30e9\u30fc\u304c\u8d77\u3053\u308a\u307e\u3057\u305f\u3002");
            }
            return output;
        }
        catch (IOException e) {
            throw new SlothLibException(e);
        }
    }

    public static String _getChaSenPath() {
        return System.getProperty(chasenPathPropKey, CHASEN_PATH_DEFAULT);
    }

    public static String _getChaSenRcPath() {
        return System.getProperty(chasenRcPathPropKey, CHASEN_RCPATH_DEFAULT);
    }

    public static String getChaSenEncoding() {
        return System.getProperty(chasenEncodingPropKey, CHASEN_ENCODING_DEFAULT);
    }
}

