/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import slothLib.NLP.IMorpheme;
import slothLib.NLP.MeCabResult;
import slothLib.NLP.MeCabServer;
import slothLib.SlothLibException;

public class MeCabSample {
    private Shell sShell = null;
    private Text textArea = null;
    private Button button = null;
    private Text textArea1 = null;

    public static void main(String[] args) {
        Display display = Display.getDefault();
        MeCabSample thisClass = new MeCabSample();
        thisClass.createSShell();
        thisClass.sShell.open();
        while (!thisClass.sShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private void createSShell() {
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessVerticalSpace = true;
        gridData2.verticalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 2;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.sShell = new Shell();
        this.sShell.setText("MeCab it");
        this.sShell.setSize(new Point(497, 393));
        this.sShell.setLayout((Layout)new GridLayout());
        this.textArea = new Text((Composite)this.sShell, 2626);
        this.textArea.setLayoutData((Object)gridData2);
        this.button = new Button((Composite)this.sShell, 0);
        this.button.setText("Mecab it");
        this.button.setLayoutData((Object)gridData1);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MeCabSample.this.textArea1.setText(MeCabSample.this.mecabIt(MeCabSample.this.textArea.getText()));
            }
        });
        this.textArea1 = new Text((Composite)this.sShell, 2626);
        this.textArea1.setLayoutData((Object)gridData);
    }

    private String mecabIt(String text) {
        try {
            StringBuffer sb = new StringBuffer();
            MeCabServer mecab = new MeCabServer();
            MeCabResult result = mecab.doAnalyze(text);
            IMorpheme[] iMorphemeArray = result.getMorphemes();
            int n = iMorphemeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMorpheme s = iMorphemeArray[n2];
                sb.append(s + "\n");
                ++n2;
            }
            return sb.toString();
        }
        catch (SlothLibException e) {
            return "error: " + e.getMessage();
        }
    }
}

