package test.org.seasar.sql;

import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.sql.XAConnectionImpl;
import org.seasar.sql.XADataSourceImpl;

public class XAConnectionImplTest extends TestCase {

    private XAConnectionImpl _xaCon;
    private boolean _closed = false;
    private boolean _errored = false;

    public XAConnectionImplTest(String name) {
        super(name);
    }

    public void testGetXAResource() throws Exception {
        assertNotNull("1", _xaCon.getXAResource());
    }

    public void testGetConnection() throws Exception {
        assertNotNull("1", _xaCon.getConnection());
    }

    public void testGetPhysicalConnection() throws Exception {
        assertNotNull("1", _xaCon.getPhysicalConnection());
    }

    public void testNotifyClose() throws Exception {
        _closed = false;
        ConnectionEventListener l =
            new ConnectionEventListener() {
                public void connectionClosed(ConnectionEvent evt) {
                    _closed = true;
                }


                public void connectionErrorOccurred(ConnectionEvent evt) { }
            };
        _xaCon.addConnectionEventListener(l);
        _xaCon.notifyClose();
        assertTrue("1", _closed);
    }

    public void testNotifyError() throws Exception {
        _errored = false;
        ConnectionEventListener l =
            new ConnectionEventListener() {
                public void connectionClosed(ConnectionEvent evt) { }


                public void connectionErrorOccurred(ConnectionEvent evt) {
                    _errored = true;
                }
            };
        _xaCon.addConnectionEventListener(l);
        _xaCon.notifyError(new SQLException("test"));
        assertTrue("1", _errored);
    }

	public void testClose() throws Exception {
		Connection con = _xaCon.getPhysicalConnection();
		_xaCon.close();
        assertEquals("1", true, _xaCon.isClosed());
        assertEquals("2", true, con.isClosed());
    }
    
    protected void setUp() throws Exception {
        XADataSourceImpl ds = new XADataSourceImpl();
        ds.setDriverClassName("oracle.jdbc.driver.OracleDriver");
        ds.setURL("jdbc:oracle:thin:@d1606:1521:ark");
        ds.setUser("ark");
        ds.setPassword("ark");
        _xaCon = (XAConnectionImpl) ds.getXAConnection();
    }

    protected void tearDown() throws Exception {
        _xaCon.close();
    }

    public static Test suite() {
        return new TestSuite(XAConnectionImplTest.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{XAConnectionImplTest.class.getName()});
    }
}
