package test.org.seasar.mbean;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.seasar.mbean.RemoteNotificationListenerFacade;
import org.seasar.system.JMXService;
import org.seasar.util.SeasarException;

import test.org.seasar.system.NotificationListenerTester;
import test.org.seasar.system.Notify;
import test.org.seasar.system.NotifyMBean;
import test.org.seasar.system.RMIAdaptorTestCase;

public class RemoteNotificationListenerFacadeTest extends RMIAdaptorTestCase {

	private RemoteNotificationListenerFacade _listenerFacade;
	
    public RemoteNotificationListenerFacadeTest(String name) throws Exception {
        super(name);
    }

	public void testStartAndStop() throws Exception {
		Notify notify = new Notify();
		JMXService.registerMBean(notify, NotifyMBean.NAME);
		
		_listenerFacade = new RemoteNotificationListenerFacade(
			NotificationListenerTester.class.getName(), "Notify", "default");
		NotificationListenerTester listener = null;
    	_listenerFacade.start();
    	String listenerName = _listenerFacade.getRMINotificationListenerAdaptor().getListenerName();
    	try {
   			listener = (NotificationListenerTester)
    			_listenerFacade.getNotificationListener();
    		assertNotNull("1", listener);
    		assertEquals("2", true, listener.isStarted());
			notify.sendMessage("Hello");
			assertEquals("3", true, listener.isCalled());
    	} finally {
    		_listenerFacade.stop();
    	}
    	assertEquals("4", false, JMXService.isRegistered(listenerName));
    	try {
    		JMXService.removeNotificationListener(NotifyMBean.NAME, listenerName);
    		fail("5");
    	} catch (SeasarException ex) {
    		System.out.println(ex);
    	}
	}

    protected void setUp() throws Exception {
    	super.setUp();    	
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(RemoteNotificationListenerFacadeTest.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{RemoteNotificationListenerFacadeTest.class.getName()});
    }
}