package org.seasar.util;

import org.seasar.message.MessageFormatter;

public class SeasarException extends Exception {

    private String _messageCode;
    private Object[] _arguments;
    private String _className;
    private String _methodName;
    private String _message;
    
    public SeasarException(String messageCode) {
        this(messageCode, ArrayUtil.EMPTY_OBJECTS, (Throwable) null);
    }
    
    public SeasarException(String messageCode, Object arg0) {
        this(messageCode, new Object[]{arg0}, null);
    }
    
    public SeasarException(String messageCode, Object arg0, Object arg1) {
        this(messageCode, new Object[]{arg0, arg1}, (Throwable) null);
    }
    
    public SeasarException(String messageCode, Object arg0, Object arg1,
    		Object arg2) {
    			
        this(messageCode, new Object[]{arg0, arg1, arg2}, (Throwable) null);
    }
    
    public SeasarException(String messageCode, Object arg0, Object arg1,
    		Object arg2, Object arg3) {
    			
        this(messageCode, new Object[]{arg0, arg1, arg2, arg3}, (Throwable) null);
    }
    
    public SeasarException(String messageCode, Object arg0, Object arg1,
    		Object arg2, Object arg3, Object arg4) {
    			
        this(messageCode, new Object[]{arg0, arg1, arg2, arg3, arg4}, (Throwable) null);
    }
    
    public SeasarException(String messageCode, Throwable cause) {
        this(messageCode, ArrayUtil.EMPTY_OBJECTS, cause);
    }
    
    public SeasarException(String messageCode, Object arg0, Throwable cause) {
        this(messageCode, new Object[]{arg0}, cause);
    }
    
    public SeasarException(String messageCode, Object arg0, Object arg1,
    		Throwable cause) {
    			
        this(messageCode, new Object[]{arg0, arg1}, cause);
    }
    
    public SeasarException(String messageCode, Object arg0, Object arg1,
    		Object arg2, Throwable cause) {
    			
        this(messageCode, new Object[]{arg0, arg1, arg2}, cause);
    }
    
    public SeasarException(String messageCode, Object arg0, Object arg1,
    		Object arg2, Object arg3, Throwable cause) {
    			
        this(messageCode, new Object[]{arg0, arg1, arg2, arg3}, cause);
    }
    
    public SeasarException(String messageCode, Object arg0, Object arg1,
    		Object arg2, Object arg3, Object arg4, Throwable cause) {
    			
        this(messageCode, new Object[]{arg0, arg1, arg2, arg3, arg4}, cause);
    }

    public SeasarException(final String messageCode, final Object[] arguments) {
        this(messageCode, arguments, null);
    }

    public SeasarException(final String messageCode, final Object[] arguments,
            final Throwable cause) {

        super(cause);
        if (messageCode == null) {
            throw new IllegalArgumentException(MessageFormatter.getMessage("ESSR0007", new Object[]{"messageCode"}));
        }
        _messageCode = messageCode;
        _arguments = arguments;
        _message = MessageFormatter.getMessage(messageCode, _arguments);
        StackTraceElement ste = getStackTrace()[0];
        _className = ste.getClassName();
        _methodName = ste.getMethodName();
    }

    public static SeasarException convertSeasarException(final Throwable throwable) {
        return convertSeasarException("ESSR0017", new Object[]{throwable}, throwable);
    }

    public static SeasarException convertSeasarException(
            final String messageCode, final Object[] arguments, Throwable throwable) {

        if (throwable instanceof SeasarException) {
            return (SeasarException) throwable;
        }
        return new SeasarException(messageCode, arguments, throwable);
    }

    public SeasarRuntimeException convertSeasarRuntimeException() {
        return new SeasarRuntimeException(_messageCode, _arguments, getCause(), _className, _methodName, _message);
    }


    public String getMessage() {
        return _message;
    }

    public String getLocalizedMessage() {
        return _message;
    }

    public String getMessageCode() {
        return _messageCode;
    }

    public Object[] getArguments() {
        return _arguments;
    }

    public String getClassName() {
        return _className;
    }

    public String getMethodName() {
        return _methodName;
    }
}