package org.seasar.nazuna.amf;

public final class AMFDataType {

	public static final byte UNKNOWN = -1;
	public static final byte NUMBER = 0;
	public static final byte BOOLEAN = 1;
	public static final byte STRING = 2;
	public static final byte OBJECT = 3;
	public static final byte NULL = 5;
	public static final byte FLASHED_SHARED_OBJECT = 7;
	public static final byte ARRAY_SHARED_OBJECT = 8;
	public static final byte ARRAY = 10;
	public static final byte DATE = 11;
	public static final byte AS_OBJECT = 13;
	public static final byte XML = 15;
	public static final byte CUSTOM_CLASS = 16;
	
	private AMFDataType() {
	}
	
	public static final String toString(byte dataType) {
		switch (dataType) {
			case NUMBER:
				return "NUMBER";
			case BOOLEAN:
				return "BOOLEAN";
			case STRING:
				return "STRING";
			case OBJECT:
				return "OBJECT";
			case NULL:
				return "NULL";
			case FLASHED_SHARED_OBJECT:
				return "FLUSHED_SHARED_OBJECT";
			case ARRAY_SHARED_OBJECT:
				return "ARRAY_SHARED_OBJECT";
			case ARRAY:
				return "ARRAY";
			case DATE:
				return "DATE";
			case AS_OBJECT:
				return "AS_OBJECT";
			case XML:
				return "XML";
			case CUSTOM_CLASS:
				return "CUSTOM_CLASS";
			default:
				return "UNKNOWN";
		}
	}
}
