package org.seasar.nazuna;

import java.lang.reflect.Array;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class GetArrayVariableExp implements Expression {

	private String _name;
	private int _index;
	
    public GetArrayVariableExp(final String name, final int index) {
    	Assertion.assertNotNull("name", name);
    	Assertion.assertTrue(index >= 0, "ESSR0004", "index");
    	
        _name = name;
        _index = index;
    }

    public Object evaluateValue(final RuleContext ruleContext) throws SeasarException {
    	Object array = ruleContext.getValue(_name);
    	return Array.get(array, _index);
    }
}
